using System;
using System.Collections.Generic;
using System.Text;
using Zensys.PCController.Interfaces;
using Zensys.PCController.Classes;
using Zensys.PCController.UI;
using Zensys.PCController.Models;

namespace Zensys.PCController.Dispatchers
{
    public class LogFormDispatcher : IViewDispatcher
    {
        #region IViewDispatcher Members

        public void Bind(IView view, ActionCollection actions, DocumentModel documentModel)
        {
            LogForm form = (LogForm)view;

            //Form
            form.Load += new EventHandler(actions.LogFormActions.OnFormLoad);
            form.FormClosing += new System.Windows.Forms.FormClosingEventHandler(actions.LogFormActions.OnFormClosing);
            //DocumentModel
            documentModel.DocumentModelStateChanged += new EventHandler<EventArgs>(actions.LogFormActions.OnDocumentModelStateChanged);
        }

        public void Drop(IView view, ActionCollection actions, DocumentModel documentModel)
        {
            LogForm form = (LogForm)view;

            //Form
            form.Load -= new EventHandler(actions.LogFormActions.OnFormLoad);
            form.FormClosing -= new System.Windows.Forms.FormClosingEventHandler(actions.LogFormActions.OnFormClosing);

            //DocumentModel
            documentModel.DocumentModelStateChanged -= new EventHandler<EventArgs>(actions.LogFormActions.OnDocumentModelStateChanged);
        }

        #endregion
    }
}
