using System;
using System.Collections.Generic;
using System.Text;
using System.Drawing;

namespace Zensys.PCController.Controls.Drawing
{
    public class TopologyMapShape
    {
        private Color mBackColor = Color.White;
        private Point mLocation = new Point(0, 0);
        private Rectangle mBounds = Rectangle.Empty;
        private TopologyMapCanvas mSite = null;
        private Pen mDefaultPen = new Pen(Color.Black);
        private string mLabel = String.Empty;
        private Font mDefaultFont = new Font("Microsoft Sans Serif", 8.5F, FontStyle.Regular, GraphicsUnit.Point, ((byte)(204)));

        public Font DefaultFont
        {
            get { return mDefaultFont; }
            set { mDefaultFont = value; }
        }

        public string Label
        {
            get { return mLabel; }
            set { mLabel = value; }
        }
        public Pen DefaultPen
        {
            get { return mDefaultPen; }
            set { mDefaultPen = value; }
        }

        public TopologyMapCanvas Site
        {
            get { return mSite; }
            set { mSite = value; }
        }

        public Rectangle Bounds
        {
            get { return mBounds; }
            set { mBounds = value; }
        }

        public Point Location
        {
            get { return mLocation; }
            set { mLocation = value; }
        }
        public Color BackColor
        {
            get { return mBackColor; }
            set { mBackColor = value; }
        }
        public virtual void Paint(Graphics graphics)
        {
        }
    }
}
