using System;
using System.Collections.Generic;
using System.Text;
using System.Drawing;
using Zensys.PCController.Models;

namespace Zensys.PCController.Controls.Drawing
{
    public class TopologyMapElement : TopologyMapShape
    {
        private int mColumnIndex;
        private int mRowIndex;
        private TopologyMapNode mVerticalNode;
        private TopologyMapNode mHorizontalNode;

        private Color LINK_EXISTS_COLOR = Color.Blue;
        private Color LINK_NOT_EXISTS_COLOR = Color.Red;


        public TopologyMapNode HorizontalNode
        {
            get { return mHorizontalNode; }
            set { mHorizontalNode = value; }
        }

        public TopologyMapNode VerticalNode
        {
            get { return mVerticalNode; }
            set { mVerticalNode = value; }
        }

        public int RowIndex
        {
            get { return mRowIndex; }
            set { mRowIndex = value; }
        }

        public int ColumnIndex
        {
            get { return mColumnIndex; }
            set { mColumnIndex = value; }
        }

        private bool mSelected = false;

        public bool Selected
        {
            get { return mSelected; }
            set { mSelected = value; }
        }
        private bool mHovered = false;

        public bool Hovered
        {
            get { return mHovered; }
            set { mHovered = value; }
        }

        public override void Paint(System.Drawing.Graphics graphics)
        {
            if (this.Site != null)
            {
                if (this.Selected || this.Hovered)
                {
                    DrawSelected(graphics);
                }
                else
                {
                    this.Location = new Point(this.Site.MarginLeft + this.ColumnIndex * TopologyMapCanvas.ELEMENT_WIDTH,
                    this.Site.MarginTop + +this.RowIndex * TopologyMapCanvas.ELEMENT_HEIGHT);
                    this.Bounds = new Rectangle(this.Location.X, this.Location.Y, TopologyMapCanvas.ELEMENT_WIDTH, TopologyMapCanvas.ELEMENT_HEIGHT);
                    graphics.FillRectangle(new SolidBrush(this.BackColor), this.Bounds);
                    graphics.DrawRectangle(this.DefaultPen, this.Bounds);
                }
            }

        }

        private void DrawSelected(Graphics graphics)
        {
            this.Location = new Point(this.Site.MarginLeft + this.ColumnIndex * TopologyMapCanvas.ELEMENT_WIDTH,
                    this.Site.MarginTop + +this.RowIndex * TopologyMapCanvas.ELEMENT_HEIGHT);
            Rectangle selRect = new Rectangle(this.Location.X - 3, this.Location.Y - 3, TopologyMapCanvas.ELEMENT_WIDTH + 6, TopologyMapCanvas.ELEMENT_HEIGHT + 6);
            Rectangle selShadowRect = new Rectangle(this.Location.X - 6, this.Location.Y - 6, TopologyMapCanvas.ELEMENT_WIDTH + 12, TopologyMapCanvas.ELEMENT_HEIGHT + 12);
            graphics.FillRectangle(new SolidBrush(Color.White), selShadowRect);
            graphics.FillRectangle(new SolidBrush(this.BackColor), selRect);
            graphics.DrawRectangle(this.DefaultPen, selRect);

            if (this.HorizontalNode != null && this.VerticalNode != null &&
                this.HorizontalNode.Tag != null && this.VerticalNode.Tag != null)
            {
                string title = String.Format("{0}\n{1}", String.Format("{0} ({1})", this.HorizontalNode.Tag.Device.Type, this.HorizontalNode.Tag.Device.Id.ToString().PadLeft(3, '0')),
                                String.Format("{0} ({1})", this.VerticalNode.Tag.Device.Type, this.VerticalNode.Tag.Device.Id.ToString().PadLeft(3, '0')));

                SizeF s = graphics.MeasureString(title, this.DefaultFont);
                float x = this.Bounds.X + 15;
                float y = this.Bounds.Y + 15;
                if ((x + s.Width) > this.Site.Width)
                {
                    x = x - s.Width;
                }
                if ((y + s.Height) > this.Site.Height)
                {
                    y = y - s.Height;
                }
                RectangleF layoutRect = new RectangleF(x, y, s.Width, s.Height);

                graphics.FillRectangle(new SolidBrush(SystemColors.Info), layoutRect);
                graphics.DrawString(title, this.DefaultFont, this.DefaultPen.Brush, layoutRect);
                graphics.DrawRectangle(this.DefaultPen, layoutRect.X, layoutRect.Y, layoutRect.Width, layoutRect.Height);

            }
        }

        internal bool HitTest(Point point)
        {
            return this.Bounds.Contains(point);
        }
    }
}
