using System;
using System.Collections.Generic;
using System.Text;
using Zensys.PCController.Classes;
using Zensys.PCController.Controllers;
using System.Windows.Forms;
using Zensys.ZWave.Enums;
using Zensys.ZWave.Devices;
using Zensys.ZWave;
using System.Threading;

namespace Zensys.PCController.Actions
{
    public class ErttFormActions : BaseAction
    {
        public ErttFormActions(ControllerManager controller)
            : base(controller)
        {

        }
        const byte BASIC_ON = 0xFF;
        const byte BASIC_OFF = 0x00;
        const byte MAX_NODES_COUNT = 232;
        private bool isStarted = false;

        public void OnFormLoad(object sender, EventArgs e)
        {
            ControllerManager.ErttForm.TxControlGroup(false);
            ControllerManager.ErttForm.RetransmissionCheckBox.Checked = true;
            if (ControllerManager.DocumentModel != null && ControllerManager.DocumentModel.Controller != null && ControllerManager.DocumentModel.Controller.ConnectionStatus == ConnectionStatuses.Opened)
            {
                if (ControllerManager.DocumentModel.Controller.IsSupportedSerialApiCommand((byte)CommandTypes.CmdSerialApiTest))
                {
                    ControllerManager.ErttForm.TxControlGroup(true);
                }
            }
        }

        public void OnStartClick(object sender, EventArgs e)
        {
            isStarted = !isStarted;

            if (ControllerManager.DocumentModel != null && ControllerManager.DocumentModel.Controller != null && ControllerManager.DocumentModel.Controller.ConnectionStatus == ConnectionStatuses.Opened)
            {
                Thread tr = new Thread(new ThreadStart(delegate
                {
                    bool retransmission = false;
                    int iMode = 0;
                    int noOfRuns = 0;
                    TransmitOptions txOption = TransmitOptions.TransmitOptionNone;

                    byte[] testnodemask = new byte[MAX_NODES_COUNT / 8];

                    if (ControllerManager.ErttForm.RetransmissionCheckBox.Checked)
                    {
                        retransmission = true;
                    }
                    else
                    {
                        DialogResult dr = DialogResult.OK;
                        ControllerManager.MainForm.Invoke(new EventHandler(delegate
                        {
                            dr = MessageBox.Show(ControllerManager.MainForm,
                                 "WARNING: By disabling re-transmission you are about to make simulations of your Z-Wave communication\n\nthat differs from the way an operational Z-Wave Network functions. In an ordinary Z-Wave Network\n\nevery command is re-transmitted up to 2 times if necessary. Please consult the User's Guide to the\n\nZ-Wave Reliability Test Tool for more information. Press OK to continue\n\n", "Enhanced Reliability Test Tool", MessageBoxButtons.OKCancel);
                        }));
                        if (dr == DialogResult.Cancel)
                        {
                            return;
                        }
                    }

                    if (ControllerManager.ErttForm.BasicSetVal0RadioButton.Checked)
                        iMode = 0;
                    else if (ControllerManager.ErttForm.BasicSetVal255RadioButton.Checked)
                        iMode = 1;
                    else if (ControllerManager.ErttForm.BasicSetVal0255RadioButton.Checked)
                        iMode = 2;
                    else
                        iMode = 0;

                    txOption = TransmitOptions.TransmitOptionAcknowledge;
                    if (retransmission)
                    {
                        txOption |= TransmitOptions.TransmitOptionAutoRoute;
                    }
                    else
                    {
                        txOption |= TransmitOptions.TransmitOptionNoRetransmit;
                    }

                    if (ControllerManager.ErttForm.LowPowerCheckBox.Checked)
                    {
                        txOption |= TransmitOptions.TransmitOptionLowPower;
                    }

                    //List<byte> nodeIdList = new List<byte>();
                    int nodesCount = 0;
                    List<IDeviceInfo> selectedDevices = ControllerManager.Actions.CommonActions.GetSelectedDevices(true);
                    if (selectedDevices.Count == 0)
                    {
                        selectedDevices = ControllerManager.DocumentModel.Controller.IncludedNodes;
                    }

                    ControllerManager.ErttForm.BeginInvoke(new EventHandler(delegate
                    {
                        ControllerManager.ErttForm.ReportDataGridView.Rows.Clear();
                        ControllerManager.ErttForm.UartErrorsLabel.Text = "0";
                    }));
                    foreach (IDeviceInfo node in selectedDevices)
                    {
                        if (node.Id != ControllerManager.DocumentModel.Controller.Id)// && node.IsListening)
                        {
                            nodesCount++;
                            if (ControllerManager.ErttForm.TxControlledByModuleCheckBox.Checked)
                            {
                                testnodemask[(node.Id - 1) >> 3] |= (byte)(1 << ((node.Id - 1) & 0x07));
                            }
                            ControllerManager.ErttForm.Invoke(new EventHandler(delegate
                            {
                                ControllerManager.ErttForm.ReportDataGridView.Rows.Add(new object[] { ((int)node.Id).ToString().PadLeft(3, '0'), node.Type, 0, 0 });
                                ControllerManager.ErttForm.ReportDataGridView.Rows[ControllerManager.ErttForm.ReportDataGridView.Rows.Count - 1].Tag = node;
                                //System.Diagnostics.Debug.WriteLine(((int)node.Id).ToString().PadLeft(3, '0'));
                                //System.Diagnostics.Debug.WriteLine(ControllerManager.ErttForm.ReportDataGridView.Rows[ControllerManager.ErttForm.ReportDataGridView.Rows.Count - 1].Cells[0].Value.ToString());
                            }));
                        }
                    }


                    int packetsSend = 0;
                    int packetSendSuccess = 0;
                    int packetUARTErrors = 0;


                    decimal iMax = ControllerManager.ErttForm.TestIterationsNumericUpDown.Value - 1;
                    decimal txDelay = ControllerManager.ErttForm.TxDelayNumericUpDown.Value;
                    decimal txPayloadLen = ControllerManager.ErttForm.TxDelayNumericUpDown.Value;
                    if (ControllerManager.ErttForm.RunForewerCheckBox.Checked)
                    {
                        iMax = 0xFFFF;
                    }
                    if (ControllerManager.ErttForm.TxControlledByModuleCheckBox.Checked)
                    {
                        int testCmd = 2;//testCmd = checkSendDataMeta.Checked ? 2 : 1;
                        ControllerManager.DocumentModel.Controller.SendZWaveTest(
                            (byte)testCmd,
                            (ushort)txDelay,
                            (byte)txPayloadLen,
                            (int)iMax,
                            txOption,
                            (byte)testnodemask.Length,
                            testnodemask);
                    }
                    else
                    {
                        //bool switchMode = false;
                        while (isStarted)
                        {
                            byte[] command;
                            switch (iMode)
                            {
                                case 0:
                                    command = ControllerManager.XmlDataManager.FillCommand("COMMAND_CLASS_BASIC", "BASIC_SET", new byte[] { BASIC_OFF });
                                    break;
                                case 1:
                                    command = ControllerManager.XmlDataManager.FillCommand("COMMAND_CLASS_BASIC", "BASIC_SET", new byte[] { BASIC_ON });
                                    break;
                                case 2:
                                    if (Convert.ToBoolean(noOfRuns / nodesCount % 2))
                                        command = ControllerManager.XmlDataManager.FillCommand("COMMAND_CLASS_BASIC", "BASIC_SET", new byte[] { BASIC_OFF });
                                    else
                                        command = ControllerManager.XmlDataManager.FillCommand("COMMAND_CLASS_BASIC", "BASIC_SET", new byte[] { BASIC_ON });
                                    break;
                                default:
                                    command = ControllerManager.XmlDataManager.FillCommand("COMMAND_CLASS_BASIC", "BASIC_SET", new byte[] { BASIC_OFF });
                                    break;
                            }
                            foreach (IDeviceInfo node in selectedDevices)
                            {
                                if (node.Id != ControllerManager.DocumentModel.Controller.Id)// && node.IsListening)
                                {
                                    // Send Data
                                    try
                                    {
                                        TransmitStatuses res = TransmitStatuses.CompleteFail;
                                        res = ControllerManager.DocumentModel.Controller.SendData(node.Id, command, txOption);
                                        packetsSend++;
                                        ControllerManager.ErttForm.BeginInvoke(new EventHandler(delegate
                                        {
                                            ControllerManager.ErttForm.PacketSentLabel.Text = packetsSend.ToString();
                                        }));
                                        if (res == TransmitStatuses.CompleteOk)
                                        {
                                            packetSendSuccess++;
                                            ControllerManager.ErttForm.BeginInvoke(new EventHandler(delegate
                                            {
                                                ControllerManager.ErttForm.PacketReceivedLabel.Text = packetSendSuccess.ToString();
                                            }));
                                        }
                                        else if (res == TransmitStatuses.ResMissing)
                                        {
                                            packetUARTErrors++;
                                            ControllerManager.ErttForm.BeginInvoke(new EventHandler(delegate
                                            {
                                                ControllerManager.ErttForm.UartErrorsLabel.Text = packetUARTErrors.ToString();
                                            }));
                                        }
                                        ControllerManager.ErttForm.Invoke(new EventHandler(delegate
                                        {
                                            foreach (DataGridViewRow row in ControllerManager.ErttForm.ReportDataGridView.Rows)
                                            {
                                                if (row.Tag != null && row.Tag is IDeviceInfo && (row.Tag as IDeviceInfo).Id == node.Id)
                                                {
                                                    row.Cells[2].Value = ((int)res).ToString();
                                                    if (res != 0)
                                                    {
                                                        int cnt = int.Parse(row.Cells[3].Value.ToString());
                                                        cnt++;
                                                        row.Cells[3].Value = cnt;
                                                    }
                                                }
                                            }

                                        }));

                                        if ((noOfRuns >= (iMax * nodesCount)) && (iMax != 0xFFFF))
                                        {
                                            isStarted = false;
                                        }
                                        else
                                        {
                                            noOfRuns++;
                                        }
                                        if (res != 0 && ControllerManager.ErttForm.StopOnErrorCheckBox.Checked)
                                        {
                                            isStarted = false;
                                        }
                                    }
                                    catch (Exception ex)
                                    {
                                        ControllerManager.LogManager.LogOperationFailure("Error in runing ERTT test. " + ex.Message);
                                        isStarted = false;
                                    }
                                }
                            }
                        }
                    }
                }));

                tr.IsBackground = true;
                tr.Start();
            }
        }
    }
}