using System;
using System.Collections.Generic;
using System.Text;
using Zensys.ZWave.Devices;
using Zensys.Framework;
using System.Timers;
using Zensys.ZWave.InstallerTool.Controllers;
using System.Windows.Forms;
using Zensys.ZWave.Logging;
using Zensys.ZWave.Events;

namespace Zensys.ZWave.InstallerTool.Models
{
    public class DocumentModel
    {
        public event EventHandler<EventArgs> DocumentModelStateChanged;
        public event EventHandler<EventArgs> ControllerChanging;
        public event EventHandler<EventArgs> ControllerChanged;
        private BindingContext mContext;
        public DocumentModel(BindingContext context)
        {
            mDevices = new ThreadedBindingList<IDeviceInfo>();
            mTopologyMapItemCollection = new TopologyMapItemCollection();
            mTopologyMapItemCollection.CollectionChanged += new EventHandler<NotifyCollectionChangedEventArgs>(OnDocumentModelStateChanged);
            if (context != null)
            {
                mContext = context;
                mDevicesCurrencyManager = (CurrencyManager)context[mDevices];
            }

        }

        #region Devices (nodes)
        internal void RemoveDevice(byte deviceId)
        {
            lock (mDevices)
            {
                IDeviceInfo deviceForDelete = null;
                foreach (IDeviceInfo device in mDevices)
                {
                    if (device.Id == deviceId)
                    {
                        deviceForDelete = device;
                    }
                }
                if (deviceForDelete != null)
                {
                    mDevices.Remove(deviceForDelete);
                }
            }
        }
        private ThreadedBindingList<IDeviceInfo> mDevices;
        public ThreadedBindingList<IDeviceInfo> Devices
        {
            get { return mDevices; }
            set { mDevices = value; }
        }

        private CurrencyManager mDevicesCurrencyManager;
        public CurrencyManager DevicesCurrencyManager
        {
            get { return mDevicesCurrencyManager; }
        }

        public IDeviceInfo CurrentDevice
        {
            get
            {
                if (mDevicesCurrencyManager.Position != -1)
                {
                    return (IDeviceInfo)mDevicesCurrencyManager.Current;
                }
                else
                {
                    return null;
                }
            }
        }
        #endregion

        void OnDocumentModelStateChanged(object sender, NotifyCollectionChangedEventArgs e)
        {
            SetDocumentModelStateChanged();
        }

        void OnDocumentModelStateChanged(object sender, EventArgs e)
        {
            SetDocumentModelStateChanged();
        }

        public void SetDocumentModelStateChanged()
        {
            if (DocumentModelStateChanged != null)
                DocumentModelStateChanged(this, EventArgs.Empty);
        }

        private DataSourceStates mState;
        public DataSourceStates State
        {
            get { return mState; }
        }

        private IInstallerController mController = null;
        public IInstallerController Controller
        {
            get { return mController; }
        }

        internal void SetUpController(IInstallerController value)
        {
            mController = value;
            if (mController != null)
            {
                mController.ApplicationCommandHandlerEvent -= new Zensys.ZWave.Events.DeviceAppCommandHandlerEventHandler(ControllerManager.Instance.Actions.CommonActions.ControllerApplicationCommandHandlerEvent);
                mController.ApplicationCommandHandlerEvent += new Zensys.ZWave.Events.DeviceAppCommandHandlerEventHandler(ControllerManager.Instance.Actions.CommonActions.ControllerApplicationCommandHandlerEvent);

                mController.ControllerUpdated -= new Zensys.ZWave.Events.ControllerUpdatedEventHandler(ControllerManager.Instance.Actions.ControllerFormActions.ControllerUpdated);
                mController.ControllerUpdated += new Zensys.ZWave.Events.ControllerUpdatedEventHandler(ControllerManager.Instance.Actions.ControllerFormActions.ControllerUpdated);

                mController.LearnModeStatusChanged -= new LearnModeStatusChangedEventHandler(ControllerManager.Instance.Actions.ControllerFormActions.LearnModeStatusChanged);
                mController.LearnModeStatusChanged += new LearnModeStatusChangedEventHandler(ControllerManager.Instance.Actions.ControllerFormActions.LearnModeStatusChanged);

                mController.NodeStatusChanged -= new Zensys.ZWave.Events.NodeStatusChangedEventHandler(ControllerManager.Instance.Actions.NodeFormActions.OnControllerNodeStatusChanged);
                mController.NodeStatusChanged += new Zensys.ZWave.Events.NodeStatusChangedEventHandler(ControllerManager.Instance.Actions.NodeFormActions.OnControllerNodeStatusChanged);

                mController.CommandClassesStore.GetExternalStorageBuffer -= new GetExternalStorageBufferEventHandler(CommandClassesStore_GetExternalStorageBuffer);
                mController.CommandClassesStore.GetExternalStorageBuffer += new GetExternalStorageBufferEventHandler(CommandClassesStore_GetExternalStorageBuffer);

                mController.CommandClassesStore.PutExternalStorageBuffer -= new PutExternalStorageBufferEventHandler(CommandClassesStore_PutExternalStorageBuffer);
                mController.CommandClassesStore.PutExternalStorageBuffer += new PutExternalStorageBufferEventHandler(CommandClassesStore_PutExternalStorageBuffer);
            }
            SetDocumentModelStateChanged();
        }
        private byte[] mExternalCommandClassesStorage = new byte[2000];
        /// <summary>
        /// Gets the external storage.
        /// </summary>
        /// <value>The external storage.</value>
        public byte[] ExternalCommandClassesStorage
        {
            get { return mExternalCommandClassesStorage; }
            set { mExternalCommandClassesStorage = value; }
        }

        private void CommandClassesStore_PutExternalStorageBuffer(uint offset, byte[] buffer, uint length)
        {
            for (uint i = offset; i < offset + length; i++)
            {
                mExternalCommandClassesStorage[i] = buffer[i - offset];
            }
        }

        private byte[] CommandClassesStore_GetExternalStorageBuffer(uint offset, byte length)
        {
            byte[] ret = new byte[length];
            for (uint i = offset; i < offset + length; i++)
            {
                ret[i - offset] = mExternalCommandClassesStorage[i];
            }
            return ret;
        }
        private TopologyMapItemCollection mTopologyMapItemCollection;
        public TopologyMapItemCollection TopologyMapItemCollection
        {
            get { return mTopologyMapItemCollection; }
        }
    }
}
