using System;
using System.Collections.Generic;
using System.Text;
using Zensys.ZWave.InstallerTool.UI;
using Zensys.ZWave.InstallerTool.Interfaces;
using Zensys.ZWave.InstallerTool.Models;
using Zensys.ZWave.InstallerTool.Classes;

namespace Zensys.ZWave.InstallerTool.Dispatchers
{
    /// <summary>
    /// LogFormDispatcher class. Bind/Unbind functions to the Log Form controls.
    /// </summary>
    public class LogFormDispatcher : IViewDispatcher
    {
        #region IViewDispatcher Members
        /// <summary>
        /// Binds the functions to the specified view.
        /// </summary>
        /// <param name="view">The view.</param>
        /// <param name="actions">The actions (functions).</param>
        public void Bind(IView view, ActionCollection actions, DocumentModel documentModel)
        {
            LogForm form = (LogForm)view;

            //Form
            form.Load += new EventHandler(actions.LogFormActions.OnFormLoad);
            form.FormClosing += new System.Windows.Forms.FormClosingEventHandler(actions.LogFormActions.OnFormClosing);


        }
        /// <summary>
        /// Drops the functions to the specified view.
        /// </summary>
        /// <param name="view">The view.</param>
        /// <param name="actions">The actions (functions).</param>
        public void Drop(IView view, ActionCollection actions, DocumentModel documentModel)
        {
            LogForm form = (LogForm)view;

            ////Form
            form.Load -= new EventHandler(actions.LogFormActions.OnFormLoad);
            form.FormClosing -= new System.Windows.Forms.FormClosingEventHandler(actions.LogFormActions.OnFormClosing);

        }

        #endregion
    }
}
