using System;
using System.Collections.Generic;
using System.Text;
using Zensys.ZWave.InstallerTool.Controllers;
using Zensys.ZWave.ZWaveHAL.Actions;
using Zensys.ZWave.Enums;

namespace Zensys.ZWave.InstallerTool.Classes
{
    /// <summary>
    /// Base class for actions. Provides methods that extends <see cref="ControllerManager"/> 
    /// </summary>
    public class BaseAction
    {
        private ControllerManager mControllerManager;
        internal ControllerManager ControllerManager
        {
            get { return mControllerManager; }
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="BaseAction"/> class.
        /// </summary>
        /// <param name="controllerManager">The controller manager.</param>
        public BaseAction(ControllerManager controllerManager)
        {
            mControllerManager = controllerManager;
        }
        public bool IsControllerLibrary(Libraries library)
        {
            return library == Libraries.InstallerLib;
        }

        private ActionsHAL mActionsHAL;
        public ActionsHAL ActionsHAL
        {
            get { return mActionsHAL; }
            set { mActionsHAL = value; }
        }
    }
}
