using System;
using System.Collections.Generic;
using System.Text;
using Zensys.ZWave.InstallerTool.Classes;
using Zensys.ZWave.InstallerTool.Controllers;
using System.Windows.Forms;
using Zensys.ZWave.Logging;
using Zensys.Framework;
using Zensys.Framework.UI.Controls;
using Zensys.ZWave.InstallerTool.UI;
using System.Threading;
using System.Data;

namespace Zensys.ZWave.InstallerTool.Actions
{
    /// <summary>
    /// LogFormActions class. Contains Log Form functions.
    /// </summary>
    public class LogFormActions : BaseAction
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="LogFormActions"/> class.
        /// </summary>
        /// <param name="controller">The controller.</param>
        public LogFormActions(ControllerManager controller)
            : base(controller)
        {

        }

        public void OnFormLoad(object sender, EventArgs e)
        {
            BindData();
        }

        private void BindData()
        {
            ControllerManager.ZWaveManager.LogDataSource.Ctx = SynchronizationContext.Current;
            DataColumn dcIsPut = new DataColumn("IsPut", typeof(bool));
            DataColumn dcIsRequest = new DataColumn("IsRequest", typeof(bool));
            DataColumn dcTime = new DataColumn("Time", typeof(DateTime));
            DataColumn dcApplicationString = new DataColumn("ApplicationString", typeof(string));
            DataColumn dcParameterString = new DataColumn("ParameterString", typeof(string));
            DataColumn dcPayload = new DataColumn("Payload", typeof(byte[]));

            ControllerManager.LogForm.logViewControl.DataTable.Columns.Add(dcIsPut);
            ControllerManager.LogForm.logViewControl.DataTable.Columns.Add(dcIsRequest);
            ControllerManager.LogForm.logViewControl.DataTable.Columns.Add(dcTime);
            ControllerManager.LogForm.logViewControl.DataTable.Columns.Add(dcApplicationString);
            ControllerManager.LogForm.logViewControl.DataTable.Columns.Add(dcParameterString);
            ControllerManager.LogForm.logViewControl.DataTable.Columns.Add(dcPayload);
            ControllerManager.ZWaveManager.LogDataSource.ListChanged += new System.ComponentModel.ListChangedEventHandler(LogDataSource_ListChanged);
        }

        void LogDataSource_ListChanged(object sender, System.ComponentModel.ListChangedEventArgs e)
        {
            switch (e.ListChangedType)
            {
                case System.ComponentModel.ListChangedType.ItemAdded:
                    ControllerManager.LogForm.logViewControl.DataTable.Rows.Add(new object[] 
                    { 
                        ControllerManager.ZWaveManager.LogDataSource[e.NewIndex].IsPut,
                        ControllerManager.ZWaveManager.LogDataSource[e.NewIndex].IsRequest,
                        ControllerManager.ZWaveManager.LogDataSource[e.NewIndex].Time,
                        ControllerManager.ZWaveManager.LogDataSource[e.NewIndex].ApplicationString,
                        ControllerManager.ZWaveManager.LogDataSource[e.NewIndex].ParameterString,
                        ControllerManager.ZWaveManager.LogDataSource[e.NewIndex].Payload
                    });

                    break;
                case System.ComponentModel.ListChangedType.ItemChanged:
                    break;
                case System.ComponentModel.ListChangedType.ItemDeleted:
                    break;
                case System.ComponentModel.ListChangedType.ItemMoved:
                    break;
                case System.ComponentModel.ListChangedType.PropertyDescriptorAdded:
                    break;
                case System.ComponentModel.ListChangedType.PropertyDescriptorChanged:
                    break;
                case System.ComponentModel.ListChangedType.PropertyDescriptorDeleted:
                    break;
                case System.ComponentModel.ListChangedType.Reset:
                    ControllerManager.LogForm.logViewControl.DataTable.Rows.Clear();
                    foreach (LogPacket lp in ControllerManager.ZWaveManager.LogDataSource)
                    {
                        ControllerManager.LogForm.logViewControl.DataTable.Rows.Add(new object[] 
                        { 
                            lp.IsPut,
                            lp.IsRequest,
                            lp.Time,
                            lp.ApplicationString,
                            lp.ParameterString,
                            lp.Payload
                        });
                    }

                    break;
                default:
                    break;
            }
        }

        public void OnFormClosing(object sender, FormClosingEventArgs e)
        {
            ControllerManager.MainForm.LogToolStripMenuItem.Checked = false;
            ControllerManager.LogForm.Hide();
            e.Cancel = true;
        }

        public void WriteMessage(string message)
        {
            if (ControllerManager.LogForm != null && ControllerManager.LogForm.IsDisposed == false)
            {
                ControllerManager.LogForm.Invoke(new EventHandler(delegate
                {
                    if (ControllerManager.LogForm.txtLog.Text.Length + message.Length >= ControllerManager.LogForm.txtLog.MaxLength)
                    {
                        ControllerManager.LogForm.txtLog.Text = string.Empty;
                    }
                    ControllerManager.LogForm.txtLog.AppendText(message);
                    ControllerManager.LogForm.txtLog.AppendText(Environment.NewLine);
                }));
            }
        }

        public void WriteMessage(Exception exception)
        {
            WriteMessage(exception.Message);
        }
    }
}
