using System;
using System.Collections.Generic;
using System.Text;
using System.Drawing;

namespace Zensys.Framework.UI.Controls
{
    /// <summary>
    /// Provides information how data item should be present in ListDataView
    /// </summary>
    public class ItemColumn
    {
        public ItemColumn(string caption, string[] dataItems, GetTextHandler onGetText, GetImageIndexHandler onGetImageIndex) 
        {
            mCaption = caption;
            mDataItems = dataItems;
            OnGetText = onGetText;
            OnGetImageIndex = onGetImageIndex;
        }

        public ItemColumn(string caption, string[] dataItems, GetTextHandler onGetText, GetImageIndexHandler onGetImageIndex, int width)
            : this(caption, dataItems, onGetText, onGetImageIndex)
        {
            mWidth = width;
        }

        public ItemColumn(string caption, string[] dataItems, GetTextHandler onGetText, GetImageIndexHandler onGetImageIndex, bool autoWidth)
            : this(caption, dataItems, onGetText, onGetImageIndex)
        {
            mAutoWidth = autoWidth;
        }

        private string mCaption;
        /// <summary>
        /// Gets the caption of the column.
        /// </summary>
        /// <value>The caption.</value>
        public string Caption
        {
            get { return mCaption; }
            //set { mCaption = value; }
        }

        private int mWidth = 75;
        /// <summary>
        /// Gets the width.
        /// </summary>
        /// <value>The width.</value>
        public int Width
        {
            get { return mWidth; }
            //set { mWidth = value; }
        }

        private bool mAutoWidth;
        public bool AutoWidth
        {
            get { return mAutoWidth; }
            //set { mAutoWidth = value; }
        }
	

        private string[] mDataItems;
        /// <summary>
        /// Gets the data items.
        /// </summary>
        /// <value>The data items.</value>
        public string[] DataItems
        {
            get { return mDataItems; }
            //set { mDataItems = value; }
        }

        public event GetTextHandler OnGetText;
        public event GetImageIndexHandler OnGetImageIndex;

        public string GetText(List<object> dataObjects)
        {
            string ret = null;
            if (OnGetText != null)
            {
                ret = OnGetText(dataObjects);
            }
            return ret;
        }

        public int GetImageIndex(List<object> dataObjects)
        {
            int ret = -1;
            if (OnGetImageIndex != null)
            {
                ret = OnGetImageIndex(dataObjects);
            }
            return ret;
        }
    }
    public delegate string GetTextHandler(List<object> dataObjects);
    public delegate int GetImageIndexHandler(List<object> dataObjects);
}
