using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using System.Drawing;

namespace Zensys.Framework.UI.Controls
{
    public class DataGridViewBitImageCell : DataGridViewImageCell
    {
        public DataGridViewBitImageCell()
            : base()
        {
        }
        public override Type EditType
        {
            get
            {
                return null;
            }
        }

        protected override Size GetPreferredSize(Graphics graphics, DataGridViewCellStyle cellStyle, int rowIndex, Size constraintSize)
        {
            if (this.OwningColumn != null && this.OwningColumn is DataGridViewBitImageColumn)
            {
                DataGridViewBitImageColumn clmn = (DataGridViewBitImageColumn)this.OwningColumn;
                if (clmn.Images != null && clmn.Images.Images.Count > 0)
                {
                    Size retVal = clmn.Images.ImageSize;
                    if (retVal.Width < 10)
                        return new Size(16, 16);
                    retVal.Width += 2;

                    return retVal;
                }
            }
            return base.GetPreferredSize(graphics, cellStyle, rowIndex, constraintSize);
        }

        protected override object GetFormattedValue(object value, int rowIndex, ref DataGridViewCellStyle cellStyle, System.ComponentModel.TypeConverter valueTypeConverter, System.ComponentModel.TypeConverter formattedValueTypeConverter, DataGridViewDataErrorContexts context)
        {
            if (value == null)
                return value;

            if (!value.GetType().IsAssignableFrom(typeof(Image)))
            {
                if (this.OwningColumn is DataGridViewBitImageColumn)
                {
                    if (value is bool)
                    {
                        DataGridViewBitImageColumn clmn = (DataGridViewBitImageColumn)this.OwningColumn;
                        if (clmn.Images != null && clmn.Images.Images.Count>1)
                        {
                            Image img = null;
                            if ((bool)value)
                            {
                                if (clmn.TrueImageIndex > -1)
                                {
                                    img = clmn.Images.Images[clmn.TrueImageIndex];
                                }
                            }
                            else
                            {
                                if (clmn.FalseImageIndex > -1)
                                {
                                    img = clmn.Images.Images[clmn.FalseImageIndex];
                                }
                            }
                            return img;
                        }
                    }
                }
            }
            else
                return base.GetFormattedValue(value, rowIndex, ref cellStyle, valueTypeConverter, formattedValueTypeConverter, context);

            return null;
        }
    }
}
