using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;
using Zensys.Framework.UI.Controls;

namespace Zensys.Framework.UI.Views
{
    public partial class LogViewControl : UserControl
    {
        public LogViewControl()
        {
            InitializeComponent();
            DoubleBuffered = true;
            ImageList ilist = new ImageList();
            ilist.TransparentColor = Color.Magenta;
            ilist.Images.AddRange(new Image[] { Properties.Resources.Input, Properties.Resources.Output});
            logView.SmallImageList = ilist;
        }

        private void listView1_Resize(object sender, EventArgs e)
        {
            int fixedWidth = 0;
            int autoWidthColumnsCount = 0;
            foreach (ItemColumn icol in ItemColumns)
            {
                if (icol.AutoWidth)
                    autoWidthColumnsCount++;
                else
                    fixedWidth += icol.Width;
            }
            if (autoWidthColumnsCount > 0)
            {
                int width = (int)((logView.ClientSize.Width - fixedWidth) / autoWidthColumnsCount);
                if (width < 75)
                    width = 75;
                foreach (ColumnHeader col in logView.Columns)
                {
                    if (col.Tag as ItemColumn != null)
                    {
                        ItemColumn ic = (ItemColumn)col.Tag;
                        if (ic.AutoWidth)
                        {
                            col.Width = width;
                        }
                    }
                }
            }
        }

        private void btnCopy_Click(object sender, EventArgs e)
        {
            if (logView.SelectedItems.Count > 10000)
                if (MessageBox.Show(Properties.Resources.msgLogViewTooManyItems, Properties.Resources.captionLogView, MessageBoxButtons.OKCancel) != DialogResult.OK)
                    return;
            if (logView.Items != null && logView.Items.Count > 0)
            {
                if (logView.SelectedItems != null && logView.SelectedItems.Count > 0)
                {
                    StringBuilder sb = new StringBuilder();
                    foreach (ListViewItem item in logView.SelectedItems)
                    {
                        if (item.ImageIndex == InputImageIndex)
                            sb.Append("IN");
                        else
                            sb.Append("OUT");
                        for (int i = 1; i < ItemColumns.Count; i++)
                        {
                            sb.Append('\t');
                            sb.Append(item.SubItems.Count > i && item.SubItems[i] != null ? item.SubItems[i].Text : "N/A");
                        }
                        sb.Append(Environment.NewLine);
                    }
                    Clipboard.SetText(sb.ToString());
                }
            }
        }

        private void btnClear_Click(object sender, EventArgs e)
        {
            if (logView.Items.Count > 0)
            {
                if (MessageBox.Show(Properties.Resources.msgLogViewClear, Properties.Resources.captionLogView, MessageBoxButtons.OKCancel) != DialogResult.OK)
                    return;
                logView.ClearItems();
            }
        }

        private void btnRemove_Click(object sender, EventArgs e)
        {
            if (logView.SelectedItems != null && logView.SelectedItems.Count > 0)
            {
                if (MessageBox.Show(Properties.Resources.msgLogViewRemoveSelected, Properties.Resources.captionLogView, MessageBoxButtons.OKCancel) != DialogResult.OK)
                    return;
                foreach (ListViewItem item in logView.SelectedItems)
                {
                    logView.RemoveItem(item);
                }
            }
        }


        /// <summary>
        /// Registers the menu.
        /// </summary>
        /// <param name="mainMenu">The main menu.</param>
        public void RegisterMenu(MenuStrip mainMenu)
        {
            ToolStripMenuItem logMenu = null;
            foreach (ToolStripItem var in mainMenu.Items)
            {
                if (var is ToolStripMenuItem)
                {
                    if (var.Text == Properties.Resources.menuLogView)
                    {
                        logMenu = var as ToolStripMenuItem;
                        break;
                    }
                }
            }
            if (logMenu == null)
            {
                logMenu = new ToolStripMenuItem();
                logMenu.Text = Properties.Resources.menuLogView;
                mainMenu.Items.Add(logMenu);
            }
            logMenu.DropDownItems.Clear();
            ToolStripItem copyMenuItem = CreateAsToolStripButton(btnCopy);
            copyMenuItem.Click += btnCopy_Click;
            ToolStripItem removeMenuItem = CreateAsToolStripButton(btnRemove);
            removeMenuItem.Click += btnRemove_Click;
            ToolStripItem clearMenuItem = CreateAsToolStripButton(btnClear);
            clearMenuItem.Click += btnClear_Click;
            logMenu.DropDownItems.AddRange(new System.Windows.Forms.ToolStripItem[] {
            copyMenuItem, removeMenuItem, clearMenuItem});
        }

        private ToolStripItem CreateAsToolStripButton(ToolStripButton btn)
        {
            ToolStripItem ret = new ToolStripMenuItem();
            ret.Text = btn.Text;
            ret.ToolTipText = btn.ToolTipText;
            ret.Image = btn.Image;
            return ret;
        }

        public IBindingList DataSource
        {
            get { return logView.DataSource; }
            set { logView.DataSource = value; }
        }

        public List<ItemColumn> ItemColumns
        {
            get { return logView.ItemColumns; }
        }

        public int InputImageIndex
        {
            get { return 0; }
        }
        
        public int OutputImageIndex
        {
            get { return 1; }
        }

        public bool AutoScrollItems
        {
            get { return logView.AutoScrollItems; }
            set { logView.AutoScrollItems = value; }
        }

        public Color BkColor
        {
            get { return logView.BkColor; }
            set { logView.BkColor = value; }
        }

        public Color AlternativeBkColor
        {
            get { return logView.AlternativeBkColor; }
            set { logView.AlternativeBkColor = value; }
        }
    }
}
