using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;
using Zensys.Framework.UI.Controls;
using System.Drawing.Design;
using System.Threading;

namespace Zensys.Framework.UI.Views
{
    public partial class LogGridViewControl : UserControl
    {
        public event EventHandler FilterClick;
        public LogGridViewControl()
        {
            InitializeComponent();
            ImageList.TransparentColor = Color.Magenta;
            ImageList.Images.AddRange(new Image[] { Properties.Resources.Input, Properties.Resources.Output, Properties.Resources.Help, Properties.Resources.Information });
            mDataTable = new DataTable();
            LogBindingSource.DataSource = DataTable;
        }

        private DataTable mDataTable;
        public DataTable DataTable
        {
            get { return mDataTable; }
            set { mDataTable = value; }
        }
	
        private void btnClear_Click(object sender, EventArgs e)
        {
            if (logGridView.Rows.Count > 0)
            {
                if (MessageBox.Show(Properties.Resources.msgLogViewClear, Properties.Resources.captionLogView, MessageBoxButtons.OKCancel) != DialogResult.OK)
                    return;
                //logGridView.Rows.Clear();
                if(LogBindingSource!=null)
                    ((DataTable)LogBindingSource.DataSource).Clear();
            }
        }

        private void btnRemove_Click(object sender, EventArgs e)
        {
            if (logGridView.SelectedRows != null && logGridView.SelectedRows.Count > 0)
            {
                if (MessageBox.Show(Properties.Resources.msgLogViewRemoveSelected, Properties.Resources.captionLogView, MessageBoxButtons.OKCancel) != DialogResult.OK)
                    return;
                foreach (DataGridViewRow item in logGridView.SelectedRows)
                {
                    logGridView.Rows.Remove(item);
                    if (LogBindingSource != null)
                    {
                        LogBindingSource.Remove(item.DataBoundItem);
                    }
                }
            }
        }


        /// <summary>
        /// Registers the menu.
        /// </summary>
        /// <param name="mainMenu">The main menu.</param>
        public void RegisterMenu(MenuStrip mainMenu)
        {
            ToolStripMenuItem logMenu = null;
            foreach (ToolStripItem var in mainMenu.Items)
            {
                if (var is ToolStripMenuItem)
                {
                    if (var.Text == Properties.Resources.menuLogView)
                    {
                        logMenu = var as ToolStripMenuItem;
                        break;
                    }
                }
            }
            if (logMenu == null)
            {
                logMenu = new ToolStripMenuItem();
                logMenu.Text = Properties.Resources.menuLogView;
                mainMenu.Items.Add(logMenu);
            }
            logMenu.DropDownItems.Clear();
            ToolStripItem removeMenuItem = CreateAsToolStripButton(btnRemove);
            removeMenuItem.Click += btnRemove_Click;
            ToolStripItem clearMenuItem = CreateAsToolStripButton(btnClear);
            clearMenuItem.Click += btnClear_Click;
            logMenu.DropDownItems.AddRange(new System.Windows.Forms.ToolStripItem[] { removeMenuItem, clearMenuItem});
        }

        private ToolStripItem CreateAsToolStripButton(ToolStripButton btn)
        {
            ToolStripItem ret = new ToolStripMenuItem();
            ret.Text = btn.Text;
            ret.ToolTipText = btn.ToolTipText;
            ret.Image = btn.Image;
            return ret;
        }

        public DataGridView LogGridView
        {
            get { return logGridView; }
        }

        private void toolStripButton1_Click(object sender, EventArgs e)
        {
            if (FilterClick != null)
            {
                FilterClick(this, EventArgs.Empty);
            }
            if (string.IsNullOrEmpty(LogBindingSource.Filter))
            {
                LogBindingSource.Filter = "IsRequest = true";
            }
            else
            {
                LogBindingSource.RemoveFilter();
            }

        }

        private void btnResetSort_Click(object sender, EventArgs e)
        {
            LogBindingSource.RemoveSort();
        }
    }
}
