using System;
using System.Collections.Generic;
using System.Text;

namespace Zensys.Framework.Helpers
{
    /// <summary>
    /// Provides static methods for the converting data.
    /// </summary>
    public static class Converter
    {
        /// <summary>
        /// Gets the hex.
        /// </summary>
        /// <param name="key">The key.</param>
        /// <returns></returns>
        public static string getHex(byte key)
        {
            string ret = string.Format("0x{0:X2}", key);
            return ret;
        }
        /// <summary>
        /// Gets the byte from string.
        /// </summary>
        /// <param name="str">The string value.</param>
        /// <returns></returns>
        public static Byte GetByte(string str)
        {
            if (str.StartsWith("0x") || str.StartsWith("0X"))
                return Convert.ToByte(str, 16);
            else
                return Convert.ToByte(str);
        }

        /// <summary>
        /// Gets the datetime.
        /// </summary>
        /// <param name="value">The string value.</param>
        /// <returns></returns>
        public static DateTime getDateTime(string value)
        {
            return DateTime.Parse(value);
        }

        /// <summary>
        /// Gets the string from DateTime.
        /// </summary>
        /// <param name="value">The DateTime value.</param>
        /// <returns></returns>
        public static string getString(DateTime value)
        {
            return value.ToString();
        }
    }
}
