using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using Zensys.ZWave.Application;

namespace Zensys.ZWave.ZWaveHAL.UI
{
    public partial class VariantGroupEditorForm : Form
    {
        public VariantGroupEditorForm()
        {
            InitializeComponent();
        }

        private ParamValue mObj;
        public ParamValue Obj
        {
            get { return mObj; }
            set { mObj = value; }
        }


        private void VariantGroupEditorForm_Load(object sender, EventArgs e)
        {
            if (Obj != null && Obj.ParamValues != null)
            {
                foreach (ParamValue p in Obj.ParamValues)
                {
                    vglist.Add(new ParameterWrapperCollection(p.ParamValues, Obj.ParamDefinition.Name + "[" + vglist.Count.ToString() + "]"));
                }
            }
            BindList();
            if (listBox1.Items.Count > 0)
            {
                listBox1.SelectedIndex = 0;
                this.prpParametersGrid.SelectedObject = vglist[0];
            }
        }

        private void BindList()
        {
            listBox1.DataSource = vglist;
        }

        private void btnOk_Click(object sender, EventArgs e)
        {
            DialogResult = DialogResult.OK;
            Close();
        }

        private void btnAdd_Click(object sender, EventArgs e)
        {
            ParamValue pv = ParamValue.CreateParamValue(Obj.ParamDefinition);
            pv.ParamValues = new List<ParamValue>();
            foreach (Param p in pv.ParamDefinition.Param1)
            {
                pv.ParamValues.Add(ParamValue.CreateParamValue(p));
            }
            if (Obj.ParamValues == null)
            {
                Obj.ParamValues = new List<ParamValue>();
            }
            Obj.ParamValues.Add(pv);
            vglist.Add(new ParameterWrapperCollection(pv.ParamValues, Obj.ParamDefinition.Name + "[" + vglist.Count.ToString() + "]"));
            if (listBox1.Items.Count > 0)
            {
                listBox1.SelectedIndex = vglist.Count - 1;
                this.prpParametersGrid.SelectedObject = vglist[vglist.Count - 1];
            }
            else
            {
                this.prpParametersGrid.SelectedObject = null;
            }
        }

        private void btnRemove_Click(object sender, EventArgs e)
        {
            if (listBox1.SelectedIndex > -1)
            {
                vglist.RemoveAt(listBox1.SelectedIndex);
            }
            if (listBox1.Items.Count > 0)
            {
                listBox1.SelectedIndex = 0;
                this.prpParametersGrid.SelectedObject = vglist[0];
            }
            else
            {
                this.prpParametersGrid.SelectedObject = null;
            }
        }

        BindingList<ParameterWrapperCollection> vglist = new BindingList<ParameterWrapperCollection>();
        private void listBox1_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (listBox1.SelectedIndex > -1)
            {
                this.prpParametersGrid.SelectedObject = vglist[listBox1.SelectedIndex];
            }
            else
            {
                this.prpParametersGrid.SelectedObject = null;
            }
        }

    }
}