using System;
using System.Collections.Generic;
using System.Text;
using System.Configuration;
using Zensys.ZWave.Devices;
using System.Windows.Forms;
using WeifenLuo.WinFormsUI.Docking;
using Zensys.ZWave.Application;

namespace Zensys.ZWave.ZWaveHAL
{
    public class BaseEntryPointHAL
    {
        protected LogManager mLogManager;
        protected ExceptionManager mExceptionManager;
        protected XmlDataManager mXmlDataManager;
        protected String mPortName;
        public virtual void Initialize(IController connectedDevice, string portName, LogManager logManager, ExceptionManager exceptionManager, XmlDataManager xmlDataManager)
        {
            mPortName = portName;
            mLogManager = logManager;
            mExceptionManager = exceptionManager;
            mXmlDataManager = xmlDataManager;
            SetNodeInformationInternal(connectedDevice);
        }

        public virtual void Finalize(IDevice connectedDevice)
        {
            
        }

        protected virtual void SetNodeInformationInternal(IController controller)
        {
            GenericDevice genDevice = mXmlDataManager.FindGenericDevice("GENERIC_TYPE_STATIC_CONTROLLER");
            SpecificDevice specDevice = mXmlDataManager.FindSpecificDevice(genDevice, "SPECIFIC_TYPE_PC_CONTROLLER");
            if (specDevice != null)
            {
                controller.SetNodeInformation(true,
                    genDevice.KeyId,
                    specDevice.KeyId, new byte[] 
                { 
                    mXmlDataManager.GetCommandClassKey("COMMAND_CLASS_CONTROLLER_REPLICATION"),
                    mXmlDataManager.GetCommandClassKey("COMMAND_CLASS_BASIC"),
                    mXmlDataManager.GetCommandClassKey("COMMAND_CLASS_VERSION")
                });
            }
        }

        //protected CommandClassesStore mCustomCommandClassesStore;
        //public CommandClassesStore CustomCommandClassesStore
        //{
        //    get { return mCustomCommandClassesStore; }
        //    set { mCustomCommandClassesStore = value; }
        //}

        public virtual bool IsControlVisible(string name)
        {
            return false;
        }

        public virtual void InjectUIControl(ToolStripMenuItem menuBar, DockPanel parentPanel)
        {
            
        }
        
        public virtual bool IsBusy
        {
            get { return false; }
        }


        public virtual void CustomReset()
        {
            
        }
    }
}
