using System;
using System.Collections.Generic;
using System.Text;
using Zensys.ZWave.Devices;
using Zensys.ZWave.Enums;
using System.Threading;
using Zensys.ZWave;
using Zensys.ZWave.Events;
using Zensys.Framework;
using Zensys.ZWave.Exceptions;
using Zensys.ZWave.Application;

namespace Zensys.ZWave.ZWaveHAL.Actions
{
    public class NodesViewActions : ActionsHAL
    {

        public delegate void AddQueueCommandDelegate(byte nodeId, QueueAction action);
        public delegate void ExecuteQueueCommandDelegate(byte sourceNodeId, bool isWakeUpNoMoreInformationFrameNeeded);
        public event EventHandler ItemChanged;
        public event EventHandler SendNextBasicGet;
        public event EventHandler<NodeEventArgs> NodeAdded;
        private System.Timers.Timer timerBasicGet = new System.Timers.Timer(10000);
        private AddQueueCommandDelegate mAddQueueCommandCallback;
        public AddQueueCommandDelegate AddQueueCommandCallback
        {
            get { return mAddQueueCommandCallback; }
            set { mAddQueueCommandCallback = value; }
        }

        private ExecuteQueueCommandDelegate mExecuteQueueCommandCallback;
        public ExecuteQueueCommandDelegate ExecuteQueueCommandCallback
        {
            get { return mExecuteQueueCommandCallback; }
            set { mExecuteQueueCommandCallback = value; }
        }

        public NodesViewActions(BaseEntryPointHAL entryPoint)
            : base(entryPoint)
        {
            timerBasicGet.Elapsed += new System.Timers.ElapsedEventHandler(timerBasicGet_Elapsed);
        }

        void timerBasicGet_Elapsed(object sender, System.Timers.ElapsedEventArgs e)
        {
            try
            {
                SendNextBasicGetData(basicGetController);
            }
            catch (RequestTimeoutException rex)
            {
                System.Diagnostics.Debug.WriteLine("RequestTimeoutException - timerBasicGet");
                timerBasicGet.Start();
            }

        }
        private byte mBasicValue = 0;
        public override void ProcessApplicationCommandHandler(IController controller, byte sourceNodeId, bool isBroadCast, CommandClassValue[] commandClassValues)
        {
            try
            {
                mLogManager.LogMessage(
                    string.Format("Received: {0}.{1}, hex data: {2}",
                    commandClassValues[0].CommandClassDefinition.Name,
                    commandClassValues[0].CommandValue.CommandDefinition.Name,
                    Tools.GetHex(commandClassValues[0].Data, " ", false)));
            }
            catch (Exception)
            { }
            ProcessCommandResponse(commandClassValues);
            foreach (CommandClassValue var in commandClassValues)
            {
                if (var.CommandClassDefinition.Name == "COMMAND_CLASS_WAKE_UP" && var.CommandClassDefinition.Version == 1)
                {
                    if (var.CommandValue.CommandDefinition.Name == "WAKE_UP_NOTIFICATION")
                    {
                        if (ExecuteQueueCommandCallback != null)
                        {
                            if (isBroadCast)
                            {
                                ExecuteQueueCommandCallback(sourceNodeId, false);
                            }
                            else
                            {
                                ExecuteQueueCommandCallback(sourceNodeId, true);
                            }
                        }
                    }
                    else if (var.CommandValue.CommandDefinition.Name == "WAKE_UP_INTERVAL_REPORT")
                    {
                        ThreadPool.QueueUserWorkItem(new WaitCallback(delegate
                        {
                            SendDataInternal(
                                controller,
                                sourceNodeId,
                                mXmlDataManager.FillCommand("COMMAND_CLASS_WAKE_UP", "WAKE_UP_NO_MORE_INFORMATION", null),
                                TransmitOptions.TransmitOptionAutoRoute | TransmitOptions.TransmitOptionAcknowledge | TransmitOptions.TransmitOptionExplore);
                        }));
                    }
                }
                else if (var.CommandClassDefinition.Name == "COMMAND_CLASS_BASIC" && var.CommandClassDefinition.Version == 1)
                {
                    if (var.CommandValue.CommandDefinition.Name == "BASIC_REPORT" && basicGetNodesEnumerator != null)
                    {
                        timerBasicGet.Stop();
                        SendNextBasicGetData(controller);
                        //SendNextBasicGetDataDelegate asyncThread = new SendNextBasicGetDataDelegate(SendNextBasicGetData);
                        //asyncThread.BeginInvoke(controller, SendNextBasicGetDataCallback, asyncThread);
                    }
                    else if (var.CommandValue.CommandDefinition.Name == "BASIC_SET")
                    {
                        mBasicValue = var.CommandValue.ParamValues[0].ByteValueList[0];
                    }
                    else if (var.CommandValue.CommandDefinition.Name == "BASIC_GET")
                    {
                        ThreadPool.QueueUserWorkItem(new WaitCallback(delegate
                        {
                            SendDataInternal(
                                controller,
                                sourceNodeId,
                                mXmlDataManager.FillCommand("COMMAND_CLASS_BASIC", "BASIC_REPORT", new byte[] { mBasicValue }),
                                TransmitOptions.TransmitOptionAutoRoute | TransmitOptions.TransmitOptionAcknowledge | TransmitOptions.TransmitOptionExplore);
                        }));

                    }
                }
                else if (var.CommandClassDefinition.Name == "COMMAND_CLASS_CONTROLLER_REPLICATION" && var.CommandClassDefinition.Version == 1)
                {
                    SendReplicationReceiveCompleteDelegate asyncThread = new SendReplicationReceiveCompleteDelegate(SendReplicationReceiveComplete);
                    asyncThread.BeginInvoke(controller, SendReplicationReceiveCompleteCallback, asyncThread);
                }
                else if (var.CommandClassDefinition.Name == "COMMAND_CLASS_VERSION" && var.CommandClassDefinition.Version == 1)
                {
                    if (var.CommandValue.CommandDefinition.Name == "VERSION_GET")
                    {
                        SendVersionReportDataDelegate asyncThread = new SendVersionReportDataDelegate(SendVersionReportData);
                        asyncThread.BeginInvoke(controller, sourceNodeId, SendVersionReportDataCallback, asyncThread);
                    }
                }
            }
        }

        private delegate void SendVersionReportDataDelegate(IController controller, byte destNodeId);
        private delegate void SendNextBasicGetDataDelegate(IController controller);
        private delegate void SendReplicationReceiveCompleteDelegate(IController controller);

        private void SendNextBasicGetDataCallback(IAsyncResult asyncResult)
        {
            SendNextBasicGetDataDelegate caller = (SendNextBasicGetDataDelegate)asyncResult.AsyncState;
            try
            {
                caller.EndInvoke(asyncResult);
            }
            catch (RequestTimeoutException rex)
            {
            }
        }

        private void SendReplicationReceiveCompleteCallback(IAsyncResult asyncResult)
        {
            SendReplicationReceiveCompleteDelegate caller = (SendReplicationReceiveCompleteDelegate)asyncResult.AsyncState;
            try
            {
                caller.EndInvoke(asyncResult);
            }
            catch (RequestTimeoutException rex)
            {
            }
        }
        private void SendVersionReportDataCallback(IAsyncResult asyncResult)
        {
            SendVersionReportDataDelegate caller = (SendVersionReportDataDelegate)asyncResult.AsyncState;
            try
            {
                caller.EndInvoke(asyncResult);
            }
            catch (RequestTimeoutException rex)
            {
            }
        }

        private void ProcessCommandResponse(CommandClassValue[] commandClassValues)
        {
            try
            {
                //StringBuilder sb = new StringBuilder();
                //sb.Append(string.Format("{0} received", command.Name));
                //if (args.ParamValues != null && args.ParameterValues is List<ParameterValue> && ((List<ParameterValue>)args.ParameterValues).Count > 0)
                //{
                //    sb.Append(", parameters: ");
                //    foreach (ParameterValue pval in ((List<ParameterValue>)args.ParameterValues))
                //    {
                //        sb.Append(string.Format("{0}={1}; ", pval.Text, Tools.ToHexString(pval.Value, " ")));
                //    }
                //}
                //mLogManager.LogMessage(sb.ToString());
            }
            catch (Exception)
            { }
        }

        public IDeviceInfo NetworkWideInclusionAction(IController controller)
        {
            IDeviceInfo addedNode = null;
            try
            {
                if (controller.ConnectionStatus == Zensys.ZWave.Enums.ConnectionStatuses.Closed)
                {
                    controller.Open(controller.SerialPort);
                }
                addedNode = controller.AddNodeToNetworkWide();
                if (addedNode != null && addedNode.Id != 0)
                {
                    IDeviceInfo _addedNode = controller.GetProtocolInfo(addedNode.Id, false);
                    addedNode.Capability = _addedNode.Capability;
                    addedNode.Security = _addedNode.Security;
                    addedNode.Reserved = _addedNode.Reserved;
                    if (addedNode.SupportedCommandClasses != null)
                    {
                        foreach (byte b in addedNode.SupportedCommandClasses)
                        {
                            controller.CommandClassesStore.Store(addedNode.Id, b);
                        }
                    }
                    controller.NodeAddedProtocolDone();
                    AddNodeCustomAction(addedNode);
                    if (NodeAdded != null)
                    {
                        NodeAdded(this, new NodeEventArgs(addedNode));
                    }
                }
                else
                {
                    controller.NodeAddedProtocolDone();
                }
            }
            catch (Exception ex)
            {
                mExceptionManager.RegisterException(ex);
            }
            return addedNode;
        }

        public IDeviceInfo AddNodeAction(IController controller)
        {
            IDeviceInfo addedNode = null;
            try
            {
                if (controller.ConnectionStatus == ConnectionStatuses.Closed)
                {
                    controller.Open(controller.SerialPort);
                }
                mLogManager.LogMessage("Add Node to network started...");
                addedNode = controller.AddNodeToNetwork();
                if (addedNode != null)
                {
                    IDeviceInfo _addedNode = controller.GetProtocolInfo(addedNode.Id, false);
                    addedNode.Capability = _addedNode.Capability;
                    addedNode.Security = _addedNode.Security;
                    addedNode.Reserved = _addedNode.Reserved;
                    if (addedNode.SupportedCommandClasses != null)
                    {
                        foreach (byte b in addedNode.SupportedCommandClasses)
                        {
                            controller.CommandClassesStore.Store(addedNode.Id, b);
                        }
                    }
                    controller.NodeAddedProtocolDone();
                    AddNodeCustomAction(addedNode);
                    if (NodeAdded != null)
                    {
                        NodeAdded(this, new NodeEventArgs(addedNode));
                    }
                }
                else
                {
                    controller.NodeAddedProtocolDone();
                }
            }
            catch (Exception ex)
            {
                mExceptionManager.RegisterException(ex);
            }
            return addedNode;
        }

        protected virtual bool AddNodeCustomAction(IDeviceInfo node)
        {
            return false;
        }

        public byte RemoveNodeAction(IController controller)
        {
            IDeviceInfo removedNode = null;
            try
            {
                if (controller.ConnectionStatus == ConnectionStatuses.Closed)
                {
                    controller.Open(controller.SerialPort);
                }

                removedNode = controller.RemoveNodeFromNetwork();
            }
            catch (Exception ex)
            {
                mExceptionManager.RegisterException(ex);
            }
            if (removedNode != null)
            {
                mLogManager.LogMessage("Node removed from the network...");
                return removedNode.Id;
            }
            else
            {
                mLogManager.LogMessage("Remove Node from the network failed...");
                return 0;
            }

        }

        public IDeviceInfo NodeInfoAction(IController controller, byte nodeId, IDeviceInfo device)
        {
            IDeviceInfo infoNode = null;
            try
            {
                if (controller.ConnectionStatus == ConnectionStatuses.Closed)
                {
                    controller.Open(controller.SerialPort);
                }

                infoNode = controller.RequestNodeInfo(nodeId);
            }
            catch (Exception ex)
            {
                mExceptionManager.RegisterException(ex);
            }
            if (infoNode != null)
            {
                if (infoNode.SupportedCommandClasses != null)
                {
                    device.Basic = infoNode.Basic;
                    device.Generic = infoNode.Generic;
                    device.Specific = infoNode.Specific;
                    foreach (byte b in infoNode.SupportedCommandClasses)
                    {
                        controller.CommandClassesStore.Store(infoNode.Id, b);
                    }
                    device.SupportedCommandClasses = infoNode.SupportedCommandClasses;

                    if (Array.IndexOf(device.SupportedCommandClasses, mXmlDataManager.GetCommandClassKey("COMMAND_CLASS_SECURITY")) > -1)
                    {
                        //request custom command classes 
                        NodeInfoCustomAction(controller, device);
                    }

                    if (ItemChanged != null)
                    {
                        ItemChanged(device, EventArgs.Empty);
                    }
                }
                mLogManager.LogMessage("Request Node information from the network...");
            }
            else
            {
                mLogManager.LogMessage("Request Node information from the network failed...");
            }
            return device;
        }

        protected virtual void NodeInfoCustomAction(IController controller, IDeviceInfo device)
        {

        }

        private delegate void SetWakeUpIntervalDelegate(int wakeUpInterval, IController controller, IDeviceInfo device);
        private void SetWakeUpInterval(int wakeUpInterval, IController controller, IDeviceInfo device)
        {
            wakeUpInterval *= 60; // Convert the minuttes to seconds.
            uint usec1 = (uint)wakeUpInterval >> 16 & 0xFF;
            uint usec2 = (uint)wakeUpInterval >> 8 & 0xFF;
            uint usec3 = (uint)wakeUpInterval & 0xFF;
            byte sec1 = Convert.ToByte(usec1);
            byte sec2 = Convert.ToByte(usec2);
            byte sec3 = Convert.ToByte(usec3);
            byte[] command = mXmlDataManager.FillCommand("COMMAND_CLASS_WAKE_UP", "WAKE_UP_INTERVAL_SET", new byte[] { sec1, sec2, sec3, controller.Id });
            SendDataInternal(controller, device.Id, command, TransmitOptions.TransmitOptionAutoRoute | TransmitOptions.TransmitOptionAcknowledge | TransmitOptions.TransmitOptionExplore);
        }

        public QueueAction SetWakeUpIntervalAction(IController controller, IDeviceInfo selectedDevice, string msgSetWakeUpInterval, int wakeUpInterval)
        {
            QueueAction action = null;
            try
            {
                if (controller.ConnectionStatus == ConnectionStatuses.Closed)
                {
                    controller.Open(controller.SerialPort);
                }
                if (selectedDevice.IsListening == false)
                {
                    if (selectedDevice.IsCommandQueueOverrided == false)
                    {
                        action = new QueueAction(
                            new SetWakeUpIntervalDelegate(SetWakeUpInterval),
                            new object[] { wakeUpInterval, controller, selectedDevice },
                            msgSetWakeUpInterval, true, (byte)CommandTypes.CmdZWaveSendData, "Set Wake Up Interval", 0);
                    }
                    else
                    {
                        SetWakeUpInterval(wakeUpInterval, controller, selectedDevice);
                    }
                }
            }
            catch (Exception ex)
            {
                mExceptionManager.RegisterException(ex);
            }
            return action;
        }

        public void NopAction(IController controller, byte nodeId, string msgErrNopSendFail)
        {
            try
            {
                if (controller.ConnectionStatus == ConnectionStatuses.Closed)
                {
                    controller.Open(controller.SerialPort);
                }
                byte[] nopFrame = new byte[1];
                nopFrame[0] = 0x00;

                TransmitStatuses txStatus = SendDataInternal(controller, nodeId, nopFrame, TransmitOptions.TransmitOptionAutoRoute | TransmitOptions.TransmitOptionAcknowledge | TransmitOptions.TransmitOptionExplore);
                if (txStatus != TransmitStatuses.CompleteOk)
                {
                    mLogManager.LogOperationFailure(msgErrNopSendFail);
                }
            }
            catch (Exception ex)
            {
                mExceptionManager.RegisterException(ex);
            }
        }

        public virtual bool AbortAction(IController device, byte commandType)
        {
            if (device.ConnectionStatus == Zensys.ZWave.Enums.ConnectionStatuses.Closed)
            {
                device.Open(device.SerialPort);
            }
            device.StopRequest(commandType);
            return true;
        }

        public bool IsFailedNodeAction(IController controller, byte nodeId)
        {
            bool isFailed = false;
            try
            {
                if (controller.ConnectionStatus == ConnectionStatuses.Closed)
                {
                    controller.Open(controller.SerialPort);
                }
                isFailed = controller.IsFailedNode(nodeId);
            }
            catch (Exception ex)
            {
                mExceptionManager.RegisterException(ex);
            }
            if (isFailed)
            {
                mLogManager.LogMessage("Selected Node is Failed...");
            }
            else
            {
                mLogManager.LogMessage("Selected Node is normally running...");
            }
            return isFailed;
        }

        public IDeviceInfo ReplaceFailedNodeAction(IController controller, byte nodeId)
        {
            IDeviceInfo replacedNode = null;
            try
            {
                if (controller.ConnectionStatus == ConnectionStatuses.Closed)
                {
                    controller.Open(controller.SerialPort);
                }
                replacedNode = controller.ReplaceFailedNode(nodeId);
                Thread.Sleep(100); // Workaround for TO's 02415,  02416
                if (replacedNode != null)
                {
                    IDeviceInfo _addedNode = controller.GetProtocolInfo(replacedNode.Id, false);
                    IDeviceInfo ss = controller.RequestNodeInfo(replacedNode.Id);
                    replacedNode.Capability = _addedNode.Capability;
                    replacedNode.Security = _addedNode.Security;
                    replacedNode.Reserved = _addedNode.Reserved;

                    replacedNode.Basic = _addedNode.Basic;
                    replacedNode.Generic = _addedNode.Generic;
                    replacedNode.Specific = _addedNode.Specific;
                    replacedNode.SupportedCommandClasses = ss.SupportedCommandClasses;
                    if (replacedNode.SupportedCommandClasses != null)
                    {
                        foreach (byte b in replacedNode.SupportedCommandClasses)
                        {
                            controller.CommandClassesStore.Store(replacedNode.Id, b);
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                mExceptionManager.RegisterException(ex);
            }
            if (replacedNode != null)
            {
                mLogManager.LogMessage("Failed Node removed from the network...");
            }
            else
            {
                mLogManager.LogMessage("Remove Failed Node from the network failed...");
            }
            return replacedNode;
        }

        public bool RemoveFailedNodeAction(IController controller, byte nodeId)
        {
            bool removedNode = false;
            try
            {
                if (controller.ConnectionStatus == ConnectionStatuses.Closed)
                {
                    controller.Open(controller.SerialPort);
                }
                FailedNodeStatus failedNodeStatus = controller.RemoveFailedNodeID(nodeId);
                if (failedNodeStatus == FailedNodeStatus.FailedNodeRemoved)
                {
                    removedNode = true;
                }
            }
            catch (Exception ex)
            {
                mExceptionManager.RegisterException(ex);
            }
            if (removedNode)
            {
                mLogManager.LogMessage("Failed Node removed from the network...");
            }
            else
            {
                mLogManager.LogMessage("Remove Failed Node from the network failed...");
            }
            return removedNode;
        }

        public void SetSucNodeId(IController controller, IDeviceInfo device, byte capability)
        {
            if (device != null)
            {
                BasicDevice bd = mXmlDataManager.FindBasicDevice(device.Basic);
                if (bd.Name == "BASIC_TYPE_STATIC_CONTROLLER" || bd.Name == "BASIC_TYPE_CONTROLLER")
                {
                    SetSucReturnValue ret = SetSucReturnValue.SucUndefined;
                    try
                    {
                        if (controller.ConnectionStatus == ConnectionStatuses.Closed)
                        {
                            controller.Open(controller.SerialPort);
                        }
                        ret = controller.SetSUCNodeID(device.Id, true, TransmitOptions.TransmitOptionAutoRoute | TransmitOptions.TransmitOptionAcknowledge | TransmitOptions.TransmitOptionExplore, capability);
                    }
                    catch (Exception ex)
                    {
                        mExceptionManager.RegisterException(ex);
                    }
                    mLogManager.LogMessage(string.Format("SetSuc return value = {0}...", ret));
                }
                else
                {
                    mLogManager.LogMessage(string.Format("Node:{0} is not a controller...", device.Id));
                }
            }
            else
            {
                mLogManager.LogMessage("Please select a node...");
            }

        }

        public void SendSwitchOnOffAction(IController controller, IList<IDeviceInfo> selectedNodes, bool isOn)
        {
            try
            {
                if (controller.ConnectionStatus == ConnectionStatuses.Closed)
                {
                    controller.Open(controller.SerialPort);
                }
                List<byte> nodeList = null;
                if (selectedNodes != null)
                {
                    nodeList = new List<byte>();
                    foreach (IDeviceInfo iDevice in selectedNodes)
                    {
                        if (iDevice.Generic == 0x10 || iDevice.Generic == 0x11)
                        {
                            nodeList.Add(iDevice.Id);
                        }
                    }
                }
                if (nodeList != null)
                {
                    byte[] onFrame = mXmlDataManager.FillCommand("COMMAND_CLASS_SWITCH_ALL", "SWITCH_ALL_ON", null);
                    byte[] offFrame = mXmlDataManager.FillCommand("COMMAND_CLASS_SWITCH_ALL", "SWITCH_ALL_OFF", null);
                    TransmitStatuses result;
                    if (isOn)
                    {
                        result = SendDataInternal(controller, 0xFF, onFrame, TransmitOptions.TransmitOptionAutoRoute | TransmitOptions.TransmitOptionAcknowledge | TransmitOptions.TransmitOptionExplore);
                        if (result != TransmitStatuses.CompleteOk)
                        {
                            mLogManager.LogOperationFailure(string.Format("Send SwitchOnOff operation failed. {0} received", result));
                        }
                    }
                    else
                    {
                        result = SendDataInternal(controller, 0xFF, offFrame, TransmitOptions.TransmitOptionAutoRoute | TransmitOptions.TransmitOptionAcknowledge | TransmitOptions.TransmitOptionExplore);
                        if (result != TransmitStatuses.CompleteOk)
                        {
                            mLogManager.LogOperationFailure(string.Format("Send SwitchOnOff operation failed. {0} received", result));
                        }
                    }
                    if (result == TransmitStatuses.CompleteOk)
                    {
                        foreach (byte devItemId in nodeList)
                        {
                            if (controller.CommandClassesStore.IsSupported(devItemId, mXmlDataManager.GetCommandClassKey("COMMAND_CLASS_SWITCH_ALL")))
                            {
                                if (isOn)
                                {
                                    result = SendDataInternal(controller, devItemId, onFrame, TransmitOptions.TransmitOptionAutoRoute | TransmitOptions.TransmitOptionAcknowledge | TransmitOptions.TransmitOptionExplore);
                                    if (result != TransmitStatuses.CompleteOk)
                                    {
                                        mLogManager.LogOperationFailure(string.Format("Send SwitchOnOff operation failed. {0} received", result));
                                        break;
                                    }
                                }
                                else
                                {
                                    result = SendDataInternal(controller, devItemId, offFrame, TransmitOptions.TransmitOptionAutoRoute | TransmitOptions.TransmitOptionAcknowledge | TransmitOptions.TransmitOptionExplore);
                                    if (result != TransmitStatuses.CompleteOk)
                                    {
                                        mLogManager.LogOperationFailure(string.Format("Send SwitchOnOff operation failed. {0} received", result));
                                        break;
                                    }
                                }
                            }
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                mExceptionManager.RegisterException(ex);
            }
        }

        private IEnumerator<IDeviceInfo> basicGetNodesEnumerator = null;
        private IController basicGetController = null;
        public void BasicGetAction(IController controller, IList<IDeviceInfo> selectedNodes, bool isOn)
        {
            try
            {
                if (selectedNodes.Count > 0 && isOn)
                {
                    basicGetNodesEnumerator = selectedNodes.GetEnumerator();
                    basicGetController = controller;
                    if (controller.ConnectionStatus == ConnectionStatuses.Closed)
                    {
                        controller.Open(controller.SerialPort);
                    }

                    SendNextBasicGetData(controller);
                }
                else
                {
                    timerBasicGet.Stop();
                    basicGetNodesEnumerator = null;
                    basicGetController = null;
                }
            }
            catch (Exception ex)
            {
                mExceptionManager.RegisterException(ex);
            }
            finally
            {

            }
        }

        private void SendNextBasicGetData(IController controller)
        {
            IDeviceInfo node = GetNextBasicGetNode();
            if (node != null)
            {
                Thread.Sleep(100);
                timerBasicGet.Start();
                ThreadPool.QueueUserWorkItem(new WaitCallback(delegate
                {
                    SendDataWrapper(
                                   mXmlDataManager.FindCommandClass("COMMAND_CLASS_BASIC", 1),
                                   mXmlDataManager.FindCommand("COMMAND_CLASS_BASIC", 1, "BASIC_GET"),
                                   node,
                                   controller,
                                   new byte[] { },
                                   TransmitOptions.TransmitOptionAutoRoute | TransmitOptions.TransmitOptionAcknowledge | TransmitOptions.TransmitOptionExplore);
                }));
            }
        }
        private void SendReplicationReceiveComplete(IController controller)
        {
            Thread.Sleep(300);
            controller.ReplicationReceiveComplete();
        }

        private void SendVersionReportData(IController controller, byte destNodeId)
        {
            byte[] data = mXmlDataManager.FillCommand("COMMAND_CLASS_VERSION", "VERSION_REPORT", new byte[]
            {
                (byte)controller.Version.Library,
                controller.Version.ZWaveProtocolVersion,
                controller.Version.ZWaveProtocolSubVersion,
                controller.Version.ZWaveApplicationVersion,
                controller.Version.ZWaveApplicationSubVersion
            });
            controller.SendData(destNodeId, data, TransmitOptions.TransmitOptionAutoRoute | TransmitOptions.TransmitOptionAcknowledge | TransmitOptions.TransmitOptionExplore);
        }

        private IDeviceInfo GetNextBasicGetNode()
        {
            if (basicGetNodesEnumerator != null)
            {
                if (basicGetNodesEnumerator.MoveNext())
                {
                    return basicGetNodesEnumerator.Current;
                }
                else
                {
                    basicGetNodesEnumerator.Reset();
                    return GetNextBasicGetNode();
                }
            }
            else return null;
        }

        public void SendBasicSetOnOffAction(IController controller, IList<IDeviceInfo> selectedNodes, bool isOn)
        {
            byte commandParameter = (byte)(isOn ? 0xFF : 0x00);
            try
            {
                if (controller.ConnectionStatus == ConnectionStatuses.Closed)
                {
                    controller.Open(controller.SerialPort);
                }

                TransmitStatuses result;
                if (selectedNodes != null)
                {
                    CommandClass cmdClass = mXmlDataManager.FindCommandClass("COMMAND_CLASS_BASIC", 1);
                    Command cmd = mXmlDataManager.FindCommand(cmdClass, "BASIC_SET");
                    if (selectedNodes.Count == 1)
                    {

                        SendDataWrapper(
                            cmdClass,
                            cmd,
                            selectedNodes[0],
                            controller,
                            new byte[] { commandParameter },
                            TransmitOptions.TransmitOptionAutoRoute | TransmitOptions.TransmitOptionAcknowledge | TransmitOptions.TransmitOptionExplore);
                    }
                    else
                    {
                        result = SendBasicSetInternal(controller, cmdClass, cmd, new byte[] { commandParameter }, selectedNodes);
                    }
                }
            }
            catch (Exception ex)
            {
                mExceptionManager.RegisterException(ex);
            }
        }

        protected virtual TransmitStatuses SendBasicSetInternal(IController controller, CommandClass cmdClass, Command cmd, byte[] data, IList<IDeviceInfo> selectedNodes)
        {
            List<byte> nodeList = new List<byte>();
            foreach (IDeviceInfo iDevice in selectedNodes)
            {
                nodeList.Add(iDevice.Id);
            }
            List<byte> tmp = new List<byte>();
            tmp.Add(cmdClass.KeyId);
            tmp.Add(cmd.KeyId);
            tmp.AddRange(data);
            TransmitStatuses result = SendDataMultiInternal(controller, nodeList, tmp.ToArray(), TransmitOptions.TransmitOptionAutoRoute | TransmitOptions.TransmitOptionAcknowledge | TransmitOptions.TransmitOptionExplore);
            if (result != TransmitStatuses.CompleteOk)
            {
                mLogManager.LogOperationFailure(string.Format("{0} failed. {1} received", cmd.Name, result));
            }
            else
            {
                mLogManager.LogMessage(string.Format("{0} succeeded. {1} received", cmd.Name, result));
            }
            return result;
        }

        protected virtual TransmitStatuses SendDataMultiInternal(IController controller, List<byte> nodeList, byte[] data, TransmitOptions txOptions)
        {
            TransmitStatuses result = controller.SendDataMulti(nodeList, data, txOptions);
            return result;
        }

        private delegate TransmitStatuses SendCommandDelegate(CommandClass cmdClass, Command cmd, IDeviceInfo device, IController controller, byte[] data, TransmitOptions txOptions);
        private TransmitStatuses SendCommand(CommandClass cmdClass, Command cmd, IDeviceInfo device, IController controller, byte[] data, TransmitOptions txOptions)
        {
            TransmitStatuses ret = TransmitStatuses.ResMissing;
            byte[] packet = null;
            if (data.Length > 0)
            {
                List<byte> tmp = new List<byte>();
                tmp.Add(cmdClass.KeyId);
                tmp.Add(cmd.KeyId);
                tmp.AddRange(data);
                packet = tmp.ToArray();
            }
            else
            {
                packet = new byte[] { cmdClass.KeyId, cmd.KeyId };
            }
            ret = SendDataInternal(controller, device.Id, packet, txOptions);
            if (ret != TransmitStatuses.CompleteOk)
            {
                mLogManager.LogOperationFailure(string.Format("{0} failed. {1} received", cmd.Name, ret));
            }
            else
            {
                mLogManager.LogMessage(string.Format("{0} succeeded. {1} received", cmd.Name, ret));
            }
            return ret;
        }

        protected virtual TransmitStatuses SendDataInternal(IController controller, byte deviceId, byte[] data, TransmitOptions txOptions)
        {
            TransmitStatuses ret = controller.SendData(deviceId, data, txOptions);
            return ret;
        }

        protected void SendDataWrapper(CommandClass cmdClass, Command cmd, IDeviceInfo device, IController controller, byte[] data, TransmitOptions txOptions)
        {
            if (device.IsListening || device.IsCommandQueueOverrided)
            {
                SendCommand(cmdClass, cmd, device, controller, data, txOptions);
            }
            else
            {
                if ((device.Security & 0x20) != 0 ||
                    (device.Security & 0x40) != 0)
                {
                    SendCommand(cmdClass, cmd, device, controller, data, txOptions);
                }
                else
                {
                    QueueAction action = new QueueAction(
                         new SendCommandDelegate(SendCommand),
                         new object[] { cmdClass, cmd, device, controller, data, txOptions },
                         "Sending Command", false, (byte)CommandTypes.CmdZWaveSendData, "Send Command: " + cmd.Text, 0);

                    if (mAddQueueCommandCallback != null)
                    {
                        mAddQueueCommandCallback.DynamicInvoke(new object[] { device.Id, action });
                        mLogManager.LogMessage(string.Format("{0} added to command queue for Node {1}.", cmd.Name, device.Id));
                    }
                }
            }
        }
    }
}
