using System;
using System.Collections.Generic;
using System.Text;
using Zensys.ZWave.Devices;
using Zensys.ZWave.Enums;
using System.Threading;
using Zensys.ZWave.Events;
using Zensys.ZWave.Application;

namespace Zensys.ZWave.ZWaveHAL.Actions
{
    public class AssociationsViewActions : ActionsHAL
    {
        public delegate void AddQueueCommandDelegate(byte nodeId, QueueAction action);
        private AddQueueCommandDelegate mAddQueueCommandCallback;
        public AddQueueCommandDelegate AddQueueCommandCallback
        {
            get { return mAddQueueCommandCallback; }
            set { mAddQueueCommandCallback = value; }
        }

        public event EventHandler<AssociationReportEventArgs> AssociationReport;

        public AssociationsViewActions(BaseEntryPointHAL entryPoint)
            : base(entryPoint)
        {
        }

        public void RequestAssociationsAction(IController controller, IDeviceInfo associativeDevice, string msgGetGroupingsFrame)
        {
            try
            {
                if (associativeDevice.IsListening || associativeDevice.IsListening)
                {
                    RequestAssociationGroupCount(controller, associativeDevice);
                }
                else
                {
                    if ((associativeDevice.Security & 0x20) != 0 ||
                        (associativeDevice.Security & 0x40) != 0)
                    {
                        RequestAssociationGroupCount(controller, associativeDevice);
                    }
                    else
                    {
                        QueueAction action = new QueueAction(
                            new RequestAssociationGroupCountDelegate(RequestAssociationGroupCount),
                            new object[] { controller, associativeDevice },
                            msgGetGroupingsFrame, false, (byte)CommandTypes.CmdZWaveSendData, "Load Association", 2000);
                        if (mAddQueueCommandCallback != null)
                        {
                            mAddQueueCommandCallback.DynamicInvoke(new object[] { associativeDevice.Id, action });
                            mLogManager.LogMessage(string.Format("{0} added to command queue for Node {1}.", "Load Association", associativeDevice.Id));
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                throw ex;
            }
        }

        private delegate void RequestAssociationGroupCountDelegate(IController controller, IDeviceInfo device);
        private void RequestAssociationGroupCount(IController controller, IDeviceInfo device)
        {
            ACHEvents.Clear();
            ACHReceived.Reset();
            GetGroupingsInternal(controller, device);
            if (ACHEvents.Count == 0)
            {
                ACHReceived.WaitOne(new TimeSpan(0, 0, 3), true);
            }
            if (ACHEvents.Count > 0)
            {
                if (ACHEvents[0].CommandBuffer.Length > 2)
                {
                    for (byte groupId = 0x01; groupId < ACHEvents[0].CommandBuffer[2] + 1; groupId++)
                    {
                        GetAssociationsInternal(controller, groupId, ACHEvents[0].SourceNodeId);
                    }
                }
            }
        }

        protected virtual void GetGroupingsInternal(IController controller, IDeviceInfo device)
        {
            TransmitStatuses ret = controller.SendData(
                device.Id,
                mXmlDataManager.FillCommand("COMMAND_CLASS_ASSOCIATION", "ASSOCIATION_GROUPINGS_GET", null),
                TransmitOptions.TransmitOptionAutoRoute | TransmitOptions.TransmitOptionAcknowledge | TransmitOptions.TransmitOptionExplore);
            if (ret != TransmitStatuses.CompleteOk)
            {
            }
        }

        protected virtual void GetAssociationsInternal(IController controller, byte groupId, byte nodeId)
        {
            TransmitStatuses ret = controller.SendData(
               nodeId,
               mXmlDataManager.FillCommand("COMMAND_CLASS_ASSOCIATION", "ASSOCIATION_GET", new byte[] { groupId }),
               TransmitOptions.TransmitOptionAutoRoute | TransmitOptions.TransmitOptionAcknowledge | TransmitOptions.TransmitOptionExplore);
            if (ret != TransmitStatuses.CompleteOk)
            {
            }
        }

        public void CreateAssociationAction(IController controller, IDeviceInfo associativeDevice, AssociativeGroup associativeGroup, IDeviceInfo device, bool isAssignChecked, string msgCreateAssociation, string msgGetGroupingsFrame)
        {
            try
            {
                if (associativeDevice.IsListening || associativeDevice.IsListening)
                {
                    CreateAssociation(controller, associativeDevice, associativeGroup.GroupId, new byte[] { device.Id }, isAssignChecked);
                }
                else
                {

                    if ((associativeDevice.Security & 0x20) != 0 ||
                        (associativeDevice.Security & 0x40) != 0)
                    {
                        CreateAssociation(controller, associativeDevice, associativeGroup.GroupId, new byte[] { device.Id }, isAssignChecked);
                    }
                    else
                    {
                        if (mAddQueueCommandCallback != null)
                        {
                            QueueAction action = new QueueAction(
                             new CreateAssociationDelegate(CreateAssociation),
                             new object[] { controller, associativeDevice, associativeGroup.GroupId, new byte[] { device.Id }, isAssignChecked },
                             msgCreateAssociation, false, (byte)CommandTypes.CmdZWaveSendData, "Create Association", 0);

                            mAddQueueCommandCallback.DynamicInvoke(associativeDevice.Id, action);
                            mLogManager.LogMessage(string.Format("{0} added to command queue for Node {1}.", "Create Association", associativeDevice.Id));

                            action = new QueueAction(
                                new RequestAssociationGroupCountDelegate(RequestAssociationGroupCount),
                                new object[] { controller, associativeDevice },
                                msgGetGroupingsFrame, false, (byte)CommandTypes.CmdZWaveSendData, "Load Association", 2000);

                            mAddQueueCommandCallback.DynamicInvoke(associativeDevice.Id, action);
                            mLogManager.LogMessage(string.Format("{0} added to command queue for Node {1}.", "Load Association", associativeDevice.Id));
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                throw ex;
            }

        }
        private delegate void CreateAssociationDelegate(IController controller, IDeviceInfo selectedDevice, byte groupId, byte[] destDevices, bool assignReturnRoute);
        private void CreateAssociation(IController controller, IDeviceInfo selectedDevice, byte groupId, byte[] destDevices, bool assignReturnRoute)
        {
            if (assignReturnRoute && selectedDevice.Basic == mXmlDataManager.GetBasicDeviceKey("BASIC_TYPE_ROUTING_SLAVE"))
            {
                foreach (byte nid in destDevices)
                {
                    controller.AssignReturnRoute(selectedDevice.Id, nid);
                }
            }
            CreateAssociationInternal(controller, selectedDevice, groupId, destDevices);
        }

        protected virtual void CreateAssociationInternal(IController controller, IDeviceInfo selectedDevice, byte groupId, byte[] destDevices)
        {
            List<byte> tmp = new List<byte>();
            tmp.Add(groupId);
            tmp.AddRange(destDevices);
            TransmitStatuses ret = controller.SendData(selectedDevice.Id, mXmlDataManager.FillCommand("COMMAND_CLASS_ASSOCIATION", "ASSOCIATION_SET", tmp.ToArray()), TransmitOptions.TransmitOptionAutoRoute | TransmitOptions.TransmitOptionAcknowledge | TransmitOptions.TransmitOptionExplore);
            if (ret != TransmitStatuses.CompleteOk)
            {
            }
        }

        public void RemoveAssociationAction(IController controller, IDeviceInfo associativeDevice, AssociativeGroup group, bool assignChecked, string msgRemoveAssociation, string msgGetGroupingsFrame)
        {
            try
            {
                if (associativeDevice.IsListening || associativeDevice.IsListening)
                {
                    RemoveAssociation(controller, associativeDevice, group.GroupId, new byte[] { group.CurrentDeviceId }, assignChecked);
                }
                else
                {
                    if ((associativeDevice.Security & 0x20) != 0 ||
                        (associativeDevice.Security & 0x40) != 0)
                    {
                        RemoveAssociation(controller, associativeDevice, group.GroupId, new byte[] { group.CurrentDeviceId }, assignChecked);
                    }
                    else
                    {
                        if (mAddQueueCommandCallback != null)
                        {
                            QueueAction action = new QueueAction(
                                 new RemoveAssociationDelegate(RemoveAssociation),
                                 new object[]{
                                     controller,
                                     associativeDevice,
                                       group.GroupId,
                                       new byte[] { group.CurrentDeviceId },
                                       assignChecked},
                                 msgRemoveAssociation, false, (byte)CommandTypes.CmdZWaveSendData, "Remove Association", 0);
                            mAddQueueCommandCallback.DynamicInvoke(associativeDevice.Id, action);
                            mLogManager.LogMessage(string.Format("{0} added to command queue for Node {1}.", "Remove Association", associativeDevice.Id));


                            action = new QueueAction(
                                new RequestAssociationGroupCountDelegate(RequestAssociationGroupCount),
                                new object[] { controller, associativeDevice },
                                msgGetGroupingsFrame, false, (byte)CommandTypes.CmdZWaveSendData, "Load Association", 2000);
                            mAddQueueCommandCallback.DynamicInvoke(associativeDevice.Id, action);
                            mLogManager.LogMessage(string.Format("{0} added to command queue for Node {1}.", "Load Association", associativeDevice.Id));
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                throw ex;
            }
        }

        private delegate void RemoveAssociationDelegate(IController controller, IDeviceInfo selectedDevice, byte groupId, byte[] selectedDeviceIdInGroup, bool assignReturnRoute);

        private void RemoveAssociation(IController controller, IDeviceInfo selectedDevice, byte groupId, byte[] selectedDeviceIdInGroup, bool assignReturnRoute)
        {
            if (assignReturnRoute && selectedDevice.Basic == mXmlDataManager.GetBasicDeviceKey("BASIC_TYPE_ROUTING_SLAVE"))
            {
                controller.DeleteReturnRoute(selectedDevice.Id);
            }
            RemoveAssociationInternal(controller, selectedDevice, groupId, selectedDeviceIdInGroup);
        }

        protected virtual void RemoveAssociationInternal(IController controller, IDeviceInfo selectedDevice, byte groupId, byte[] selectedDeviceIdInGroup)
        {
            List<byte> tmp = new List<byte>();
            tmp.Add(groupId);
            tmp.AddRange(selectedDeviceIdInGroup);
            TransmitStatuses ret = controller.SendData(selectedDevice.Id, mXmlDataManager.FillCommand("COMMAND_CLASS_ASSOCIATION", "ASSOCIATION_REMOVE", tmp.ToArray()), TransmitOptions.TransmitOptionAutoRoute | TransmitOptions.TransmitOptionAcknowledge | TransmitOptions.TransmitOptionExplore);
            if (ret != TransmitStatuses.CompleteOk)
            {
            }
        }

        public AutoResetEvent ACHReceived = new AutoResetEvent(false);
        public List<DeviceAppCommandHandlerEventArgs> ACHEvents = new List<DeviceAppCommandHandlerEventArgs>();
        public override void ProcessApplicationCommandHandler(IController controller, byte sourceNodeId, bool isBroadCast, CommandClassValue[] commandClassValues)
        {
            foreach (CommandClassValue var in commandClassValues)
            {
                if (var.CommandClassDefinition.Name == "COMMAND_CLASS_ASSOCIATION" && var.CommandClassDefinition.Version == 1)
                {
                    if (var.CommandValue.CommandDefinition.Name == "ASSOCIATION_GROUPINGS_REPORT")
                    {
                        if (commandClassValues != null && commandClassValues.Length > 0)
                        {
                            DeviceAppCommandHandlerEventArgs dd = new DeviceAppCommandHandlerEventArgs(commandClassValues[0].Data, sourceNodeId, commandClassValues[0].CommandClassDefinition.KeyId, commandClassValues[0].CommandValue.CommandDefinition.KeyId, false);
                            ACHEvents.Add(dd);
                        }
                        ACHReceived.Set();
                    }
                    else if (var.CommandValue.CommandDefinition.Name == "ASSOCIATION_REPORT")
                    {
                        if (var.CommandValue.ParamValues != null)
                        {
                            if (AssociationReport != null)
                            {
                                AssociationReport(this, new AssociationReportEventArgs(var.CommandValue.ParamValues));
                            }
                        }
                    }
                }
            }
        }
    }
}
