using System;
using System.Collections.Generic;
using System.Text;
using System.Reflection;

namespace Zensys.ZWave.Runtime
{
    /// <summary>
    /// Provides a run-time initialization methods.
    /// </summary>
    public class RuntimeManager
    {
        /// <summary>
        /// Layers names.
        /// </summary>
        public enum Layers
        {
            /// <summary>
            /// ApplicationLayer
            /// </summary>
            ApplicationLayer,
            /// <summary>
            /// TransportLayer
            /// </summary>
            TransportLayer,
            /// <summary>
            /// SessionLayer
            /// </summary>
            SessionLayer,
            /// <summary>
            /// FrameLayer
            /// </summary>
            FrameLayer
        }
        /// <summary>
        /// Loads the assemblies.
        /// </summary>
        /// <param name="zWaveManager">The <see cref="ZWaveManager"/>.</param>
        public static void LoadAssemblies(ZWaveManager zWaveManager)
        {
            //Application Layer
            Assembly asmAL = Assembly.LoadFrom("Zensys.ZWave.SerialPortApplication.dll");
            zWaveManager.ApplicationLayer = (IApplicationLayer)Activator.
                CreateInstance(asmAL.GetType("Zensys.ZWave.SerialPortApplication.ApplicationLayer"));
            //Transport Layer
            Assembly asmTL = Assembly.LoadFrom("Zensys.ZWave.SerialPortTransport.dll");
            zWaveManager.TransportLayer = (ITransportLayer)Activator.
                CreateInstance(asmTL.GetType("Zensys.ZWave.SerialPortTransport.TransportLayer"));
            //Session Layer
            Assembly asmSL = Assembly.LoadFrom("Zensys.ZWave.SerialPortSession.dll");
            zWaveManager.SessionLayer = (ISessionLayer)Activator.
                CreateInstance(asmSL.GetType("Zensys.ZWave.SerialPortSession.SessionLayer"));
            //Frame Layer
            Assembly asmFL = Assembly.LoadFrom("Zensys.ZWave.SerialPortFrame.dll");
            zWaveManager.FrameLayer = (IFrameLayer)Activator.
                CreateInstance(asmFL.GetType("Zensys.ZWave.SerialPortFrame.FrameLayer"));
        }

        /// <summary>
        /// Loads the assembly.
        /// </summary>
        /// <param name="zWaveManager">The <see cref="ZWaveManager"/>.</param>
        /// <param name="layer">The layer name <see cref="Layers"/>.</param>
        /// <param name="layerDllName">Name of the layer DLL.</param>
        /// <param name="layerInstanceName">Name of the layer instance.</param>
        public static void LoadAssembly(ZWaveManager zWaveManager, Layers layer, string layerDllName, string layerInstanceName)
        {
            Assembly assembly = Assembly.LoadFrom(layerDllName);
            switch (layer)
            {
                case Layers.ApplicationLayer:
                    {
                        zWaveManager.ApplicationLayer = (IApplicationLayer)Activator.CreateInstance(assembly.GetType(layerInstanceName));
                    } break;
                case Layers.FrameLayer:
                    {
                        zWaveManager.FrameLayer = (IFrameLayer)Activator.CreateInstance(assembly.GetType(layerInstanceName));
                    } break;
                case Layers.SessionLayer:
                    {
                        zWaveManager.SessionLayer = (ISessionLayer)Activator.CreateInstance(assembly.GetType(layerInstanceName));
                    } break;
                case Layers.TransportLayer:
                    {
                        zWaveManager.TransportLayer = (ITransportLayer)Activator.CreateInstance(assembly.GetType(layerInstanceName));
                    } break;
            }
        }

        internal static void LoadAssemblies(ZWaveManager zWaveManager, string applicationLayerDllName, string applicationLayerInstanceName, string transportLayerDllName, string transportLayerInstanceName, string sessionLayerDllName, string sessionLayerInstanceName, string frameLayerDllName, string frameLayerInstanceName)
        {
            Assembly asmAL = Assembly.LoadFrom(applicationLayerDllName);
            zWaveManager.ApplicationLayer = (IApplicationLayer)Activator.
                CreateInstance(asmAL.GetType(applicationLayerInstanceName));
            //Transport Layer
            Assembly asmTL = Assembly.LoadFrom(transportLayerDllName);
            zWaveManager.TransportLayer = (ITransportLayer)Activator.
                CreateInstance(asmTL.GetType(transportLayerInstanceName));
            //Session Layer
            Assembly asmSL = Assembly.LoadFrom(sessionLayerDllName);
            zWaveManager.SessionLayer = (ISessionLayer)Activator.
                CreateInstance(asmSL.GetType(sessionLayerInstanceName));
            //Frame Layer
            Assembly asmFL = Assembly.LoadFrom(frameLayerDllName);
            zWaveManager.FrameLayer = (IFrameLayer)Activator.
                CreateInstance(asmFL.GetType(frameLayerInstanceName));
        }
    }
}

