using System;
using System.Collections.Generic;
using System.Text;
using Zensys.ZWave.Enums;

namespace Zensys.ZWave.Events
{
    /// <summary>
    /// Provides data for <see cref="Zensys.ZWave.Devices.IDeviceFlash.ProgressChanged"/> or <see cref="Zensys.ZWave.Devices.IDeviceMemory.ProgressChanged"/> event.
    /// </summary>
    public class ProgressChangedEventArgs
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="ProgressChangedEventArgs"/> class.
        /// </summary>
        /// <param name="prevValue">The current value.</param>
        /// <param name="newValue">The total value.</param>
        public ProgressChangedEventArgs(ProgressStatuses status, int current, int total)
        {
            this.ProgressStatus = status;
            this.Current = current;
            this.Total = total;
        }
        /// <summary>
        /// Gets or sets the current progress status.
        /// </summary>
        /// <value>The current progress status.</value>
        private ProgressStatuses mProgressStatus;
        public ProgressStatuses ProgressStatus
        {
            get { return mProgressStatus; }
            set { mProgressStatus = value; }
        }
	
        private int mCurrent;
        /// <summary>
        /// Gets or sets the current progress value.
        /// </summary>
        /// <value>The current progress value.</value>
        public int Current
        {
            get { return mCurrent; }
            set { mCurrent = value; }
        }

        private int mTotal;
        /// <summary>
        /// Gets or sets the total progress value.
        /// </summary>
        /// <value>The current total value.</value>
        public int Total
        {
            get { return mTotal; }
            set { mTotal = value; }
        }	
    }
}
