using System;
using System.Collections.Generic;
using System.Text;

namespace Zensys.ZWave.Events
{
    /// <summary>
    /// Provides data for <see cref="Zensys.ZWave.Devices.IDevice.ApplicationCommandHandler_BridgeEvent"/> event.
    /// </summary>
    public class DeviceAppCommandHandler_BridgeEventArgs : EventArgs
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="DeviceAppCommandHandler_BridgeEventArgs"/> class.
        /// </summary>
        /// <param name="frameBuffer">The frame buffer.</param>
        /// <param name="sourceNodeId">The source node id.</param>
        /// <param name="destNodeIds">The dest node ids.</param>
        /// <param name="commandClassKey">The command class key.</param>
        /// <param name="commandKey">The command key.</param>
        public DeviceAppCommandHandler_BridgeEventArgs(byte[] commandBuffer, byte sourceNodeId, byte[] destNodeIds, byte commandClassKey, byte commandKey)
        {
            CommandBuffer = commandBuffer;
            SourceNodeId = sourceNodeId;
            DestNodeIds = destNodeIds;
            CommandClassKey = commandClassKey;
            CommandKey = commandKey;
        }

        /// <summary>
        /// 
        /// </summary>
        public byte[] CommandBuffer;
        /// <summary>
        /// 
        /// </summary>
        public byte SourceNodeId;
        /// <summary>
        /// 
        /// </summary>
        public byte[] DestNodeIds;
        /// <summary>
        /// 
        /// </summary>
        public byte CommandClassKey;
        /// <summary>
        /// 
        /// </summary>
        public byte CommandKey;
    }
}
