using System;
using System.Collections.Generic;
using System.Text;
using System.Net.Sockets;
using System.Net;
using System.Threading;

namespace Zensys.ZWave.SerialPortTransport
{
    public class SocketAsyncClient
    {
        byte[] m_DataBuffer = new byte[10];
        IAsyncResult m_asynResult;
        public AsyncCallback pfnCallBack;
        public Socket m_socClient;

        public event EventHandler<SocketDataReceivedEventArgs> DataReceived;

        private string mConnectionString;
        public string ConnectionString
        {
            get { return mConnectionString; }
        }
        public bool Connected
        {
            get
            {
                if (m_socClient != null)
                    return m_socClient.Connected;
                else
                    return false;
            }
        }
        public void Connect(string connectionString)
        {
            if (!String.IsNullOrEmpty(connectionString) && connectionString.Contains(":"))
            {
                string[] connectionStrings = connectionString.Split(':');
                mConnectionString = connectionString;
                try
                {
                    m_socClient = new Socket(AddressFamily.InterNetwork, SocketType.Stream, ProtocolType.Tcp);
                    IPAddress ip = IPAddress.Parse(connectionStrings[0]);
                    int iPortNo = Convert.ToInt16(connectionStrings[1]);
                    IPEndPoint ipEnd = new IPEndPoint(ip, iPortNo);
                    m_socClient.Connect(ipEnd);
                    WaitForData();
                }
                catch (SocketException se)
                {
                    throw se;
                }
                catch (Exception ex)
                {
                    throw ex;
                }
            }
            else
            {
                throw new Exception(String.Format("Invalid connection string '{0}'.", connectionString));
            }
        }
        internal void WaitForData()
        {
            try
            {
                if (m_socClient != null)
                {
                    if (pfnCallBack == null)
                    {
                        pfnCallBack = new AsyncCallback(OnDataReceived);
                    }
                    Packet theSocPkt = new Packet();
                    theSocPkt.thisSocket = m_socClient;
                    m_asynResult = m_socClient.BeginReceive(theSocPkt.dataBuffer, 0, theSocPkt.dataBuffer.Length, SocketFlags.None, pfnCallBack, theSocPkt);
                }
            }
            catch (SocketException se)
            {
                System.Diagnostics.Debugger.Log(0, "1", String.Format("\nOnDataReceived: {0}\n", se.Message));
            }
        }
        internal void OnDataReceived(IAsyncResult asyn)
        {
            try
            {

                Packet theSockId = (Packet)asyn.AsyncState;
                if (theSockId.thisSocket != null && theSockId.thisSocket.Connected)
                {
                    int iRx = 0;
                    iRx = theSockId.thisSocket.EndReceive(asyn);
                    if (DataReceived != null)
                    {
                        DataReceived(this, new SocketDataReceivedEventArgs(theSockId.dataBuffer));
                    }
                    //Thread.Sleep(50);
                    WaitForData();
                }
            }
            catch (ObjectDisposedException oe)
            {
                System.Diagnostics.Debugger.Log(0, "1", "\nOnDataReceived: Socket has been closed\n");
            }
            catch (SocketException se)
            {
                System.Diagnostics.Debugger.Log(0, "1", String.Format("\nOnDataReceived: {0}\n", se.Message));
            }
        }

        public void Close()
        {
            if (m_socClient != null)
            {
                m_socClient.Close();
                m_socClient = null;
                Thread.Sleep(800);
            }
        }

        public void Send(byte[] buffer)
        {
            if (m_socClient != null)
            {
                m_socClient.Send(buffer);
            }
        }
    }
    public class Packet
    {
        public Socket thisSocket;
        public byte[] dataBuffer = new byte[1];
    }
    public class SocketDataReceivedEventArgs : EventArgs
    {
        public SocketDataReceivedEventArgs(byte[] data)
        {
            Data = data;
        }
        private byte[] mData;

        public byte[] Data
        {
            get { return mData; }
            set { mData = value; }
        }
    }
}
