using System;
using System.Collections.Generic;
using System.Text;
using Zensys.ZWave.Devices;
using Zensys.ZWave.Enums;
using Zensys.ZWave.Logging;

namespace Zensys.ZWave.SerialPortApplication.Devices
{
    public class Slave : Device, ISlave
    {
        internal Slave(ISessionLayer sessionLayer)
            : base(sessionLayer)
        { 
        }
        #region ISlave Members

        public void Support9600Only()
        {
            throw new Exception("The method or operation is not implemented.");
        }

        override public LearnMode SetLearnMode(bool learnMode)
        {
            LogTopSession();
            if (IsSupportedSerialApiCommand((byte)CommandTypes.CmdZWaveSetLearnMode, true))
            {
                SessionLayer.ExecuteNonRequest((byte)CommandTypes.CmdZWaveSetLearnMode, new byte[] { Convert.ToByte(learnMode), SessionLayer.SequenceNumber });
            }
            return LearnMode.Done;
        }

        override public void SetDefault()
        {
            LogTopSession();
            if (IsSupportedSerialApiCommand((byte)CommandTypes.CmdZWaveSetDefault, true))
            {
                SessionLayer.ExecuteRequest((byte)CommandTypes.CmdZWaveSetDefault, new byte[] { SessionLayer.SequenceNumber });
            }
        }

        protected override void OnSessionLayerResponseReceivedCustomActions(Zensys.ZWave.Events.ResponseReceivedEventArgs args)
        {
            //handle ApplicationSlaveUpdate
        }
        #endregion
    }
}
