using System;
using System.Collections.Generic;
using System.Text;
using Zensys.ZWave.Devices;
using Zensys.ZWave.Enums;
using Zensys.ZWave.Logging;

namespace Zensys.ZWave.SerialPortApplication.Devices
{
    public class DeviceLed : IDeviceLed
    {
        private ISessionLayer mSessionLayer;

        public DeviceLed(ISessionLayer sessionLayer)
        {
            mSessionLayer = sessionLayer;
        }
        public DeviceLed(ISessionLayer sessionLayer, LedTypes type)
        {
            Type = type;
            mSessionLayer = sessionLayer;
        }
        #region IDeviceLed Members

        public void SetState(bool state)
        {
            //mSessionLayer.LogDataSource.AddTopSession(new LogSession(String.Format("{0} {1} ({2})", Type.ToString(), "Led SetState", state.ToString())));
            if (state)
            {
                mSessionLayer.ExecuteNonRequest((byte)ProgrammerCommandTypes.FUNC_ID_PROGRAMMER_SET_LED, new byte[] { (byte)this.Type, (byte)LedStates.ON, mSessionLayer.SequenceNumber });
            }
            else
            {
                //mSessionLayer.ExecuteNonRequest(new byte[] { 0x01, 0x00, 0x07, 0x00, 0x53, 0x02, 0x00, 0x05, 0xac });
                mSessionLayer.ExecuteNonRequest((byte)ProgrammerCommandTypes.FUNC_ID_PROGRAMMER_SET_LED, new byte[] { (byte)this.Type, (byte)LedStates.OFF, mSessionLayer.SequenceNumber });
            }
        }

        private LedTypes mType;
        public LedTypes Type
        {
            get
            {
                return mType;
            }
            set
            {
                mType = value;
            }
        }

        #endregion
    }
}
