#!/bin/bash
#Usage: ./install_gorush.sh
GORUSH_VERSION="v1.7.4"
CONFIG="config.yml"
CERT="ios_cert.p12"
INSTALL_DIR="/opt/remotenas/gorush"
LOGS_DIR="/var/opt/remotenas/logs"

docker version >/dev/null 2>&1 || { echo >&2 "Docker is not installed."; exit 1; }
sed -n '1p' $0 >/dev/null 2>&1 || { echo >&2 "Sed is not installed."; exit 1; }

if ! [ -f "${CONFIG}" ]; then
    echo "Configuration file not found: `ls -d -1 ${PWD}`/${CONFIG}"
    exit 2
fi
if ! [ -f "${CERT}" ]; then
    echo "Certificate file not found: `ls -d -1 ${PWD}`/${CERT}"
    exit 3
fi

while [ -z "${PASS}" ]; do
    echo "Enter certificate password:"
    read PASS
done
while [ -z "${PASS2}" ]; do
    echo "Repeat certificate password:"
    read PASS2
done
if [ "${PASS}" != "${PASS2}" ]; then
    echo "The passwords do not match"
    exit 4
fi

CONFIG_TEMP="config.tmp"
cp -f "${CONFIG}" "${CONFIG_TEMP}"
CERT_BASENAME=`basename "${CERT}"`
sed -i -e "s/<IOS_CERT>/${CERT_BASENAME}/g" "${CONFIG_TEMP}"
#TODO: special characters id password like / \
sed -i -e "s/<IOS_CERT_PASSWORD>/${PASS}/g" "${CONFIG_TEMP}"

echo "Clearing old containers"
docker rm -f gorush 2>/dev/null

if [ -d "${INSTALL_DIR}" ]; then
    DATE=`date "+%Y%m%d.%H%M"`
    BACKUP_DIR="/root/backup/gorush/${DATE}/"
    echo "Moving old config files to: ${BACKUP_DIR}"
    mkdir -p "${BACKUP_DIR}"
    mv "${INSTALL_DIR}" "${BACKUP_DIR}"
fi

echo "Installing gorush..."
mkdir -p "${INSTALL_DIR}/certs"
mkdir -p "${LOGS_DIR}"
docker pull appleboy/gorush:"${GORUSH_VERSION}"

mv "${CONFIG_TEMP}" "${INSTALL_DIR}/config.yml"
cp "${CERT}" "${INSTALL_DIR}/certs"
cp gorush.sh "${INSTALL_DIR}"
touch "${LOGS_DIR}/gorush.log"

echo "Creating container..."
docker run -d --name gorush -v "${INSTALL_DIR}"/config.yml:/config.yml -v "${INSTALL_DIR}"/certs:/certs -v "${LOGS_DIR}":/logs -p 8088:8088 appleboy/gorush:"${GORUSH_VERSION}"
echo "Installation finished"
