#!/bin/bash

start() {
    if [ "${STATUS}" == "true" ]; then
        echo "Gorush is already running";
        exit 0;
    fi
    docker start gorush
    echo "Gorush service has been started";
}

stop() {
    if [ "${STATUS}" != "true" ]; then
        echo "Gorush is not running. Nothing to stop.";
        exit 0;
    fi
    docker stop gorush
    echo "Gorush service has been stopped";
}

status() {
    if [ "${STATUS}" == "true" ]; then
        echo "Gorush is running";
        exit 0;
    else
        echo "Gorush is not running";
        exit 2;
    fi
}

restart() {
    docker restart gorush
}

docker version >/dev/null 2>&1 || { echo >&2 "Docker is not installed."; exit 1; }
STATUS=`docker inspect -f {{.State.Running}} gorush`
case "$1" in
    start)
        start
        ;;
    stop)
        stop
        ;;
    status)
        docker ps --filter "name=gorush"
        status
        ;;
    restart)
        restart
        ;;
    *)
        echo $"Usage: $0 {start|stop|status|restart}"
esac

exit 0
