
/*! stargate-webui - v05.01.19-689 - 2015-02-05 02-02-18 */

var SWCElements = {

    /**
     * Custom swc checkboxes
     */
    checkbox:  {

        /**
         * Current element class name:
         *
         * @param className {String}
         *
         */
        className: 'swc-checkbox',

        /**
         * Current element active class name:
         *
         * @param activeClassName {String}
         *
         */
        activeClassName: 'checked',

        /**
         * Init all custom checkboxes on the page:
         */
        initAll: function() {
            var self = this;

            $('body')
                .on('click', '.' + this.className + ':not(.prevent-click, .disabled)', function(e) {
                    self.triggerChange($(e.target));
                })
                .on('swc-checkbox:swc-change', '.' + this.className, function(e, value) {
                    self.customChange($(e.target), value);
                });
        },

        /**
         * Trigger user changes on a checkbox:
         *
         * @param element {Object}
         * @param fireEvent {Boolean}
         *
         */
        triggerChange: function(element) {
            var checkBox = element.hasClass(this.className) ? element : element.closest('.' + this.className),
                state = checkBox.data('value');

            if (state) {
                checkBox.removeClass(this.activeClassName);
            } else {
                checkBox.addClass(this.activeClassName);
            }

            checkBox.data('value', !state);
            checkBox.trigger('swc-checkbox:change', !state);
        },

        /**
         * Trigger application changes on a checkbox:
         *
         * @param element {Object}
         *
         */
        customChange: function(element, value) {
            var checkBox = element.hasClass(this.className) ? element : element.closest('.' + this.className);

            if (value) {
                checkBox.addClass(this.activeClassName);
            } else {
                checkBox.removeClass(this.activeClassName);
            }

            checkBox.data('value', value);
        }
    },

    /**
     * Custom swc checkbox with one additional position
     */
    checkboxExtended:  {

        /**
         * Current element class name:
         *
         * @param className {String}
         *
         */
        className: 'swc-extended',

        /**
         * Current element active class name:
         *
         * @param activeClassName {String}
         *
         */
        activeClassName: 'checked',

        partlyClassName: 'partly',

        /**
         * Init all custom checkboxes on the page:
         */
        initAll: function() {
            var self = this;

            $('body')
                .on('click', '.' + this.className + ':not(.prevent-click)', function(e) {
                    self.triggerChange($(e.target));
                })
                .on('swc-extended:swc-change', '.' + this.className, function(e, value) {
                    self.customChange($(e.target), value);
                });
        },

        /**
         * Trigger user changes on a checkbox:
         *
         * @param element {Object}
         * @param fireEvent {Boolean}
         *
         */
        triggerChange: function(element) {
            var checkBox = element.hasClass(this.className) ? element : element.closest('.' + this.className),
                state = checkBox.data('value'),
                result = state,
                extend = checkBox.hasClass('partly');

            checkBox.removeClass(this.activeClassName);

            if (state || extend) {
                result = false;
            } else {
                checkBox.addClass(this.activeClassName);
                result = true;
            }


            checkBox.data('value', result);
            checkBox.trigger('swc-checkbox:change', result);
        },

        /**
         * Trigger application changes on a checkbox:
         *
         * @param element {Object}
         *
         */
        customChange: function(element, value) {
            var checkBox = element.hasClass(this.className) ? element : element.closest('.' + this.className);

            checkBox.removeClass(this.activeClassName).removeClass(this.partlyClassName);

            if (value === "partly") {
                checkBox.addClass(this.partlyClassName);
            } else if(value) {
                checkBox.addClass(this.activeClassName);
            }

            checkBox.data('value', value);
        }
    },

    /**
     * Custom ON-OFF switcher
     */
    switcher:  {

        /**
         * Current element class name:
         *
         * @param className {String}
         *
         */
        className: 'swc-switcher',

        /**
         * Current element active class name:
         *
         * @param activeClassName {String}
         *
         */
        activeClassName: 'checked',

        /**
         * Current element width:
         *
         * @param activeClassName {String}
         *
         */
        switcherWidth: 40,

        /**
         * Init all custom switchers on the page:
         */
        initAll: function() {
            var self = this, preventClick = false;

            $('body')
                .on('click', '.' + this.className + ' .switcher-container', function(e) {
                    if(!preventClick){
                        self.triggerChange($(e.target));
                    }
                })
                .on('swc-switcher:swc-change', '.' + this.className, function(e, value) {
                    self.customChange($(e.target), value);
                })
                .on('mousedown', '.' + this.className + ' .btn', function(e) {
                    var element = $(this);
                    element.data('switch', true);
                    element.data('mouseOffset', e.pageX);
                    element.data('isChecked', element.closest('.'+self.className).hasClass(self.activeClassName));
                })
                .on('mouseup', '.' + this.className + ' .btn', function(e) {
                    var element = $(this);
                    if(element.data('switch')){
                        element.data('switch', false);
                        stopModify(element.closest('.switcher-container').find('.container'));
                    }
                })
                .on('mouseleave', '.' + this.className + ' .btn', function(e) {
                    var element = $(this);
                    if(element.data('switch')){
                        element.data('switch', false);
                        stopModify(element.closest('.switcher-container').find('.container'));
                    }
                })
                .on('mousemove', '.' + this.className + ' .btn', function(e) {
                    var element = $(this);
                    if(element.data('switch')){
                        preventClick = true;
                        var alpha = +element.data('mouseOffset') - e.pageX;
                        var containerPosition = +element.closest('.switcher-container').find('.container').css('right').replace('px','');
                        if(containerPosition+alpha>=0 && containerPosition+alpha<=40){
                            element.closest('.switcher-container').find('.container').css({
                                'right': '+='+alpha+'px'
                            });
                            element.closest('.switcher-container').find('.btn').css({
                                'right': '+='+alpha+'px'
                            });
                            element.data('mouseOffset', e.pageX);
                        }
                    }
                });
            var stopModify = function(element){
                /**
                 * prevents 'click' event execution
                 */
                setTimeout(function(){preventClick = false;}, 10);
                var containerPosition = +element.css('right').replace('px',''),
                    switcher = element.closest('.'+self.className),
                    newState = true;

                if(containerPosition>19){
                    newState = false;
                }
                self.customChange(element, newState);
                var stateWasChanged = (newState !== element.closest('.'+self.className).find('.btn').data('isChecked'));
                if(stateWasChanged){
                    switcher.trigger('swc-switcher:change', newState);
                }
            };
        },

        /**
         * Trigger user changes on a switcher:
         *
         * @param element {Object}
         * @param fireEvent {Boolean}
         *
         */
        triggerChange: function(element) {
            var switcher = element.hasClass(this.className) ? element : element.closest("." + this.className),
                state = switcher.data('value');

            if (!state) {
                switcher.addClass(this.activeClassName);
                switcher.find('.container').animate({'right': '0px'}, 100);
                switcher.find('.btn').animate({'right': '0px'}, 100);
            } else {
                switcher.removeClass(this.activeClassName);
                switcher.find('.container').animate({'right': '38px'}, 100);
                switcher.find('.btn').animate({'right': '40px'}, 100);
            }

            switcher.data('value', !state);
            switcher.trigger('swc-switcher:change', !state);
        },

        /**
         * Trigger application changes on a switcher:
         *
         * @param element {Object}
         *
         */
        customChange: function(element, value) {
            var switcher = element.hasClass(this.className) ? element : element.closest("." + this.className);

            if (value) {
                switcher.addClass(this.activeClassName);
                switcher.find('.container').animate({'right': '0px'}, 100);
                switcher.find('.btn').animate({'right': '0px'}, 100);
            } else {
                switcher.removeClass(this.activeClassName);
                switcher.find('.container').animate({'right': '38px'}, 100);
                switcher.find('.btn').animate({'right': '40px'}, 100);
            }

            switcher.data('value', value);

        }
    },

    /**
     * Custom swc radio buttons
     */
    radioButton: {

        /**
         * Current element class name:
         *
         * @param className {String}
         *
         */
        className: 'swc-radio-buttons',

        /**
         * Current element active class name:
         *
         * @param activeClassName {String}
         *
         */
        activeClassName: 'active',

        /**
         * Init all custom radio buttons on the page:
         */
        initAll: function() {
            var self = this;

            $('body')
                .on('click', '.' + this.className + ':not(.disabled) .mode:not(.disabled)', function(e) {
                    self.triggerChange($(e.target));
                })
                .on('swc-radio-buttons:swc-change', '.' + this.className, function(e, value) {
                    self.customChange($(e.target), value);
                });
        },

        /**
         * Trigger user changes on a radio button:
         *
         * @param element {Object}
         * @param fireEvent {Boolean}
         *
         */
        triggerChange: function(element) {
            var mode = element.hasClass('.mode') ? element : element.closest('.mode'),
                radioGroup = mode.closest('.' + this.className);

            // Do nothing if clicking on active radio button
            if (mode.hasClass('active')) {
                return;
            }

            // Remove active class from previous mode
            radioGroup.find('.mode').removeClass('active');

            // Set active class to current button
            mode.addClass('active');

            // Set radioGroup group value
            radioGroup.data('value', mode.data('value'));
            radioGroup.trigger('swc-radio-buttons:change', mode.data('value'));
        },

        /**
         * Trigger application changes on a radio button:
         *
         * @param button {Object}
         *
         */
        customChange: function(element, value) {
            var radioGroup = element.hasClass(this.className) ? element : element.closest('.' + this.className);

            // Remove active class from previous mode
            radioGroup.find('.mode').removeClass('active');

            // Set active class to current button
            radioGroup.find('.mode[data-value="' + value + '"]').addClass('active');

            radioGroup.data('value', value);
        }

    },

    /**
     * Custom swc drop downs
     */
    dropDown: {

        /**
         * Current element class name:
         *
         * @param className {String}
         *
         */
        className: 'swc-dropdown',

        /**
         * Current element overlay class name:
         *
         * @param classNameOverlay {String}
         *
         */
        classNameOverlay: 'swc-dropdown-overlay',

        /**
         * Set element type to be handled correctly
         */
        type: 'absolute-position',

        /**
         * Current element tag name:
         *
         * @param tagName {String}
         *
         */
        tagName: 'div',

        /**
         * Current element hidden tag name:
         *
         * @param hiddenField {String}
         *
         */
        hiddenField: 'input',

        /**
         * Current element active class name:
         *
         * @param activeClassName {String}
         *
         */
        activeClassName: 'selected',

        /**
         * Init all custom elements on the page:
         */
        initAll: function() {
            var self = this;

            $('body')
                .on('click', '.' + this.className + ':not(.disabled)', function(e) {
                    SWCElements.global.closeAll(self.className);
                    self.open($(e.target));
                    e.stopPropagation();
                })
                .on('click', '.' + this.classNameOverlay + ' .option.selected', function(e) {
                    self.close($(e.target));
                    e.stopPropagation();
                })
                .on('click', '.' + this.classNameOverlay + ' .option:not(.selected)', function(e) {
                    self.change($(e.target));
                    e.stopPropagation();
                })
                .on(this.className + ':swc-change', '.' + this.className, function(e, value) {
                    self.customChange($(e.target), value);
                });
        },

        /**
         * Trigger drop down open:
         *
         * @param element {Object}
         *
         */
        open: function(element) {
            var dropDown = element.hasClass(this.className) ? element : element.closest("." + this.className),
                className = dropDown.data('class'),
                hideDefault = dropDown.data('hide-default'),
                options = dropDown.data('options'),
                selected = dropDown.data('selected'),
                selectedDefault = selected,
                position = dropDown.offset(),
                width = dropDown.innerWidth(),
                value = dropDown.data('value'),
                // This additional width needed to handle scrollbar which appears when option list is not empty
                additionalWidth = getObjectLength(options) > 5 ? 20 : 0,
                template = $.template("swc-dropdown", swc.Templates.get("swc-dropdown").get('content')),
                optionList = [], // support for option list as array
                selectedOption;

            // Remove existing dropdowns
            if ($('.' + this.classNameOverlay).size()) {
                this.closeAll();
            }

            // Hide native dropdown:
            dropDown.css('visibility', 'hidden');
            
            if (!selected) {
                selectedDefault = dropDown.find('.selected-option').text();
            }
            
            // Correct behaviour: options should be an array of objects,
            // so for backward compatibility we add this processor here
            if (_.isArray(options)) {
                optionList = options;
                selectedOption = _.findWhere(optionList, {value: selected + ""});
            } else {
                if (selected) {
                    selectedOption = {
                        value: selected,
                        name: options[selected].name,
                        additionalLabel: options[selected].additionalLabel
                    };
                }
            }
            
            // Append element to body
            $('body').append(
                $.tmpl(template, {
                        className: className,
                        options: options,
                        optionList: optionList.length > 0 ? optionList : null,
                        hideDefault: hideDefault,
                        selectedDefault: selectedDefault,
                        selectedOption: selectedOption
                    }
                )
            );
            
            // Set element position and width
            $('.' + this.classNameOverlay).css({
                'top': position.top + 'px',
                'left': position.left + 'px',
                'width': width + additionalWidth
            });

            $('body').trigger('swc-dropdown:opened', [{'$dropDown': $('.' + this.classNameOverlay)}]);
        },

        /**
         * Trigger dropdown change event:
         *
         * @param element
         *
         */
        change: function(element) {
            var dropDownOverlay = element.hasClass(this.classNameOverlay) ?
                    element :
                    element.closest('.' + this.classNameOverlay),
                className = dropDownOverlay.data('class'),
                dropDown = $('.swc-dropdown[data-class="' + className + '"]'),
                option = $(element).hasClass('option') ? $(element) : $(element).closest('.option'),
                value = option.data('value');
            
            this.renderSelectedOption(element, dropDown);

            // Trigger change event:
            dropDown.trigger('swc-dropdown:change', value);

            this.close(element);
        },

        /**
         * Trigger dropdown application change:
         *
         * @param element
         * @param value
         */
        customChange: function(element, key) {
            var dropDown = element.hasClass(this.className) ? element : element.closest("." + this.className);

            // Update data and Insert new value to visible part of dropdown
            this.renderSelectedOption(element, dropDown, key);
        },

        /**
         * Update data and Insert new value to visible part of dropdown
         * 
         * @param element {DOMElement} on which event was triggered
         * @param dropDown {swcElements.Dropdown} element
         * @param selectedValue {String} - optional, only used when triggered by custom change.
         */
        renderSelectedOption: function (element, dropDown, selectedValue) {
            var optionTemplate = $.template("swc-select-option", swc.Templates.get("swc-select-option").get('content')),
                options = dropDown.data('options'),
                option = $(element).hasClass('option') ? $(element) : $(element).closest('.option'),
                selectedOption;

            // Update data and Insert new value to visible part of dropdown
            if (options) {
                if (_.isArray(options)) {
                    // NOTE: `findWhere` can't compare String and Number correctly,
                    // but sometimes {selectedOption.value} is a digit, thus we appending an empty string to it
                    selectedOption = _.findWhere(options,
                        { value: (!_.isUndefined(selectedValue) ? selectedValue : option.data('value')) + "" }
                    );
                } else {
                    if (selectedValue && options[selectedValue]) {
                        selectedOption = {
                            "value": options[selectedValue].value,
                            "name": options[selectedValue].name,
                            "additionalLabel": options[selectedValue].additionalLabel
                        }
                    } else if(options[option.data('key')]) {
                        selectedOption = {
                            "value": options[option.data('key')].value,
                            "name": options[option.data('key')].name,
                            "additionalLabel": options[option.data('key')].additionalLabel
                        }
                    }
                }

                // Update dropdown element (a kind of "selectbox") with selected data/value
                if (selectedOption) {
                    var previousValue = dropDown.data('value');

                    if (!_.isUndefined(previousValue)) {
                        dropDown.data('previous-value', previousValue);
                    } else {
                        dropDown.data('previous-value', selectedOption.value);
                    }

                    dropDown.data('selected', selectedOption.value);
                    dropDown.data('value', selectedOption.value);

                    dropDown.find('.selected-option').html(
                        $.tmpl(optionTemplate, { selectedOption: selectedOption })
                    );
                }
            }
        },

        /**
         * Trigger dropdown overlay to be closed
         *
         * @param element
         */
        close: function(element) {
            var dropDownOverlay = element.hasClass(this.classNameOverlay) ?
                    element :
                    element.closest('.' + this.classNameOverlay),
                className = dropDownOverlay.data('class'),
                dropDown = $('.swc-dropdown[data-class="' + className + '"]');

            // Remove dropdown overlay:
            if (dropDownOverlay.size()) {
                dropDownOverlay.remove();
            }

            // Show dropdown if exists:
            if (dropDown.size()) {
                dropDown.css('visibility', 'visible');
            }
        },

        /**
         * Close all dropdowns on the page:
         */
        closeAll: function() {
            var self = this;

            $.each($('.' + this.classNameOverlay), function(key, element) {
                self.close($(element));
            });
        }
    },

    expandableList: {

        /**
         * Current element class name:
         *
         * @param className {String}
         *
         */
        className: 'expandable-list',

        /**
         * Current element item class name:
         *
         * @param itemClassName {String}
         *
         */
        itemClassName: 'expandable-list-item',

        /**
         * Current element item hidden class name:
         *
         * @param itemHiddenClassName {String}
         *
         */
        itemHiddenClassName: 'list-item-hidden',

        /**
         * Current element tag name:
         *
         * @param tagName {String}
         *
         */
        tagName: 'div',

        /**
         * Init all custom elements on the page:
         */
        initAll: function() {
            var self = this;

            $('body')
                .on('click', '.' + this.className + ' .show-hidden', function(e) {
                    self.setSelected($(e.target));
                })
                .on('click', '.' + this.className + ' .do-edit:not(.disabled)', function(e) {
                    self.setStateEdit($(e.target), {user: true, undo: false});
                })
                .on('click', '.' + this.className + ' .do-edit.active-edit', function(e) {
                    self.setStateEdit($(e.target), {user: true, undo: true});
                })
                .on('click', '.' + this.className + ' .do-delete:not(.disabled)', function(e) {
                    self.setStateDelete($(e.target));
                })
                .on('click', '.' + this.className + ' .do-custom-edit:not(.disabled)', function(e){
                    self.setStateCustomEdit($(e.target));
                })
                .on('expandable:swc-open', '.' + this.className, function(e, value) {
                    self.setSelected($('.' + self.itemClassName+"[data-key='"+value+"'] .show-hidden:visible"), true);
                })
                .on('expandable:swc-close', '.' + this.className, function(e, value) {
                    self.setSelected($('.' + self.itemClassName+"[data-key='"+value+"'] .show-hidden:visible"), false);
                })
                .on('expandable:swc-edit', '.' + this.className, function(e, value) {
                    self.setStateEdit($('.' + self.itemClassName+"[data-key='"+value+"'] .do-edit:visible"), {user: false, undo: false});
                })
                .on('expandable:swc-no-edit', '.' + this.className, function(e, value) {
                    self.setStateEdit($('.' + self.itemClassName+"[data-key='"+value+"'] .do-edit:visible"), {user: false, undo: true});
                })
                .on('expandable:swc-delete', '.' + this.className, function(e, value) {
                    self.setStateDelete($('.' + self.itemClassName+"[data-key='"+value+"'] .do-delete:visible"));
                });

        },

        setSelected: function(button, toOpen) {
            var fullList = button.closest('.' + this.className),
                itemList = button.closest('.' + this.itemClassName),
                state = button.closest(".show-hidden").hasClass('expanded') ? "expanded" : "closed";

            fullList.find('.' + this.itemClassName).removeClass("expanded");
            fullList.find('.' + this.itemClassName).find('.device').removeClass("selected");
            if (state === "closed" || toOpen) {
                itemList.addClass("expanded");
                itemList.find('.device').addClass("selected");
                fullList.trigger('expandable:open', itemList.attr('data-key'));
            } else {
                fullList.trigger('expandable:close', itemList.attr('data-key'));
            }
        },

        setStateEdit: function(button, options) {
            var fullList = button.closest('.' + this.className),
                itemList = button.closest('.' + this.itemClassName),
                state = itemList.hasClass('mode-editing') ? true : false;
            if(!state && !options.undo){
                itemList.addClass('mode-editing');
                if(options.user){
                    fullList.trigger('expandable:edit', itemList.attr('data-key'));
                }
            } else if(options.undo){
                itemList.removeClass('mode-editing');
                fullList.trigger('expandable:no-edit', itemList.attr('data-key'));
            }
        },

        setStateCustomEdit: function(button){
            var fullList = button.closest('.' + this.className),
                itemList = button.closest('.' + this.itemClassName);
            fullList.trigger('expandable:custom-edit', itemList.attr('data-key'));
        },

        setStateDelete: function(button) {
            var fullList = button.closest('.' + this.className),
                itemList = button.closest('.' + this.itemClassName);
            fullList.trigger('expandable:delete', itemList.attr('data-key'));
        }
    },

    /**
     * Popover elements
     */
    popovers: {

        /**
         * Set element type to be handled correctly
         */
        type: 'absolute-position',

        /**
         * Elements popover active toggle class:
         */
        className: 'has-popover',

        initAll: function() {
            var self = this;

            $('body')
                .on('click', '.' + this.className, function(e) {
                    var element = $(e.target).hasClass(self.className) ? $(e.target) : $(e.target).closest('.' + self.className);

                    if(!element.hasClass('no-click')){
                        if (element.hasClass('selected')) {
                            self.closeAll();
                        } else {
                            self.open($(e.target));
                        }

                        e.stopPropagation();
                    }
                })
                .on('popover:toggle', '.' + this.className, function(e) {
                    var element = $(e.target);

                    if (element.hasClass('selected')) {
                        self.closeAll();
                    } else {
                        self.open(element);
                    }

                    e.stopPropagation();

                })
                .on('popover:close', function(e) {
                    self.closeAll();
                    e.stopPropagation();
                });
        },

        /**
         * Open popover on selected element:
         */
        open: function(e) {
            var self = this,
                holder = e.hasClass(this.className) ? e : e.closest('.' + this.className),
                popover,
                popoverElement,
                template,
                layerTemplate,
                popoverClassName = holder.data('popover-class-name'),
                options = {
                    template: holder.data('popover-template-id'),
                    templateData: holder.data('popover-template-data') ? holder.data('popover-template-data') : {},
                    placement: holder.data('popover-placement'),
                    holderClassName: holder.data('popover-holder'),
                    customPos: holder.data('popover-custom-position')
                };

            if (!holder.data('popover-element')) {
                popoverElement = holder;
            } else {
                var searchClass = holder.data('popover-element');

                popoverElement = holder.find(holder.data('popover-element'));

                if (!e.hasClass(searchClass.replace('.', ''))) {
                    self.closeAll();
                    return;
                }
            }

            // Select template
            if (!swc.Templates.get(options.template)) {
                self.closeAll();
                return;
            }

            // Add values to template data:
            options.templateData.localeStrings = swc.models.Locale.getLocaleStrings();
            options.templateData.localeString = getTranslationStringsjQuery;
            options.templateData.formatDate = swc.models.Locale.formatDate;

            if (typeof(options.templateData) === 'string') {
                options.templateData = JSON.parse(options.templateData);
            }

            // Close all other elements:
            if(holder.data('popover-layer') === undefined) {
               if(!$(holder.context).hasClass('popoverName')) {
                    layerTemplate='<div class="popover"><div class="arrow"></div><h3 class="popover-title"></h3><div class="popover-content"></div></div>';
               } else {
                    layerTemplate='<div class="popover"><div class="arrow"></div><div class="popover-content"></div></div>';
               }
                SWCElements.global.closeAll(self.className);
            } else {
               popoverElement.addClass('layer'+holder.data('popover-layer'));
               popoverElement.addClass('layered');
               popoverElement.data('layer',holder.data('popover-layer'));
               SWCElements.global.closeAllOnLayer(holder.data('popover-layer'));
               layerTemplate='<div class="popover layered layer'+holder.data('popover-layer')+'"><div class="arrow"></div><h3 class="popover-title"></h3><div class="popover-content"></div></div>';
            }
            
            // Prepare popover on element
            popoverElement.popover({
                html: true,
                content: $.tmpl(swc.Templates.get(options.template).get('content'), options.templateData),
                placement: options.placement,
                container: holder.data('popover-container') ? holder.data('popover-container') : "body",
                customPos: options.customPos,
                template: layerTemplate
            });

            // Display popover:
            popoverElement.popover('show');

            // Set holder elements selected
            holder.addClass('selected');
            popoverElement.addClass('selected');


            // Add data options to active popover:
            popover = $('body').find('.popover');

            popover.addClass(popoverClassName);

            // Set popover data
            popover.data('holderClassName', options.holderClassName);
        },

        /**
         * Close all popovers on the page:
         * @param destroyLayered boolean 
         *     false or null = destroy popups without layered
         *     true = destroy all popups 
         */
        closeAll: function(destroyLayered) {
            if((!_.isEmpty(destroyLayered) && destroyLayered===false) || destroyLayered===undefined){
               $.each($('.has-popover.selected').not(".layered"), function(key, value) {
                var holder = $(value),
                    popoverElement;
                if (!holder.data('popover-element')) {
                    popoverElement = holder;
                } else {
                    popoverElement = holder.find(holder.data('popover-element'));
                }
                holder.removeClass('selected');
                popoverElement.removeClass('selected');
                popoverElement.popover("destroy");
            });
            $('body > .popover').not(".layered").remove();
            } else {
               $.each($('.has-popover.selected'), function(key, value) {
                var holder = $(value),
                    popoverElement;
                if (!holder.data('popover-element')) {
                    popoverElement = holder;
                } else {
                    popoverElement = holder.find(holder.data('popover-element'));
                }
                holder.removeClass('selected');
                popoverElement.removeClass('selected');
                popoverElement.popover("destroy");
            });
            $('body > .popover').remove();
            }
        },
        /**
         * close all popovers on given layer
         */
        closeAllOnLayer: function(layerId) {
            $.each($('.has-popover.selected.layer'+layerId), function(key, value) {
                var holder = $(value),
                    popoverElement;

                // Select base popover element:
                if (!holder.data('popover-element')) {
                    popoverElement = holder;
                } else {
                    popoverElement = holder.find(holder.data('popover-element'));
                }

                // Remove popover:
                holder.removeClass('selected');
                popoverElement.removeClass('selected');

                // Remove popover:
                popoverElement.popover("destroy");
            });
            $('body > .popover.layer'+layerId).remove();
        }
    },

    /**
     * Global body handler:
     */
    global: {

        // Close all absolute elements on body click
        initAll: function() {
            var self = this;

            $('body')
                .on('click', '.popover', function(e) {
                    e.stopPropagation();
                })
                .on('click', function(e) {
                    self.closeAll();
                });
        },

        /**
         * Close all elements on given layer:
         * @param activeElement
         */
        closeAllOnLayer: function(layerId) {
            $.each(SWCElements, function(key, value) {
                if (value.type && value.type === 'absolute-position') {
                    if ($.isFunction(value.closeAllOnLayer)) {
                        value.closeAllOnLayer(layerId);
                    }
                }
            });
        },
        
        /**
         * Close all elements:
         * @param activeElement
         */
        closeAll: function(activeElement) {
            $.each(SWCElements, function(key, value) {
                if (value.type && value.type === 'absolute-position') {
                    if ($.isFunction(value.closeAll)) {
                        value.closeAll();
                    }
                }
            });
        }
    },

    charactersFilter: {

        initAll: function() {
            var self = this;

            /*$('body')
                .on('keydown', '.characters-filter', function(e) {
                    self.checkCharacter(e);
                });*/
                
            $('body')
                .on('keypress', '.characters-filter', function(e) {
                    self.checkCharacter2(e);
                });
        },
        
        checkCharacter2: function(e) {
            var character = String.fromCharCode(e.which),
                regexp = $(e.target).data('characters-regexp');
                
            var regTemp = new RegExp(regexp, "ig");
    
            if (!regTemp.test(character)) {
                e.preventDefault();
            }
        },

        checkCharacter: function(e) {
            var character = getCharacterByKey(e.shiftKey, e.keyCode),
                regexp = $(e.target).data('characters-regexp'),
                // the following array contains codes of "C", "X", "V", "Z" keys
                // to have opportunity to check appropriate Ctrl+Key combinations
                serviceCtrlKeys = [67, 88, 86, 90],
                // the following array contains code of "Ins" key
                // to have opportunity to check appropriate Shift+Key combination
                serviceShiftKeys = [45];

            // Filter dots:
            if (e.keyCode === 190 || e.keyCode === 110) {
                character = ".";
            }

            // Enable Ctrl combinations
            if (e.ctrlKey && $.inArray(e.keyCode, serviceCtrlKeys) !== -1) {
                return;
            }

            // Enable Shift combinations
            if (e.shiftKey && $.inArray(e.keyCode, serviceShiftKeys) !== -1) {
                return;
            }

            // Enable global key codes:
            if (character && !character.length || !regexp) {
                return;
            } else {
                var regTemp = new RegExp(regexp, "ig");

                if (!regTemp.test(character)) {
                    e.preventDefault();
                }
            }
        }
    },

    /**
     * Modal windows functionality
     */
    modalWindow: {

        initAll: function() {
            var self = this;

            $('body')
                .on('click', '.modalWindow', function(e) {
                    e.stopPropagation();
                });
        },

        /**
         * Display modal windows
         *
         * @param options {Object}
         *
         * @description:
         *
         *  templateID: {String} - id of template to be shown in a modal window
         *  templateData: {Object} - data to be passed to template
         *
         *  className: {String} - will be added to the modal window
         *
         *  onApply: <function> which will be called when apply button is pressed
         *  onCancel: <function> which will be called when cancel button is pressed
         *  onShow: <function> which will be called when dialog window is shown
         *  onHide: <function> which will be called when dialog window is closed
         */
        show: function(options) {
            var modalShadow = $('<div class="modalWindowShadow"></div>'),
                modalWindow,
                modalWindowInner,
                modalWindowData = {
                    'width': 0,
                    'height': 0
                },
                modalWindowTemplate = $.template("modalWindowInner", swc.Templates.get('application:modal-window').get('content')),
                modalWindowTemplateContent = $("<span>undefined template</span>"),
                modalLocaleStrings = !_.isUndefined(options.localeStrings) ? options.localeStrings : swc.models.Locale.getLocaleStrings();

            // Hide previously opened window, when new window request (fixing windows duplicate):
            if ($('body').find('.modalWindow').size()) {
                SWCElements.modalWindow.hide();
            }

            // We need to add specific translations for the template:
            modalLocaleStrings = _.extend(modalLocaleStrings, swc.models.Locale.getLocaleStrings(options.templateID.replaceAll(":", "/")));

            // Define template for modal window content:
            if (options.templateID) {
                modalWindowTemplateContent = $.template("modalWindowContent", swc.Templates.get(options.templateID).get('content'));
            }

            // Append modal window shadow and modal window to application:
            $('body').append(modalShadow);
            $('body').append($.tmpl(modalWindowTemplate, {}));

            // Handle clicks on modal window shadow:
            modalShadow.on('click', function(e) {
                e.stopPropagation();
            });

            // Define modal window reference:
            modalWindow = $('.modalWindow'),
            modalWindowInner = $('.modalWindowInner');

            // Append modal window content
            modalWindowInner.html(
                $.tmpl(modalWindowTemplateContent, {
                        data: options.templateData ? options.templateData : {},
                        deviceIndex: function (item, map) {
                            var indexToIncriment = 0,
                                index = 0;

                            $.each(map, function(key, device) {
                                if (key === item) {
                                    index = indexToIncriment;
                                }

                                indexToIncriment++;
                            });

                            return index;
                        },
                        localeStrings: modalLocaleStrings,
                        localeString: getTranslationStringsjQuery,
                        formatDate: swc.models.Locale.formatDate
                    }
                )
            );

            // Add addition class name to modal window:
            if (options.className) {
                modalWindow.addClass(options.className);
            }

            // Set correct positioning of modal window:
            modalWindow.css({
                marginTop: -((modalWindow.outerHeight() / 2) + 75) + 'px',
                marginLeft: -((modalWindow.outerWidth() / 2) - 147) + 'px' // menu has 255 width
            });

            // Display the modal window itself
            modalWindow.show();

            // Trigger options onShow function
            if (options.onShow && $.isFunction(options.onShow)) {
                options.onShow();
            }

            // Cancel changes handler:
            modalWindow.find('.cancel-changes').on('mousedown', function(e) {
                var button = $(e.target).hasClass('button') ? $(e.target) : $(e.target).closest('.button');

                if (button.hasClass('disabled')) {
                    return;
                }

                if (options.onCancel && $.isFunction(options.onCancel)) {
                    options.onCancel();
                }

                e.stopPropagation();

                SWCElements.modalWindow.hide();
            });

            // Apply changes handler:
            modalWindow.find('.apply-changes').on('mousedown', function(e) {
                var button = $(e.target).hasClass('button') ? $(e.target) : $(e.target).closest('.button');

                if (button.hasClass('disabled')) {
                    return;
                }

                if (options.onApply && $.isFunction(options.onApply)) {
                    options.onApply();
                }

                e.stopPropagation();
            });
        },

        /**
         * Hide modal window
         */
        hide: function() {
            var modalShadow = $('.modalWindowShadow'),
                modalWindow = $('.modalWindow');

            // Hide modal window shadow
            modalShadow.remove();

            // Remove modal window content:
            if (modalWindow.size()) {
                modalWindow.remove();
            }
        }
    },

    progressRuler: {

        /**
         * Current element class name:
         *
         * @param className {String}
         *
         */
        className: 'ruler-container',

        /**
         * Init all custom rulers on the page:
         */
        initAll: function() {
            var self = this;

            $('body')
                .on('swc-ruler:start', '.' + this.className, function(e, params) {
                    e.stopPropagation();
                    self.customChange($(e.target), params);
                });
        },

        /**
         * Animates progress bar during `time` passed as an option
         *
         * @param DOMElement
         * @param options {Object} Example: {length: length, time:time }
         *                                 where length - width alpha in percents
         *                                 time - time of changing in milliseconds
         */
        customChange: function(element, options) {
            var progressBar = element.find('.fill');

            if (!options.time) {
                element.trigger('swc-ruler:finish');
            } else {
                progressBar.animate(
                    { width: '+=' + (options.length || element.width()) },
                    options.time,
                    'linear',
                    function() {
                        element.trigger('swc-ruler:finish');
                    }
                );
            }
        }


    }
};

$(document).ready(function() {
    _.each(SWCElements, function(value, key) {
        if (_.isFunction(SWCElements[key].initAll)) {
            SWCElements[key].initAll();
        }
    });
});
;String.prototype.capitalize = function() {
    return this.charAt(0).toUpperCase() + this.slice(1);
};

String.prototype.deCapitalize = function() {
    return this.charAt(0).toLowerCase() + this.slice(1);
};

String.prototype.replaceAll = function(search, replace){
    return this.split(search).join(replace);
};

/**
 * FIX for IE browser
 * @link http://tosbourn.com/2013/08/javascript/a-fix-for-window-location-origin-in-internet-explorer/
 */
if (!window.location.origin) {
    window.location.origin = window.location.protocol + "//" + window.location.hostname +
        (window.location.port ? ':' + window.location.port: '');
}

/**
 * Returns array with defined length - useful for 'for' loops in jquery-tmpl
 * example:
 *
 * {{each returnArray(5)}}
 * {{/each}}
 *
 * @param length
 * @returns {Array}
 */
function returnArray(length){
    if (length <= 0) {
        return [];
    }
    return new Array(Math.round(length));
}

function getTranslationStrings(id, isLoadingWindow) {
    var localeStrings;

    if (isLoadingWindow) {
        localeStrings = swc.models.Locale.getLocaleStrings('application');
        swc.Utils.translatedProductName = localeStrings.ProductName;
        swc.Utils.translatedProductNameFull = document.title = localeStrings.ProductNameFull;
    } else {
        localeStrings = swc.models.Locale.getLocaleStrings();
    }

    if (localeStrings && localeStrings[id]) {
        return localeStrings[id];
    } else {
        return id;
    }
}

/**
 * Method for translation strings in html template.
 *
 * @description
 *
 *  {{html localeString("Some string to be translated")}} = Some string to be translated
 *  {{html localeString("Some %placeholder% to be translated", { 'placeholder': 'value' } )}} = Some value to be translated
 *
 * @param id {String}
 * @param params {Object | Map}
 *
 * @returns {String}
 */
function getTranslationStringsjQuery(id, params) {
    var string = id,
        deviceName = swc.Utils.getDeviceName(true);

    if (this.data.localeStrings && this.data.localeStrings[id]) {
        string = this.data.localeStrings[id];
    }

    if (params && getObjectLength(params)) {
        $.each(params, function(key, value) {
            string = string.replaceAll('%' + key + '%', value);
        });
    }

    string = string
            .replaceAll('%ProductName%', swc.Utils.translatedProductName)
            .replaceAll('%ProductNameFull%', swc.Utils.translatedProductNameFull);
    return string;
}

/**
 * Get parameter Name / Value based on element type and value:
 * @param element {Object}
 */
function getParameter(element) {
    var parameterName = '',
        parameterValue = '';

    if (element.hasClass('swc-input')) {
        parameterName = element.attr('name');
        parameterValue = element.val();
    }

    else if (element.hasClass('swc-checkbox')) {
        parameterName = element.data('name');
        parameterValue = element.data('value');
    }

    else if (element.hasClass('swc-extended')) {
        parameterName = element.data('name');
        parameterValue = element.data('value');
    }

    else if (element.hasClass('swc-dropdown')) {
        parameterName = element.data('name');
        parameterValue = element.data('value');
    }

    else if (element.hasClass('swc-radio-buttons')) {
        parameterName = element.data('name');
        parameterValue = element.data('value');
    }

    return {
        'parameterName': parameterName,
        'parameterValue': parameterValue,
        'parameterClasses': $(element).attr('class') ? $(element).attr('class').split(/\s+/) : [],
        'parameterData': $(element).data()
    };
}

function getObjectLength(map) {
    var length = 0;

    if (map) {
        $.each(map, function(key, value) {
            length++;
        });
    }

    return length;
}

/**
 * Get application locale either stored in localStorage or retrieved from user's web-browser
 *
 * @param supportedLocales list of locales currently supported by application
 *
 * @return {String}
 */
function getApplicationLocale(supportedLocales) {
    var locale,
        browserLocale = navigator.language ? navigator.language.split('-')[0] : navigator.userLanguage.split('-')[0];

    var storedLocal = swc.Utils.isCookieSupport() ? localStorage.getItem("locale") : null;
    if (storedLocal && storedLocal !== "undefined") {
        locale = storedLocal;
    } else {
        if (_.findWhere(supportedLocales, {key: browserLocale.toLowerCase()})) {
            locale = browserLocale.toLowerCase();
        }
    }

    return locale;
}

function getBuildInfo() {
    var info = swc.settings.application.get('build');

    $.each(info, function(key, value) {
        console.log(key + ' - ' + value);
    });
}

function getCharacterByKey(isShiftKey, characterCode) {
    var keysToExclude = [
            8, 9, 13, 16, 17, 18, 20, 27, 37, 39, 46, 91,  92
        ],
        keysCodesMap = {
            32: " ", 48: ")", 49: "!", 50:  "@", 51:  "#", 52:  "$",
            53:  "%", 54:  "^", 55:  "&", 56:  "*", 57:  "(", 59:  ":",
            96: "0", 97: "1", 98: "2", 99: "3", 100: "4", 101: "5", 102: "6",
            103: "7", 104: "8", 105: "9", 107:  "+", 109:  "_", 188:  "<",
            190:  ">", 191:  "?", 192:  "~", 219:  "{", 220:  "|", 221:  "}",
            222:  "\""
        },
        character = "";
    if ($.inArray(characterCode, keysToExclude) !== -1) {
        return character;
    }

    if (typeof isShiftKey !== "boolean" || typeof characterCode !== "number") {
        return character;
    }

    if (isShiftKey) {
        if (characterCode >= 65 && characterCode <= 90) {
            character = String.fromCharCode(characterCode);
        } else {
            character = keysCodesMap[characterCode];
        }
    } else {
        if (characterCode >= 65 && characterCode <= 90) {
            character = String.fromCharCode(characterCode).toLowerCase();
        }
        else if (characterCode >= 96 && characterCode <= 105) {
            character = keysCodesMap[characterCode];
        } else {
            character = String.fromCharCode(characterCode);
        }
    }

    return character;
}

/**
 * Few SAH callbacks use prototype.js-related event dispatcher on document object. This function will convert it to jquery-related
 * @param event
 * @param options
 */
document.fire = function(event, options){
    $(document).trigger(event, options);
};

/**
 * mobile device detector
 */
function detectMobileBrowser(){
    return (/Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent));
}

(function($) {
    $.fn.getCursorPosition = function() {
        var input = this.get(0);
        if (!input) return; // No (input) element found
        if (document.selection) {
           input.focus();
        }
        return 'selectionStart' in input ? input.selectionStart:'' || Math.abs(document.selection.createRange().moveStart('character', -input.value.length));
     }
   })(jQuery);
;var swc = {
    "base": {},
    "views": {},
	"mixins": {},
    "models": {},
    "constructors": {},
    "settings": {
    "application": {},
    "rest": {}
    }
};

if (!Object.keys) {
  Object.keys = function(obj) {
    var keys = [];

    for (var i in obj) {
      if (obj.hasOwnProperty(i)) {
        keys.push(i);
      }
    }

    return keys;
  };
}

swc.Utils = {
    
    deviceId: null,
    translatedProductName: "",
    
    HalfWidthZeroCode: 0x30,
    HalfWidthNineCode: 0x39,
    FullWidthZeroCode: 0xff10,
    FullWidthNineCode: 0xff19,
    NumberNormalizeMap: {
    },
    HalfWidthPeriod: '.',
    FullWidthPeriod: '．',
    HalfWidthComma: ',',
    maxDeviceLastConnectionStamp: 30 * 24 * 60 * 60 * 1000,

    /**
     * Format IPv6 address to short form:
     *
     * @description
     *
     *  one or more leading zeroes from any groups of hexadecimal digits MUST be removed;
     *  consecutive sections of zeroes MUST be replaced with a double colon ( :: ).
     *
     * @param address {String}
     *
     * @returns {String}
     */
    formatIPv6Address: function (address) {
        return address ? address.replace(/\b0+/g, "").replace(/:{2,}/g, "::") : '';
    },

    /**
     * @function: getBytesWithUnit()
     * @purpose: Converts bytes to the most simplified unit.
     * @param: (number) bytes, the amount of bytes
     * @returns: (string)
     */
    getBytesWithUnit: function (bytes) {
        var units = [ ' bytes', ' KB', ' MB', ' GB', ' TB', ' PB', ' EB', ' ZB', ' YB' ],
            amountOf2s, i;

        if (isNaN(bytes)) {
            return "";
        }

        amountOf2s = Math.floor(Math.log(+bytes) / Math.log(2));

        if (amountOf2s < 1) {
            amountOf2s = 0;
        }

        i = Math.floor(amountOf2s / 10);
        bytes = +bytes / Math.pow(2, 10 * i);

        // Rounds to 3 decimals places.
        if (bytes.toString().length > bytes.toFixed(2).toString().length) {
            bytes = bytes.toFixed(2);
        }

        return bytes + units[i];
    },

    lengthInUtf8Bytes: function(str) {
      // Matches only the 10.. bytes that are non-initial characters in a multi-byte sequence.
      var m = encodeURIComponent(str).match(/%[89ABab]/g);
      return str.length + (m ? m.length : 0);
    },

    limitSetOfCharactersDown: function(e, regex, others) {
        var key = String.fromCharCode(e.keyCode);
        //if we got key which is CUT, PAST, COPY, BACKSPACE, DELETE, ARROWS and some others then pass it
        if((!_.isUndefined(others) && _.indexOf(others, e.keyCode) !== -1) || e.keyCode === 9 ||
            e.keyCode === 86 || e.keyCode === 190 || e.keyCode === 67 || e.keyCode === 88 ||
            e.keyCode === 8 || e.keyCode === 46 || (e.keyCode >= 37 && e.keyCode <= 40) || (e.keyCode >= 96 && e.keyCode <= 105)) {
            return true;
        }
        if(regex.test(key)) {
            e.preventDefault();
            return false;
        }
    },

    limitSetOfCharactersInput: function(e, regex) {
        var replacement=$(e.target).val(),
        pos = e.target.selectionStart;
        if(regex.test(replacement)) {
            replacement=replacement.replace(regex,'');
            $(e.currentTarget).val(replacement);
            e.target.setSelectionRange(pos-1, pos-1);
        }
    },

    /**
     * Returns the version of Internet Explorer or 0 for indicating the use of another browser.
     *
     * @returns {Number}
     */
    getIEVersion: function () {
        var rv = 0; // Return value assumes failure.
        var ua = navigator.userAgent;
        var re = /MSIE (\d+(?:\.\d+)?)/;

        if (navigator.appName === 'Microsoft Internet Explorer') {
            if (re.exec(ua) !== null) {
                rv = parseFloat(RegExp.$1);
            }
        }

        if(!(window.ActiveXObject) && "ActiveXObject" in window) {
            return 11;
        }

        return rv;
    },

    /**
     * Check if childArr contains all values from parentArr
     * @param parentArr array
     * @param childArr array
     */
    containsArray: function (parentArr, childArr) {
        var contains = true;
        _.each(parentArr, function(value){
            if(!_.contains(childArr, value)){
                contains = false;
            }
        });

        return contains;
    },

    /**
     * Convert values Value => Element Key map to values
     *
     * @param map {Object}
     * @param data {Object} page elements
     *
     * @returns {*}
     */
    getDataToValidate: function(map, data) {
        var values = {};

        _.each(data, function(elementMap) {
            _.each(map, function(value, id) {
                if (!_.isUndefined(value.elementName) && elementMap.parameterName === value.elementName) {
                    if (!_.isUndefined(value.elementClass)) {
                        if (_.indexOf(elementMap.parameterClasses, value.elementClass) !== -1) {
                            values[id] = elementMap.parameterValue;
                        }
                    } else {
                        values[id] = elementMap.parameterValue;
                    }
                }
            });
        });

        return values;
    },
    
    getDeviceID: function() {
        return this.deviceId;
    },

    /**
     * is used because doublequotes break NP response format in some calls (PF, IPv6).
     */
    generateId: function () {
        return _.uniqueId((new Date().getTime()) + "_");
    },

    /**
     * General validation requirement from Swisscom for passwords (except WiFi)
     */
    validatePassword: function (password) {
        var testRegEx = /^(?=.*?[a-zA-Z])(?=.*?([ -@]|[\[-`]|[{-~]))[ -~]{8,16}$/;

        return testRegEx.test(password);
    },

    validatePasswordSimple: function (password) {
        var testRegEx = /^(?=.*?[a-zA-Z])(?=.*?([ -@]|[\[-`]|[{-~]))[ -~]*$/;

        return testRegEx.test(password);
    },

    /**
     * WiFi password validator
     *
     * @param {String} password
     *
     * @return {boolean}
     */
    validateWifiPassword: function (password) {
        var testRegEx = /^(?=.*?[a-zA-Z])(?=.*?[-._\d])[-.\w]{8,63}$/;

        return testRegEx.test(password);
    },

    nonPrintableRegexGlobal: function() {
        var re=/[^\x20-\x7e]$/g;
        return re;
    },

    /**
     * Calculates day number (assuming 0 is Monday) and seconds from start of a day
     * using seconds since start of a week.
     * Result would be an object of view: {seconds: 3000, hops: 2},
     * where hops = day of week (0 - Monday, 1 - Tuesday...)
     * @example:
     *   <pre>604800(end of sunday) -> 86400(end of a day)</pre>
     *
     * @param seconds in a week
     *
     * @returns Object
     */
    getDaySeconds: function(seconds_since_monday) {
        var secondsInDay = 86400;
        return {
            seconds: seconds_since_monday % secondsInDay || secondsInDay,
            hops: Math.ceil(seconds_since_monday / secondsInDay) - 1
        };
    },

    /**
     * Check if browser has cookies enabled.
     * 
     * @return {Boolean}
     */
    isCookieSupport: function() {
        var cookieEnabled = ( typeof navigator.cookieEnabled !== 'undefined') ? navigator.cookieEnabled : false;
    
        if (cookieEnabled) {
            var date = new Date();
            // 20s
            date.setTime(date.getTime() + (1000 * 20));
            var expires = "; expires="+date.toGMTString();
            
            document.cookie = 'test=test; expires=' + expires;
            cookieEnabled = (document.cookie.indexOf('test') !== -1) ? true : false;
        }
    
        return (cookieEnabled);
    },
    
    /**
     * Append ie fixes to page.
     * 
     * @param path to css
     */
    appendIECss: function(path) {
        $.get(path, function(data) {
            var css = data,
                head = document.getElementsByTagName('head')[0],
                style = document.createElement('style');

            style.type = 'text/css';

            if (style.styleSheet) {
                style.styleSheet.cssText = css;
            } else {
                style.appendChild(document.createTextNode(css));
            }

            head.appendChild(style);
        });
    },
    isALetter: function(character){

        if(character.toUpperCase() !== character.toLowerCase()) {
            return true;
        }
        return false;
    },

    isANumber: function(num) {
        return !isNaN(num);
    },
    
    getCurrentDate: function() {
        var result = null;
        $.ajax({
            type: 'POST',
            headers: {
                'X-Context': $.cookie(swc.Utils.getDeviceID() + '/context'),
                'Authorization': 'X-Sah ' + $.cookie(swc.Utils.getDeviceID() + '/context'),
                'X-Sah-Request-Type': "idle",
                'idle': true
            },
            url: '/sysbus/Time:getTime',
            timeout: 2000,
            async: false,
            data: {
                "parameters": {}
            },
            success: function(response) {
                if(!_.isEmpty(response) && !_.isEmpty(response.data) && !_.isEmpty(response.data.time)){
                // DATE is coming from server with TimeZone.
                result = new Date(Date.parse(response.data.time));
                }
                else{
                    swc.models.Login.processLogout({ action: 'session-logout' });
                    //if we get corrupt data from server get time from browser 
                    result= new Date();
                }
            }
        });
        
        return result;
    },
    
    reSync: function(model, method) {
         swc.models[model].autoSync = true;
         setTimeout(function() {
            swc.models[model].autoSync = false;
         }, 10000);
         
         return swc.models[model].sync(method);
    },

      /**
     * Get device codename
     * 
     */

    getDeviceName: function() {

        var productClass = swc.Utils.ProductClass?  swc.Utils.ProductClass.split('-')[0] : '';

        switch(productClass) {
            case 'SLT':
                return 'starlite';

            case 'LNK':
                return 'starlink';

            default:
                return 'starlite';
        }
    },

    updateDevicesByModelName: function(model, event, callback) {
         var arr = [],
             self = this;
          _.each(event.data.object.attributes,function(who){

            if(!_.isUndefined(callback)) {
              callback(who, self, arr);
            }
            else {
              arr.push(who);
            }
          });

          swc.models[model].updateDeviceList(arr);
          swc.models[model].trigger("change");
          swc.models[model].trigger("devices-loaded", true);
    },
    
    
    sortByCollate: function(array, map, desc) {
        var me = this;

        var arr = _.clone(array);
        arr.sort(function(a, b) {
            var aProperty, bProperty, comp;
            aProperty = me.transformArgument(a, map, arr, [a]);
            bProperty = me.transformArgument(b, map, arr, [b]);
            if (_.isString(aProperty) && _.isString(bProperty)) {
                comp = me.collateStrings(aProperty, bProperty);
            } else if (aProperty < bProperty) {
                comp = -1;
            } else if (aProperty > bProperty) {
                comp = 1;
            } else {
                comp = 0;
            }
            return comp * ( desc ? -1 : 1);
        });
        return arr;
    }, transformArgument: function(el, map, context, mapArgs) {
        if (!map) {
            return el;
        } else if (map.apply) {
            return map.apply(context, mapArgs || []);
        } else if (_.isFunction(el[map])) {
            return el[map].call(el);
        } else {
            return el[map];
        }
    }, collateStrings: function(a, b) {
        var aValue, bValue, aChar, bChar, aEquiv, bEquiv, index = 0, tiebreaker = 0;

        var sortIgnore = this.AlphanumericSortIgnore;
        var sortIgnoreCase = this.AlphanumericSortIgnoreCase;
        var sortEquivalents = this.AlphanumericSortEquivalents;
        var sortOrder = this.AlphanumericSortOrder;
        var naturalSort = this.AlphanumericSortNatural;

        a = this.getCollationReadyString(a, sortIgnore, sortIgnoreCase);
        b = this.getCollationReadyString(b, sortIgnore, sortIgnoreCase);

        do {

            aChar = this.getCollationCharacter(a, index, sortEquivalents);
            bChar = this.getCollationCharacter(b, index, sortEquivalents);
            aValue = this.getSortOrderIndex(aChar, sortOrder);
            bValue = this.getSortOrderIndex(bChar, sortOrder);

            if (aValue === -1 || bValue === -1) {
                aValue = a.charCodeAt(index) || null;
                bValue = b.charCodeAt(index) || null;
                if (naturalSort && this.codeIsNumeral(aValue) && this.codeIsNumeral(bValue)) {
                    aValue = this.stringToNumber(a.slice(index));
                    bValue = this.stringToNumber(b.slice(index));
                }
            } else {
                aEquiv = aChar !== a.charAt(index);
                bEquiv = bChar !== b.charAt(index);
                if (aEquiv !== bEquiv && tiebreaker === 0) {
                    tiebreaker = aEquiv - bEquiv;
                }
            }
            index += 1;
        } while(aValue != null && bValue != null && aValue === bValue);
        if (aValue === bValue) {
            return tiebreaker;
        }
        return aValue - bValue;
    },

    codeIsNumeral: function(code) {
        return (code >= this.HalfWidthZeroCode && code <= this.HalfWidthNineCode) || (code >= this.FullWidthZeroCode && code <= this.FullWidthNineCode);
    }, buildNumberHelpers: function() {
        var digit, i;
        // reseting the default value of FullWidthDigits which is undefined to an empty string. 
        this.FullWidthDigits="";
        for ( i = 0; i <= 9; i++) {
            digit = this.chr(i + this.FullWidthZeroCode);
            this.FullWidthDigits += digit;
            this.NumberNormalizeMap[digit] = this.chr(i + this.HalfWidthZeroCode);
        }
        this.NumberNormalizeMap[this.HalfWidthComma] = '';
        this.NumberNormalizeMap[this.FullWidthPeriod] = this.HalfWidthPeriod;
        // Mapping this to itself to easily be able to easily
        // capture it in stringToNumber to detect decimals later.
        this.NumberNormalizeMap[this.HalfWidthPeriod] = this.HalfWidthPeriod;
        this.NumberNormalizeReg = new RegExp('[' + this.FullWidthDigits + this.FullWidthPeriod + this.HalfWidthComma + this.HalfWidthPeriod + ']', 'g');
    }, stringToNumber: function(str, base) {
        var sanitized, isDecimal;
        sanitized = str.replace(this.NumberNormalizeReg, function(chr) {
            var replacement = swc.Utils.NumberNormalizeMap[chr];
            if (replacement === swc.Utils.HalfWidthPeriod) {
                isDecimal = true;
            }
            return replacement;
        });
        return isDecimal ? parseFloat(sanitized) : parseInt(sanitized, base || 10);
    }, getCollationReadyString: function(str, sortIgnore, sortIgnoreCase) {
        if (!_.isString(str)) {
            str = String(str);
        }
        if (sortIgnoreCase) {
            str = str.toLowerCase();
        }
        if (sortIgnore) {
            str = str.replace(sortIgnore, '');
        }
        return str;
    }, getCollationCharacter: function(str, index, sortEquivalents) {
        var chr = str.charAt(index);
        return sortEquivalents[chr] || chr;
    }, getSortOrderIndex: function(chr, sortOrder) {
        if (!chr) {
            return null;
        } else {
            return sortOrder.indexOf(chr);
        }
    }, buildAlphanumericSort: function() {
        var order = 'AÁÀÂÃĄBCĆČÇDĎÐEÉÈĚÊËĘFGĞHıIÍÌİÎÏJKLŁMNŃŇÑOÓÒÔPQRŘSŚŠŞTŤUÚÙŮÛÜVWXYÝZŹŻŽÞÆŒØÕÅÄÖ';
        var equiv = 'AÁÀÂÃÄ,CÇ,EÉÈÊË,IÍÌİÎÏ,OÓÒÔÕÖ,Sß,UÚÙÛÜ';
        this.AlphanumericSortOrder = $.map(order.split(''), function(str) {
            return str + str.toLowerCase();
        }).join('');
        var equivalents = {};
        _.each(equiv.split(','), function(set) {
            var equivalent = set.charAt(0);
            _.each(set.slice(1).split(''), function(chr) {
                equivalents[chr] = equivalent;
                equivalents[chr.toLowerCase()] = equivalent.toLowerCase();
            });
        });
        this.AlphanumericSortNatural = true;
        this.AlphanumericSortIgnoreCase = true;
        this.AlphanumericSortEquivalents = equivalents;
    }, chr: function(num) {
        return String.fromCharCode(num);
    }

};

// We have to disable cache completely
$.ajaxSetup({
    cache: false
});

$(document).ready(function() {
    if(typeof console === "undefined") {
        window.console = {log: function() {}};
    }
    $.getJSON("/static/settings/application.json", {}, function(response, statusText, jqXHR){
        swc.Utils.deviceId = jqXHR.getResponseHeader('ETAG');
        swc.Utils.buildAlphanumericSort();
        swc.Utils.buildNumberHelpers();
        
        //response.
        swc.settings.application = new Backbone.Model();
        swc.settings.application.set(response);

        // This setting should be the same as currently used domain,
        // that is why fixing it here to not dig through all application where we do redirect,
        // i.e. Reboot / Restore Config / Upgrade, etc
        swc.settings.application.set("url", window.location.origin);

        //Temporary custom icons hack
        var customDevices = [
            {
                avplayer: {
                    deviceIcon: "avplayer",
                    deviceTypeLocalized: "AV Player",
                    deviceTypeText: "AV Player"
                }
            }
        ];
        _.each(customDevices, function(device){
            swc.settings.application.attributes.supportedWiredDevices[Object.keys(device)[0]] =
            swc.settings.application.attributes.supportedWirelessDevices[Object.keys(device)[0]] =
            device[Object.keys(device)[0]];
        });

        // Clone application dispatcher from Backbone events:
        swc.constructors.dispatcher = _.clone(Backbone.Events);

        // Init main application model
		swc.models.Application = new swc.constructors.ApplicationModel();

        var IEVersion = swc.Utils.getIEVersion();

		// Execute IE fixes
		if (IEVersion <= 7) {
            swc.Utils.appendIECss('/application/ie7.css');
		} else if (IEVersion === 8) {
			swc.Utils.appendIECss('/application/ie8.css');

            $.get('/application/ie8.fix.js');
        }

        if (IEVersion === 7 || IEVersion === 8) {
            swc.Utils.appendIECss('/application/ie7and8.css');
        }
	});
});
;swc.constructors.LocaleModel = Backbone.Model.extend({

    /**
     * Current application locale
     *
     * @param locale {String}
     *
     */
    locale: "",

    /**
     * Default application locale defined in settings
     *
     * @var defaultLocale {String}
     */
    defaultLocale: "",

    /**
     * List of available locales:
     *
     * @param available {Array}
     *
     */
    available: [],

    initialize: function() {
        this.defaultLocale = swc.settings.application.get('locales')['default'];
        this.available = swc.settings.application.get('locales').available;
    },

    /**
     * Get localised strings for selected component:
     *
     * @param component {String}
     *
     */
    getLocaleStrings: function(componentTrigger) {
        var component = Backbone.history.fragment ? Backbone.history.fragment : 'application';

        if (componentTrigger) {
            component = componentTrigger;
        } else {
            // for reote-login we have just login page
            if(component === 'remote-login') {
                component = 'login';
            }


            //get same translations as for speedtest app inside webui
            if(component === 'speedtest') {
                component = 'applications/speedtest';
            }
        }

        var componentsArray = component.split('/'),
            strings = swc.locales;

        return this.getLocaleStringsRecursively(strings[componentsArray[0]], {});
    },

    getLocaleStringsRecursively: function(strings, result) {
        var self = this;

        if (!getObjectLength(strings)) {
            return result;
        }

        $.each(strings, function(id, string) {
            if (typeof string !== "object") {
                result[id] = string;
            } else {
                self.getLocaleStringsRecursively(string, result);
            }
        });

        return result;
    },

    /**
     * Insert locale strings to the collection when application is loaded
     *
     * @param strings {Object}
     *
     */
    setLocaleStrings: function(strings) {
        swc.locales = strings;
    },

    /**
     * Get saved UI language in a deferred way
     *
     * @return Promise
     */
    getLocale: function(){
        var deferred = new $.Deferred();

        // Request language from the server
        // Save current UI language on NP side
        var restClient = new swc.constructors.Rest();
        restClient.sendRequest({
            url: '/sysbus/UserInterface:getLanguage',
            data: {
                parameters: {}
            },

            success: function(response) {
                if(response.status && response.status !== false){
                    deferred.resolve(response);
                }
                else {
                    deferred.reject();
                }
            },

            error: function(){
                deferred.reject();
            }
        });

        return deferred.promise();
    },
    /**
     * @param language {string} - language property
     * 
     * @return {string} -returns accepted language property / or default language property
     */
    validateLanguage: function(language){
        var validationState=swc.models.Locale.defaultLocale;
        if(language.length >= 3){
           language = language.slice(0,2);
        }
        _.each(swc.models.Locale.available,function(availableLanguage){
            if(availableLanguage.key+""===language+""){
                validationState=language;
            }
        });
        return validationState;
    },
    setLocaleCookie: function(language){
       var date = new Date();
           date.setFullYear(date.getFullYear()+1);
       var expires = "; expires="+date.toGMTString();
       document.cookie = 'locale='+language+'; expires=' + expires;
    },
    /**
     * Set application locale file:
     *
     * @param locale {String}
     *
     */
    setLocale: function(locale, save) {
        var self = this,
            deferred = new $.Deferred();

        sessionStorage.removeItem("eventManager:channelId");

        // Update cookie locale
        if(swc.Utils.isCookieSupport() && save) {
            localStorage.setItem("locale", locale);
        }
        // save into self property
        self.locale = locale;

        /**
         * Load localization strings
         *
         * @return Deferred
         */
        function loadLocalizationData() {
            var deferred = new $.Deferred();

            var system = new swc.constructors.System(),
                info = system.getGatewayType();

            swc.Utils.ProductClass = info.ProductClass;
            swc.Utils.NPVersion = info.NPVersion;

            var deviceName = swc.Utils.getDeviceName();

            swc.Utils.DeviceType = deviceName;

            $('body').addClass(deviceName + ' ' + swc.Utils.NPVersion);

            $.ajax({
                url: 'static/translations/' + deviceName + '/' + self.locale + '.json',
                type: 'get',
                dataType:'json'
            }).done(function(response) {
                self.setLocaleStrings(response);
                deferred.resolve();
            }).fail(function(){
                deferred.reject();
            });

            return deferred.promise();
        }

        function setLanguage(data) {
            localStorage.setItem("locale", data.status);
            if(window.location.href.toString().indexOf('captivePortal.html') > -1) {
                self.setLocaleCookie(data.status);
            }
            self.locale = data.status;
        }

        /**
         * Save selected UI language on NP side
         *
         * @return Promise
         */
        function saveLanguageOnServer(){
            var deferred = new $.Deferred();
            // Save current UI language on NP side
            var restClient = new swc.constructors.Rest();
            restClient.sendRequest({
                url: '/sysbus/UserInterface:setLanguage',
                method: 'POST',
                contentType: 'application/x-sah-ws-4-call+json',
                data: {
                    "parameters": {
                        "currentLanguage": locale
                    }
                },

                success: function() {
                    deferred.resolve();
                },

                error: function(){
                    deferred.reject();
                }
            });

            return deferred.promise();
        }

        /**
         * 
         *
         */

        function getLanguage(){
            var deferred = new $.Deferred(),
                restClient = new swc.constructors.Rest();

            if(!save)
            {
                restClient.sendRequest({
                    url: '/sysbus/UserInterface:getLanguage',
                    contentType: 'application/x-sah-ws-4-call+json',
                    data: {
                        "parameters": {
                        
                        }
                    },

                    success: function(data) {
                        setLanguage(data);
                        deferred.resolve();
                    },

                    error: function(){
                        deferred.reject();
                    }
                });
             } else {
                 deferred.resolve();
             }

            return deferred.promise();
        }

        $.when(getLanguage())
            .done(function() {
                $.when(loadLocalizationData(), saveLanguageOnServer())
                .done(function(){
                    deferred.resolve();
                })
                .fail(function(){
                    deferred.reject();
                });
             })
            .fail(function() { deferred.reject(); });
        //set cookie locale
        
        return deferred.promise();
    },

    /**
     * Get locale options for dropdown:
     */
    getLocaleOptions: function() {
        var self = this,
            options = [];

        $.each(self.available, function(key, locale) {
            options.push({
                name: locale.text,
                value: locale.key
            });
        });

        return options;
    },

    getStaticPagesLinks: function(){
        var locales = swc.settings.application.get('locales').available;
        var locale = _.findWhere(locales, {key: this.locale});
        return locale.staticPages;
    },

    formatDate: function (date, format) {
        var d = new Date(date).getTime();
        if (_.isNaN(d)) {
            return date;
        }
        moment.lang(swc.models.Locale.locale);
        return moment(d).format(format || "D MMM YYYY, HH:mm");
    }
});
;swc.constructors.Template = Backbone.Model;
swc.constructors.SimpleModel = Backbone.Model;

/**
 * Base backbone model for extending in application
 *
 * @type {*}
 *
 */
swc.base.Model = Backbone.Model.extend({

    /**
     * Rest interface component:
     *
     * @param {component} String
     *
     */
    component: '',

    /**
     * Rest interface action:
     *
     * @param {component} String
     *
     */
    action: '',

    /**
     * Rest interface component to save data
     *
     * @param {componentSave} String
     */
    componentSave: '',

    /**
     * Rest interface action to save data
     *
     * @param {actionSave} String
     */
    actionSave: '',

    /**
     * JSON data witch will be sent via AJAX when model.sync() will be proceed
     */
    json: {},

    /**
     * JSON data witch will be sent via AJAX when model.save() will be proceed
     */
    saveJSON: {},

    /**
     * Request method
     */
    method: 'POST',

    /**
     * Request method for save action
     */
    methodSave: 'POST',

    /**
     * Model sync method which can be redefined while extending if necessary
     */
    sync: function() {
        var deferred = new $.Deferred(),
            headers,
            self = this;

        if (this.headers) {
            headers = this.headers;
        } else {
            headers = {
                'X-Context': $.cookie(swc.Utils.getDeviceID() + '/context'),
                'Authorization': 'X-Sah ' + $.cookie(swc.Utils.getDeviceID() + '/context')
            };
        }

        swc.models.Rest.sendRequest({
            component: self.component,
            action: self.action,
            data: self.json,

            method: self.method,
            contentType: 'application/x-sah-ws-4-call+json',

            headers: headers,

            success: function(response) {
                if (response.status) {
                    if (typeof response.status === "string") {
                        self.set("data", $.parseJSON(response.status));
                    } else {
                        self.set("data", response.status);
                    }
                } else {
                    if (typeof response === "string") {
                        self.set("data", $.parseJSON(response));
                    } else {
                        self.set("data", response);
                    }
                }

                return deferred.resolve();
            },

            error: function() {
                return deferred.resolve();
            }
        });

        return deferred.promise();
    },

    /**
     *
     */
    save: function() {
        var deferred = new $.Deferred(),
            self = this;

        swc.models.Rest.sendRequest({
            component: self.componentSave,
            action: self.actionSave,
            data: self.saveJSON,
            method: self.methodSave,

            success: function() {
                return deferred.resolve();
            },

            error: function() {
                return deferred.resolve();
            }
        });

        return deferred.promise();
    },

    /**
     * Method for updating current model on the server
     */
    pageSave: function() {}
});

/**
 *
 * Backbone model for Templates
 *
 * @type {*}
 *
 */
swc.constructors.Templates = Backbone.Collection.extend({

    initialize: function() {},

    /**
     * Load application template files
     *
     * @param callback
     *
     */
    loadTemplates: function(callback) {
        var self = this,
            deferred = new $.Deferred();

        $.get('/application/tpl.min.html').success(function(response) {
            $.each($(response), function(templateKey, template) {
                if(template.nodeName.toLowerCase() === 'script') {
                    var localTemplate = new swc.constructors.Template();

                    localTemplate.set('content', template);
                    localTemplate.set('id', $(template).attr('id'));

                    self.add(localTemplate);
                }
            });

            if ($.isFunction(callback)) {
                callback();
            }
        });

        return deferred.promise();
    }
});
;swc.constructors.Rest = Backbone.Model.extend({

    /**
     * List of rules for formatting query strings
     * @type {Object}
     */
    rules: {
        stringType: function(json) {
            return JSON.stringify(json);
        },
        jsonType: function(json) {
            return json;
        }
    },

    /**
     * Initialise REST model
     */
    initialize: function() {},

    /**
     * Send REST request based on incoming options
     * @param options {Object}
     * @return {Object}
     */
    sendRequest: function(options) {
        var contentType = options.contentType ? options.contentType : 'application/x-sah-ws-4-call+json',
            requestType = options.method ? options.method : 'POST',
            // undefined -> true
            // true -> true
            // false -> false
            processData = options.processData === false ? options.processData : true,
            asyncCall = options.async === false ? options.async : true,
            requestHeaders = options.headers ? options.headers : {
                'X-Context': $.cookie(swc.Utils.getDeviceID() + '/context'),
                'Authorization': 'X-Sah ' + $.cookie(swc.Utils.getDeviceID() + '/context')
            },
            requestData = options.data ? options.data : {},
            formatRule = options.formatRule ? options.formatRule : "stringType",
            timeout = options.timeout ? options.timeout : 29000,
            
            self = this;

        // Check if request is in background:
        if (!_.isUndefined(options.fromListener) && options.fromListener === true) {
            requestHeaders = $.extend(requestHeaders, {
                'X-Sah-Request-Type': 'idle',
                'idle': true
            });
        }

        if ((requestType.toLowerCase() === 'post' && !options.data)) {
            return {
                'status': 'error',
                'message': 'Wrong POST data provided'
            };
        }

        if (processData && this.rules[formatRule]) {
            requestData = this.rules[formatRule].call(this, options.data);
        } else {
            requestData = options.data;
        }

        if (!processData && !options.contentType) {
            contentType = false;
        }

        if(options.testingJSONMalformed === true) {
            options.url = "http://localhost:3000/wstesting";
        }

        $.ajax({
            type: requestType,
            url: options.url,
            contentType: contentType,
            processData: processData,
            headers: requestHeaders,
            data: requestData,
            timeout: timeout,
            cache: false,
            async: asyncCall,
            
            beforeSend: function() {},

            complete: function() {},

            success: function(response) {
                try {
                    $.parseJSON(response);
                } catch(e) {
                    if ($.isFunction(options.parseProblem)) {
                        options.parseProblem();
                        self.trigger("success:" + options.component + '-' + options.action);
                        return;
                    }
                }
                self.parseResponse(response, options);
            },

            error: function(xhr, ajaxOptions, thrownError) {

                var response = xhr.responseText;

                try {
                    $.parseJSON(response);
                } catch(e) {
                    if ($.isFunction(options.parseProblem)) {
                        options.parseProblem();
                        self.trigger("success:" + options.component + '-' + options.action);
                        return;
                    }
                }

                /*if (options.error && $.isFunction(options.error)) {
                    options.error(xhr, ajaxOptions, thrownError);
                }*/
                if (response) {
                    if(response.indexOf("Permission denied") !== -1) {
                        if (options.error && $.isFunction(options.error)) {
                            options.error(xhr, ajaxOptions, thrownError);
                        }

                        swc.models.Login.processLogout({ action: 'session-logout' });
                    } else {
                        var json = jQuery.parseJSON(response);
                        self.parseResponse(json, options);
                    }
                }
                else {
                    if (options.error && $.isFunction(options.error)) {
                            options.error(xhr, ajaxOptions, thrownError);
                        }
                }
            },

            statusCode: {
                401: function() {
                    if (options.statusCode && options.statusCode['401'] && $.isFunction(options.statusCode['401'])) {
                        options.statusCode['401']();
                    }
                },
                
                403: function() {
                    if (options.statusCode && options.statusCode['403'] && $.isFunction(options.statusCode['403'])) {
                        options.statusCode['403']();
                    }
                },

                404: function() {
                    if (options.statusCode && options.statusCode['404'] && $.isFunction(options.statusCode['404'])) {
                        options.statusCode['404']();
                    }
                },

                500: function() {
                    if (options.statusCode && options.statusCode['500'] && $.isFunction(options.statusCode['500'])) {
                        options.statusCode['500']();
                    }
                },

                502: function() {
                    if (options.statusCode && options.statusCode['502'] && $.isFunction(options.statusCode['502'])) {
                        options.statusCode['502']();
                    }
                }
            }
        });
    },
    
    parseResponse: function(response, options) {
        var isPermissionDenied = false,
            isWrongAnswer = false;
        if(response.errors && response.errors.length > 0) {
            _.each(response.errors, function(error){
                var desc = error["description"];
                if (desc === "Permission denied") {
                    isPermissionDenied = true;
                } else if(desc === "wrong state the feature is disabled or not started") {
                    isWrongAnswer = true;
                }
            });
        }

        if (!response || isPermissionDenied || isWrongAnswer) {
            swc.models.Login.processLogout({ action: 'session-logout' });
        }

        if (options.success && $.isFunction(options.success)) {
            options.success(response);
        }

        this.trigger("success:" + options.component + '-' + options.action);
    }
});
;swc.constructors.Router = Backbone.Router.extend({

    /**
     * This stores history to allow navigate back
     */
    history: [],

    appScript: ["/application/app.min.js?v=05.01.19-689"],

    lastViewRendered: true,
    toRender: null,
    isLoadingModule: false,

    /**
     * Start history tracking:
     */
    initialize: function() {
        var self = this;
        
        // Save local routing history:
        this.on('route', function() {
            self.storeHistory();
        });

        Backbone.history.start();
    },

    /**
     * Define router settings:
     */
    routes: {
        //'': 'login',
        'login': 'login',
        'remote-login': 'remoteLogin',
        'speedtest': 'speedtest',
        '*': 'loadModule'
    },

    redirects: {
        '^network(?:/settings)?/?$': 'network/settings/ip-settings',
        '^wifi(?:/settings)?/?$': 'wifi/settings/type-24',
        '^telephony$': 'telephony/device',
        '^storage(?:/settings)?/?$': 'storage/data',
        '^system(?:/settings)?/?$': 'system/settings/reset',
        '^system/diagnostics/?$': 'system/diagnostics/overview',
        '^nocookies$': 'nocookies',
        '^oldie$': 'oldie',
        '^speedcheck?$': 'applications/speedtest'
    },

    /**
     * Fixes URL if user cuts manually address bar.
     * We have to redirect WebUI to the very first tab if incomplete URL requested.
     *
     * @param {String} requestedPath Original path from the browsers URL
     *
     * @return {String}
     */
    fixPath: function(requestedPath) {
        var fixedPath = '';

        if (swc.Utils.getIEVersion() >= 1 && swc.Utils.getIEVersion() <= 7) {
            fixedPath = 'oldie';
        } else {
            if(swc.Utils.isCookieSupport()){
                if(requestedPath === 'nocookies') {
                    fixedPath = '';
                } else if(requestedPath === 'oldie') {
                    fixedPath = '';
                } else {
                    _.forEach(this.redirects, function (value, key) {
                        if (!fixedPath && (new RegExp(key)).test(requestedPath)) {
                            fixedPath = value;
                        }
                    });
            
                    // Nothing replaced? Just copy original requested path.
                    if (!fixedPath) {
                        fixedPath = requestedPath ? requestedPath : '';
                    }
            
                    // Protect from entering arbitrary URL for which there is no module in the application
                    if (_.isUndefined(swc.constructors[this.buildConstructorNameFromPathComponents(fixedPath.split("/"))])) {
                        fixedPath = swc.settings.application.get('navigation')['overview'];
                    }
                }
            } else {
                fixedPath = 'nocookies';
            }
        }

        return fixedPath;
    },

    login: function() {
        if (swc.Utils.getIEVersion() >= 1 && swc.Utils.getIEVersion() <= 7) {
            this.navigate("oldie");
        } else {
            if(swc.Utils.isCookieSupport()) {
                // Navigate to #login page explicitly so needed translation scope guessed from path
                // this.navigate("login");
                this._doLogin();
            } else {
                this.navigate("nocookies");
            }
        }
    },

    remoteLogin: function() {
        // We add global css class here to the body - "disabled-for-superadmin"
        // Needed to hide all controls which should not be visible for superuser
        $("body").addClass("disabled-for-superadmin");
        this._doLogin(true);
    },

    /**
     * General login method which has some specific logic if login done remotely through WAN port
     * @param isRemote {boolean} Optional. Just pass TRUE in case if this is remote login
     * @private
     */
    _doLogin: function(isRemote) {
        var userIsLoggedIn = swc.models.Login.checkIfLoggedIn(),
            route = 'login';

        if (isRemote) {
            // Set this value to let login view know about remote login
            localStorage.setItem('remoteLogin', true);
            route = 'remote-login';
        }

        if (userIsLoggedIn) {
            this.navigate('overview', {trigger: true});
        } else {
            this.navigatePage(route, null);
        }
    },

    speedtest: function() {
        if(swc.models.Login.checkIfLoggedIn()) {
            window.location.hash = "applications/speedtest";
            return;
        }

        this.navigate('speedtest');
    },

    /**
     * General controller - loads module
     * @see this.navigatePage method
     * @param path
     */
    loadModule: function(path) {
        var me = this,
            userIsLoggedIn = swc.models.Login.checkIfLoggedIn();

        if(!_.isUndefined(swc.router)) {
            this.isLoadingModule = true;
        }

        // if we do not have cookie support we do not care about login
        if (!userIsLoggedIn && swc.Utils.isCookieSupport()) {
            if (!path || path.indexOf("recovery") === -1) {
                swc.models.Login.processLogout();
            } else {
                me.navigate(path, {
                    trigger : true
                });
            }
        } else {
            require(me.appScript, function() {
                me.navigate(path, {
                    trigger : true,
                    informWhenRendered : true
                });
            });
        }
    },

    /**
     * Save current fragment into history
     */
    storeHistory: function(fragment) {
        var urlToStore = !_.isUndefined(fragment) ? fragment : Backbone.history.fragment;

        // Avoid urls duplication:
        if (this.history.length && this.history[this.history.length - 1] === urlToStore) {
            return;
        }

        // Save current fragment to local history:
        this.history.push(urlToStore);
    },

    /**
     * Changes url to the previous one
     */
    navigateBack: function() {
        if (this.history.length > 1) {
            Backbone.history.navigate(this.history[this.history.length - 2], {trigger: false});
        } else {
            this.navigate(Backbone.history.fragment, {trigger: true});
        }
    },

    saveChangesDialog: function(confirmLeave) {
        var self = this;

        SWCElements.modalWindow.show({
            templateID: 'application:modal:changes-confirm',
            templateData: {
                formatDate: swc.models.Locale.formatDate
            },
            localeStrings: swc.models.Locale.getLocaleStrings('application'), // TODO :: no time to identify. Refactor this
            className: 'confirm-changes',

            onCancel: function() {
                // resolving deferred will allow us navigate to requested page
                confirmLeave.resolve();
            },

            onApply: function() {
                SWCElements.modalWindow.hide();
                self.navigateBack();
                confirmLeave.reject();
            }
        });
    },

    /**
     * Build View' constructor name from components got by splitting hash part of URL by "/"
     *
     * @protected For internal usage only!
     *
     * @param {Array} pathComponents
     *
     * @returns {string}
     */
    buildConstructorNameFromPathComponents: function (pathComponents) {
        var constructorName;

        constructorName = _.map(pathComponents.slice(0, 2), function (elem) {
            return elem.capitalize();
        }).join("") + "View";

        return constructorName.replace(/-/g, "");
    },

    navigatePage: function(path, options) {
        var pathComponents = path ? path.split('/') : Backbone.history.fragment.split('/'),
            area = $('#current-page'),
            constructor, view,
            self = this;

        // Check if application is already rendered:
        if (!area.size()) {
            swc.views.Application.showPageLoading('Initializing application');
        }

        // Generate constructor name:
        constructor = this.buildConstructorNameFromPathComponents(pathComponents);

        // Select correct name for view constructor:
        view = constructor.deCapitalize();

        // Do not re-create an instance of View if it has been created already
        if (!swc.views[view]) {
            swc.views[view] = new swc.constructors[constructor]();
        }

        // Define if current page has tabs:
        swc.views[view].hasTabs = pathComponents.length > 2;

        swc.constructors.dispatcher.trigger('route:change');

        if(!_.isUndefined(options) && options !== null && options.informWhenRendered === true && view === 'overviewView') {
            swc.views[view].on('render:finished:complete', function() {
                swc.views[view].off('render:finished:complete');
                self.lastViewRendered = true;
                if(self.toRender !== null) {
                    self.toRender.render();
                }
            });
        }

        //Render current view:
        if(!_.isUndefined(options) && options !== null && options.informWhenRendered === true && view === 'overviewView' && this.lastViewRendered === true) {
            this.lastViewRendered = false;
            self.toRender = null;
            swc.views[view].render(options);
        } else if(view === 'overviewView') {
            self.toRender = null;
            swc.views[view].render(options);
        } else if(this.lastViewRendered === false) {
            self.toRender = swc.views[view];
            swc.views['overviewView'].showPageLoading('Loading page data..');
        } else {
            self.toRender = null;
            swc.views[view].render(options);
        }
    },

    /**
     * This customized method will check if there are any changes made on page and Apply button is enabled.
     * Will show "confirm leave" dialog window if have unsaved pages.
     *
     * @override
     * @param fragment
     * @param options - standard Backbone navigation options + additional parameter {skipUnsavedChanges: true/false},
     *                  which defines weather to skip check for unsaved changes
     * @returns {defer.promise|*|Promise.promise}
     */
    navigate: function(fragment, options) {
        var currentView = swc.views.currentView,
            self = this,
            path = this.fixPath(fragment),
            confirmLeave = new $.Deferred();

        var pathComponents = path ? path.split('/') : Backbone.history.fragment.split('/');
        var constructor = this.buildConstructorNameFromPathComponents(pathComponents);

        if(!_.isUndefined(swc.constructors[constructor]) && $.isFunction(swc.constructors[constructor].prototype.isAbleToNavigate)) {
            if(swc.constructors[constructor].prototype.isAbleToNavigate() === false) {
                self.navigate('overview', {trigger: true});
                return;
            }
        }

        var pagesArray = Backbone.history.fragment.split("/"),
            TabConstructorName = _.map(pagesArray, function(n) {
                return n.capitalize();
            }).concat("View").join("").replace(/-/g,'');

        if(!_.isUndefined(swc.constructors[TabConstructorName]) && $.isFunction(swc.constructors[TabConstructorName].prototype.isAbleToNavigate)) {
            if(swc.constructors[TabConstructorName].prototype.isAbleToNavigate() === false) {
                document.location.href = "#overview";
                return;
            }
        }

        function navigateFn() {
            // Save route path, when custom navigation called:
            self.storeHistory(fragment);
    
            // Only go ahead if user confirmed their decision
            confirmLeave.promise().then(function(){
                // do the actual navigation
                Backbone.Router.prototype.navigate(path, options);
                self.navigatePage(path, options);
            });
    
            // Check for not saved changes on page
            // temporally canceled checker on some pages
            if (currentView && currentView.hasChanged() && !(!_.isUndefined(options) && (options.skipUnsavedChanges))) {
                self.saveChangesDialog(confirmLeave);
                return confirmLeave.promise();
            } else {
                confirmLeave.resolve();
            }
        }

        if(swc.models.Login.checkIfLoggedIn()) {
            require(swc.models.Login.appScript, function() {
                navigateFn();
            });
        } else {
            navigateFn();
        }
    },

    /**
     * Determines to where redirect user after they successfully logged in - either overview or previous page
     * @private
     */
    determineNextPage: function() {
        var previousPage = localStorage.getItem('previous-page'),
            location = 'overview';

        // Define page where user has to be navigated to:
        if (previousPage && _.indexOf(['login', 'remote-login'], previousPage) === -1) {
            location = previousPage;
        }

        // clear information about previous page
        localStorage.removeItem('previous-page');

        return location;
    }
});
;swc.base.PageView = Backbone.View.extend({

    /**
     * Selected view tag name
     *
     * @param tagName {String}
     *
     */
    tagName: 'div',

    /**
     * Selected view class name
     *
     * @param className {String}
     *
     */
    className: '',

    /**
     * List of allowed modes for current page:
     *
     * @param allowedMods {Array}
     *
     */
    allowedMods: ["standard", "expert"],

    /**
    * List of disallowed devices for current page
    *
    * @param disallowedDevices {Array}
    */

    disallowedDevices: [],

    /**
     * List of models which have to be preloaded before page is rendered
     *
     * @param models {Object} :: object :: callback function
     *
     */
    models: [],

    /**
     * List of methods for each validateable component to be called:
     * @param validation {Object || Map}
     *
     * @description can be used in two ways - passing arguments as <string> : <string>, or
     *              passing arguments as <string> : <array>
     *
     * @example
     *              validation: {
     *                  'input[name="somename"]': 'IPModel.validateIPAddress'
     *                  'input[name="othername"]': [
     *                                                 'IPModel.validateDHCP',
     *                                                 'IPModel.validateDMZ'
     *                                             ]
     *              }
     */
    validation: [],

    /**
     * Template data storage which will be passed to the template when models are loaded:
     */
    templateData: {},

    /**
     * Default interval for listeners - 10 seconds
     */
    listenerInterval: 10,

    /**
     * Flag which enable / disable pages:
     */
    listenerEnabled: false,

    /**
     * List of pages where listeners will work for current view
     */
    listenerPages: [],

    /**
    * list of observers to avoid duplicates
    */
    observers : [],
    /**
     * List of default events for each page - will be extended by each view
     * @param events {Object}
     */
    events: {
        // special event to be called from the code:
        'validate .validatable': 'pageValidation',

        // When user makes a change on the field and leaves focus from it:
        'change input.validatable': 'pageValidation',

        // When user makes a change on checkbox:
        'swc-checkbox:change .swc-checkbox.validatable': 'pageValidation',

        // When user makes a change on checkbox extended:
        'swc-checkbox-extened:change .swc-checkbox.validatable': 'pageValidation',

        // When user makes a change on dropdown:
        'swc-dropdown:change .swc-dropdown.validatable': 'pageValidation',

        // When user makes a change on radiobutton:
        'swc-radio-buttons:change .swc-radio-buttons.validatable': 'pageValidation',

        // When user makes a change in the field but focus is still in
        'keyup input.swc-input': 'setButtonsState',

        // Button cancel changes click handler
        'click .button.cancel-changes:not(.disabled)': 'cancelChanges',

        // Button save changes click handler
        'mousedown .button.save-changes:not(.disabled)': 'saveChanges'
    },

    /**
     * Flag to identify if page content is disabled by loading backdrop
     * @param isPageEnabled {Boolean}
     */
    isPageEnabled: true,

    /**
     * Flag to identify if page tabs are disabled by loading backdrop
     * @param isTabsEnabled {Boolean}
     */
    isTabsEnabled: true,

    showGlobalError: true,

    /**
     * Initialise view
     */
    initialize: function() {
        var pagesArray = Backbone.history.fragment.split("/");

        // Guess page template ID from the URL if it is not set explicitly
        if (_.isUndefined(this.pageTemplateID)) {
            if (pagesArray.length === 1) {
                if (!pagesArray[0].length) {
                    this.pageTemplateID = 'overview';
                } else {
                    this.pageTemplateID = pagesArray[0];
                }
            } else {
                this.pageTemplateID = pagesArray[0] + ':' + pagesArray[1];
            }
        }

        // Prepare template for current page:
        this.template = $.template("pageContent", swc.Templates.get(this.pageTemplateID).get('content'));

        // Extend global events:
        this.events = _.extend({}, swc.base.PageView.prototype.events, this.events);
    },

    /**
     * Check if current view has unsaved changes on it, e.g. has "dirty model".
     * So far it check if there us enabled "Save" button.
     *
     * @return {boolean}
     */
    hasChanged: function() {
        var changeValue = this.$(".client-buttons a[class*='apply']:not(.disabled), " +
            ".client-buttons a[class*='save']:not(.disabled)").size() > 0;
        return changeValue;
    },

    /**
     * Load all models which are included to current page
     *
     * @param callback {Function}
     *
     */
    loadModels: function(fromListener) {
        var deferred = new $.Deferred(),
            toDo = [],
            modelsToLoad = !_.isUndefined(this.models) ? _.values(this.models) : [];

        if (this.hasTabs) {
            modelsToLoad = _.union(modelsToLoad, !_.isUndefined(this.tabView.models) ? _.values(this.tabView.models) : []);
        }

        if (_.isEmpty(modelsToLoad)) {
            return deferred.resolve();
        } else {
            _.each(modelsToLoad, function(model) {
                if (!swc.models[model]) {
                    swc.models[model] = new swc.constructors[model]();
                }
                //reset the state of autosync on pagerender for models on first load
                
                if( fromListener === false && swc.models[model].autoSync===false){
                    swc.models[model].autoSync=true;
                }
                if (swc.models[model].isNewArchitecture) {
                    toDo.push(
                        swc.models[model].sync('read', { isListener: fromListener === true ? true : false })
                    );
                } else {
                    toDo.push(
                        swc.models[model].sync(fromListener === true ? true : false)
                    );
                }
            });

            $.when.apply(this, toDo)
                .done(function() {
                    deferred.resolve();
                })
                .fail(function() {
                    // TODO :: navigate user to coresponding sticky page
                    deferred.resolve();
                });
        }

        return deferred.promise();
    },

    /**
     * To be overriden if necessary.
     * this method is called after the models are synced
     * @returns a promise object.
     * If the promise is resolved then the render method continues executing.
     * If the promise is rejected then the render method stops executing.
     * Useful when preconditions may require redirecting to another page.
     */
    preRender: function () {
        // default behavior is - to render on
        return (new $.Deferred()).resolve();
    },

    disableEventHandlersModels: function() {
        if(!_.isUndefined(swc.models.Telephony)) {
            swc.models.Telephony.off('overview');
            swc.models.Telephony.off('settings');
        }
    },

    /**
     * Render Selected Page
     */
    render: function(options) {
        var self = this,
            promise;

        var oldFragment = Backbone.history.fragment;

        self.disableEventHandlersModels();

        // Check if render was called from child view:
        if (self.parentView) {
            self.parentView.render();
            return;
        }

        //check if the view has an event manager attached
        if(!_.isEmpty(swc.views.currentView) && !_.isEmpty(swc.views.currentView.eventDispatcher)){
            swc.views.currentView.eventDispatcher.stopObserv();
        }

        //check if the parent view has an event manager attached - if we are in a tab view
        if(!_.isEmpty(swc.views.currentView) && !_.isEmpty(swc.views.currentView.parentView) && !_.isEmpty(swc.views.currentView.parentView.eventDispatcher)){
            swc.views.currentView.parentView.eventDispatcher.stopObserv();
        }
        // Check if current application mode allows user to visit current page
        self.checkPermissions();
        // Show loading window:
        self.showPageLoading('Loading page data..');

        // Check if current page has tab and init it:
        if (self.hasTabs) {
            self.initTabView();
        }

        // Reset values to its defaults
        this.isPageEnabled = true;
        this.isTabsEnabled = true;

        // Load page models:
        $.when(self.loadModels(false))
            .done(function() {

                if(oldFragment !== Backbone.history.fragment) {
                    return;
                }
                // Check for preconditions (if any)
                // (actually, it should be called in initialize method, but in our case we have
                // models loading in render!!! method, so we have to make a way...)
                // If there are tabs then we have to call tabView method instead:
                if (self.hasTabs) {
                    promise = self.tabView.preRender();
                } else {
                    promise = self.preRender();
                }

                $.when(promise)
                    .done(function() {

                        if(oldFragment !== Backbone.history.fragment) {
                            return;
                        }

                        // Set template data:
                        self.setTemplateData();

                        // Check if page has tabs:
                        if (self.hasTabs) {
                            // Set template data to tab view:
                            self.tabView.setTemplateData();

                            // Get parent templates content:
                            self.getTemplateContent();

                            // Get child template content:
                            self.tabView.getTemplateContent();

                            // Render parent template
                            self.templateContent.find('.tabs-content').html(self.tabView.templateContent);

                            // Display page basing on content:
                            self.displayPage();

                            // Render complete method trigger:
                            self.renderComplete();
                            self.tabView.renderComplete();
                            self.tabView.startListener();
                            self.tabView.trigger('render:finished');
                        } else {
                            self.getTemplateContent();
                            self.displayPage();
                            self.renderComplete();
                        }

                        if(!_.isUndefined(options) && options !== null && options.informWhenRendered === true) {
                            self.trigger('render:finished:complete');
                        }

                        self.trigger('render:finished');

                        self.startListener();
                    });
            });

        return this;
    },

    /**
     * This method will be overriden in each view. In this method can be set <templateData> variable
     */
    setTemplateData: function() {},

    /**
     * Get page template content:
     * @returns {*}
     */
    getTemplateContent: function() {
        var self = this;

        this.templateContent = this.$el.html($.tmpl(self.template, {
            data: self.templateData,
            localeStrings: swc.models.Locale.getLocaleStrings(),
            localeString: getTranslationStringsjQuery,
            staticPagesLinks: swc.models.Locale.getStaticPagesLinks(),
            formatDate: swc.models.Locale.formatDate
        }));
    },

    /**
     * Insert ready template to application content:
     */
    displayPage: function() {
        var self = this,
            area = $('#current-page');

        // Check if application is already rendered:
        if (!area.size()) {
            swc.views.Application.renderApplicationArea();
        }

        // Render template content to application area:
        swc.views.Application.contentArea.html(
            self.templateContent
        );

        // Set menu link state:
        swc.views.Application.setMenuActiveLink();

        // Delegate events:
        this.delegateEvents();

        // Delegate events on tab view:
        if (this.hasTabs) {
            this.tabView.delegateEvents();
        }

        // Hide loading window dialog:
        this.stopPageLoading();
    },

    /**
     * Method which will be called when main part of a page will be
     * rendered and all necessary data will be loaded
     *
     * @description Here you can place any observers on existing elements, fill in drop downs, add devices etc.
     */
    renderComplete: function() {},

    /**
     * Render Page Selected Tab:
     *
     * @description Tab constructor id is building in following way:
     *
     * (currentPageName.capitalise() + currentSubPageName.capitalise() + currentTabName.capitalise()).replace(/-/g,'') + 'View'
     *
     * For example for storage/settings/cloud-backup it will be "StorageSettingsCloudbackupView"
     *
     */
    initTabView: function() {
        var pagesArray = Backbone.history.fragment.split("/"),
            TabConstructorName = _.map(pagesArray, function(n) {
                return n.capitalize();
            }).concat("View").join("").replace(/-/g,''),
            TabViewName = TabConstructorName.deCapitalize();

        if (!swc.views[TabViewName]) {
            swc.views[TabViewName] = new swc.constructors[TabConstructorName]();
            swc.views[TabViewName].parentView = this;
        }

        this.tabView = swc.views[TabViewName];
        // Check if current application mode allows user to visit current page
        this.tabView.checkPermissions();

        if($.isFunction(this.tabView.postInitialize)) {
            this.tabView.postInitialize();
        }
    },

    /**
     * Show page Saving / Loading dialog
     *
     * @description: when each view method render() will be called - the loading dialog will appear
     *               this method is extended by each view in application, so it can be called from any
     *               place of the application by invoking this.showPageLoading(argumet : string);
     *
     * @param action {String}
     */
    showPageLoading: function(message, timeout) {
        var self = this,
            template = $.template('loading', swc.Templates.get('application:loading-window').get('content')),
            dialog = $('.loading-window'),
            id = Math.random();

        // Close all popover
        SWCElements.popovers.closeAll(true);
        // Close dropdowns
        SWCElements.dropDown.closeAll();
        // Close modal windows
        SWCElements.modalWindow.hide();

        // Do nothing if loading window exists
        if (dialog.size()) {
            return;
        }

        // Append loading window to body:
        $('#components').append(
            $.tmpl(template, {
                id: id,
                message: getTranslationStrings(message, true),
                localeStrings: swc.models.Locale.getLocaleStrings('application'),
                localeString: getTranslationStringsjQuery,
                formatDate: swc.models.Locale.formatDate
            })
        );

        setTimeout(function() {
            var loadingWindow = $('.loading-window[data-id="' + id + '"]');

            if (loadingWindow.size()) {
                self.showPageLoadingFail();
            }
        }, timeout || 30000);
    },

    /**
     * IF Loading of page data failed - show user a modal window:
     */
    showPageLoadingFail: function() {
        this.stopPageLoading();

        SWCElements.modalWindow.show({
            templateID: 'application:loading-window-fail',
            templateData: {},
            className: 'loading-window-fail',

            onApply: function() {
                window.location.reload();
            }
        });
    },

    /**
     * Removes Loading / Saving dialog
     */
    stopPageLoading: function() {
        if(!_.isUndefined(swc.router)) {
            swc.router.isLoadingModule = false;
        }

        var dialog = $('#components .loading-window');

        if (dialog.size()) {
            dialog.remove();
        }
    },

    /**
     * Disable / Enable tabs on current page
     *
     * @param isEnabled {Boolean}
     * @param options {Object} -> { className: <string>, isTabOverlay: <boolean>, ... }
     *
     * @return void
     */
    setTabsState: function(isEnabled, options) {
        var self = this,
            pageTabs = this.$('li.tab');

        if (!_.isEmpty(pageTabs)) {
            if ((this.isTabsEnabled === true && isEnabled === false) || (this.isTabsEnabled === false && isEnabled === true)) {
                _.each(pageTabs, function(tabElement) {
                    var $tab = $(tabElement),
                        $tabLink = $tab.find('a');

                    if (isEnabled === false) {
                        self.createDisabledOverlay($tabLink, _.extend({
                            className: $tab.hasClass('active') ? '' : 'transparent',
                            isTabOverlay: true
                        }, options));
                    } else {
                        self.removeDisabledOverlay(_.extend({
                            removeTabsOverlay: true
                        }, options));
                    }

                    $tab.toggleClass("disabled", isEnabled === false);
                });
            }

            this.isTabsEnabled = isEnabled;
        }
    },

    /**
     * Covers current page's content with an semi-transparent overlay element.
     * Thus Disables/Enables the page.
     *
     * @param isEnabled {Boolean} Defines either page should be enabled or disabled
     * @param options {Object} Possible options:
     *                         - isPageOverlay {boolean}:     Whether or not hide page under semi-transparent overlay
     *                         - disabledBlockClass {String}: Name of CSS class with used to mark a block which will be
     *                                                        covered with overlay, instead of covering the whole page.
     *
     * @retun void
     */
    setPageState: function(isEnabled, options) {
        var self = this,
            $blockToDisable = $('.tabs-content').size() ? $('.tabs-content') : $('.base-content'),
            $disabledOverlay = $('#current-page').find('.showDisabledBackDrop.page-overlay');

        // Sometimes we should not add overlay to the whole page, but rather to some region on the page
        // thus we can mark such region with a special css class name passed in 'disabledBlockClass' option
        if (options && !_.isUndefined(options['disabledBlockClass'])) {
            $blockToDisable = $('#current-page').find("." + options['disabledBlockClass']);
        }

        if (isEnabled === false) {
            if (this.isPageEnabled || !$disabledOverlay.size()) {
                self.createDisabledOverlay($blockToDisable, _.extend({
                    isPageOverlay: true
                }, options));
            }
        } else {
            self.removeDisabledOverlay(_.extend({
                removePageOverlay: true
            }, options));
        }

        this.isPageEnabled = isEnabled;
    },

    /**
     * Creates an overlay element with size based on size of element to be faded with the overlay.
     *
     * @param options {Object} Possible values:
     *                         - className {String} Name of additional css class to be added to the overlay element's.
     *                                              Could be useful if one need to cusomize the presentation of overlay.
     *                         - isTabOverlay {boolean}  Whether overlay should be placed over tab.
     *                                                   Special 'tab-overlay' css class will be added if True.
     *                         - isPageOverlay {boolean} Whether overlay should should be placed over tab.
     *                                                   Special 'page-overlay' css class will be added if True.
     *
     * @protected Only for internal use!
     *
     * @return void
     */
    createDisabledOverlay: function($element, options) {
        var overlay = $('<div class="showDisabledBackDrop no-highlighting"></div>');

        // Set position styles
        overlay.css({
            'top': $element.offset().top + 'px',
            'left': $element.offset().left + 'px',
            'width': $element.innerWidth(),
            'height': $element.innerHeight(),
            'display': 'block'
        });

        // Set custom properties:
        if (!_.isEmpty(options)) {
            if (!_.isEmpty(options.className)) {
                overlay.addClass(options.className);
            }

            if (options.isTabOverlay) {
                overlay.addClass("tab-overlay");
            }

            if (options.isPageOverlay) {
                overlay.addClass("page-overlay");
            }
        }

        overlay.appendTo($('#current-page'));
    },

    /**
     * Remove all disabled overlays from the page (based on arguments)
     * @param options
     */
    removeDisabledOverlay: function(options) {
        var overlays = $('#current-page').find('.showDisabledBackDrop');

        _.each(overlays, function(overlay) {
            var $overlay = $(overlay);

            if (!_.isUndefined(options)) {
                if (options.removeTabsOverlay === true && $overlay.hasClass("tab-overlay")) {
                    $overlay.remove();
                }

                if (options.removePageOverlay === true) {
                    if (!_.isUndefined(options['disabledBlockClass']) &&
                        $overlay.hasClass(options['disabledBlockClass'])) {
                        $overlay.remove();
                    } else if ($overlay.hasClass("page-overlay")) {
                        $overlay.remove();
                    }
                }
            } else {
                $overlay.remove();
            }
        });
    },

    /**
     * Display corresponding message, when the page is disabled
     * @param options {Object} -> { className: <string>, ... }
     */
    showDisabledMessage: function(options) {
        var element,
            $disabledMessage = $('<div class="showDisabledBackDropMessage no-highlighting"></div>'),
            $disabledMessageContainer = $('.tabs-content').size() ? $('.tabs-content') : $('.base-content');

        // Check if options container is passed:
        if (!_.isUndefined(options) && !_.isUndefined(options.container)) {
            element = this.$(options.container);
        }

        // Check if element exists on the content container:
        if (_.isUndefined(element) || !element.size()) {
            return;
        }

        // Hide previosly shown message:
        this.hideDisabledMessage(options);

        // Copy html from message in container to disabled message:
        $disabledMessage.html(element.html());

        // Append element to message container:
        $disabledMessage.appendTo($('#current-page'));

        // Set correct styles to the disabled message:
        $disabledMessage.css({
            top: $disabledMessageContainer.offset().top + ($disabledMessageContainer.outerHeight() / 2),
            left: $disabledMessageContainer.offset().left + ($disabledMessageContainer.outerWidth() / 2),
            marginTop: -($disabledMessage.outerHeight() / 2 + 50) + 'px',
            marginLeft: -($disabledMessage.outerWidth() / 2) + 'px'
        });

        // Check if additional options passed:
        if (!_.isUndefined(options.className)) {
            $disabledMessage.addClass(options.className);
        }

        // Display message after everything is set:
        $disabledMessage.show();
    },

    /**
     * Hide corresponding message, when the page is disabled
     */
    hideDisabledMessage: function() {
        $('#current-page').find('.showDisabledBackDropMessage').remove();
    },

    /**
     * Save changes button handler:
     */
    saveChanges: function() {
        var self = this,
            validation = this.pageValidation(null, true);

        // Check if page validation errors exists on the page:
        $.when(validation)
            .fail(function () {
                // validation is not passed - do nothing
            })
            .done(function () {
                // Check if necessary methods existing:
                if ($.isFunction(self.save)) {
                    // Show page loading status:
                    self.showPageLoading("Saving page data..");

                    // Wait till page saving is completed
                    $.when(self.save())
                        .done(function(message) {
                            self.setRenderFinishedHook("success", message);
                        })
                        .fail(function(message) {
                            self.setRenderFinishedHook("error", message);
                        })
                        .always(function () {
                            if(swc.models.Login.checkIfLoggedIn()) {
                                // Define what view has to be re-rendered:
                                if (self.parentView) {
                                    self.parentView.render();
                                } else {
                                    self.render();
                                }
                            }
                        });
                }
            });
    },

    setRenderFinishedHook: function (type, message) {
        var self = this;

        this.on('render:finished', function() {
            if (self.tabView) {
                self.tabView.showSaveSuccess(type, message);
            } else {
                self.showSaveSuccess(type, message);
            }
            self.off('render:finished');
        });
    },

    /**
     * Cancel changes button handler:
     */
    cancelChanges: function(e) {
        this.$('.validation-message').hide();
        this.$('.save-validation-errors').hide();
        this.$('.validation-error').removeClass('validation-error');

        if (_.isFunction(this.onCancel)) {
            this.onCancel.apply(this, arguments);
        }
        if (this.parentView) {
            if (_.isFunction(this.parentView.onCancel)) {
                this.parentView.onCancel.apply(this, arguments);
            }
            this.parentView.render();
        } else {
            this.render();
        }
        // This prevents passing Event if "Cancel" pressed in Child (TabView).
        // Otherwise, if "onCancel" defined in Parent View, it will be called twice
        if (!_.isUndefined(e)) {
            e.stopPropagation();
        }
    },

    /**
     * Show successfull page save result:
     */
    showSaveSuccess: function(type, message) {
        var container;

        container = this.$('.buttons-container-message .save-' + (type || 'success'));
        container.show();

        if (!_.isUndefined(message)) {
            container.find('.error-message').hide();
            container.find('.error-message.' + message + '-message').show();
        }
    },

    /**
     * Set buttons state on the page:
     * @param e {Object}
     * @param toDisable {Boolean}
     */
    setButtonsState: function(e, toDisable) {
        var container = this.$('.buttons-container-message'),
            buttonSave = container.find('.button.save-changes'),
            buttonCancel = container.find('.button.cancel-changes'),
            allValuesDefault = this.pageCheckDefaultValues();

        // Prevent method from the double call. TabView has the same method and some times it make collisions
        if (this.hasTabs) {
            return;
        }

        if (container.size()) {
            if (toDisable || allValuesDefault) {
                buttonSave.addClass('disabled');
                buttonCancel.addClass('disabled');
            } else {
                buttonSave.removeClass('disabled');
                buttonCancel.removeClass('disabled');
            }
        }
    },

    /**
     * Get all elements on the page, which can be changed by user:
     *
     * @return Array
     */
    getElements: function() {
        var possibleElements = [
                '.swc-input', '.swc-checkbox', '.swc-extended', '.swc-radio-buttons', '.swc-dropdown'
            ];

        return this.$(possibleElements.join(':not(.skip-validation),') + ':not(.skip-validation)');
    },

    /**
     * Check if after changes on the page all values are set as they were
     * before the page has loaded
     *
     * @returns {boolean}
     */
    pageCheckDefaultValues: function() {
        var isDefault = true;

        $.each(this.getElements(), function(key, element) {
            var dataParameters = getParameter($(element)),
                dataDefaultValue = $(element).data('default-value');

            if (_.isBoolean(dataDefaultValue)) {
                dataDefaultValue = dataDefaultValue.toString();
            }

            if (!_.isUndefined(dataDefaultValue)) {
                if (!_.isUndefined(dataParameters.parameterValue) && dataParameters.parameterValue.toString() !== dataDefaultValue.toString()) {
                    isDefault = false;
                }
            } else {
                if (!_.isUndefined(dataParameters.parameterValue)) {
                    isDefault = false;
                }
            }
        });

        return isDefault;
    },

    /**
     * Check if current page can be viewed in selected mode
     */
    checkPermissions: function(view) {
        var currentMode = swc.settings.application.get('expertMode') ? 'expert' : 'standard',
            deviceType = swc.Utils.DeviceType,
            fixedRoute,
            tmpView;

        if (localStorage.userMode) {
            currentMode = localStorage.userMode;
        }

        if (_.isUndefined(view)) {
            swc.views.currentView = this;
            tmpView = swc.views.currentView;
        } else {
            tmpView = view;
        }

        if ($.inArray(currentMode, tmpView.allowedMods) === -1 || $.inArray(deviceType, tmpView.disallowedDevices) !== -1) {
            if(window.location.href.toString().indexOf('applications/') !== -1) {
                fixedRoute = 'applications/overview';
                swc.views.currentView = new swc.constructors.ApplicationsDyndnsView();
            }
            else if (!$('ul.page-tabs').size()) {
                fixedRoute = 'overview';
            } else {
                fixedRoute = ($(swc.views.currentView.el).closest('ul.page-tabs')
                    .find('li:first a').attr('href').replace('#',''));
            }

            swc.router.navigate(fixedRoute, { trigger: false, skipUnsavedChanges: true });

            return false;
        }

        return true;
    },

    /**
     * Page validation called when Apply button pressed, or editable field left focus
     * Implements FIFO buffer for validation requests that they may start and finish
     * in chronological order.
     * Normall call: stacks the parameters in buffer and then starts the processing
     * (if it is not started yet) of the first item from buffer.
     * Recursive call: processing next item from buffer. Is called each time when
     * a validation process is finished and the buffer is not empty.
     * @params e,validateAll - the parameters for validation call.
     * @param processNext usually undefined. Is set to true in recursive call only.
     * @return Deferred object
     */
    pageValidation: function(e, validateAll, processNext) {
        var self = this,
            deferred = new $.Deferred(),
            current;

        if (this.hasTabs) {
            return deferred.resolve();
        }

        if (_.isUndefined(swc.validation)) {
            swc.validation = {};
        }

        if(!_.isUndefined(this.validationCustom) && $.isFunction(this.validationCustom)) {
            if(this.validationCustom() === false) {
                deferred.reject('incoming lines');
                return deferred.promise();
            }
        }

        if (_.isUndefined(swc.validation.buffer)) {
            swc.validation.buffer = [];
        }

        if (_.isUndefined(swc.validation.isInProgress)) {
            swc.validation.isInProgress = false;
        }

        if (_.isUndefined(processNext)) {
            swc.validation.buffer.push({e: e, validateAll: validateAll, deferred: deferred});
        }

        if (!swc.validation.isInProgress && !_.isEmpty(swc.validation.buffer)) {
            swc.validation.isInProgress = true;
            current = swc.validation.buffer.shift();
            $.when(self.pageValidationCore(current.e, current.validateAll))
                .done(function (result) {
                    current.deferred.resolve(result);
                })
                .fail(function (result) {
                    current.deferred.reject(result);
                })
                .always(function () {
                    swc.validation.isInProgress = false;
                    if (!_.isEmpty(swc.validation.buffer)) {
                        self.pageValidation(null, null, true);
                    }
                });
        }

        return deferred.promise();
    },

    pageValidationCore: function(e, validateAll) {
        var self = this,
            deferred = new $.Deferred(),
            promises = [],
            elementsValues = [],
            validationArray = this.tabView ? this.tabView.validation : this.validation,
            elementsToValidate = this.$('.validatable:not(.skip-validation)'),
            messageValidation = this.$('.buttons-container-message .save-validation-errors'),
            messageSuccess = this.$('.buttons-container-message .save-success'),
            messageError = this.$('.buttons-container-message .save-error'),
            allValuesDefault = this.pageCheckDefaultValues();

        // Get elements name => value map
        $.each(this.getElements(), function(key, element) {
            elementsValues.push(getParameter($(element)));
        });

        // Set buttons state to disabled if all values are default
        this.setButtonsState(null, !!allValuesDefault);

        // If single element validation happens
        if (e) {
            var validatableElement = $(e).hasClass('validatable') ? $(e) : $(e.target);
            elementsToValidate = validatableElement.is('.validatable:not(.skip-validation)') ? [validatableElement] : [];
        }

        // Validate all elements from array and show errors:
        $.each(elementsToValidate, function(key, element) {
            var validationElement = $(element),
                promise,
                parameters = getParameter(validationElement),
                validationElements = $('.validatable[name="' + parameters.parameterName + '"], .validatable[data-name="' + parameters.parameterName + '"]'),
                validationMessage = self.$('.validation-message[data-parameter-name="' + parameters.parameterName + '"]'),
                validationToDo,
                validationStatus;

            // Call single validation method:
            if (validationArray[parameters.parameterName]) {
                validationToDo = validationArray[parameters.parameterName].split(':');

                var aModel = swc.models[validationToDo[0]];
                // It could happen that model is not initiated yet, try find object in swc.constructors next
                if (_.isUndefined(aModel)) {
                    aModel = new swc.constructors[validationToDo[0]]();
                    if (_.isUndefined(aModel)) {
                        throw "Called validation from undefined Model - " + validationToDo[0];
                    }
                }
                validationStatus = aModel.validation[validationToDo[1]](elementsValues);

                // Check if validation is failed or success:
                // (validator can return true, false or Deferred object)
                if (_.isFunction(validationStatus.then)) { // probably a promise
                    promise = validationStatus;
                } else if (validationStatus.status === true) {
                    promise = (new $.Deferred()).resolve(validationStatus);
                } else {
                    promise = (new $.Deferred()).reject(validationStatus);
                }
            } else {
                promise = (new $.Deferred()).resolve();
            }

            promises.push(promise);

            $.when(promise)
                .done(function () {
                    // Go through all validatable group
                    $.each(validationElements, function(key, element) {
                        var currentElement = $(element);
                        self.changeValidationMessageState(currentElement, false);
                    });

                    // Display message
                    if (validationMessage.size()) {
                        validationMessage.find('.error-message').hide();
                        validationMessage.hide();
                    }
                })
                .fail(function (validationStatus) {
                    var wasShown;
                    // Go through all validateable group
                    $.each(validationElements, function(key, element) {
                        var currentElement = $(element);
                        if (currentElement.data('validation-was-shown')) {
                            wasShown = true;
                        } else {
                            currentElement.data('validation-was-shown', true);
                        }

                        self.changeValidationMessageState(currentElement, true);
                    });

                    // Display message
                    if (validationMessage.size()) {
                        if(validationStatus.messages[0] !== undefined) {
                            var globalMessageContainer = validationMessage.find('.error-message[data-error="global"]');
                            validationMessage.show();
                            validationMessage.find('.error-message').hide();
    
                            if ((wasShown || self.showGlobalError === false) || !globalMessageContainer.size()) {
                                validationMessage
                                    .find('.error-message[data-error="' + validationStatus.messages[0] + '"]').show();
                            } else {
                                globalMessageContainer.show();
                            }
                        }
                    }
                });
        });

        // Hide messages about successfull and error saves
        messageSuccess.hide();
        messageError.hide();

        // Hide "Fix errors on the page" message
        $.when.apply(null, promises)
            .done(function () {
                messageValidation.hide();
                deferred.resolve();
            })
            .fail(function () {
                if (validateAll) {
                    messageValidation.show();
                } else {
                    messageValidation.hide();
                }
                deferred.reject();
            });

        return deferred.promise();
    },

    changeValidationMessageState: function (element, on) {
        if (on) {
            element.addClass('validation-error');
            element.data('validation-error', true);
            element.trigger('validation-fail');
        } else {
            element.removeClass('validation-error');
            element.data('validation-error', false);
            element.trigger('validation-success');
        }
    },

    /**
     * Remove all existing validation messages on the page:
     */
    clearValidationMessages: function(input){
        var inputName,
            validationMessages;

        // If an input is passes then we have to clear
        // the validation messages for the input only:
        if (input) {
            inputName = $(input).data('name');
            validationMessages = $('.validation-message[data-parameter-name="' + inputName + '"]');
            validationMessages.hide();
            validationMessages.find('.error-message').hide();
            $(input).filter('.validation-error').removeClass('validation-error');
            return;
        }

        $('.validation-message').hide();
        $('.save-validation-errors').hide();
        $('.validation-message .error-message').hide();
        $('.validation-error').removeClass('validation-error');
    },

    /**
     * Init listener for current view:
     */
    startListener: function() {
        var pagesMatch = false,
            pagesRoutes = swc.settings.application.get('navigation'),
            self = this,
            page = Backbone.history.fragment;

        // Check if listener available on current page
        if (!this.listenerPages.length) {
            pagesMatch = true;
        } else {
            $.each(this.listenerPages, function(key, value) {
                if (pagesRoutes[value] === page) {
                    pagesMatch = true;
                }
            });
        }

        // Check if everything is correct:
        if (pagesMatch && this.listenerEnabled) {
            if (!this.listenerWorking) {

                // Set flag to listener to be in process:
                this.listenerWorking = true;

                this.listenerIntervalMethod = setInterval(function() {
                    var pagesMatch = false,
                        pagesRoutes = swc.settings.application.get('navigation'),
                        page = Backbone.history.fragment;

                    // Check if listener available on current page
                    if (!self.listenerPages.length) {
                        pagesMatch = true;
                    } else {
                        $.each(self.listenerPages, function(key, value) {
                            if (pagesRoutes[value] === page) {
                                pagesMatch = true;
                            }
                        });
                    }

                    // Check if no restrictions
                    if (pagesMatch) {
                        $.when(self.loadModels(true)).done(function() {
                            if (_.isFunction(self.onListenerComplete)) {
                                self.onListenerComplete();
                            }
                        });
                    } else {
                        self.stopListener();
                    }
                }, self.listenerInterval * 1000);
            }
        } else {
            this.stopListener();
        }
    },

    /**
     * Stop current view listener working:
     */
    stopListener: function() {
        // Set listening flag to false:
        this.listenerWorking = false;

        // Remove current interval variable:
        clearInterval(this.listenerIntervalMethod);
    },

    customizeDevice: function(options) {
        var pages,
            devicesNames = swc.models.Locale.getLocaleStrings('overview/modal-windows/customize-device'),
            pageActive = 1,
            pageItems = 6, // Number of devices on one row
            // the list of supported devices which has device's type as a key
            allDeviceTypes = swc.settings.application.get('supported' + options.type.capitalize() + 'Devices'),
            // the array of device's types which can be associated with device only automatically
            nonCustomizableDevices = ['unrecognized', 'multisensor', 'switch'],
            supportedDeviceTypes = [],
            sahDeviceTypes;

        if (options.type !== 'dect' && options.device.type !== 'switch'){
            // Check if this is unsupported device and overwrite current device's type with default value
            if (!allDeviceTypes[options.device.type]) {
                options.device.type = allDeviceTypes['unrecognized'].deviceTypeDefault;
            }

            // Pass translation for each device
            $.each(allDeviceTypes, function(supportedKey, supportedDevice) {
                var deviceText = devicesNames[supportedDevice.deviceTypeLocalized];

                // Set device type to be localised
                if (!_.isUndefined(deviceText) && !_.isEmpty(deviceText)) {
                    supportedDevice.deviceTypeText = deviceText;
                } else {
                    supportedDevice.deviceTypeText = supportedDevice.deviceTypeLocalized;
                }

                if ($.inArray(supportedKey, nonCustomizableDevices) === -1) {
                    supportedDeviceTypes[supportedKey] = supportedDevice;
                }
            });

            // In order to implement simple pagination, let's pass additional array consisting of keys of supported devices.
            // SAH returns some device type as several words separated with space
            sahDeviceTypes = _.keys(supportedDeviceTypes);

            pages = Math.ceil(getObjectLength(sahDeviceTypes) / pageItems);
        }

        /**
         * Validates device name, also triggers validation failed handlers,
         * like show error message
         *
         * NOTE: "During the HPQC review meeting Simon Maurer approved to "allow basically everything" here"
         *
         * @param modal {PopoverWindow} Instance of current modal popover window
         * @param name {String} Name of device to be validated
         *
         * @return {boolean} true if name is valid
         */
        var validateDeviceName = function (modal, name, type) {

            var validationMessage = modal.find('.validation-message'),
                validationError = false,
                regex = (type === 'dect' ? /^.{1,32}$/ : /^([A-Za-z]([A-Za-z0-9]|[A-Za-z0-9-]+[A-Za-z0-9])?)$/);


            // allowed basically anything, from 1 to 32 characters length
            if(name.length > 32) {
                validationError = true;
            } else if (!regex.test(name)) {
                validationError = true;
            }

            if (validationError) {
                validationMessage.show();
                validationMessage.find('.error-message[data-error="global"]').show();
            } else {
                validationMessage.hide();
                validationMessage.find('.error-message[data-error="global"]').hide();
            }

            modal.find('input[name="device-name"]').toggleClass('validation-error', validationError);

            return !validationError;
        };

        SWCElements.modalWindow.show({
            templateID: options.template || 'overview:modal-windows:customize-device',
            templateData: {
                device: options.device,
                pages: pages,
                pagesArray: _.range(pages),
                pageItems: pageItems,
                pageActive: pageActive,
                supported: supportedDeviceTypes,
                sahDeviceTypes: sahDeviceTypes
            },
            className: 'customize-device',

            onShow: function() {
                var modal = $('.modalWindow'),
                    rows = modal.find('.devices-list-scroll'),
                    devices = modal.find('.device'),
                    switchPage = function(page) {
                        var pages = modal.find('.switch-page');

                        // Set active class to current page:
                        pages.removeClass('active');
                        modal.find('[data-page="' + page + '"]').addClass('active');

                        // Set active class to current row:
                        rows.removeClass('active');
                        modal.find('[data-page="' + page + '"]').addClass('active');
                    };

                // Display necessary row:
                rows.removeClass('active');
                modal.find('[data-page="' + pageActive + '"]').addClass('active');

                // Handle click on devices:
                modal.on('click', '.device', function() {
                    var hasChanges = false,
                        element = $('input[name="device-name"]'),
                        newType = $(this).data('type'),
                        newName = modal.find('input[name="device-name"]').val();

                    devices.removeClass('selected');
                    $(this).addClass('selected');

                    if (newType !== element.data('type') || newName !== element.data('name')) {
                        hasChanges = true;
                    }

                    modal.find('.button.apply-changes').toggleClass('disabled', !hasChanges);
                });

                modal.on('click', '.navigation.left:not(.disabled)', function() {
                    var currentPageElement = modal.find('.page.active'),
                        currentPageNumber = currentPageElement.data('page') || 1,
                        nextPageNumber = currentPageNumber - 1,
                        nextPageElement = modal.find('.page[data-page="' + nextPageNumber + '"]');

                    if (nextPageElement.size()) {
                        switchPage(nextPageNumber);
                    } else {
                        switchPage(currentPageNumber);
                    }
                });

                modal.on('click', '.navigation.right:not(.disabled)', function() {
                    var currentPageElement = modal.find('.page.active'),
                        currentPageNumber = currentPageElement.data('page'),
                        nextPageNumber = currentPageNumber +  1,
                        nextPageElement = modal.find('.page[data-page="' + nextPageNumber + '"]');

                    if (nextPageElement.size()) {
                        switchPage(nextPageNumber);
                    } else {
                        switchPage(currentPageNumber);
                    }
                });

                modal.on('click', '.switch-page', function(e) {
                    var pageElement = $(e.target).closest('.switch-page'),
                        pageNumber = pageElement.data('page');

                    switchPage(pageNumber);
                });

                modal.on('keyup', 'input[name="device-name"]', function(e) {
                    var hasChanges = false,
                        element = $(e.target),
                        newType = modal.find('.device').filter('.selected').data('type'),
                        newName = modal.find('input[name="device-name"]').val();

                    if (newType !== element.data('type') || newName !== element.data('name')) {
                        hasChanges = true;
                    }

                    modal.find('.button.apply-changes').toggleClass('disabled', !hasChanges);
                });

                modal.on('change', 'input[name="device-name"]', function() {
                    var deviceName = $.trim($(this).val());
                    validateDeviceName(modal, deviceName, options.type);
                });
            },

            onCancel: function() {
                if (options.onCancel && $.isFunction(options.onCancel)) {
                    options.onCancel();
                }
            },

            onApply: function() {
                var modal = $('.modalWindow'),
                    $input = modal.find('input[name="device-name"]'),
                    deviceType = modal.find('.device').filter('.selected').data('type'),
                    deviceName = $.trim($input.val()),
                    deviceMac = $input.data('mac');

                if (options.onApply && $.isFunction(options.onApply) && validateDeviceName(modal, deviceName, options.type)) {
                    if (options.type==='dect') {
                        options.onApply({
                            line: $input.data('line'),
                            name: deviceName
                        });
                    } else {
                        options.onApply({
                            deviceMac: deviceMac,
                            deviceType: deviceType,
                            deviceName: deviceName
                        });
                    }

                    SWCElements.modalWindow.hide();
                }
            }
        });
    }
});
;swc.base.listView = Backbone.View.extend({
    // model: colection

    itemView: '',

    initialize: function (options) {
        var self = this;
        this.options = options;
        Backbone.View.prototype.initialize.call(this, options);
        this.itemView = options.itemView;
        this.model.on('change', function () {
            self.render();
        });
    },

    renderComplete: function () {
        // to be overriden
        if (_.isFunction(this.options.renderComplete)) {
            return this.options.renderComplete.apply(this, arguments);
        }
    },

    preRender: function () {
        if (_.isFunction(this.options.preRender)) {
            return this.options.preRender.apply(this, arguments);
        }
        return (new $.Deferred()).resolve();
    },

    render: function (){
        var self = this,
            promise;

        if (self.hasTabs) {
            promise = self.tabView.preRender();
        } else {
            promise = self.preRender();
        }

        $.when(promise)
            .done(function() {
                // render each collection item:
                self.$el.empty();

                _.each(self.model.models, function (model) {
                    var view = new swc.constructors[self.itemView]({model: model});
                    self.$el.append(view.render().el);
                });

                self.renderComplete();
            });

        return this;
    }
});
;swc.constructors.SchedulerLiner = swc.base.PageView.extend({
    className: 'ranges-block',

    events: {
        'mousedown .diap_container':'new_diapazon',
        'mousedown .left_part': 'modify_start',
        'mousedown .right_part': 'modify_start',
        'mousedown .half': 'modify_start',
        'mousemove': 'modify',
        'mouseleave': 'modify_stop',
        'mouseup': 'modify_stop',
        'touchstart': 'mobilePreventScroll',
        'touchstart .mobile-block': 'mobileNewDiap',
        'touchmove .mobile-block': 'mobileModify',
        'touchleave .mobile-block': 'mobileModifyStop',
        'touchend .mobile-block': 'mobileModifyStop',
        'touchcancel .mobile-block': 'mobileModifyStop',
        'mouseover .has-tooltip': 'showTooltip',
        'mouseover .diap_container': 'showAddTooltip',
        'mouseleave .has-tooltip': 'hideTooltip',
        'click .do-delete': 'deleteDiapazon',
        'tap .do-delete': 'deleteDiapazon'
    },
    
    minAddSlotWidth: 36,
    now: null,
    prevent_creating: function(e){
        e.stopPropagation();
    },

    mobilePreventScroll: function(e){
        e.preventDefault();
    },

    mobileNewDiap: function(e){
        e.pageX = e.originalEvent.pageX;
        $(e.target).hide();
        var targetElement = document.elementFromPoint(e.originalEvent.targetTouches[0].clientX, e.originalEvent.targetTouches[0].clientY);
        $(e.target).show();
        if($(targetElement).hasClass('diap_container')){
            e.target = targetElement;
            this.new_diapazon(e);
        } else if($(targetElement).hasClass('left_part') || $(targetElement).hasClass('right_part')){
            e.target = targetElement;
            this.modify_start(e);
        }
    },

    mobileModify: function(e){
        e.pageX = e.originalEvent.pageX;
        this.modify(e);
    },

    mobileModifyStop: function(e){
        this.modify_stop(e);
    },
    
    deleteDiapazon: function(e) {
        var element = $(e.target);

        if (!this.isDisabled) {
            
            e.stopPropagation();
            e.preventDefault();

            var currentDay = 'monday';
            _.each(element.attr('class').split(' '), function(key){
                if(key.indexOf('day') > -1){
                    currentDay = key;
                }
            });
            
            this.currentDiapazon = this.scheduler.get('pixelSchedule')[currentDay];
            this.currentDiapazon.length = 0;
            
            swc.constructors.dispatcher.trigger('scheduler:change');
            this.options.model.trigger('change:pixelSchedule', this.options.model);
            this.render();
        }
    },

    /**
     * creates new range
     * @param e
     */
    new_diapazon: function(e){
        var self = this, target,
            element = $(e.target);

        if (!this.isDisabled && !element.closest('.diapazon')[0]) {
            var schedulerIndex = $('.schedulers').index(element.closest('.schedulers')),
                linerIndex = element.closest('.schedulers').find('.liner').index(element.closest('.liner'));

            e.stopPropagation();
            e.preventDefault();

            if(typeof e.offsetX === "undefined") {
                var targetOffset = element.offset();
                e.offsetX = e.pageX - targetOffset.left;
            }

            this.modifyProcess = true;
            this.markForDelete = false;

            var startCoord = this.stepWidth*(Math.floor(e.offsetX/this.stepWidth));

            if (e.offsetX>=this.scaleWidth-this.stepWidth) {
                startCoord = this.scaleWidth-this.stepWidth;
            }

            var endCoord = startCoord + this.stepWidth;
            var conflictsDiapazon = false;

            var currentDay = 'monday';
            _.each(element.closest('.liner').attr('class').split(' '), function(key){
                if(key.indexOf('day') > -1){
                    currentDay = key;
                }
            });
            this.currentDiapazon = this.scheduler.get('pixelSchedule')[currentDay];

            _.each(this.currentDiapazon, function(diapazon){
                if(startCoord === diapazon.end || (startCoord >= diapazon.begin-self.stepWidth && startCoord <= diapazon.begin)){
                    conflictsDiapazon = true;
                }
            });

            if(!conflictsDiapazon){

                this.currentDiapazon.push({
                    begin: startCoord,
                    end: endCoord
                });
                swc.constructors.dispatcher.trigger('scheduler:change');
                this.options.model.trigger('change:pixelSchedule', this.options.model);
                this.render();

                $('.schedulers').eq(schedulerIndex).find('.liner').eq(linerIndex).find('.diapazon').each(function(index, el){
                    if($(el).css('left') === startCoord+'px'){
                        target = $(el).find('.half')[0];
                    }
                });

                if(target){
                    self.modify_start({target: target, preventDefault: e.preventDefault, stopPropagation: e.stopPropagation});
                }
            } else {
                this.modifyProcess = false;
            }
        }
    },

    /**
     * Starts the modify of some range - calls when mousedown on left or right part of range
     * @param e
     */
    modify_start: function(e){
        var self = this;
        
        $(this.$el).css({"cursor":"ew-resize"});
        
        e.preventDefault();
        e.stopPropagation();

        if(!this.isDisabled){
            this.modifyProcess = true;
            this.mouseStart = e.target.offsetLeft + e.target.parentNode.offsetLeft;

            var element = $(e.target);

            // info for modified element searching - needed for popover
            this.elementInfo = {};
            this.elementInfo.operatedLineIndex = $('.schedulers .liner').index(element.closest('.liner'));

            var currentDay = 'monday';
            _.each($(e.target).closest('.liner').attr('class').split(' '), function(key){
                if(key.indexOf('day') > -1){
                    currentDay = key;
                }
            });
            this.currentDiapazon = this.scheduler.get('pixelSchedule')[currentDay];

            this.operatedDiapazon = {};
            $.each(this.currentDiapazon, function(index, diapazon){
                if(diapazon.begin <= self.mouseStart && diapazon.end + self.stepWidth > self.mouseStart){
                    self.operatedDiapazon = diapazon;
                    self.currentDiapazon.splice(index, 1);
                    self.currentDiapazon.push(self.operatedDiapazon);
                    return false;
                }
            });
            var maxRightAlpha = this.scaleWidth;
            var maxLeftAlpha = this.scaleWidth;
            this.nearestDiapazonStart = 0;
            this.nearestDiapazonFinish = 0;

            $.each(this.currentDiapazon, function (index, diapazon) {
                if (diapazon.begin !== self.operatedDiapazon.begin) {

                    if((diapazon.begin > self.operatedDiapazon.end) &&
                        ((diapazon.begin - self.operatedDiapazon.end) < maxRightAlpha)){
                        maxRightAlpha = (diapazon.begin - self.operatedDiapazon.end)-self.stepWidth;
                    }

                    if((diapazon.end < self.operatedDiapazon.begin) &&
                        ((self.operatedDiapazon.begin - diapazon.end) < maxLeftAlpha)){
                        maxLeftAlpha = (self.operatedDiapazon.begin - diapazon.end)-self.stepWidth;
                    }
                }
            });

            if(maxRightAlpha >= this.scaleWidth){
                maxRightAlpha = this.scaleWidth - this.operatedDiapazon.end;
            }
            if(maxLeftAlpha >= this.scaleWidth){
                maxLeftAlpha = this.operatedDiapazon.begin;
            }

            this.nearestDiapazonStart = this.operatedDiapazon.end + maxRightAlpha;
            this.nearestDiapazonFinish = this.operatedDiapazon.begin - maxLeftAlpha;

            $('body').trigger('popover:close');

            if(element.hasClass('left_part')){
                this.partModified = 'left';
            } else if(element.hasClass('right_part')) {
                this.partModified = 'right';
            } else {
                this.partModified = 'both';
            }

            if(element.hasClass('left_part') || element.hasClass('right_part')){
                element.trigger('popover:toggle');
            }

            this.allowModify = true;
        }
    },

    /**
     * Proceed with modify - calls on mousemove with mousedown
     * @param e
     */
    modify: function(e){
        e.preventDefault();
        e.stopPropagation();

        if(this.modifyProcess && this.allowModify && !this.isDisabled){
            var self = this, element;
            this.allowModify = false;

            setTimeout(function(){
                self.allowModify = true;
            }, 20);

            var currentCoord = e.pageX - $(this.el).find('.diap_container').eq(0).offset().left;
            var coordsAlpha = this.stepWidth * (Math.round((currentCoord - this.mouseStart) / this.stepWidth));
            this.maxWidth = this.stepWidth * (Math.round($(this.el).find('.diap_container').eq(0).width() / this.stepWidth));

            if(this.partModified === 'right') {
                coordsAlpha -= this.stepWidth;
            }

            if(coordsAlpha!==0){
                var diapazonBackup = _.clone(this.operatedDiapazon);
                this.currentDiapazon.pop();

                if(this.partModified === 'right'){
                    this.operatedDiapazon.end += coordsAlpha;
                } else if(this.partModified === 'left') {
                    this.operatedDiapazon.begin += coordsAlpha;
                } else {
                    if(coordsAlpha > 0){
                        this.partModified = 'right';
                        this.operatedDiapazon.end += this.stepWidth;
                    } else {
                        this.partModified = 'left';
                        this.operatedDiapazon.begin -= this.stepWidth;
                    }
                }

                var tmpNearestEnd = 0;
                var tmpNearestBegin = this.maxWidth;
                var tmpNearestDistance = -1;

                $.each(this.currentDiapazon, function(index, diapazon){
                    var tmpDistance = diapazonBackup.end - diapazon.end;
                    if(tmpDistance > 0 && (tmpDistance < tmpNearestDistance || tmpNearestDistance === -1)){
                        tmpNearestDistance = tmpDistance;
                        tmpNearestEnd = diapazon.end;
                    }
                });

                tmpNearestDistance = -1;

                $.each(this.currentDiapazon, function(index, diapazon){
                    var tmpDistance = diapazon.begin - diapazonBackup.begin;
                    if(tmpDistance > 0 && (tmpDistance < tmpNearestDistance || tmpNearestDistance === -1)){
                        tmpNearestDistance = tmpDistance;
                        tmpNearestBegin = diapazon.begin;
                    }
                });

                this.tmpNearestEnd = tmpNearestEnd;
                this.tmpNearestBegin = tmpNearestBegin;

                if(this.operatedDiapazon.end < this.operatedDiapazon.begin + this.stepWidth){
                    if(this.partModified === 'right'){
                        this.mouseStart = diapazonBackup.end;
                    } else {
                        this.mouseStart = diapazonBackup.begin;
                    }
                    this.currentDiapazon.push(diapazonBackup);
                    this.markForDelete = true;
                    if(this.partModified === 'right'){
                        this.operatedDiapazon.end = this.operatedDiapazon.begin + this.stepWidth;
                    } else {
                        this.operatedDiapazon.begin = this.operatedDiapazon.end - this.stepWidth;
                    }

                } else if(this.operatedDiapazon.begin < tmpNearestEnd){
                    this.operatedDiapazon.begin = tmpNearestEnd;
                    this.currentDiapazon.push(this.operatedDiapazon);
                    localStorage.setItem('startedMerging', 'true');
                } else if(this.operatedDiapazon.end > tmpNearestBegin){
                    this.operatedDiapazon.end = tmpNearestBegin;
                    this.currentDiapazon.push(this.operatedDiapazon);
                    localStorage.setItem('startedMerging', 'true');
                } else {
                    this.mouseStart += coordsAlpha;
                    this.currentDiapazon.push(this.operatedDiapazon);
                    this.markForDelete = false;

                    this.quickRender();

                    /**
                     * Search for modified element
                     */
                    $('.schedulers .liner').eq(this.elementInfo.operatedLineIndex).find('.diapazon').each(function(index, el){
                        if($(el).css('left') === self.operatedDiapazon.begin+'px'){
                            element = $(el).find('.'+self.partModified+'_part');
                        }
                    });

                    if((this.operatedDiapazon.end - this.operatedDiapazon.begin) > 9){
                        element.trigger('popover:toggle');
                    }
                }
            }
        }
    },

    /**
     * Stops the modifications and triggers 'change' event on model
     * calls when mouseup or mouseleave the view container
     * @param e
     */
    modify_stop: function(){
        var self = this;

        localStorage.setItem('startedMerging', 'false');

        if(_.isUndefined(self.tmpNearestEnd) === false && this.operatedDiapazon.begin === self.tmpNearestEnd && this.operatedDiapazon.begin !== 0){
            var lastBeginLeft = null;
            $.each(this.currentDiapazon, function(index, diapazon){
                if(diapazon.end === self.tmpNearestEnd){
                    self.currentDiapazon.splice(index, 1);
                    lastBeginLeft = diapazon.begin;
                    return false;
                }
            });

            this.operatedDiapazon.begin = lastBeginLeft;
        }
        if(_.isUndefined(self.tmpNearestBegin) === false && this.operatedDiapazon.end === self.tmpNearestBegin && this.operatedDiapazon.end !== this.maxWidth){
            var lastBeginRight = null;
            $.each(this.currentDiapazon, function(index, diapazon){
                if(diapazon.begin === self.tmpNearestBegin){
                    self.currentDiapazon.splice(index, 1);
                    lastBeginRight = diapazon.end;
                    return false;
                }
            });

            this.operatedDiapazon.end = lastBeginRight;
        }
        $('body').trigger('popover:close');
        $(this.$el).css('cursor',"inherit");
        if(this.modifyProcess){
            this.modifyProcess = false;
            if(this.markForDelete){
                this.currentDiapazon.pop();
            }
            swc.constructors.dispatcher.trigger('scheduler:change');
            this.options.model.trigger('change:pixelSchedule', this.options.model);
            this.render();
            //reset the cache value of now Date, used in quick render to optimize performance.
            this.now = null;
        }
    },
    
    showTooltip: function(e) {
        e.preventDefault();
        e.stopPropagation();

        if(!this.isDisabled && !this.modifyProcess){
            var element = $(e.currentTarget);
            if(!element.hasClass('selected')) {
                // for current time - update data
                if(element.hasClass('time-current-parent') || element.hasClass('time-parent')) {
                    var now = swc.Utils.getCurrentDate();
                    element.data('popover-template-data', { currentTime: moment(now).format('HH:mm') });
                }
                element.trigger('popover:toggle');
            }
        }
    },
    
    sortByDiapazon: function(a, b){
        var aValue = a.begin;
        var bValue = b.begin;
        return ((aValue < bValue) ? -1 : ((aValue > bValue) ? 1 : 0));
    },
    
    showAddTooltip: function(e) {
        e.preventDefault();
        e.stopPropagation();

        if(!this.isDisabled && !this.modifyProcess){
            var element = $(e.currentTarget);
            if(!element.hasClass('selected')) {
                var currentDay = 'monday';
                _.each($(e.target).closest('.liner').attr('class').split(' '), function(key){
                    if(key.indexOf('day') > -1){
                        currentDay = key;
                    }
                });
                
                var currentDiapazon = this.scheduler.get('pixelSchedule')[currentDay];
                
                // sort before finding
                currentDiapazon.sort(this.sortByDiapazon);
                
                // find next diapazon
                var currentCoord = e.pageX - $(this.el).find('.diap_container').eq(0).offset().left,
                    i = 0,
                    min = 0,
                    max = this.scaleWidth,
                    length = currentDiapazon.length;

                for(i = 0; i < length; i++) {
                    var current = currentDiapazon[i],
                        begin = current.begin,
                        end = current.end;

                    // simple case
                    if(currentCoord < begin) {
                        max = begin;
                        break;
                    } else if(currentCoord > end) {
                        min = end;
                        if(i + 1 < length) {
                            // then we need to get values from next if exists
                            current = currentDiapazon[i + 1];
                            begin = current.begin;
                            if(currentCoord < begin) {
                                max = begin;
                                break;
                            } else {
                                min = current.end;
                            }
                        } else {
                            // max is already end of range
                            break;
                        }
                    }
                    
                    i++;
                }
                                
                var delta = (min + ((max - min) / 2));
                // show only if we have 2h slot
                if((max - min) >= this.minAddSlotWidth) {
                    element.data('popover-custom-position', { x: delta });
                    element.trigger('popover:toggle');
                }
            }
        }
    },
    
    hideTooltip: function(e) {
        e.preventDefault();
        e.stopPropagation();

        if(!this.isDisabled && !this.modifyProcess){
            var element = $(e.target);
            element.trigger('popover:close');
        }
    },

    initialize: function(){
        /**
         * when true, scheduler is grey and could not be modified
         * @type {*|Boolean}
         */
        this.isDisabled = this.options.isDisabled || false;
        /**
         * width of scheduler line - usually is 432
         * @type {number}
         */
        this.scaleWidth = this.options.scaleWidth || 432;
        /**
         * width of one part on liner, usually is 432/48 = 9, 48 - number of 30-minutes pieces in one day
         * @type {number}
         */
        this.stepWidth = this.scaleWidth/48;
        /**
         * object with ranges
         * @type {*}
         */
        this.scheduler = this.options.model;
        /**
         * What will be scheduled?
         * @type: string
         */
        this.schedulerType = this.options.schedulerType;

        /**
         *  block for mobile manipulations
         */
        if(detectMobileBrowser()){
            var mobileBlock = $('<div/>', {'class': 'mobile-block'}).css({'width':'100%', 'height':'100%'});
            this.$el.append(mobileBlock);
        }

        this.render();
    },
    quickRender: function(){
        var me = this,
            element = me.$el,
            now=null;

        //check if we have to make a request to getTime
        if(me.now === null){
            now = swc.Utils.getCurrentDate();
            me.now = now;
        }
        else {
            now=me.now;
        }
        
        var currentTimePos = this.calculateCurrentTimePos(now),
            currentDay = swc.mixins.Scheduler.getCurrentDay(now);
        
        var template = $.tmpl(swc.Templates.get('core:scheduler:table').get('content'),{
            'isDisabled': this.isDisabled,
            'stepWidth': this.stepWidth,
            'scaleWidth' : this.scaleWidth,
            'schedulers' : this.scheduler.get('pixelSchedule'),
            'type': this.schedulerType,
            'localeStrings': swc.models.Locale.getLocaleStrings('core'),
            'localeString': getTranslationStringsjQuery,
            formatDate: swc.models.Locale.formatDate,
            'currentTimePos': currentTimePos,
            'currentTimePosOverflow':currentTimePos+12,
            'currentTimePosOverflowHeight':10,
            'currentDay': currentDay,
            'currentTime': moment(now).format('HH:mm')
        })[0];

        element.find('.' + $(template).attr('class')).remove();
        element.append(template);
        return this;
    },
    render: function(){
        var me = this,
            element = me.$el,
            now = swc.Utils.getCurrentDate(),
            currentTimePos = this.calculateCurrentTimePos(now),
            currentDay = swc.mixins.Scheduler.getCurrentDay(now);

        var template = $.tmpl(swc.Templates.get('core:scheduler:table').get('content'),{
            'isDisabled': this.isDisabled,
            'stepWidth': this.stepWidth,
            'scaleWidth' : this.scaleWidth,
            'schedulers' : this.scheduler.get('pixelSchedule'),
            'type': this.schedulerType,
            'localeStrings': swc.models.Locale.getLocaleStrings('core'),
            'localeString': getTranslationStringsjQuery,
            formatDate: swc.models.Locale.formatDate,
            'currentTimePos': currentTimePos,
            'currentTimePosOverflow':currentTimePos+12,
            'currentTimePosOverflowHeight':10,
            'currentDay': currentDay,
            'currentTime': moment(now).format('HH:mm')
        })[0];

        element.find('.' + $(template).attr('class')).remove();
        element.append(template);

        if(localStorage.getItem('startedMerging') === 'true') {
            $.each(_.keys(me.scheduler.get('pixelSchedule')), function(index, day){
                me.currentDiapazon = me.scheduler.get('pixelSchedule')[day];
                me.currentDiapazon.sort(me.sortByDiapazon);
                $.each(me.currentDiapazon, function(index, diapazon){
                    if(index < me.currentDiapazon.length-1 && diapazon.end === me.currentDiapazon[index+1].begin){
                        me.currentDiapazon[index+1].begin = diapazon.begin;
                        me.currentDiapazon.splice(index, 1);
                        return false;
                    }
                });

                swc.constructors.dispatcher.trigger('scheduler:change');
                me.options.model.trigger('change:pixelSchedule', me.options.model);

                localStorage.setItem('startedMerging', 'false');
                me.render();
            });
        }
        return this;
    },
    
    calculateCurrentTimePos: function(now) {
        var minutes = (Math.round(now.getMinutes() / 10) * 10), // round to 10
            hour = (now.getHours() + (minutes / 60.0)),
            result = (((hour * 433) / 24.0) - 14); // 24 hours = 433px, width 4px, padding 10px

        return result;
    }
});
;swc.base.SpeedcheckProtoView = {

    className: 'speedcheck',

    events: {
        'click .start-stop-button .button': 'startStopTest'
    },
    
    models: [ 'apServiceState', 'apServiceLoadingState', 'NetworkDevices', 'Network', 'InternetBackupStick' ],

    startButton: 'Start Speed-Check',
    stopButton: 'Stop Speed-Check',
    
    requestNextQuery: false,
    isRunning: false,
    localTest: true,
    
    type: 'get',
    url: 'http://internetbox-nas.home:57337/test/',
    timeout: 30000,
    dataType: 'jsonp',
    flashUrl: 'internetbox-nas.home:7000',
    
    totalProgress: 2 * 100, // 2 phases by 100%
    currentProgress: 0,
    currentDot: -1,
    dotAnimation: null,
    isFlash: false,
    dotAnimationUp: false,
    animationPart: 5000 / 11,// 5s / 10
    warningMessage: null,
    
    isWireless: false,
    deviceDownSpeed: 0,
    internetDownSpeed: 0,
    deviceUpSpeed: 0,
    internetUpSpeed: 0,
    
    flashTimeout: 500,
    flashCounter: 0,
    flashCounterMax: 4,
    flashTimer: null,
    
    // Major version of Flash required
    requiredMajorVersion: 11,
    // Minor version of Flash required
    requiredMinorVersion: 1,
    // Minor version of Flash required
    requiredRevision: 0,
    
    listenerInterval: 10,
    listenerPages: [ 'speed-check' ],
    
    onListenerComplete: function() {
        this.stopPageLoading();
        this.updatePageUI();
    },

    updatePageUI: function() {
        var pageState = true,
            apState = swc.models.apServiceState.get('status') || null,
            apServiceLoadingState = swc.models.apServiceLoadingState.get('isLoading') || false;

        // Check if AP is loading or OFF now, and disable tabs and page content
        if ((apState !== true || apServiceLoadingState === true) && !this.outsidePanel) {
            pageState = false;
        }

        // If AP has started -> fully reload page
        if (pageState === true) {
            this.setPageState(pageState);
            this.hideDisabledMessage();
            this.stopListener();
            this.renderComplete();
        } else {
            // Disable / Enable page and tabs based on page status:
            this.setPageState(pageState);

            // Check if AP is OFF now and show disabled message:
            if (apState === false) {
                this.showDisabledMessage({
                    container: '.apStateOffMessage',
                    className: 'above speed-check'
                });
            }

            // Check if AP is loading now and show loading message:
            if (apServiceLoadingState === true && apState === true) {
                this.showDisabledMessage({
                    container: '.apStateLoadingMessage',
                    className: 'above'
                });
            }

            // Start listener if page is disabled or loading:
            this.listenerEnabled = true;
            this.startListener();
        }
    },
    
    startStopTest: function() {
        var me = this;
        if(!swc.models.Login.checkIfLoggedIn() && !this.outsidePanel) {
            swc.router.navigatePage('');
        } else if(me.isButtonEnabled()) {
            if(me.isRunning) {
                me.stopTest();
            } else {
                // check if ap is on
                $.when(me.isApOn()).done(function() {
                    me.setButtonEnabled(false);
                    // check if we have internet connection
                    $.when(me.isConnected()).done(function() {
                        // check stargate nas address
                        $.when(me.getIP(me.updateDeviceType, me)).done(function() {
                            me.startTest();
                        }).fail(function() {
                            me.setButtonEnabled(true);
                            me.showConnectionErrorDialog();
                        });
                    }).fail(function() {
                        me.setButtonEnabled(true);
                        me.showNoConnectionDialog();
                    });
                }).fail(function() {
                    me.setButtonEnabled(true);
                    me.showApOffDialog();
                });
            }
        }
    },
    
    isButtonEnabled: function() {
        return (!this.$('.start-stop-button .button').hasClass('disabled'));
    },
    
    setButtonEnabled: function(enabled) {
        var button = this.$('.start-stop-button .button');
        if(enabled) {
            button.removeClass('disabled');
        } else {
            button.addClass('disabled');
        }
    },
    
    setButtonTitle: function(title) {
        var button = this.$('.start-stop-button .button .translation-string');
        button.html(getTranslationStrings(title));
    },
    
    executeQuery: function(url, callback, scope) {
        var me = this;

        $.ajax({
            type: me.type,
            url: me.url + url,
            timeout: 2000,
            cache: false,
            dataType: me.dataType,
            success: function(response) {
                if(callback !== null) {
                    callback.call(scope || this, response);
                }
            },
            error: function() {
                me.handleError();
            }
        });
    },
    
    getIP: function(callback, scope) {
        var me = this,
            deferred = new $.Deferred();

        $.ajax({
            type: 'GET',
            url: me.url + 'getip',
            timeout: 3000, // 1s is not enough during testing via node.js server
            cache: false,
            dataType: me.dataType
        }).done(function(response) {
            if(callback !== null) {
                callback.call(scope || this, response);
            }
            deferred.resolve();
        }).fail(function() {
            deferred.reject();
        });
        
        return deferred.promise();
    },
    
    startTest: function() {
        var me = this;
        
        me.resetTest();
        me.resetValues();
        me.executeQuery('start?origin=webui', me.handleStartResponse, me);
    },
    
    queryStatus: function(scope) {
        var me = (scope || this);
        
        $.ajax({
            type: me.type,
            url: me.url + 'status',
            timeout: me.timeout,
            cache: false,
            dataType: me.dataType,
            success: function(response) {
                if(response.origin === 'webui') {
                    me.handleStatusResponse(response);
                }
                if(me.requestNextQuery) {
                    me.queryStatus(me);
                }
            },
            error: function() {
                me.handleError();
            }
        });
    },
    
    stopTest: function() {
        var me = this;
        
        if(me.isFlash) {
            me.stopFlashTest();
        } else {
            me.executeQuery('stop', me.handleStopResponse, me);
        }
        
        me.resetTest();
        me.resetValues();
    },
    
    handleStartResponse: function(response) {
        var me = this;

        switch(response.status) {
            case 'SUCCESS':
                me.downloadPart = response.downloadDuration ? (response.downloadDuration / 11) : me.animationPart;
                me.uploadPart = response.uploadDuration ? (response.uploadDuration / 11) : me.animationPart;
                me.isRunning = true;
                $('.progress').css('visibility', 'visible');
                $('.progress-label').html(getTranslationStrings('Ping test is running'));
                this.touchLabel($('.progress-label'));
                me.requestNextQuery = true;
                me.queryStatus(me);
                break;
            case 'ERROR':
                me.handleError(response);
                break;
        }

        me.resetValues();
        me.setButtonTitle(me.stopButton);
        me.setButtonEnabled(true);
    },
    
    handleStopResponse: function() {
        var me = this;
        
        me.resetTest();
        me.resetValues();
    },
    
    resetTest: function() {
        var me = this;

        me.isRunning = false;
        me.requestNextQuery = false;
        me.currentProgress = 0;
        me.setProgressPos(0);
        $('.internet-dots .' + me.currentDot).removeClass('active');
        $('.device-dots .' + me.currentDot).removeClass('active');
        me.currentDot = -1;
        me.dotAnimationUp = false;
        me.lastEvent = null;
        me.showInternetProgress(false);
        me.showDeviceProgress(false);
        me.setButtonTitle(me.startButton);
        me.setButtonEnabled(true);
        me.isFlash = false;
    },
    
    resetValues: function() {
        var odometers = $('.odometer'),
            ping = $('.ping-value');
        
        odometers.removeClass('active');
        odometers.html(0);
        ping.removeClass('active');
        ping.html(0);
        $('.slow-device-connection').hide();
        $('body').trigger('popover:close');
    },
    
    handleFlashStatusResponse: function(response) {
        var json = JSON.parse(response);
        
        this.handleStatusResponse(json);
    },
    
    handleStatusResponse: function(response) {
        var me = this;

        switch(response.event) {
            case 'PROGRESS_PING':
                me.setActive(response);
                me.setProgressPos(response.progress);
                me.showInternetProgress(true);
                break;
            case 'PROGRESS_DOWNLOAD':
            case 'PROGRESS_UPLOAD':
                me.handleProgress(response);
                break;
            case 'PRETEST_DONE':
                me.setActive(response);
                break;
            case 'DOWNLOAD_DONE':
                me.setActive(response);
                me.dotAnimationUp = true;
                if(!me.isFlash) {
                    me.showInternetProgress(false);
                    me.showInternetProgress(true);
                }
                me.currentDot = 10;
                //me.clearDots();
                break;
            case 'UPLOAD_DONE':
                me.setActive(response);
                me.currentDot = -1;
                if(me.isFlash || !me.localTest) {
                    // end for UPLOAD_DONE
                    me.handleDone();
                } else {
                    me.handleHalfDone();
                }
                break;
            case 'TEST_CANCELED':
            case 'IDLE':
                // test is defnitely done
                me.handleDone();
                break;
            case 'ERROR':
                me.handleError(response);
                break;
        }
    },
    
    handleProgress: function(response) {
        var me = this;
        
        if(me.lastEvent !== response.event) {
            me.lastEvent = response.event;
        } else {
            me.setProgressPos(response.progress);
            me.updateEvent(response.event, response.current_value);
        }
    },
    
    setActive: function(response) {
        var me = this,
            view = null,
            value = -1,
            isFlash = this.isFlash;
        
        switch(response.event) {
            case 'PROGRESS_PING':
                view = $('#ping');
                value = response.current_value;
                break;
            case 'DOWNLOAD_DONE':
                if(isFlash) {
                    view = $('#device-download');
                    me.deviceDownSpeed = response.max;
                } else {
                    view = $('#internet-download');
                    me.internetDownSpeed = response.max;
                }
                
                value = response.max;
                break;
            case 'UPLOAD_DONE':
                if(isFlash) {
                    view = $('#device-upload');
                    me.deviceUpSpeed = response.max;
                } else {
                    view = $('#internet-upload');
                    me.internetUpSpeed = response.max;
                }

                value = response.max;
                break;
        }
        
        if(view) {
            view.addClass('active');
            view.html(value.toFixed(2));
        }
    },
    
    updateEvent: function(event, value) {
        var view = null,
            isFlash = this.isFlash;
        
        switch(event) {
            case 'PROGRESS_PING':
                view = $('#ping');
                break;
            case 'PROGRESS_DOWNLOAD':
                view = $(isFlash ? '#device-download' : '#internet-download');
                break;
            case 'PROGRESS_UPLOAD':
                view = $(isFlash ? '#device-upload' : '#internet-upload');
                break;
        }
        
        if(view) {
            view.html(value.toFixed(2));
        }
    },
    
    handleDone: function() {
        var me = this;

        me.resetTest();
        me.clearDots();
        
        if(me.localTest) {
            me.speedSummary();
        }
    },
    
    speedSummary: function() {
        var me = this,
            deviceDownSpeed = me.deviceDownSpeed,
            deltaDown = ((deviceDownSpeed * 1.1) - me.internetDownSpeed),
            deviceUpSpeed = me.deviceUpSpeed,
            deltaUp = ((deviceUpSpeed * 1.1) - me.internetUpSpeed),
            delta = Math.min(deltaDown, deltaUp),
            wanSpeed = 0,
            warningMessage = null;

        // we have better speed out then in
        if(delta < 0) {

            if(deltaDown < deltaUp) {
                wanSpeed = me.internetDownSpeed;
            } else {
                wanSpeed = me.internetUpSpeed;
            }
            // for wlan
            if(me.isWireless) {
                if(wanSpeed < 100.0) {
                    warningMessage = 'WAN less 100';
                } else if(wanSpeed < 300.0) {
                    warningMessage = 'WAN less 300 greater 100';
                } else {
                    warningMessage = 'WAN greater 300';
                }
            } else {
                if(wanSpeed < 100.0) {
                    warningMessage = 'LAN less 100';
                } else {
                    warningMessage = 'LAN greater 100';
                }
            }
            
            var info = $('.slow-device-connection');
            info.show();
            info.data('popover-template-data', { warningMessage: warningMessage });
            setTimeout(function() {
                info.trigger('popover:toggle');
            }, 250);
        }

        return warningMessage;
    },
    
    handleHalfDone: function() {
        var me = this;
        
        me.isFlash = true;
        me.currentProgress += 100;
        me.dotAnimationUp = false;
        me.showInternetProgress(false);
        me.showDeviceProgress(true);
        me.requestNextQuery = false;
        me.startFlashTest();
    },
    
    handleError: function(response) {
        var me = this,
            errorStr = response ? response.error_string : '',
            errorInfo = me.getErrorInfo(errorStr);
            
        SWCElements.modalWindow.show({
            templateID: 'system:diagnostics:speedcheck:error',
            templateData: {
                localeStrings: swc.models.Locale.getLocaleStrings(me.pageTemplateID),
                localeString: getTranslationStringsjQuery,
                title: errorInfo.title,
                message: errorInfo.message
            },
            className: 'speedcheck-error',
            onApply: function() {
                SWCElements.modalWindow.hide();

                me.resetTest();
            }
        });
    },
    
    getErrorInfo: function(errorStr) {
        var result = { title: getTranslationStrings('Error while speed testing.'), message: getTranslationStrings('Please try again.') };
        
        switch(errorStr) {
            case 'SERVER_OVERLOADED':
                result.title = getTranslationStrings('The Speed-Check Server is curently not available.');
                result.message = getTranslationStrings('Please try later again.');
                break;
            case 'ANOTHER_TEST_IN_PROGRESS':
                result.title = getTranslationStrings('Another test is in progress.');
                result.message = getTranslationStrings('Please try again after test ends.');
                break;
            case 'MANAGEMENT_SERVER_ERROR':
                result.title = getTranslationStrings('Speed test server error.');
                result.message = getTranslationStrings('Speedtest could not to be started because the speed server is momentarily unavailable. Please try again later.');
                break;
        }
        
        return result;
    },
    
    setProgressPos: function(percent) {
        var me = this,
            progress = $('.progress .ruler .fill'),
            px = null;
            
        px = this.calculateProgress(me.currentProgress + percent);
        progress.css('width', px);
    },
    
    calculateProgress: function(percent) {
        var px = ((this.maxProgress * percent) / this.totalProgress);
        return px;
    },
    
    showInternetProgress: function(show) {
        var me = this,
            progressBlock = this.$('.progress');
        
        if(show) {
            var animationPart = me.animationPart;
            if(me.dotAnimationUp) {
                animationPart = me.uploadPart;
            } else {
                animationPart = me.downloadPart;
            }
            
            // turn on animation
            me.dotAnimation = setInterval(function() {
                me.animateDot('.internet-dots');
            }, animationPart);
            progressBlock.css('visibility', 'visible');
			$('.progress-label').html(getTranslationStrings('Internet-Speed check running'));
            this.touchLabel($('.progress-label'));
		} else {
            clearInterval(me.dotAnimation);
            progressBlock.css('visibility', 'hidden');
        }
    },
    
    showDeviceProgress: function(show) {
        var me = this,
            progressBlock = this.$('.progress'),
            progressLabel = this.$('.progress-label');
        
        if(show) {
            // turn on animation
            me.dotAnimation = setInterval(function() {
                me.animateDot('.device-dots');
            }, me.animationPart);
            progressBlock.css('visibility', 'visible');
            
            if(me.isWireless) {
                progressLabel.html(getTranslationStrings('WLAN Speedcheck running'));
            } else {
                progressLabel.html(getTranslationStrings('Homenetwork Speed-Check running'));
            }

            this.touchLabel(progressLabel);
        } else {
            clearInterval(me.dotAnimation);
            progressBlock.css('visibility', 'hidden');
        }
    },
    
    animateDot: function(dotClass) {
        var me = this,
            currentDot = me.currentDot,
            clear = true;
        
        if(me.dotAnimationUp) {
            if(currentDot > 0) {
                currentDot--;
            } else {
                clear = false;
            }
        } else {
            if(currentDot < 9) {
                currentDot++;
            } else {
                clear = false;
            }
        }
        if(clear) {
            me.clearDots();
        }
        $(dotClass + ' .' + currentDot).addClass('active');
        
        me.currentDot = currentDot;
    },
    
    clearDots: function() {
        $('.dot').removeClass('active');
    },
    
    showNoConnectionInfo: function() {
        var me = this;
        
        me.stopPageLoading();
        me.setPageState(false);
        me.showDisabledMessage({
            container: '.wanOffMessage',
            className: 'above speed-check'
        });
        $(".start-stop-button a").addClass("disabled");
    },

    showConnectionDNSErrorInfo: function() {
        var me = this;
        
        me.stopPageLoading();
        me.setPageState(false);
        me.showDisabledMessage({
            container: '.connectionDNSErrorMessage',
            className: 'above speed-check'
        });
        $(".start-stop-button a").addClass("disabled");
    },
    
    showConnectionErrorInfo: function() {
        var me = this;
        
        me.stopPageLoading();
        me.setPageState(false);
        me.showDisabledMessage({
            container: '.connectionErrorMessage',
            className: 'above speed-check'
        });
        $(".start-stop-button a").addClass("disabled");
    },
    
    showApOffDialog: function() {
        this.showDialog('To start sharing your data, please switch the Central Storage on');
    },
    
    showNoConnectionDialog: function() {
        this.showDialog('There is no internet connecion.');
    },
    
    showConnectionErrorDialog: function() {
        this.showDialog('The Speedtest could not be started.');
    },
    
    showDialog: function(message) {
        var me = this;
        
        SWCElements.modalWindow.show({
            templateID: 'system:diagnostics:speedcheck:error',
            templateData: {
                localeStrings: swc.models.Locale.getLocaleStrings(me.pageTemplateID),
                localeString: getTranslationStringsjQuery,
                title: getTranslationStrings('Speedtest error'),
                message: message
            },
            className: 'speedcheck-error',
            onApply: function() {
                SWCElements.modalWindow.hide();
            }
        });
    },
    
    isConnected: function() {
        var deferred = $.Deferred();

        if(this.outsidePanel) {
            deferred.resolve();
        } else {
            var toDo = [swc.models.Network.fetch(), swc.models.InternetBackupStick.fetch()];

            $.when.apply(this, toDo).done(function() {
                var fibreState = swc.models.Network.getParameter('ConnectionStatus', 'status'),
                modemState = swc.models.InternetBackupStick.get('isConnected'),
                internetState = ((fibreState !== false) || (modemState !== false));

                if(internetState) {
                 deferred.resolve();
                } else {
                 deferred.reject();
                }
            }).fail(function() {
            deferred.reject();
            });
        }

        return deferred.promise();
    },
    
    isApOn: function() {
        var deferred = $.Deferred();
        var resolve = function() { deferred.resolve() };
        if(!this.outsidePanel) {

            var toDo = [swc.models.apServiceState.fetch(), swc.models.apServiceLoadingState.fetch()];
        
            $.when.apply(this, toDo).done(function() {
                if(swc.models.apServiceState.get('status') && !swc.models.apServiceLoadingState.get('isLoading')) {
                    deferred.resolve();
                } else {
                    deferred.reject();
                }
            }).fail(function() {
                deferred.reject();
            });
        } else {

            $.ajax({
                url: 'http://internetbox-nas.home:57337/test/getip?callback=resolve',
                type: 'GET',
                dataType: 'jsonp',
                async: true,
                crossDomain: true,
                jsonp: true,
                jsonpCallback: "resolve"
            })
            .done(function() {
                resolve();
            })
            .fail(function() {
                deferred.reject();
            });
             
        }
        return deferred.promise();
        
    },

    renderComplete: function() {
        var me = this,
            userIsSuperAdmin = swc.models.Login.checkUserSuperAdmin(),
            imageLoaded = true;

        me.showPageLoading('Loading page data..');

        $('<img src="'+ 'http://internetbox.home/static/images/swisscom-logo.png?id=' + Math.random().toString(36).substring(7) +'">').load(function() {
            imageLoaded = true;
        }).error(function(){
            imageLoaded = false;
        });

        // check if ap is on
        // if(this.outsidePanel || (swc.models.apServiceState.get('status') && !swc.models.apServiceLoadingState.get('isLoading'))) {
            // check if we have internet connection
            $.when(me.isConnected()).done(function() {
                // reset values
                me.setDefaults();
                me.resetTest();
                me.resetValues();
                
                me.maxProgress = 385;
                
                // check stargate nas address
                $.when(me.getIP(me.updateDeviceType, me)).done(function() {

                    me.stopPageLoading();
                    
                    if(window.location.href.indexOf('#speedtest') === -1 && userIsSuperAdmin) {
                        me.stopPageLoading();
                        $('.local-test').hide();
                        me.localTest = false;
                        me.totalProgress = 100;
                    } else {
                        $.when(me.checkFlashVersion()).done(function() {
                            me.appendFlashComponent();
            
                            me.totalProgress = 2 * 100;
                            me.localTest = true;
            
                            // check if we have loaded plugin
                            function checkFlash() {
                                me.stopPageLoading();
                                if((typeof me.getFlashTest() === 'undefined') || (typeof me.getFlashTest().startTest !== 'function')) {
                                    if(me.flashCounter >= me.flashCounterMax) {
                                        me.showErrorMessage('Invalid flash version');
                                    } else {
                                        me.showPageLoading('Loading page data..');
                                        setTimeout(function() {
                                           checkFlash();
                                        }, me.flashTimeout);
                                        me.flashCounter++;
                                    }
                                } else {
                                    me.flashCounter = me.flashCounterMax;
                                }
                            }
                            checkFlash();
                        }).fail(function(message) {
                            me.stopPageLoading();
                            me.showErrorMessage(message);
                        });
                    }
                }).fail(function() {
                    if(imageLoaded === false) {
                        me.showConnectionDNSErrorInfo();
                    } else {
                        me.showConnectionErrorInfo();
                    }
                });
            }).fail(function() {
                if(imageLoaded === false) {
                    me.showConnectionDNSErrorInfo();
                } else {
                    me.showNoConnectionInfo();
                }
            });
        // } 
        // else {
        //     me.stopPageLoading();
        //      if(imageLoaded === false) {
        //         me.showConnectionDNSErrorInfo();
        //     } else {
        //         me.showConnectionErrorInfo();
        //     }
        //     me.updatePageUI();
        // }

        $(window).on('beforeunload', function(){
            me.stopTest();
            return;
        });

        if(this.speedcheckRenderComplete) {
			this.speedcheckRenderComplete();
        }
    },
    
    appendFlashComponent: function() {
        new AC_FL_RunContent(
                "src", "static/swf/SpeedTest.swf?v=05.01.19-689",
                "width", "1",
                "height", "1",
                "align", "middle",
                "id", "SpeedTest",
                "quality", "high",
                "bgcolor", "#ffffff",
                "name", "SpeedTest",
                "allowScriptAccess","sameDomain",
                "type", "application/x-shockwave-flash",
                "pluginspage", "http://www.adobe.com/go/getflashplayer"
            );
    },
    
    setDefaults: function() {
        var me = this;
        
        me.flashTimeout = 500;
        me.flashCounter = 0;
        me.flashCounterMax = 4;
        me.flashTimer = null;
    },
    
    showErrorMessage: function(message) {
        var me = this;
        
        $('.local-test').hide();
        $('#flash-content').empty();
        me.localTest = false;
        me.totalProgress = 100;
        SWCElements.modalWindow.show({
            templateID: 'system:diagnostics:speedcheck:error',
            templateData: {
                localeStrings: swc.models.Locale.getLocaleStrings(me.pageTemplateID),
                localeString: getTranslationStringsjQuery,
                title: getTranslationStrings('Flash plugin error'),
                message: message
            },
            className: 'speedcheck-error',
            onApply: function() {
                SWCElements.modalWindow.hide();
            }
        });
    },
    
    updateDeviceType: function(response) {
        var me = this,
            device = swc.models.NetworkDevices ? swc.models.NetworkDevices.getDeviceByIP(response.ip) : false;
            
        if(device) {
            if(device.get('interfaceType') === 'wireless') {
                me.isWireless = true;
                $('.wifi').show();
                $('.local-title').html(getTranslationStrings('WLAN SPEED'));
            } else {
                me.isWireless = false;
                $('.wifi').hide();
                $('.local-title').html(getTranslationStrings('HOMENETWORK SPEED'));
            }
        }
    },
    
    checkFlashVersion: function() {
        var me = this,
            deferred = new $.Deferred();
        // Version check for the Flash Player that has the ability to start Player Product Install (6.0r65)
        var hasProductInstall = detectFlashVer(6, 0, 65);
        
        // Version check based upon the values defined in globals
        var hasRequestedVersion = detectFlashVer(me.requiredMajorVersion, me.requiredMinorVersion, me.requiredRevision);
        
        if(hasProductInstall) {
            if(hasRequestedVersion) {
                if(isPepperFlash()) {
                    deferred.reject('Your browser uses a not supported flash plugin.');
                } else {
                    deferred.resolve();
                }
            } else {
                deferred.reject('Invalid flash version');
            }
        } else {
            deferred.reject('No flash');
        }
        
        return deferred.promise();
    },
    
    startFlashTest: function() {
        var me = this,
            test = me.getFlashTest();

        test.setCallback([this.outsidePanel ? 'swc.views.speedtestView.handleFlashStatusResponse' : 'swc.views.applicationsSpeedtestView.handleFlashStatusResponse']);
        test.setTestServerAddress(me.flashUrl);
        //test.setSessions(1);
        test.startTest();
    },
    
    stopFlashTest: function() {
        var test = this.getFlashTest();
        test.stopTest();
    },
    
    getFlashTest: function() {
        var name = 'SpeedTest';
        if (window.document[name]) {
            return window.document[name];
        }
        if (navigator.appName.indexOf("Microsoft Internet") === -1) {
            if (document.embeds && document.embeds[name]) {
                return document.embeds[name];
            }
        } else {
            return document.getElementById(name);
        }
    },

    // OS X 10.6 - 10.9 hack. 
    touchLabel: function($e) {
        setTimeout(function() {
            $e.css("margin-left", 0);
        }, 10);
    },
    
    hasChanged: function() {
        // when we go out of site, stop test!
        if(this.isRunning) {
            this.stopTest();
        }
    }
};;swc.base.TabView = swc.base.PageView.extend({

    /**
     * Initialise view
     */
    initialize: function() {
        var pagesArray = Backbone.history.fragment.split("/");

        // Define tab template and locale ID:
        if(pagesArray[2] !== undefined && this.pageTemplateID === undefined) {
            this.pageTemplateID = pagesArray[0] + ':' + pagesArray[1] + ':' + pagesArray[2];
        }

        // Prepare template for current tab:
        this.template = $.template("pageContent", swc.Templates.get(this.pageTemplateID).get('content'));

        // Extend global events:
        this.events = _.extend({}, swc.base.PageView.prototype.events, this.events);
    },

    postInitialize: function() {
    }
});;swc.BaseCollection = Backbone.Collection.extend({

    autoSync: true,
    /**
     * @override on default {'Backbone.Collection.defaults'} property
     *
     * Default values for collection
     *
     * @param defaults {Array of Objects}
     */
    defaults: [],
    
    /**
     * this variable holds a hook to the ajax request
     * 
     * @param xhr $.ajax
     */
    xhr: null,
    /**
     * @override on default {'Backbone.Collection.url'} property
     *
     * URL for collection to be synced / fetched. Can be either string or object formated to default backbone SYNC actions
     *
     * @description
     *
     * url: '/books/' || url: {
     *      'read': '/books/get',
     *      'create': '/books/set',
     *      'update': '/books/edit',
     *      'delete': '/books/delete'
     * }
     *
     * @param url {String || Object}
     */
    url: '',

    /**
     * @override on default {'Backbone.Collection.model'} property
     *
     * Model id assigned to the collection. Each collection model will be created using this constructor
     *
     * @description
     *
     *      When {'.initialize()'} method will be called, collection will check if current model id is a valid
     *      constructor and exists in swc.models.* scope. If everything is OK -> this constructor will be used
     *      for any model assigned to this collection.
     *
     * @param model {String || Function -> Constructor}
     */
    model: '',

    /**
     * Temporary value for application, to know that this collection have to be handled by other way
     *
     * FIXME :: remove this when all models and collection will be moved to the new architecture
     *
     * @description
     *
     * This will be removed when all collections will be moved to new architecture
     *
     * @param isNewArchitecture {Boolean}
     */
    isNewArchitecture: true,

    /**
     * The flag if collection will be synced even if it has been changed
     * @param isForceSync {Boolean}
     */
    isForceSync: false,

    /**
     * Parameters for sending '{READ}' request to the server
     *
     * @param ajaxParameters {Object}
     */
    ajaxParameters: {
        'parameters': {}
    },

    /**
     * Parameter for sending '{ANY}' type of request to the server, default ajax options for the collection:
     *
     * @param ajaxSettings {Object}
     */
    ajaxSettings: {
        requestType: 'POST',
        requestDataType: 'json',
        contentType: 'application/x-sah-ws-4-call+json'
    },

    /**
     * @override on default {'Backbone.Collection.initialize()'} method
     *
     * @description
     *
     *      Initialize method sets models which are passed to the constructor. If this models are empty,
     *      collection will be filled in with {'this.defaults'}. If {'this.defaults'} will be empty, collection
     *      during initialization will also be empty.
     *
     *      Also in this method collection decides what model constructor will be used for it's models.
     *
     *      if {'this.model'} is passed as a function, consistancy of Backbone.Collection.model will be saved. If
     *                        Function is not a constructor, error will be thrown.
     *
     *      if {'this.model'} is passed as a string, initialize method will go through models constructors scope and look
     *                        for constructor with the same id. If constructor will be found, it will be assigned as a
     *                        collection constructor, else error will be thrown
     *
     *      if {'this.model'} is passed as it is, (is not overrided by extending collection) swc.BaseModel will be set as
     *                        collection models constructor
     *
     */
    initialize: function(models, options) {

        // Define what will be set as collection models:
        models = !_.isEmpty(models) ? models : this.defaults;

        // Saving posibility of native Backbone.Collection.model property to be a constructor itself
        if (!_.isUndefined(this.model) && !_.isEmpty(this.model)) {
            if (_.isString(this.model)) {

                // TODO :: when swc.constructors will be separated to swc.constructors.models -> change this

                if (!_.isFunction(swc.constructors[this.model])) {
                    throw new Error("swc.constructors." + this.model + " is undefined or not a constructor");
                } else {
                    this.model = swc.constructors[this.model];
                }
            } else {
                if (!_.isFunction(this.model)) {
                    throw new Error(this.model + " is undefined or not a constructor");
                }
            }
        } else {
            this.model = swc.BaseModel;
        }

        this.reset(models, _.extend({ silent: true }, options));
    },

    /**
     * @override on default {'Backbone.Collection.sync()'} method
     *
     * Syncs collection with a server
     *
     * @param method {String} -> one of backbone supported methods (Read, Update, Create, Delete)
     * @param options {Object} (optional)
     */
    sync: function(method, options) {
        var self = this,
            url = this.url,
            deferred = new $.Deferred();

        //allow an override for autosync
        if(self.autoSync===false){
         return deferred.resolve();
        }
        // Define action which has to be processed:
        if (_.isObject(this.url) && !_.isEmpty(this.url[method])) {
            url = this.url[method];
        }

        // Reset collection on read method if no changes were done and sync request is not from listener:
        if (!this.canChangeCollection(method, options)) {
            return deferred.resolve(); // No need to sync collection if it was changed by user
        } else {
            this.reset([], _.extend({ silent: true }, options));
        }

        // Send request to the server and fill the model with data
        $.when(self.sendRequest(method, url, options))
            .done(function(response) {

                if (self.canChangeCollection(method, options)) {
                    self.set(self.parse(response));
                    self.trigger('change');
                }

                deferred.resolve();
            })
            .fail(function(xhr, ajaxOptions, thrownError) {

                if (self.canChangeCollection(method, options)) {
                    self.set(self.defaults);
                }

                deferred.reject(xhr, ajaxOptions, thrownError);
            });

        return deferred.promise();
    },

    canChangeCollection: function(method, options) {
        if (method === "read" && !this.isForceSync) {
            if (!_.isUndefined(options) && options.isListener === true && this.hasChanged()) {
                return false;
            }
        }
        return true;
    },

    /**
     * Stop ajax request to the server
     *
     * 
     *
     * @returns {*}
     */
    stopRequest: function(){
        if(!_.isEmpty(this.xhr)){
            this.xhr.abort();
        }
    },

    /**
     * Send ajax request to the server when collection sync is processed:
     *
     * @param method {String}
     * @param url {String}
     * @param options {Object}
     *
     * @returns {*}
     */
    sendRequest: function(method, url, options) {
        var self = this,
            deferred = new $.Deferred(),
            data = method === "read" ? self.ajaxParameters : self.toJSON(options),
            requestType = this.ajaxSettings.requestType,
            timeout = !_.isUndefined(options) && !_.isUndefined(options.timeout) ? options.timeout : 20000,
            headers = {
                'X-Context': $.cookie(swc.Utils.getDeviceID() + '/context'),
                'Authorization': 'X-Sah ' + $.cookie(swc.Utils.getDeviceID() + '/context')
            };

        // Check if something is missing from mandatory arguments:
        if (_.isEmpty(url) || _.isEmpty(method)) {
            return deferred.resolve();
        }

        // Check if current request is making in background:
        if ( (!_.isUndefined(options) && !_.isUndefined(options.isListener) ) || (!_.isUndefined(this.ajaxSettings.idle) && this.ajaxSettings.idle===true ) ) {
            headers.idle = true;
            headers['X-Sah-Request-Type'] = 'idle';
        }

        // Check if it's needed different request types for get / set requests
        if (_.isObject(this.ajaxSettings.requestType) && !_.isEmpty(this.ajaxSettings.requestType[method])) {
            requestType = this.ajaxSettings.requestType[method];
        }

        // Send request to the server:
        self.xhr = $.ajax(
            {
            url: url,
            type: requestType,
            dataType: self.ajaxSettings.requestDataType,
            contentType: self.ajaxSettings.contentType,
            headers: headers,
            timeout: timeout,

            cache: false,

            data: $.isPlainObject(data) ? JSON.stringify(data) : data,

            success: function(response) {
                swc.models.Login.checkAccessToDevice(response);
                deferred.resolve(response);
            },

            error: function(xhr, ajaxOptions, thrownError) {
                swc.models.Login.checkAccessToDevice(xhr);
                // 404 - is not error, it is change of functionality - before was as 200 with error code inside
                if(xhr.status === 404 || xhr.status === 500) {
                    // prefer json than string
                    var result;
                    try {
                        result = jQuery.parseJSON(xhr.responseText);
                    } catch(e) {
                        result = xhr.responseText;
                    }
                    deferred.resolve(result);
                } else {
                    deferred.reject(xhr, ajaxOptions, thrownError);
                }
            },

            statusCode: {

                403: function() {
                    // TODO :: crete handling of this errors:
                },

                404: function() {
                    if (_.isFunction(this.on404)) {
                        this.on404();
                    }
                },

                500: function() {
                    // TODO :: crete handling of this errors:
                },

                502: function() {
                    if (_.isFunction(this.on502)) {
                        this.on502();
                    }
                }

            }
        });

        return deferred.promise();
    },

    /**
     * @override on default {'Backbone.Collection.parse()'} method
     *
     * This method is called whenever a collection's data is returned by the server, in fetch, and save. The function is
     * passed the raw response object, and should return the attributes hash to be set on the collection
     *
     * @param response {Object}
     * @param options {Object} (optional)
     *
     * @returns {Object}
     */
    parse: function(response) {
        var json = response;

        if (_.isFunction(this.apiToJSON)) {
            json = this.apiToJSON(json);
        }

        return json;
    },

    /**
     * @override on default {'Backbone.Collection.toJSON()'} method
     *
     * Transform collection to valid JSON. Goes through each model and call's it {'toJSON()'} method
     *
     * @param options {Object}
     *
     *      options = { showDeleted: true } -> includes deleted models to list of models
     *      options = {} -> includes only not deleted models
     *
     * @returns {Array of Objects}
     */
    toJSON: function(options) {
        var json = [];

        _.each(this.models, function(model) {
            if (_.isUndefined(model.get('isDeletedByCollection'))) {
                json.push(Backbone.Model.prototype.toJSON.apply(model));
            } else {
                if (!_.isUndefined(options) && options.showDeleted === true) {
                    json.push(Backbone.Model.prototype.toJSON.apply(model));
                }
            }
        });

        return json;
    },

    /**
     * @override on default {'Backbone.Collection.remove()'} method
     *
     * We need to know what models were removed from the collections, to sync them with server
     *
     * @param models {Array of Objects || Objects}
     * @param options {Object}
     *
     * @description
     *
     *      options = { permanent: true } will use native Backbone.Collection.remove();
     *
     *      When options are not passed, there works an override on default Backbone.Collection.Remove() method
     *      which set Model custom parameter {'isDeletedByCollection'} to true, which let's collection know that
     *      this model was deleted from the collection.
     *
     *      This case will be needed to get list of deleted models, when collection will be saving. Because NP doesn't
     *      support Full REST api, so it will be needed to go through all {isDeletedByCollection} models and sync them
     *      with server
     */
    remove: function(models, options) {
        var modelsDiff = [];

        if (!_.isUndefined(options)) {
            if (!_.isUndefined(options.permanent) && options.permanent === true) {
                Backbone.Collection.prototype.remove.apply(this, arguments);
            }
        } else {

            if (!_.isUndefined(models) && !_.isEmpty(models)) {
                modelsDiff = !_.isArray(models) ? [ models ] : models;
            }

            _.each(modelsDiff, function(model) {
                model.set('isDeletedByCollection', true);
            });
        }
    },

    /**
     * Creating similar to Backbone.Model.hasChanged() method, which will say if collection has changed:
     *
     * @description:
     *
     *      Goes through each model in the collections and call it's method {'.hasChanged()'}
     *      If one the models will return {'true'} that will mean that collection has changed
     *
     * // TODO :: improvement allow pass list of model as arguments.
     *
     * @returns {Boolean}
     */
    hasChanged: function() {
        var hasChanged = false;

        _.each(this.models, function(model) {
            if (model.hasChanged()) {
                hasChanged = true;
            }
        });

        return hasChanged;
    },

    /**
     * Get list of changed models. Including edited / deleted models:
     *
     * @param options {Object}
     *
     * @description
     *
     *      options = { onlyEdited: true } will return only changed models (excluding deleted);
     *      options = { onlyDeleted: true } will return only deleted models (excluding changed);
     *      options = {} || undefined will return all changed and deleted models
     *
     * @returns {Array of Objects}
     */
    changedModels: function(options) {
        var models = [];

        _.each(this.models, function(model) {

            // Selection for only edited or deleted models:
            if (!_.isUndefined(options) && !_.isEmpty(options)) {

                // Selection for only changed models:
                if (!_.isUndefined(options.onlyEdited) && options.onlyEdited === true) {
                    if (model.hasChanged() && _.isUndefined(model.get('isDeletedByCollection'))) {
                        models.push(model);
                    }
                }

                // Selection for only deleted models:
                if (!_.isUndefined(options.onlyDeleted) && options.onlyDeleted === true &&
                    !_.isUndefined(model.get('isDeletedByCollection')) && model.get('isDeletedByCollection') === true) {
                    models.push(model);
                }
            } else {
                if (model.hasChanged()) {
                    models.push(model);
                }
            }
        });

        return models;
    }

});

;swc.BaseCompositeModel = Backbone.Model.extend({

    models: {},

    /**
     * Mapper converts field name into value (get mode)
     * or into the list of models and their fields to set (set mode)
     * map: {
     *      'fieldName': 'modelName.fieldName',
     *      'complexField': function (data, options) {
     *              if (data) { //setter
     *                  return {
     *                      model: { field: value, ... }, ...
     *                  }
     *              }
     *              else { //getter
     *                  ...
     *                  return value;
     *              }
     *          }
     *      ...
     * }
     *
     * or:
     *
     * map: function (data, isReverse) { ... } // still TODO
     */
    map: {},

    modelsPool: {},

    /**
     * Define initialize method:
     *
     * @param attributes {Object}
     * @param options {Object}
     */
    initialize: function (attributes, options) {
        var self = this;
        this.modelsPool = {};

        $.each(this.models, function(key) {
            var attr = {}; // TODO - compose from attributes and mapper
            self.modelsPool[key] = new /*TODO*/ swc.constructors[key](attr, options);
        });
    },

    get: function (name) {
        if (!this.map[name]) {
            return null;
        }

        if (_.isFunction(this.map[name])) {
            return this.map[name]();
        }
        else {
            var parts = this.map[name].split('.'),
                modelName = parts[0],
                modelField = parts[1];
            return this.modelPool[modelName].get(modelField);
        }
    },

    set: function (name, value, options) {
        var self = this,
            newData = {},
            data;

        if (_.isObject(name)) {
            data = name;
        }
        else {
            data = {};
            data[name] = value;
        }

        // Run validation.
        if (!this._validate(data, options)) {
            return false;
        }

        $.each(data, function (key, val) {
            if (_.isFunction(this.map[key])) {
                _.extend(newData, this.map[key](val, options));
            }
            else {
                var parts = this.map[name].split('.'),
                    modelName = parts[0],
                    modelField = parts[1];
                if (!newData[modelName]) {
                    newData[modelName] = {};
                }
                newData[modelName][modelField] = val;
            }
        });
        $.each(newData, function (modelName, vals) {
            self.modelPool[modelName].set(vals, options);
        });

        return this;
    },

    /**
     *
     * TODO: add mapper
     */
    syncAll: function (method, options) {
        var self = this,
            deferred = new $.Deferred(),
            promises = [];

        if (_.keys(this.models).length === 0) {
            return deferred.resolve();
        }

        $.each(this.models, function(key) {
            promises.push(self.syncSubModel(method, key, options));
        });

        $.when.apply(null, promises)
            .done(function() {
                return deferred.resolve();
            })
            .fail(function() {
                return deferred.reject();
            });

        return deferred.promise();
    },

    syncSubModel: function (method, modelName, options) {
        var deferred, originalPromise;

        originalPromise = this.modelsPool[modelName].sync(method, options);

        if (this.models[modelName].required === true) {
            return originalPromise;
        }

        // If the model is not required then we resolve the deffered object always
        deferred = new $.Deferred();

        originalPromise.always(function () {
            deferred.resolve();
        });

        return deferred.promise();
    },

    sync: function(method, options) {
        var deferred = new $.Deferred();

        if (!method) {
            method = 'read';
        }

        options = _.extend({}, options);

        // Check if current page has any models:
        if (_.keys(this.models).length === 0) {
            return deferred.resolve();
        } else {
            var methodName = 'syncAs' + method.charAt(0).toUpperCase() + method.slice(1);

            if (_.isFunction(this[methodName])) {
                deferred = new $.Deferred();
                $.when(this[methodName](options))
                    .done(function() {
                        deferred.resolve();
                    })
                    .fail(function() {
                        deferred.reject();
                    });
            }
            else {
                return this.syncAll('read', options);
            }

            return deferred.promise();
        }
    },

    /**
     * Default save method.
     * Can be overriden for custom behavior.
     *
     */
    syncAsSave: function (options) {
        return this.syncAll(undefined, options);
    },

    /**
     * Validation of model parameters on '{set}' method
     *
     * @param attributes {Object}
     * @param options {Object}
     */
    _validate: function(attributes, options) {
        // TODO
        if (!this.validate()) {
            return false;
        }

        for(var i in this.modelsPool) {
            var attrs = {}; // TODO form attributes and mapper

            if (!this.modelsPool[i]._validate(_.extend({}, attrs), _.extend({}, options))) {
                return false;
            }
        }

        return true;
    },

    /**
     * @override
     *
     * @param attributes
     * @param options
     * @returns {boolean}
     */
    validate: function() {
        return true;
    },

    /**
     * Reset model to it previous values (IF some error happened)
     */
    resetToPreviousState: function() {
        $.each(this.modelsPool, function(key, model) {
            model.resetToPreviousState();
        });
    }
});
;swc.BaseModel = Backbone.Model.extend({

    /**
     * @override on default {'Backbone.model.defaults'} property
     *
     * Default values for a model
     *
     * @param defaults {Object}
     */
    defaults: {},

    /**
     * this variable holds a hook to the ajax request
     * 
     * @param xhr $.ajax
     */
    xhr: null,

    /**
     * @override on default {'Backbone.model.url'} property
     *
     * URL for model to be synced / fetched. Can be either string or object formated to default backbone SYNC actions
     *
     * @descirption
     *
     *      url: '/books/' || url: {
     *          'read': '/books/get',
     *          'create': '/books/set',
     *          'update': '/books/edit',
     *          'delete': '/books/delete'
     *      }
     *
     *      Either you can add any method you want to URL object and it will work, if you will call sync() with correct
     *      method. You can extend default behaviour by your custom methods
     *
     *      Example:
     *
     *      ulr: {
     *          'read':     '/get/books',
     *          'replace':  '/set/books/id'
     *      }
     *
     *      Then you call sync('replace'), and it will use correct ulr (/set/books/id)
     *
     * @param url {String || Object}
     */
    url: '',

    /**
     * List of the attributes which will be first time to the model, to check if it will be changed
     *
     * @param originalAttributes {Object}
     *
     * @note Please do not use this Object for your purposes. This is an urgent variable for model.
     */
    originalAttributes: {},

    /**
     * Temporary value for application, to know that this models have to be handled by other way
     *
     * FIXME :: remove this when all models and collection will be moved to the new architecture
     *
     * @description
     *
     *      This will be removed when all models will be moved to new architecture
     *
     * @param isNewArchitecture {Boolean}
     */
    isNewArchitecture: true,

    /**
     * The flag if model will be synced even if it has been changed
     * @param isForceSync {Boolean}
     */
    isForceSync: false,

    /**
     * The flag force checking if response of request is undefined for sync and then just return
     * @param checkForUndefinedResponse {Boolean}
     */
    checkForUndefinedResponse: false,

    /**
     * Parameters for sending '{READ}' request to the server
     *
     * FIXME :: move to separate object which will handle AJAX requests of model:
     *
     * @param ajaxParameters {Object}
     */
    ajaxParameters: {
        'parameters': {}
    },

    /**
     * Parameter for sending '{ANY}' type of request to the server, default ajax options for the model:
     *
     * FIXME :: move to separate object which will handle AJAX requests of model:
     *
     * @param ajaxSettings {Object}
     */
    ajaxSettings: {
        requestType: 'POST',
        requestDataType: 'json',
        contentType: 'application/x-sah-ws-4-call+json'
    },

    /**
     * @override on default {'Backbone.model.initialize()'} method
     *
     * @description
     *
     *      Was overrided because need to set {'this.originalAttributes'}. Why this is needed you can see in following
     *      methods:
     *
     * @memberOf hasChanged()
     * @memberOf changedAttributes()
     */
    initialize: function(attributes, options) {
        attributes = !_.isEmpty(attributes) ? attributes : this.defaults;

        if (_.isEmpty(this.originalAttributes)) {
            this.originalAttributes = attributes;
        }

        this.set(attributes, options);
    },

    /**
     * @override on default {'Backbone.model.sync()'} method
     *
     * Default {'Backbone.sync()'} doesn't support Application requirements.
     *
     * @description
     *
     *      This method was overrided becuase of specific Server (NP) API. It was impossible to use native {'.sync()'}
     *      method with current server API.
     *
     * @param method {String}
     * @param options {Object}
     */
    sync: function(method, options) {
        var self = this,
            url = this.url,
            deferred = new $.Deferred();

        //allow an override for autosync
        if(self.autoSync===false){
         return deferred.resolve();
        }
        // Define action which has to be processed:
        if (_.isObject(this.url) && !_.isEmpty(this.url[method])) {
            url = this.url[method];
        }

        // This check helps to avoid unnecessary AJAX calls when model is changed:
        if (!this.canChangeModel(method, options)) {
            return deferred.resolve(); // No need to sync model if it was changed by user
        }

        // Send request to the server and fill the model with data
        $.when(self.sendRequest(method, url, options))
            .done(function(response) {
                // This check is added to avoid problems when the model has been changed
                // between AJAX start and AJAX resolve.
                if(self.checkForUndefinedResponse === true && _.isUndefined(response)) {
                    return;
                }

                if (self.canChangeModel(method, options)) {
                    self.set(self.parse(response)); // No need to set if the model is changed
                }

                deferred.resolve(response);
            })
            .fail(function(xhr, ajaxOptions, thrownError) {
                if (self.canChangeModel(method, options)) {
                    self.set(self.parse(self.defaults));
                }

                deferred.reject(xhr, ajaxOptions, thrownError);
            });

        return deferred.promise();
    },

    canChangeModel: function(method, options) {
        if (method === "read" && !this.isForceSync) {
            if (!_.isUndefined(options) && options.isListener === true && this.hasChanged()) {
                return false;
            }
        }

        return true;
    },

    /**
     * Stop ajax request to the server
     *
     * 
     *
     * @returns {*}
     */
    stopRequest: function(){
        if(!_.isEmpty(this.xhr)){
            this.xhr.abort();
        }
    },
    /**
     * Send ajax request to the server when model sync is processed:
     *
     * FIXME :: move to separate object which will handle AJAX requests of model:
     *
     * @param method {String}
     * @param url {String}
     * @param options {Object}
     *
     * @returns {*}
     */
    sendRequest: function(method, url, options) {
        var self = this,
            deferred = new $.Deferred(),
            data = method === "read" ? self.ajaxParameters : self.toJSON(options),
            requestType = this.ajaxSettings.requestType,
            headers = {
                'X-Context': $.cookie(swc.Utils.getDeviceID() + '/context'),
                'Authorization': 'X-Sah ' + $.cookie(swc.Utils.getDeviceID() + '/context')
            };

        // Check if something is missing from mandatory arguments:
        if (_.isEmpty(url) || _.isEmpty(method)) {
            return deferred.resolve();
        }

        // Check if current request is making in background:
        if ( (!_.isUndefined(options) && !_.isUndefined(options.isListener) ) || (!_.isUndefined(this.ajaxSettings.idle) && this.ajaxSettings.idle===true ) ) {
            headers.idle = true;
            headers['X-Sah-Request-Type'] = 'idle';
        }

        // Check if it's needed different request types for get / set requests
        if (_.isObject(this.ajaxSettings.requestType) && !_.isEmpty(this.ajaxSettings.requestType[method])) {
            requestType = this.ajaxSettings.requestType[method];
        }

        // Send request to the server:
        self.xhr = $.ajax(
            {
            url: url,
            type: requestType,
            dataType: self.ajaxSettings.requestDataType,
            contentType: self.ajaxSettings.contentType,
            headers: headers,
            cache: false,

            data: $.isPlainObject(data) ? JSON.stringify(data) : data,

            success: function(response) {
                swc.models.Login.checkAccessToDevice(response);
                deferred.resolve(response);
            },

            error: function(xhr, ajaxOptions, thrownError) {
                //swc.models.Login.checkAccessToDevice(xhr);
                // 404 - is not error, it is change of functionality - before was as 200 with error code inside
                if(xhr.status === 404 || xhr.status === 500) {
                    // prefer json than string
                    var result;
                    try {
                        result = jQuery.parseJSON(xhr.responseText);
                    } catch(e) {
                        result = xhr.responseText;
                    }
                    deferred.resolve(result);
                } else {
                    deferred.reject(xhr, ajaxOptions, thrownError);
                }
            },

            statusCode: {
                403: function() {
                    // TODO :: crete handling of this errors:
                },

                404: function() {
                    if (_.isFunction(this.on404)) {
                        this.on404();
                    }
                },

                500: function() {
                    // TODO :: crete handling of this errors:
                },

                502: function() {
                    if (_.isFunction(this.on502)) {
                        this.on502();
                    }
                }
            }
        });

        return deferred.promise();
    },

    /**
     * @override on default {'Backbone.model.parse()'} method
     *
     * This method is called whenever a model's data is returned by the server, in fetch, and save. The function is
     * passed the raw response object, and should return the attributes hash to be set on the model
     *
     * @param response {Object}
     *
     * @returns {Object}
     */
    parse: function(response) {
        var json = response;

        // Convert json to suitable format if method for this exists
        if (_.isFunction(this.apiToJSON)) {
            json = this.apiToJSON(json);
        }

        // Save original json in order to check for model changes
        this.originalAttributes = json;

        return json;
    },

    /**
     * @override on default {'Backbone.model.toJSON()'} method
     *
     * Transform JSON form model to valid server JSON, to be saved
     *
     * @param json {Object}
     *
     * @returns {Object}
     */
    toJSON: function() {
        return Backbone.Model.prototype.toJSON.call(this);
    },

    /**
     * @override on default {'Backbone.model.hasChanged()'} method
     *
     * Default method doesn't fit current application requirements
     *
     * @description
     *
     *      var model = new Backbone.model({ a: 10 });
     *
     *          model.set('a', 15);
     *          model.set('a', 10);
     *
     *          model.hasChanged() -> true
     *
     *      Current implementation does not allow us to see if model was really changed, so here is the override
     *
     *      var model = new swc.BaseModel({ a: 10 });
     *
     *          model.set('a', 15);
     *          model.set('a', 10);
     *
     *          model.hasChanged() -> false
     *
     * @param attributes {String || Array of Strings} (saving native Backbone.hasChanged(attrs) interface)
     *
     * @returns {Boolean}
     */
    hasChanged: function(attributes) {
        var changedAttributes = this.changedAttributes(),
            hasChanged = !_.isEmpty(changedAttributes);

        if (!_.isUndefined(attributes) && !_.isEmpty(attributes)) {
            hasChanged = false;

            attributes = !_.isArray(attributes) ? [ attributes ] : attributes;

            _.each(attributes, function(key) {
                if (!_.isUndefined(changedAttributes[key])) {
                    hasChanged = true;
                }
            });
        }

        return hasChanged;
    },

    /**
     * @override on default {'Backbone.model.changedAttributes()'} method
     *
     * Default method doesn't fit current application requirements
     *
     * @description
     *
     *      var model = new Backbone.model({ a: 10 });
     *
     *          model.set('a', 15);
     *          model.set('a', 10);
     *
     *          model.changedAttributes('a') -> true
     *
     *      Current implementation does not allow us to see if model was really changed, so here is the override
     *
     *      var model = new swc.BaseModel({ a: 10 });
     *
     *          model.set('a', 15);
     *          model.set('a', 10);
     *
     *          model.changedAttributes('a') || model.changedAttributes(['a'])  -> false
     *
     * @param attributes {String || Array of Strings} (saving native Backbone.changedAttributes(attrs) interface)
     *
     * @returns {Array of Objects}
     */
    changedAttributes: function(attributes) {
        var self = this,
            attrs = {},
            attrsDiff = _.keys(this.attributes);

        if (!_.isUndefined(attributes) && !_.isEmpty(attributes)) {
            attrsDiff = !_.isArray(attributes) ? [ attributes ] : attributes;
        }

        _.each(attrsDiff, function(attribute) {
            var mapsEqual = _.isEqual(
                _.pick(self.attributes, attribute),
                _.pick(self.originalAttributes, attribute)
            );

            if (!mapsEqual) {
                attrs[attribute] = self.get(attribute);
            }
        });

        return attrs;
    }
});
;swc.constructors.ApplicationModel = Backbone.Model.extend({

    /**
     * Init application model
     */
    initialize: function() {
        var self = this;
        // Load templates and necessary scripts:
        swc.Templates = swc.Templates ? swc.Templates : new swc.constructors.Templates();
        swc.Templates.loadTemplates(function() {
            swc.models.Locale = new swc.constructors.LocaleModel();

            var storedLocal = swc.Utils.isCookieSupport() ? localStorage.getItem("locale") : null,
                browserLang = window.navigator.userLanguage || window.navigator.language,
                cookieLang = $.cookie("locale");
            if(swc.Utils.isCookieSupport()){
                if(!_.isEmpty(cookieLang) && cookieLang.length===2){
                    storedLocal=cookieLang;
                } else{
                    storedLocal=swc.models.Locale.validateLanguage(browserLang);
                    //swc.models.Locale.setLocaleCookie(storedLocal);
                }
                
            }
            
            // When it is the very first run or cache and local storage are cleared
            if (!storedLocal) {
                self.initLocaleFallback();
            }
            // otherwise - get locale preference from the serverside
            else {
                /*$.when(swc.models.Locale.getLocale())
                    .done(function(response){*/
                        $.when(swc.models.Locale.setLocale(storedLocal, false))
                            .always(function() {
                                self.initComponents();
                            });
                    /*})
                    .fail(function(){
                        self.initLocaleFallback();
                    });*/
            }
        });
    },

    sync: function(fromListener) {
        var deferred = $.Deferred();

        if(swc.Utils.DeviceType === 'default') {
			$.when(this.getAPGlobalState(fromListener), swc.models.PasswordRecovery.sync("read", { isListener: fromListener }))
				.always(function() {
					deferred.resolve();
				});
        } else {
			deferred.resolve();
        }

        return deferred.promise();
    },

    /**
     * Fallback mechanism to get locale from local storage or default settings
     * and save it on server side
     *
     * @return void
     */
    initLocaleFallback: function() {
        var self = this;
        var appLocale = getApplicationLocale(swc.models.Locale.available);
        if (appLocale === undefined) {
            appLocale = swc.models.Locale.defaultLocale;
        }
        // save locale preference on server side
        $.when(swc.models.Locale.setLocale(appLocale, false)).always(function() {
            self.initComponents();
        });
    },

    /**
     * Init core models and views
     *
     * @return void
     */
    initComponents: function() {
        var self = this;

        // We have to have PasswordRecovery model in order to show 'Set new password' button on login page
        swc.models.PasswordRecovery = new swc.constructors.PasswordRecovery();

        // Basic initialization(the following order is important because ApplicationView
        // uses System model which needs Rest model):

        // 1. Init core models:
        swc.models.Login = new swc.constructors.LoginModel();
        swc.models.Rest = new swc.constructors.Rest();

        // 2. Init application view:
        swc.views.Application = new swc.constructors.ApplicationView();

        // Need to get all login information because of incorrect implementation of login model
        $.when(this.sync())
            .done(function() {
                self.coreRun();
            })
            .fail(function() {
                self.coreRun();
            });
    },

    /**
     * Gets an example of time from server and keeps it in swc.settings
     * Is used for formatting dates in server's timezone.
     */
    initServerTimeZone: function() {
        var self = this,
            onRequestComplete = function(response) {
                if (response && response.data && response.data.time) {
                    swc.settings.serverTimeZone = moment.parseZone(response.data.time).zone();
                } else {
                    setTimeout(function() {
                        self.initServerTimeZone();
                    }, 1000);
                }
            };

        swc.models.Rest.sendRequest({
            url: '/sysbus/Time:getTime',
            fromListener: true,
            timeout: 2000,
            data: {
                "parameters": {}
            },
            success: onRequestComplete,
            error: onRequestComplete
        });
    },

    /**
     * Start application:
     */
    coreRun: function() {
        var userLogin = swc.models.Login.checkIfLoggedIn();

        if (userLogin) {
            this.initServerTimeZone();
        }

        // Pre render application area if user is logged in:
        if (window.isOnStickyPage){
            Backbone.history.start(); // no router, so need to do this
            swc.views.StickyPageView = new swc.constructors.StickyPageView();
        } else {
            // Init Application Router:
            swc.router = swc.router ? swc.router : new swc.constructors.Router();
        }
    },

    // get global AP state
    getAPGlobalState: function(fromListener) {
        var self = this,
            deferred = new $.Deferred();

        // Just in case ;-) Actually we call swc.settings throughout all application
        self.set('domainName', swc.settings.application.get('url'));

        swc.models.Rest.sendRequest({
            url: '/sysbus/APController:get',
            fromListener: fromListener,
            data: {
                parameters: {}
            },

            success: function(response) {
                if (response.status !== null) {
                    self.set(response.status);
                } else {
                    self.set({
                        GlobalEnable: false,
                        DNSName: swc.settings.application.get('apUrl')
                    });
                }
                deferred.resolve();
            },

            error: function() {
                self.set({
                    GlobalEnable: false,
                    DNSName: swc.settings.application.get('apUrl')
                });
            }
        });

        return deferred.promise();
    }
});
;swc.constructors.EventDispatcher = swc.BaseCollection.extend({

    eventListenerInterval: null,

    eventManager: null,

    eventManagerListener: null,
    //keeps info about model, its trigger after event is returned and event handler
    handlers: {
        swcmodelsCentralStorage: { //handler : 'AP.USB.Device', //alternative event mode for version 1 of webservices
            resource: 'AP.USB.Device', //which element should we watch
            event   : 'usb_notification_device_deleted'
        },
        swcmodelsNetworkDevices_USB: {
            resource: 'Devices.Device', //which element should we watch
            event   : 'usb_device_updated'
        },
        swcmodelsNetworkDevices_USB_ADDED: {
            resource: 'Devices.Device',
            event   : 'usb_device_added'
        },
        swcmodelsNetworkDevices_USB_DELETED: {
            resource: 'USBHosts.Host.usbhost_1.Device', //IGD.USBHosts.Host.usbhost_1.Device
            event   : 'device_deleted'
        },
        topology: {
            resource: 'Devices.Device',
            event   : 'topology_changed'
        },
        swcmodelsNetworkDevices: {
            resource: 'Devices.Device',
            event   : 'self_device_updated'
        },
        swcmodelsNetworkDevices_WIFI: {
            resource: 'Devices.Device',
            event   : 'wifi_device_updated'
        },
        swcmodelsNetworkDevices_ETH: {
            resource: 'Devices.Device',
            event   : 'eth_device_updated'
        },
        swcmodelsNetworkDevices_LOGICAL: {
            resource: 'Devices.Device',
            event   : 'logical_device_updated'
        },
        swcmodelsNetworkDevices_ERR: {
            resource: 'Devices.Device',
            event   : 'device_error'
        },
        swcmodelsNetworkDevices_ERRSOLVED: {
            resource: 'Devices.Device',
            event   : 'device_error_solved'
        },
        swcmodelsNetworkDevices_VOIP: {
            resource: 'Devices.Device',
            event   : 'voice_device_updated'
        },
        swcmodelsNetworkDevices_VPN_CHANGED: {
            resource: 'APController',
            event   : 'changed'
        },
        swcmodelsNetwork: {
            resource: 'NMC.Wifi',
            event   : ''
        },
        paringDone: {
            resource: 'DECT',
            event: 'pairingDone'
        },
        APAdd: {
            resource: 'AP.USB.Device',
            event: 'add'
        },
        modemStatus: {
            handler: "NeMo.Intf.wwan"
        }
    },
    
    views: {
        'overview': ['swcmodelsNetworkDevices_VPN_CHANGED', "swcmodelsNetworkDevices","swcmodelsNetworkDevices_LOGICAL","swcmodelsNetworkDevices_WIFI","swcmodelsNetworkDevices_ETH","swcmodelsNetworkDevices_ERR","swcmodelsNetworkDevices_ERRSOLVED","swcmodelsNetworkDevices_USB","swcmodelsNetworkDevices_VOIP","topology", "modemStatus", "swcmodelsNetworkDevices_USB_ADDED", 'swcmodelsNetworkDevices_USB_DELETED', 'APAdd', 'swcmodelsCentralStorage' ],
        'cs_settings': [ "swcmodelsNetworkDevices"],
        'network_device_list': [ "swcmodelsNetworkDevices_WIFI","swcmodelsNetworkDevices_ETH","topology" ],
        'parental_controll': [ "swcmodelsNetworkDevices_WIFI","swcmodelsNetworkDevices_ETH"],
        'storage_devices': ['swcmodelsNetworkDevices_USB', 'swcmodelsNetworkDevices', 'APAdd', 'swcmodelsCentralStorage'],
        'wlan': ['swcmodelsNetwork'],
        'telephony': ['paringDone', 'swcmodelsNetworkDevices_VOIP'],
        'dectSettings': ['paringDone'],
        'vpn_server': ['swcmodelsNetworkDevices_VPN_CHANGED']
    },

    observ: function(view, returnCall){
        if(!_.isEmpty(returnCall.observers[view])){
            return null;
        }
        else{
            returnCall.observers.push(view);
        }
        var eventList=null,
        self = this;

        if(!_.isEmpty(self.views) && !_.isEmpty(self.views[view])){
            eventList = [];
            _.each(self.views[view], function(who){
                 if(_.isEmpty(self.handlers[who].handler)){
                     eventList.push({"service":self.handlers[who].resource,"event":self.handlers[who].event});
                 }
                 else{
                     eventList.push({"handler":self.handlers[who].handler});
                 }
            });
        } else {

        }

        if(eventList !== null){
            self.addEventManagerListener(eventList,self.views[view],returnCall);
        }
    },
    stopObserv:function(){
        if(!_.isEmpty(this.eventManagerListener)){
            this.eventManagerListener.status=false;
            this.eventManagerListener.off("change");
            this.eventManagerListener.stopRequest();
            delete this.eventManagerListener;
        }
        if(!_.isEmpty(this.eventManager)){
            this.eventManager.stopRequest();
            delete this.eventManager;
        }
    },

    addEventManagerListener: function(eventList, eventHandlers, returnCall) {
        var self = this;
        self.eventManager = new swc.constructors.EventManager({parameters: { events: eventList, channelid: 0 }});
        self.eventManagerListener = new swc.constructors.EventManagerListenerv4();

        $.when(self.eventManager.openChannel())
        .done(function(){
            if(self.eventManagerListener!==null){
                var channel =  self.eventManager.get('channelid');

                self.eventManagerListener.setAjaxParameters({
                    service: "eventmanager",
                    method: "get_events",
                    parameters: {channelid: channel}
                });

                callback();
                self.eventManagerListener.on('change', callback);
                    //start listening to channel after getting channel ID
                self.eventManagerListener.listenChannel();
            }//if
        })
        .always(function() {
        });

        function callback() {
            var incommingEvent = self.eventManagerListener.pop();

            if (_.isEmpty(incommingEvent)) {
                return;
            }

            if(!_.isEmpty(self.eventManagerListener.models)){
                _.each(self.eventManagerListener.models,function(elem){
                    if(elem.attributes.status && elem.attributes.status.events.length>0){
                        for(var i=0; i<elem.attributes.status.events.length; i++){

                            incommingEvent=elem.attributes.status.events[i];
                            //used to debug event handling
                            //console.debug(incommingEvent);
                            _.each(eventHandlers, function(who){
                                if( self.handlers[who].event+"" === incommingEvent.data.object.reason+"" || self.handlers[who].handler+"" === incommingEvent.data.handler+""){
                                    //return the call to the view
                                returnCall.passEvent(incommingEvent,self.handlers[who]);
                                }
                            });
                        }
                    }
                });
            }

        }
    }

});

swc.constructors.EventManagerListenerv4 = swc.BaseCollection.extend({

    url: "/ws",
    
    status: true,
    testingJSONMalformed: false,
    
    //model: 'StargateEvent',
    //failInterval : null,
    ajaxSettings: {
        requestType: 'POST',
        requestDataType: 'json',
        contentType: "application/x-sah-ws-4-call+json",
        idle:true
    },

    defaults: {
        service: "eventmanager",
        method: "get_events",
        parameters: {
            "channelid": 0, // mark that subscription channel should be crerated
            "events": []
        }
    },

    initialize: function() {
        swc.BaseCollection.prototype.initialize.apply(this, arguments);
        this.testingJSONMalformed = swc.settings.application.get('testing').testingJSONMalformedEvent === 'true' ? true : false;
    },

    setAjaxParameters: function (ajaxParameters) {
        this.ajaxParameters = ajaxParameters;
    },

    /**
     * Listen to subscribed events using currently opened channel
     */
     listenChannel: function() {
        var deferred = new $.Deferred(),
        self = this;

        if(self.testingJSONMalformed === true) {
            self.url = "/wseventtesting";
        }

        $.when(this.sync("read", {silent: false}))
        .done(function () {
            if(self.status){
                self.listenChannel();
            }
            deferred.resolve();
        })
        .fail(function() {
            if(self.status){
                self.listenChannel();
            }
            deferred.reject();
        })
        .then(function(){});

        return deferred.promise();
    }
});
/**
* EventController is used for blocking and dispatching events
* in a queue. Internet-box is sometimes sending more than 1
* event at the same time so we have to block the rest of them
* since we need only one.
*/

swc.constructors.EventController = function(obj) {
    this.block = [];
    this.time = 10;

    var self = this;

    this.pass = function(event, eventObject) {
        var context = this;

        _.each(obj, function(el, ind){
            if(obj[ind].event === eventObject.event || obj[ind].event === event.data.handler) {
                self.runBlocked(context, context[obj[ind].action], event, obj[ind].event);
            }
        });
    };

    this.runBlocked = function(that, fn, event, name) {
        setTimeout(function() {
            if(self.block[name] === undefined) {
                self.block[name] = "blocked";
                //console.log("Block event: " + name);
                fn.call(that, event);
            }

            setTimeout(function() {
                if(self.block[name] === "blocked") {
                    self.block[name] = undefined;
                    //console.log("Unblock event: " + name);
                }
            }, 300);
        }, self.time);
    };

    return {
        pass: this.pass
    };
};;swc.constructors.EventManager = swc.BaseModel.extend({

    url: "/ws",

    ajaxSettings: {
        requestType: 'POST',
        requestDataType: 'json',
        contentType: "application/x-sah-ws-4-call+json"
    },

    defaults: {
        service: "eventmanager",
        method: "get_events",
        parameters: {
            "channelid": 0, // mark that subscription channel should be crerated
            "events": []
        }
    },

    eventsVersionToUse: 2,

    initialize: function() {
        if((!_.isUndefined(arguments[0]) && arguments[0].eventsVersionToUse === 1)) {
            this.eventsVersionToUse = 1;
            this.ajaxSettings.contentType = "application/x-sah-event-1-call+json";
            this.defaults = {
                "channelid": 0, // mark that subscription channel should be crerated
                "events": []
            };
        } else {
            this.eventsVersionToUse = 2;
            this.ajaxSettings.contentType = "application/x-sah-ws-4-call+json";
            this.defaults = {
                service: "eventmanager",
                method: "get_events",
                parameters: {
                    "channelid": 0, // mark that subscription channel should be crerated
                    "events": []
                }
            };
        }
        swc.BaseModel.prototype.initialize.apply(this, arguments);
    },

    /**
     * Creates an Event-Manager channel to listen for subscribed events
     *
     * @returns Promise
     */
    openChannel: function() {
        var deferred = new $.Deferred();
        if((!_.isUndefined(this.eventsVersionToUse) && this.eventsVersionToUse === 1)) {
            $.when(this.sync("create", {silent: true}))
                .done(function () {
                    deferred.resolve();
                })
                .fail(function() {
                    deferred.reject();
                });
        } else {
            var self = this;

            $.when(this.sync("create", {silent: true}))
                .done(function (resp) {
                    self.set({channelid: resp.status.channelid});
                    swc.models.EventDispatcher.eventManagerListener.set({status: resp.status});
                    deferred.resolve();
                })
                .fail(function() {
                    deferred.reject();
                });

        }

        return deferred.promise();
    }
});

/**
* This is just a helper Object to be passed into EventManagerListener
*/
swc.constructors.StargateEvent = swc.BaseModel.extend();

swc.constructors.EventManagerListener = swc.BaseCollection.extend({

    url: "/ws",

    model: 'StargateEvent',

    ajaxSettings: {
        requestType: 'POST',
        requestDataType: 'json',
        contentType: "application/x-sah-ws-4-call+json"
    },

    defaults: {
        service: "eventmanager",
        method: "get_events",
        parameters: {
            "channelid": 0, // mark that subscription channel should be crerated
            "events": []
        }
    },

    eventsVersionToUse: 2,

    initialize: function() {
        if((!_.isUndefined(arguments[0]) && arguments[0].eventsVersionToUse === 1)) {
            this.eventsVersionToUse = 1;
            this.ajaxSettings.contentType = "application/x-sah-event-1-call+json";
            this.defaults = {
                "channelid": 0, // mark that subscription channel should be crerated
                "events": []
            };
        } else {
            this.eventsVersionToUse = 2;
            this.ajaxSettings.contentType = "application/x-sah-ws-4-call+json";
            this.defaults = {
                service: "eventmanager",
                method: "get_events",
                parameters: {
                    "channelid": 0, // mark that subscription channel should be crerated
                    "events": []
                }
            };
        }
        swc.BaseCollection.prototype.initialize.apply(this, arguments);
    },

    apiToJSON: function (response) {
        /**
         * Example response would be:
         * {"channelid":12,"events":[{"data":{"handler":"Screen","object":{"reason":"PasswordRecovery","attributes":{"response":"Allowed"}}}}]}
         */
        var result = [];

        if (!_.isEmpty(response.events)) {
            _.each(response.events, function (elem) {
                result.push({
                    "handler": elem.data.handler,
                    "reason": elem.data.object.reason,
                    "attributes": elem.data.object.attributes
                });
            });
        }

        return result;
    },

    setAjaxParameters: function (ajaxParameters) {
        this.ajaxParameters = ajaxParameters;
    },

    /**
     * Listen to subscribed events using currently opened channel
     */
    listenChannel: function() {
        var deferred = new $.Deferred();
        if((!_.isUndefined(this.eventsVersionToUse) && this.eventsVersionToUse === 1)) {
            $.when(this.sync("read", {silent: false}))
                .done(function () {
                    deferred.resolve();
                })
                .fail(function() {
                    deferred.reject();
                });
        } else {
            var self = this;

            $.when(this.sync("read", {silent: false}))
                .done(function (resp) {
                    self.set({events: resp.status.events});
                    deferred.resolve();
                })
                .fail(function() {
                    deferred.reject();
                });
        }

        return deferred.promise();
    }
});
;swc.constructors.LoginModel = Backbone.Model.extend({

    adminName: "admin",

    appScript: ["/application/app.min.js?v=05.01.19-689"],

    /**
     * Check if user is logged in:
     *
     * @description user login is stored in two cookies {contextID} and {.../sessid}
     *
     * @return {Boolean}
     *
     */
    checkUserLogin: function() {
        var deviceID = swc.Utils.getDeviceID();

        if (!deviceID || !$.cookie(deviceID + '/context')) {
            return false;
        } else {
            return true;
        }
    },
    
    checkIfLoggedIn: function() {
        var result = true;
        $.ajax({
            type: 'POST',
            headers: {
                'X-Context': $.cookie(swc.Utils.getDeviceID() + '/context'),
                'Authorization': 'X-Sah ' + $.cookie(swc.Utils.getDeviceID() + '/context'),
                'X-Sah-Request-Type': "idle",
                'idle': true
            },
            url: '/sysbus/Time:getTime',
            timeout: 2000,
            async: false,
            data: {
                "parameters": {}
            },
            success: function(response) {
                if(!_.isUndefined(response.errors) && !_.isNull(response.errors)) {
                    result = false;
                }
            },
            error: function() {
                result = false;
            }
        });
        return result;
    },

    /**
     * Check if the user is logged in via checking response message
     *
     * @description:
     *
     * if the response from device contains text "Permission denied" then
     * user is not logged in and the logout process should be started
     *
     * @param xhr {xmlHttpRequest} Response from device
     */
    checkAccessToDevice: function(xhr) {
        var errorText = 'Permission denied';

        if (_.isUndefined(xhr)) {
            swc.models.Login.processLogout({ action: 'session-logout' });
            return;
        }

        if (!_.isUndefined(xhr.responseText) && _.isString(xhr.responseText) && xhr.responseText.indexOf(errorText) !== -1) {
            swc.models.Login.processLogout({ action: 'session-logout' });
            return;
        }

        if (!_.isUndefined(xhr.errors) && !_.isEmpty(xhr.errors) && !_.isEmpty(_.where(xhr.errors, { description: errorText }))) {
            swc.models.Login.processLogout({ action: 'session-logout' });
        }
    },

    /**
     * Check if user is super admin
     * @returns {boolean}
     */
    checkUserSuperAdmin: function() {
        var isSuperAdmin = false;

        if(swc.Utils.isCookieSupport()) {
            if (!_.isNull(localStorage.getItem('userSuperAdmin')) && localStorage.getItem('userSuperAdmin')) {
                isSuperAdmin = true;
            }
        }

        return isSuperAdmin;
    },

    /**
     * Change password. It is needed in System and Login
     * @param password
     * @returns {*}
     */

    changePassword: function(password){
        var self = this,
            deferred = new $.Deferred();

        swc.models.Rest.sendRequest({
            url: '/sysbus/NMC:changePassword',
            method: 'POST',
            contentType: 'application/x-sah-ws-1-call+json',
            data: {
                parameters: {
                    name: self.adminName,
                    password: password
                }
            },

            success: function(response) {
                if (response.errors && response.errors.length > 0) {
                    deferred.reject(response.errors[0].description);
                } else {
                    deferred.resolve();
                }
            }
        });

        return deferred.promise();

    },

    /**
     * Remove application cookies
     */
    removeCookies: function(){
        var deviceID = swc.Utils.getDeviceID();

        // Expire all SAH cookies
        $.cookie(deviceID + '/context', '', { expires: -1 });

        // Expire all SWC cookies
        $.cookie('swc/deviceID', '', { expires: -1 });
    },

    /**
     * Sign-out user and release context on NP side
     * @param options {Object|null} Possible values:
     *                              - action : defines how signing out was performed - by session timeout or manually
     *                              - redirectUrl : if we have to redirect user to some url after have signed them out
     * @returns {*|Promise.promise}
     */
    processLogout: function(options) {
        var self = this;

        // preventing multiple logout processing
        if (swc.models.Login.checkIfLoggedIn()) {
            // Only do local sign-out post-processing if successfully signed-off on NP side
            // Release current context on NP side
            $.when(swc.models.Rest.sendRequest({
                    url: '/ws',
                    method: 'POST',
                    headers: {
                        "Authorization": "X-Sah-Logout " + $.cookie(swc.Utils.getDeviceID() + '/context'),
                        'X-Context': $.cookie(swc.Utils.getDeviceID() + '/context')
                    },
                    data: {
                        service: "sah.Device.Information",
                        method: "releaseContext",
                        parameters: {
                            applicationName: "webui"
                        }
                    }
                }))
                .always(function () {
                    self.setLogoutState(options);
                });
        } else {
            this.setLogoutState(options);
        }
    },

    /**
     * Set application state after logout
     *
     * @description:
     *
     * This method perform following actions:
     * 1.Sets application env variables to appropriate state(action-logout, session-logout,
     *   reset-logout) in the localStorage
     * 2.Removes session cookies
     * 3.Triggers events: beforeLogout, afterLogout
     * 4.Redirects on the login/remoteLogin page
     *
     * @localParam router {swc.constructors.Router | Backbone.history} When user is not logged in
     *             and tries to navigate on the some inside page, e.g. http://localhost:3000/#storage/settings,
     *             the swc.constructors.Router is not exist and it's not possible to use its method
     *             navigate(). In this case should be used the method navigate() of the Backbone.history object
     *
     * @param options {Object} addition logout options
     * Param <options> can accept two keys:
     *   - action - defines the source which has initialized logout action.
     *              Can accept the following values:
     *              * user-logout - action initiated by user themself by clicking on "Logout" button
     *              * session-logout - session expired on server
     *              * reset-logout - when i-Box redirected after 'Upgrade'/'Restore Config'/'FactoryReset' operations
     *
     *   - redirectUrl - if after logout user should be redirected to some page
     *
     * @return void
     */
    setLogoutState: function(options) {
        var self = this,
            currentPage = Backbone.history.fragment,
            userIsSuperAdmin = this.checkUserSuperAdmin(),
            router = _.isUndefined(swc.router) ? Backbone.history : swc.router,
            doRouterTrigger = _.isUndefined(swc.router) ? true : false;

        // Local logout procedure starts here
        self.removeCookies();

        // WARNING!!!
        // DO NOT REMOVE THIS BLOCK OF CODE!
        // Sometimes we just must redirect user's browser to some url in order to refresh index.html page
        if (options && options.redirectUrl) {
            localStorage.setItem('previous-page', 'overview');
            // Set flag back that this user was logged in remotely
            var loginPageUrl = "/";
            if (userIsSuperAdmin) {
                localStorage.setItem('remoteLogin', true);
                loginPageUrl = loginPageUrl + "#remote-login";
            }
            document.location.href = options.redirectUrl + loginPageUrl;

            return;
        }

        // Let listeners know that we are about to sign out
        self.trigger('beforeLogout');

        // Hide all modals and popovers
        SWCElements.modalWindow.hide();
        SWCElements.popovers.closeAll();

        // We have to navigate user to correct page after logout / session logout / not logged in access
        if (options && options.action) {
            switch (options.action) {
                case 'user-logout':
                    localStorage.setItem('action-logout', 'true');
                    break;
                case 'session-logout':
                    localStorage.setItem('session-logout', 'true');
                    break;
                case 'reset-logout':
                    localStorage.setItem("reset-logout", 'true');
                    break;
                default:
                    localStorage.setItem('session-logout', 'true');
                    break;
            }

            localStorage.setItem('previous-page', 'overview');
        } else {
            if (!localStorage.getItem('previous-page') || localStorage.getItem('previous-page') === "overview") {
                localStorage.setItem('previous-page', Backbone.history.fragment);
            }
        }

        // Set flag back that this user was logged in remotely
        if (userIsSuperAdmin) {
            localStorage.setItem('remoteLogin', true);
        }

        // Update current application page:
        if (currentPage !== 'login' && currentPage !== 'remote-login') {
            if (!_.isNull(localStorage.getItem('remoteLogin'))) {
                if (currentPage !== 'remote-login') {
                    router.navigate('remote-login', { trigger: doRouterTrigger, skipUnsavedChanges: true });
                }
            } else {
                if (currentPage !== 'login') {
                    router.navigate('login', { trigger: doRouterTrigger, skipUnsavedChanges: true });
                }
            }
        }

        self.trigger('afterLogout');
    },

    /**
     * Process user login:
     *
     * @param login {String}
     * @param password {String}
     *
     */
    processLogin: function(login, password) {
        var self = this, deferred = new $.Deferred();

        swc.models.Rest.sendRequest({
            url: '/ws',
            timeout: 1000,
            method: 'POST',
            contentType: 'application/x-sah-ws-4-call+json',

            headers: {
                Authorization: 'X-Sah-Login'
            },

            data: {
                service: "sah.Device.Information",
                method: "createContext",
                parameters: {
                    applicationName: "webui",
                    username: login,
                    password: password
                }
            },

            success: function(response) {
                if (response.status === 0) {
                    // load app.js if it is not loaded
                    require(self.appScript, function() {

                        // load app.js
                        var deviceID = swc.Utils.getDeviceID();
                        
                        // Set Device ID Cookie
                        // In order to define not deleted cookies from previous logins by old device ID
                        $.cookie('swc/deviceID', deviceID);
                        
                        // Set Context Cookie
                        $.cookie(deviceID + '/context', response.data.contextID);
                        
                        // Let application know if user is super admin
                        if (login === "superadmin") {
                            localStorage.setItem('userSuperAdmin', true);
                        } else {
                            localStorage.removeItem('userSuperAdmin');
                        }
                        
                        deferred.resolve({status: true, response: response});

                        //self.loginStatusListener();
                    });
                } else {
                    deferred.resolve({status: false, response: response});
                }
            },

            error: function() {
                deferred.reject();
            }
        });

        return deferred.promise();
    },

    /**
     * Listener for user login status:
     */
    /*loginStatusListener: function() {
        var self = this,
            interval = 10,  // seconds
            onRequestComplete = function() {
                var userLogin = self.checkUserLogin();

                if (!userLogin) {
                    self.processLogout({ action: 'session-logout' });
                } else {
                    setTimeout(function() {
                        self.loginStatusListener();
                    }, interval * 1000);
                }
            };

        swc.models.Rest.sendRequest({
            url: '/sysbus/Time:getTime',
            fromListener: true,
            timeout: 2000,
            data: {
                "parameters": {}
            },
            success: onRequestComplete,
            error: onRequestComplete
        });
    },*/

    /**
     * Get device recovery status - true or false
     * @returns {*}
     */
    getRecoveryStatus: function(){
        var self = this, deferred = new $.Deferred();

        swc.models.Rest.sendRequest({
            url: '/sysbus/PasswordRecovery:getStatus',
            method: 'POST',
            contentType: 'application/x-sah-ws-1-call+json',
            data: {
                parameters: {}
            },

            /**
             * NOTE:
             * NP returns response as such: {result: {status: [1, "Enable"]}},
             * where first element of array is true|false indicating either feature is enabled at all.
             * Second element indicates what is the current status of recovery:
             * "Enable" - we can start a new process; "Processing" - means there is a process in-progress.
             */
            success: function(response) {
                if (!_.isUndefined(response.result) && !_.isUndefined(response.result.status)) {
                    self.set('recoveryEnable', response.result.status[0]);
                    self.set('recoveryStatus', response.result.status[1]);
                } else {
                    self.set('recoveryEnable', false);
                    self.set('recoveryStatus', null);
                }
                deferred.resolve();
            },

            error: function() {
                self.set('recoveryEnable', false);
                self.set('recoveryStatus', null);
                deferred.resolve();
            }
        });

        return deferred.promise();
    },

    /**
     * Set device recovery status
     *
     * @param {Boolean} isEnable
     *
     * @returns {*}
     */
    setRecoveryStatus: function(isEnable){
        var deferred = new $.Deferred();

        swc.models.PasswordRecovery.set("recoveryEnable", isEnable);
        $.when(swc.models.PasswordRecovery.sync("update"))
            .done(function () {
                deferred.resolve();
            })
            .fail(function () {
                deferred.reject();
            });

        return deferred.promise();
    }

});
;swc.constructors.PasswordRecovery = swc.BaseModel.extend({

    userName: "admin",

    url: {
        "read": "/sysbus/PasswordRecovery:getStatus",
        "update": "/sysbus/PasswordRecovery:setEnable"
    },

    defaults: {
        'recoveryEnable': false,
        'recoveryStatus': null
    },

    validation: {
        password: function (data) {
            var validationMessages = [],
                validationData = swc.Utils.getDataToValidate({
                    'newPassword': { elementName: 'new-password' }
                }, data);

            // Check if password contains not allowed characters:
            if (!swc.Utils.validatePassword(validationData['newPassword'])) {
                validationMessages.push('invalid characters');
            }

            return {
                status: _.isEmpty(validationMessages),
                messages: validationMessages
            };
        },

        passwordConfirm: function (data) {
            var validationMessages = [],
                validationData = swc.Utils.getDataToValidate({
                    'newPassword': { elementName: 'new-password' },
                    'newPasswordConfirm': { elementName: 'new-password-confirm' }
                }, data),
                newPasswordConfirm = validationData['newPasswordConfirm'];
             
            // Do not check match until first password will be valid
            var passwordValid = swc.Utils.validatePassword(validationData['newPassword']);
            if(!passwordValid) {
                return {
                    status: false,
                    messages: validationMessages
                };
            }
            
            // If confirm is empty - it is valid
            if(_.isEmpty(newPasswordConfirm)) {
                return {
                    status: true
                };
            }
                        
            // Check if password match:
            if (validationData['newPassword'] !== newPasswordConfirm) {
                validationMessages.push('does not match');
            }

            return {
                status: _.isEmpty(validationMessages),
                messages: validationMessages
            };
        }
    },

    apiToJSON: function (response) {
        if (!response || !response.status) {
            return {
                recoveryEnable: false,
                recoveryStatus: false
            };
        }
        return {
            recoveryEnable: response.status[0],
            recoveryStatus: response.status[1]
        };
    },

    toJSON: function () {
        return {
            parameters: {
                Enable: this.get('recoveryEnable')
            }
        };
    },

    /**
     * Short method to check if Recovery Process is currently running
     *
     * @returns {boolean}
     */
    isRecoveryRunning: function() {
        return this.get("recoveryStatus") === "Processing";
    },

    startProcess: function () {
        var deferred = new $.Deferred();

        swc.models.Rest.sendRequest({
            url: '/sysbus/PasswordRecovery:start',
            data: {
                parameters: {}
            },

            success: function () {
                deferred.resolve();
            },

            error: function () {
                deferred.reject();
            }
        });

        return deferred.promise();
    },

    stopProcess: function () {
        var deferred = new $.Deferred();

        swc.models.Rest.sendRequest({
            url: '/sysbus/PasswordRecovery:stop',
            data: {
                parameters: {}
            },

            success: function () {
                deferred.resolve();
            },

            error: function () {
                deferred.reject();
            }
        });

        return deferred.promise();
    },

    setNewPassword: function(password) {
        var deferred = new $.Deferred();

        swc.models.Rest.sendRequest({
            url: '/sysbus/PasswordRecovery:setPassword',
            data: {
                parameters: {
                    password: password
                }
            },

            success: function(response) {
                // When feature was not triggered then it is not allowed to set new password,
                // an error like "wrong state the feature is disabled or not started" will be returned
                if (!_.isUndefined(response.errors) && response.errors.length > 0) {
                    deferred.reject(response.errors[0].description);
                } else {
                    deferred.resolve(response.status);
                }

            },

            error: function (xhr, error, errorMsg) {
                deferred.reject(errorMsg);
            }
        });

        return deferred.promise();
    },

    forgetChannelId: function () {
        sessionStorage.removeItem("eventManager:channelId");
    }
});
;swc.constructors.System = Backbone.Model.extend({

    apBootTime: 100000, // 2 minutes
    minExpectedRebootTime: 160000, // 2 minutes 40 seconds
    maxExpectedRebootTime: 240000, // 4 minutes

    sync: function(fromListener, failOverLoop){
        var self = this,
            deferred = new $.Deferred(),
            timeout = 5000;

        if(!_.isUndefined(failOverLoop)) {
            timeout = 10000;
        }

        // As there are no request in the $.when() function which checks
        // session state the checkSessionState() method should wrap them
        self.checkSessionState(function(result) {
            if(result === true) {
                $.when(self.identifyGateway(fromListener, timeout), self.getFirmware(fromListener, timeout))
                    .done(function () {
                        if(_.isUndefined(failOverLoop)) {
                            self.set('errorStatus', false);
                            deferred.resolve();
                        } else {
                            deferred.resolve(true);
                        }
                    });
            } else {
                $.when(self.identifyGateway(fromListener, timeout), self.getFirmware(fromListener, timeout))
                    .done(function () {
                        if(_.isUndefined(failOverLoop)) {
                            self.set('errorStatus', true);
                            deferred.resolve();
                        } else {
                            deferred.resolve(false);
                        }
                    });
                //deferred.reject();
            }
        }, timeout);

        return deferred.promise();
    },

    /**
     * Calculates quantity of days, hours and minutes from provided seconds
     * This method used to display smth. like "up" time, or "connected for" time
     *
     * @param seconds
     *
     * @returns {Object} {d - days, h - hours, m - minutes}
     */
    makeUpTime: function(seconds){
        var timeObj = {},
            leftForHours = seconds % 86400,
            leftForMinutes = leftForHours % 3600;

        timeObj.d = Math.floor(seconds / 86400);
        timeObj.h = Math.floor(leftForHours / 3600);
        timeObj.m = Math.floor(leftForMinutes / 60);

        return timeObj;
    },

    identifyGateway: function(fromListener, timeout){
        var self = this,
            deferred = new $.Deferred();

        swc.models.Rest.sendRequest({
            url: '/sysbus/DeviceInfo:get',
            data: {
                parameters: {}
            },
            fromListener: fromListener,
            timeout: timeout,

            success: function(response) {
                var data = response['status'];

                if (!data) {
                    return;
                }

                self.set({
                    'manufacturer': data.Manufacturer,
                    'NPVersion': data.SoftwareVersion,
                    'externalIP': data.ExternalIPAddress,
                    'upTime': self.makeUpTime(data.UpTime),
                    'serialNumber': data.SerialNumber,
                    'model': data.ModelName,
                    'ProductClass': data.ProductClass
                });

                deferred.resolve(data);
            },

            error: function() {
                deferred.resolve();
            }
        });

        return deferred.promise();
    },

    getGatewayType: function() {
        var ret = {};
        var restClient = new swc.constructors.Rest();
        restClient.sendRequest({
            url: '/sysbus/DeviceInfo:get',
            data: {
                parameters: {}
            },
            async: false,
            success: function(data) {
                ret.ProductClass = data.status.ProductClass;
                ret.NPVersion = 'NP6';
            }
        });

        return ret;
    },

    rebootGateway: function(timeout){
        var self = this,
            deferred = new $.Deferred();

        swc.models.Rest.sendRequest({
            url: '/sysbus/NMC:reboot',
            data: {"parameters":{}},
            success: function() {
                deferred.resolve();
                setTimeout(function(){
                    if (swc.models.apServiceState.isEnabled()) {
                        // self.whenApUp(self.doLogout);
                        self.doLogout();
                    } else {
                        self.whenDeviceUp(self.doLogout);
                    }
                }, timeout || self.minExpectedRebootTime);
            },
            error: function () {
                deferred.reject();
            }
        });

        return deferred.promise();
    },

    resetGateway: function(timeout){
        var self = this,
            deferred = new $.Deferred();

        swc.models.Rest.sendRequest({
            url: '/sysbus/NMC:reset',
            method: 'POST',
            formatRule: 'jsonType',
            contentType: 'application/x-sah-ws-4-call+json',
            data: {"parameters":{}},

            success: function(response) {
                if(!response.status){
                    deferred.reject();
                } else {
                    deferred.resolve();
                    setTimeout(function () {
                        if (swc.models.apServiceState.isEnabled()) {
                            // self.whenApUp(self.doReset);
                            self.doReset();
                        } else {
                            self.whenDeviceUp(self.doReset);
                        }
                    }, timeout || self.minExpectedRebootTime);
                }
            },
            error: function() {
                deferred.reject();
            }
        });

        return deferred.promise();
    },

    whenDeviceUp: function (callback) {
        var self = this;

        if (self.rebootCheckInterval) {
            return;
        }
        this.checkInProcess = false;

        this.doCheckDeviceUp(callback);
        this.rebootCheckInterval = setInterval(function () {
            self.doCheckDeviceUp(callback);
        }, 5000);
    },

    doCheckDeviceUp: function (callback) {
        var self = this;

        if (this.checkInProcess) {
            return;
        }
        this.checkInProcess = true;

        $.ajax({
            url: '/sysbus/DeviceInfo:get',
            type: 'post',
            data: {"parameters":{}},
            timeout: 5000,

            success: function (response) {
                var data = response['status'];
                if (data && data.DeviceStatus === 'Up') {
                    clearInterval(self.rebootCheckInterval);
                    self.rebootCheckInterval = null;
                    self.trigger('device:up');
                    callback();
                }
            },

            complete: function () {
                self.checkInProcess = false;
            }
        });
    },

    whenApUp: function (callback) {
        var self = this;

        if (self.rebootCheckInterval) {
            return;
        }
        this.checkInProcess = false;

        this.doCheckApUp(callback);
        this.rebootCheckInterval = setInterval(function () {
            self.doCheckApUp(callback);
        }, 5000);
    },

    /**
     * Polls NP and check if AP is "Up" and running.
     * Calls callback if AP is "Up"
     *
     * @param callback
     */
    doCheckApUp: function (callback) {
        var self = this;

        if (this.checkInProcess) {
            return;
        }

        this.checkInProcess = true;

        $.when(swc.models.apServiceLoadingState.fetch())
            .done(function(){
                if (swc.models.apServiceLoadingState.isApStarted()) {
                    clearInterval(self.rebootCheckInterval);
                    self.rebootCheckInterval = null;
                    self.trigger('ap:up'); // maybe we will need it? Copied from whenDeviceUp(), not sure if needed.
                    callback();
                }
            })
            .fail(function() {
                // TODO: What?
            })
            .always(function(){
                self.checkInProcess = false;
            });
    },

    doLogout: function() {
        swc.models.Login.processLogout({ 'redirectUrl': swc.settings.application.get("url"), action: 'reset-logout' });
    },

    doReset: function() {
        // clean local storage with saved language
        localStorage.removeItem('locale');
        swc.models.Login.processLogout({ 'redirectUrl': swc.settings.application.get("url"), action: 'reset-logout' });
    },

    upgradeGateway: function(formdata){
        var deferred = new $.Deferred();

        swc.models.Rest.sendRequest({
            url: '/webuiUpgrade',
            timeout: 360000,
            contentType: false,
            processData: false,
            data: formdata,
            headers: {
                "X-Context": $.cookie(swc.Utils.getDeviceID() + '/context')
            },

            success: function(response) {
                var resp = $(response).text();
                if(resp.indexOf('200') >= 0){
                    deferred.resolve();
                } else {
                    deferred.reject();
                }
            },

            error: function(){
                deferred.reject();
            }
        });

        return deferred.promise();
    },

    getLogs: function(){
        var deferred = new $.Deferred();

        swc.models.Rest.sendRequest({
            url: '/ws',
            method: 'POST',
            contentType: 'application/x-sah-ws-4-call+json',
            data: {
                "service":"com.swisscom.stargate/ws/system.com.swisscom.stargate.system",
                "method":"getLogsURL",
                "parameters": {}
            },

            success: function(response) {
                deferred.resolve();
                var data = JSON.parse(response.status);
                document.location.href = data.data.url;
            }
        });

        return deferred.promise();
    },

    getFirmware: function(fromListener, timeout){
        var self = this,
            deferred = new $.Deferred();

        if(swc.Utils.DeviceType !== 'default') {
			self.set('APVersion', false);
			deferred.resolve();
			return deferred.promise();
        }

        swc.models.Rest.sendRequest({
            url: '/ws',
            fromListener: fromListener,
            timeout: timeout,
            data: {
                "service":"APController",
                "method":"getSoftWareVersion",
                "parameters": {}
            },

            success: function(response) {
                if(response.status){
                    var data = response.data;
                    self.set('APVersion', data.version);
                    $('body').addClass("AP" + data.version.substring(1,2));
                } else {
                    self.set('APVersion', false);
                }

                deferred.resolve();
            },

            error: function() {
                self.set('APVersion', false);
                deferred.resolve();
            }
        });

        return deferred.promise();
    },

    configBackup: function(){
        var deferred = new $.Deferred();

        swc.models.Rest.sendRequest({
            url: '/backup?nocache',
            method: 'GET',
            timeout: 200000,

            success: function() {
                deferred.resolve();
            }
        });

        return deferred.promise();

    },

    configBackupACS: function(){
        var deferred = new $.Deferred();

        swc.models.Rest.sendRequest({
            url: '/sysbus/NMC/NetworkConfig:launchNetworkBackup',
            timeout: 200000,

            data: {
                "parameters": {}
            },

            success: function() {
                deferred.resolve();
            },

            error: function () {
                deferred.reject();
            }
        });

        return deferred.promise();
    },

    /**
     * Updates the session cookies from the server.
     * Is used to check if the session is still valid at the server side.
     * Calls callback function in case of success.
     * Initiates client logout in case of fail.
     *
     * @param callback
     *
     * @returns void
     */
    checkSessionState: function(callback, timeout) {
        swc.models.Rest.sendRequest({
            url: '/sysbus/Time:getTime',
            fromListener: true,
            timeout: timeout,

            data: {
                "parameters": {}
            },

            success: function(response) {
                swc.models.Login.checkAccessToDevice(response);
                if (swc.models.Login.checkIfLoggedIn() && _.isFunction(callback)) {
                    callback(true);
                }
            },

            error: function(xhr) {
                swc.models.Login.checkAccessToDevice(xhr);
                callback(false);
            }
        });
    },

    /**
    * Update session on the device
    *
    * @description: sometimes it is necessary to refresh session
    * on the device according user action which doesn't fetch any
    * data from the device
    * fromListener set to true to allow idle:true
    */
    updateSessionState: function() {
        swc.models.Rest.sendRequest({
            url: '/sysbus/Time:getTime',
            fromListener: true,
            timeout: 2000,

            data: {
                "parameters": {}
            },

            success: function(response) {
                swc.models.Login.checkAccessToDevice(response);
            },

            error: function(xhr) {
                swc.models.Login.checkAccessToDevice(xhr);
            }
        });
    },

    updateSessionStatePromise: function() {
        var deferred = new $.Deferred();

        swc.models.Rest.sendRequest({
            url: '/sysbus/Time:getTime',
            fromListener: true,
            timeout: 2000,

            data: {
                "parameters": {}
            },

            success: function(response) {
                deferred.resolve();
                swc.models.Login.checkAccessToDevice(response);
            },

            error: function(xhr) {
                deferred.reject();
                swc.models.Login.checkAccessToDevice(xhr);
            }
        });
        return deferred.promise();
    }
});

;swc.constructors.UserManagement = swc.BaseModel.extend({

    userName: "admin",

    groups: [ "http", "admin" ],

    validation: {
        currentPassword: function(data) {

            var deferred = new $.Deferred(),
                validationData = swc.Utils.getDataToValidate({
                    'password': { elementName: 'current-password' },
                    'newPassword': { elementName: 'new-password' },
                    'newPasswordConfirm': { elementName: 'new-password-confirm' }
                }, data);

            // Skip validation when passwords section not changed:
            if (_.isEmpty(validationData['password']) && _.isEmpty(validationData['newPassword']) &&
                _.isEmpty(validationData['newPasswordConfirm'])) {
                return { status: true, messages: [] };
            }

            // Check if password is correct: (validated by server)
            $.when(swc.models.UserManagement.checkPassword(validationData['password']))
                .always(function(status) {
                    if (status) {
                        deferred.resolve();
                    } else {
                        deferred.reject({
                            status: false,
                            messages: [ 'invalid password' ]
                        });
                    }
                });

            return deferred.promise();
        },

        newPassword: function(data) {
            var validationMessages = [],
                validationData = swc.Utils.getDataToValidate({
                    'password': { elementName: 'current-password' },
                    'newPassword': { elementName: 'new-password' },
                    'newPasswordConfirm': { elementName: 'new-password-confirm' }
                }, data);

            // Skip validation when passwords section not changed:
            if (_.isEmpty(validationData['password']) && _.isEmpty(validationData['newPassword']) &&
                _.isEmpty(validationData['newPasswordConfirm'])) {
                return { status: true, messages: [] };
            }

            // Check if password contains not allowed characters:
            if (!swc.Utils.validatePassword(validationData['newPassword'])) {
                validationMessages.push('invalid characters');
            }

            return {
                status: _.isEmpty(validationMessages),
                messages: validationMessages
            };
        },

        newPasswordConfirm: function(data) {
            var validationMessages = [],
                validationData = swc.Utils.getDataToValidate({
                    'password': { elementName: 'current-password' },
                    'newPassword': { elementName: 'new-password' },
                    'newPasswordConfirm': { elementName: 'new-password-confirm' }
                }, data);

            // Skip validation when passwords section not changed:
            if (_.isEmpty(validationData['password']) && _.isEmpty(validationData['newPassword']) &&
                _.isEmpty(validationData['newPasswordConfirm'])) {
                return { status: true, messages: [] };
            }

            // Check if password match:
            if (validationData['newPassword'] !== validationData['newPasswordConfirm']) {
                validationMessages.push('does not match');
            }

            return {
                status: _.isEmpty(validationMessages),
                messages: validationMessages
            };
        }
    },

    checkPassword: function(password){
        var self = this,
            deferred = new $.Deferred();

        swc.models.Rest.sendRequest({
            url: '/sysbus/UserManagement:authenticate',
            method: 'POST',
            contentType: 'application/x-sah-ws-1-call+json',
            data: {
                "parameters": {
                    "name": self.userName,
                    "password": password,
                    "groups": self.groups
                }
            },

            success: function(response) {
                deferred.resolve(response.result.status);
            },

            fail: function() {
                deferred.reject(false);
            }
        });

        return deferred.promise();
    },

    changePassword: function(password) {
        var self = this,
            deferred = new $.Deferred();

        swc.models.Rest.sendRequest({
            url: '/sysbus/NMC:changePassword',
            method: 'POST',
            contentType: 'application/x-sah-ws-1-call+json',
            data: {
                parameters: {
                    name: self.userName,
                    password: password
                }
            },

            success: function(response) {
                if (response.errors && response.errors.length > 0) {
                    deferred.reject(response.errors[0].description);
                } else {
                    deferred.resolve();
                }
            },

            fail: function() {
                deferred.reject(false);
            }
        });

        return deferred.promise();
    }
});
;swc.constructors.ApplicationView = swc.base.PageView.extend({

    /**
     * Current view class name:
     */
    className: 'application',

    /**
     * Events listener setup
     */
    events: {
        'click .logout': 'logout',
        'swc-dropdown:change .locale-selector': 'setLocale',
        'swc-radio-buttons:change #user-mode-switcher': 'switchUserMode'
    },
    
    names: ['Andreas', 'Simon', 'Daniel', 'Marcel', 'Timo', 'Nicolas', 'Beat', 'Antonio', 'Antoine', 'Carmen', 'Petra', 'Thomas', 'Jurg', 'Christian', 'Severin', 'Bruno', 'Diego', 'Stefan', 'Guido', 'Cyril', 'Kim', 'Philippe', 'Dirk', 'Peter', 'Mario', 'Raffaele', 'Roman', 'Ben', 'Chait', 'Dev', 'Sam', 'Paul', 'Thierry', 'Christophe', 'Isabelle', 'Dominique', 'Olivier', 'Rusco', 'Henry', 'Jessie', 'Tina', 'Eva', 'Robert', 'Allan', 'Anderson', 'LH', 'Dickson', 'Tomek', 'Oleg', 'Igor', 'Alex', 'Andrey', 'Dimitry', 'Nelson', 'Kamel', 'Younes', 'Nabil', 'Eric', 'Pierre', 'Dries', 'Benoit', 'Kassem', 'Wouter', 'David', 'Vincent', 'Jan', 'Xavier', 'Vincent', 'Cédric', 'Guillaume', 'Koen', 'Sylvain', 'Andry', 'Dariusz', 'Iulian', 'Tom', 'Koen', 'Abdel-Illah', 'François', 'Bastien', 'Julien', 'Grzegorz', 'Maxime', 'Son-Tchor', 'Yoann', 'Thomas', 'Robin', 'Saravanan', 'Filip', 'Soeland', 'Wissem', 'Nadia', 'Abdelkarim', 'Mustapha', 'Ali', 'Mourad', 'Anas', 'Mehdi', 'Rami', 'Mohamed', 'Mateusz', 'Pawel', 'Ania', 'Szymon', 'Tacciana', 'Kasia', 'Hanna', 'Wiktor', 'Hubert', 'Remek'],

    /**
     * Initialise function has to be overrided from the base page view because of routing address mismatch
     */
    initialize: function() {
        var layoutId = 'application';

        if (!swc.models.Login.checkIfLoggedIn()) {
            layoutId = 'login-layout';
        }
        
        this.prepareLayout(layoutId);
        
        this.bindKonami();
    },
    
    bindKonami: function() {
        var me = this,
            code = "38,38,40,40,37,39,37,39,66,65",
            kkeys = [];
        
        $(document).keydown(function(e){
            kkeys.push( e.keyCode );
            while (kkeys.length > code.split(',').length) {
                kkeys.shift();
            }
            if ( kkeys.toString().indexOf( code ) >= 0 ){
                me.showKonami();
            }
        });
        
        // append tag list
        var tagList = $('.tag-list'),
            li, a;
        _.each(me.names, function(name) {
            li = $('<li/>')
                .appendTo(tagList);
            a = $('<a/>')
                .attr('href', '#')
                .text(name)
                .appendTo(li);
        });
    },
    
    showKonami: function() {
        var width = $(window).width(),
            height = $(window).height(),
            radius = (width / height),
            options = {
                textColour: '#2d90ec',
                textHeight: 30,
                outlineMethod: 'block',
                initial: [0, 1],
                wheelZoom: false,
                noSelect: true,
                minSpeed: 0.005,
                maxSpeed: 0.005,
                radiusX: radius,
                noMouse: true,
                shuffleTags: true,
                depth: 1
            },
            tagsCanvas = $('#eeTagsCanvas'),
            canvas = $('#eeTags');
            
        tagsCanvas.on('click', function() {
            TagCanvas.Delete('eeTags');
            tagsCanvas.hide();
        });
        tagsCanvas.show();
        
        canvas.attr('width', width);
        canvas.attr('height', height);
        TagCanvas.Start('eeTags', 'tags', options);
        $('html, body').scrollTop(0);
    },

    prepareLayout: function(layoutId) {
        // First, we clean-up previous content
        if (swc.views.Application && swc.views.Application.contentArea) {
            swc.views.Application.contentArea.remove();
            this.addSessionUpdateListener();
        }

        this.template = $.template('loading', swc.Templates.get(layoutId).get('content'));
    },

    /**
     * Add listener which handles user's clicks inside application area or changing state of any UI element
     * and update session on the device.
     *
     * It is needed on Overview page or other pages where there is a background listener which sends IDLE header to NP.
     *
     * Event callback should not react oftener than once per minute,
     * thus _.throttle() used to satisfy such condition.
     */
    addSessionUpdateListener: function() {
        var interval = 60, // 1 minute
            systemModel = new swc.constructors.System(),
            eventsToListen = [ 'mouseup', 'keyup', 'click', 'swc-radio-buttons:change',
                       'swc-checkbox:change', 'swc-dropdown:change' ].join(" ");

            $('body').on(eventsToListen, _.throttle(function() {
                    // If user is not signed-in - nothing to prolongate
                    if (swc.models.Login.checkUserLogin()) {
                        systemModel.updateSessionState();
                    }
                }, interval * 1000)
            );
    },

    /**
     * Render function has to be overrided from the base page view because of it's specific
     */
    render: function() {},

    /**
     * Render main application area:
     */
    renderApplicationArea: function() {
        var self = this,
            userModeType = swc.settings.application.get('expertMode') ? 'expert' : 'standard',
            userSuperAdmin = swc.models.Login.checkUserSuperAdmin(),
            localesOptions = swc.models.Locale.getLocaleOptions();

        // Set content to application page:
        $('#application').html(this.$el.html(
            $.tmpl(self.template, {
                jenkins: swc.settings.application.get('jenkins') || {},
                localeStrings: swc.models.Locale.getLocaleStrings('application'),
                localeString: getTranslationStringsjQuery,
                formatDate: swc.models.Locale.formatDate,
                staticPagesLinks: swc.models.Locale.getStaticPagesLinks(),
                GlobalEnable: swc.models.Application.get('GlobalEnable')
            }))
        );

        // Set locale selector values:
        $('.locale-selector').data('options', localesOptions);
        $('.locale-selector').trigger('swc-dropdown:swc-change', swc.models.Locale.locale);

        // Define content area
        this.contentArea = $("#current-page");

        /**
         * TODO: Extract switch for Expert / Simple mode into separate method
         */

        // Check if user mode was selected in cookies
        if(swc.Utils.isCookieSupport()) {
            if (localStorage.userMode) {
                userModeType = localStorage.userMode;
    
                if (localStorage.userMode === 'expert') {
                    swc.settings.application.set('expertMode', true);
                } else {
                    swc.settings.application.set('expertMode', false);
                }
            }
        }

        // Set expert / standard mode to body:
        if (userModeType === 'standard') {
            $('body').removeClass('expert-mode-only').addClass('standard-mode');
        } else {
            $('body').addClass('expert-mode-only').removeClass('standard-mode');
        }

        // Add supper admin class to body to handle some features with CSS styles:
        $('body').toggleClass('superAdmin', userSuperAdmin);

        // Trigger mode switcher change
        $('#user-mode-switcher').trigger('swc-radio-buttons:swc-change', userModeType);

        this.delegateEvents();
    },

    /**
     * Update application mode basing on cookie values:
     */
    setApplicationMode: function() {
        var userModeType = swc.settings.application.get('expertMode') ? 'expert' : 'standard',
            body = $('body');

        if (userModeType === "expert") {
            body.addClass('expert-mode-only').removeClass('standard-mode');
        } else {
            body.removeClass('expert-mode-only').addClass('standard-mode');
        }
        
        return userModeType;
    },

    /**
     * Update menu links when navigating to the page:
     */
    setMenuActiveLink: function() {
        var page = Backbone.history.fragment.split('/'),
            baseLink = this.$('li.menu-' + page[0]),
            tabGroup, tabLink, tabLinkBefore, tabLinkAfter,
            hasSubMenu = baseLink.find('ul').size(),
            subMenuLink;

        // Set active state of link:
        baseLink.addClass('active').siblings().removeClass('active');
        baseLink.siblings().find('ul').hide();

        // Show submenu links if they are existing
        if (hasSubMenu) {
            baseLink.find('ul').show();
        }

        // Check if routing lvl more then 1:
        if (page.length > 1) {
            subMenuLink = baseLink.find('li.page-' + page[1]);

            // Set active state of submenu links
            subMenuLink.siblings().find('a').removeClass('active');
            subMenuLink.find('a').addClass('active');
        }

        // Check if routing lvl more then 2:
        if (page.length > 2) {
            tabGroup = this.$('.page-tabs');

            if (tabGroup.size()) {
                tabLink = tabGroup.find('li.tab-' + page[2]);
                tabLinkBefore = tabLink.prev();
                tabLinkAfter = tabLink.next();

                // Set tab state active
                tabLink.addClass('active no-bg').siblings().removeClass('active no-bg');

                if (tabLinkBefore.size()) {
                    tabLinkBefore.addClass('no-bg before');
                }

                if (tabLinkAfter.size()) {
                    tabLinkAfter.addClass('after');
                }
            }
        }
    },

    /**
     * User experience mode switcher
     *
     * @param e {Object}
     *
     */
    switchUserMode: function(e, value) {
        var me = this,
            currentView = swc.views.currentView,
            confirmLeave = new $.Deferred();

        var urlToStore = Backbone.history.fragment;

        swc.router.history.push(urlToStore);

        // Only go ahead if user confirmed their decision
        confirmLeave.promise().then(function() {
            var pathComponents = Backbone.history.fragment.split('/'),
            constructor, view;

            // Define user mode type
            if (value === 'standard') {
                swc.settings.application.set('expertMode', false);
                $('body').removeClass('expert-mode-only').addClass('standard-mode');
            } else {
                swc.settings.application.set('expertMode', true);

                $('body').addClass('expert-mode-only').removeClass('standard-mode');
            }

            localStorage.userMode = value;

            constructor = swc.router.buildConstructorNameFromPathComponents(pathComponents);

            view = constructor.deCapitalize();

            if(me.checkPermissions(swc.views[view]) === true) {
                swc.views[view].render();
            }
        }, function() {
            var userModeType = me.setApplicationMode();
            // Trigger mode switcher change
            $('#user-mode-switcher').trigger('swc-radio-buttons:swc-change', userModeType);
        });

        if (currentView && currentView.hasChanged()) {
            swc.router.saveChangesDialog(confirmLeave);
            return confirmLeave.promise();
        } else {
            confirmLeave.resolve();
        }
    },

    /**
     * Update application locale based on dropdown value
     */
    setLocale: function(e, value) {
        var self = this,
            oldLocale = swc.models.Locale.locale,
            currentView = swc.views.currentView;
        
        function commitLocale() {
            // Clear application content:
            $('#application').html('');

            // Show loading window:
            self.showPageLoading('Loading locale strings');

            // Re-render application
            swc.router.navigate(Backbone.history.fragment, { skipUnsavedChanges: true });
        }
        //set cookie language value
        swc.models.Locale.setLocaleCookie(value);
        $.when(swc.models.Locale.setLocale(value, true)).done(function() {
            // Check for not saved changes on page
            // temporally canceled checker on some pages
            if (currentView && currentView.hasChanged()) {
                SWCElements.modalWindow.show({
                    templateID: 'application:modal:locale-changes-confirm',
                    templateData: {
                        formatDate: swc.models.Locale.formatDate
                    },
                    localeStrings: swc.models.Locale.getLocaleStrings('application'),
                    className: 'confirm-changes',
        
                    onCancel: function() {
                        commitLocale();
                    },
        
                    onApply: function() {
                        SWCElements.modalWindow.hide();

                        swc.models.Locale.setLocale(oldLocale, true);
                        $('.locale-selector').trigger('swc-dropdown:swc-change', oldLocale);
                    }
                });
            } else {
                commitLocale();
            }
        });
    },

    /**
     * Logout from application
     */
    logout: function() {
        swc.models.Login.processLogout({ action: 'user-logout' });
    }
});
;swc.constructors.OldieView = swc.base.PageView.extend({

    className: 'oldie',

    pageTemplateID: 'oldie',

    preRender: function () {
        // Login View has special layout
        if (swc.views.Application.contentArea && swc.views.Application.contentArea.size()) {
            swc.views.Application.contentArea.remove();
            swc.views.Application.prepareLayout('login-layout');
        }
    },

    setTemplateData: function() {
        this.templateData = {
            localeStrings: swc.models.Locale.getLocaleStrings(),
            localeString: getTranslationStringsjQuery,
            formatDate: swc.models.Locale.formatDate
        };
    },
    
    checkPermissions: function() {
        // skip this, old IE version is visible for everyone
    }
});
;swc.constructors.SetPasswordView = swc.base.TabView.extend({

    className: 'gateway-login',

    events: {
        'swc-checkbox:change .show-password':   'onPasswordStatusChange',
        'swc-checkbox:change .change-recovery': 'onRecoveryStatusChange',

        'keyup input[name="new-password"]': 'onPasswordKeyUp',
        'keyup input.original': 'onPasswordsChange',
        'keyup input.copy':     'onPasswordsChange',
        'change input.original': 'onPasswordsChange',
        'change input.copy':     'onPasswordsChange'
    },
    
    origRecoveryEnable: null,

    setTemplateData: function() {
        this.origRecoveryEnable = swc.models.PasswordRecovery.get('recoveryEnable');
        this.templateData = {
            recoveryEnable: this.origRecoveryEnable
        };
    },
    
    isGlobaEnableChanged: function() {
        return (this.origRecoveryEnable !== swc.models.PasswordRecovery.get('recoveryEnable'));
    },

    /**
     * Adding handler for page elements after page has been rendered successfully:
     *
     * @description:
     *
     * When user changes password fields, they have to be validated, and if the validation completed successfully, the
     * password field must be marked with a green sign. Same if validation failed, green mark should be removed from the
     * input.
     */
    renderComplete: function() {
        var self = this,
            $currentPasswordInput = self.$('input[name="current-password"]'),
            $newPasswordInput = self.$('input[name="new-password"]'),
            $newPasswordConfirmInput = self.$('input[name="new-password-confirm"]');

        // Register validation listeners:
        self.registerValidationListener($currentPasswordInput);
        self.registerValidationListener($newPasswordInput);
        self.registerValidationListener($newPasswordConfirmInput);

        // Revalidate related fields:
        $newPasswordInput
            .on('validation-success', function() {
                // only if not empty
                if(!_.isEmpty($newPasswordConfirmInput.val())){
                    self.pageValidation($newPasswordConfirmInput);
                }
            });
    },

    /**
     * Handler for validation password fields:
     *
     * @description:
     *
     * When the user changes something in the password field, the value must be updated in the related hidden password
     * field. So when the user will toggle "show password" checkbox, he will see already updated password in both check
     * boxes. Also, this simplifies validation process.
     *
     * @param e {Object} -> event
     */
    registerValidationListener: function($element) {
        var self = this;

        // Check if element exists on the page:
        if (!$element.size()) {
            return;
        }

        // Add green mark when success validation happens:
        $element.on('validation-success', function() {
            $element.toggleClass('valid', !_.isEmpty($element.val()));

            // Re-validate form when all elements set to default state:
            if (self.pageCheckDefaultValues()) {
                self.resetValidationState();
            }

            self.setButtonsState();
        });

        // Remove green mark when validation fails:
        $element.on('validation-fail', function() {
            $element.removeClass('valid');
        });
    },

    /**
     * Handler for validation event triggered on the field:
     *
     * @description:
     *
     * When the page was reset to default values all validation messages should be cleared from the page
     */
    resetValidationState: function() {
        var self = this,
            $elements = [
                this.$('input[name="current-password"]'),
                this.$('input[name="new-password"]'),
                this.$('input[name="new-password-confirm"]')
            ];

        // Go through each element and clear it's validation state:
        _.each($elements, function($element) {
            if ($element.size()) {
                var $errorMessagesSection = self.$('.validation-message[data-parameter-name="' + $element.attr('name') + '"]');

                // Remove valitation errors from the element:
                $element.removeClass('valid validation-error');

                // Hide error messages section:
                $errorMessagesSection.hide();
                $errorMessagesSection.find('span').hide();
            }
        });
    },
    
    onPasswordKeyUp: function(e) {
        var element = $(e.target),
            value = element.val(),
            validElement = $('.password-section input[name=' + element.attr('name') + ']');

        validElement.toggleClass('valid', swc.Utils.validatePassword(value));
    },

    /**
     * Handler of changing password fields:
     *
     * @description:
     *
     * When the user changes something in the password field, the value must be updated in the related hidden password
     * field. So when the user will toggle "show password" checkbox, he will see already updated password in both inputs
     * [type="password"] and [type="text"]. Also, this simplifies validation process.
     *
     * @param e {Object} -> event
     */
    onPasswordsChange: function(e) {
        var currentPasswordInput = $(e.target),
            relatedPasswordInputs = this.$('.password-section input[name=' + $(e.target).attr('name') + ']');

        // Define which password input has to be updated:
        if (currentPasswordInput.hasClass('original')) {
            relatedPasswordInputs.filter('.copy').val(currentPasswordInput.val());
        } else {
            relatedPasswordInputs.filter('.original').val(currentPasswordInput.val());
        }

        this.setButtonsState();
    },

    /**
     * Handler of "show password" checkbox changing by the user.
     *
     * @note:
     *
     * when checkbox value set to <true> all passwords must be shown.
     *
     * @param e {Object} -> event
     * @param value {Boolean}
     */
    onPasswordStatusChange: function(e, value) {
        var $passwordOriginalInputs = this.$('.password-section .original'),
            $passwordCopyInputs = this.$('.password-section .copy');

        // Toggle password fields based on checkbox value (true || false)
        $passwordOriginalInputs.toggle(!value);
        $passwordCopyInputs.toggle(value);
    },

    /**
     * Handler of "enable password recovery" checkbox changing by the user.
     *
     * @description:
     *
     * When user disabled "Password Recovery" he must be shown the dialog, where he will confirm his changes.
     * If he will reject this changes, "enable password recovery" checkbox should be reverted to previous state,
     * else "enable password recovery" checkbox should stay in state chosen by the user.
     *
     * @param e {Object} -> event
     * @param value {Boolean}
     *
     * @return void
     */
    onRecoveryStatusChange: function(e, value) {
        var self = this,
            checkBox = this.$('.change-recovery');

        // Update password recovery status in the model:
        swc.models.PasswordRecovery.set('recoveryEnable', value);

        // Check if password recovery status disabled and show confirmation window:
        if (value === false) {
            SWCElements.modalWindow.show({
                templateID: 'system:settings:gateway:modal:on-recovery-status-change',
                templateData: {},
                className: 'gateway-on-recovery-change',

                onCancel: function() {
                    checkBox.trigger('swc-checkbox:swc-change', !value);
                    swc.models.PasswordRecovery.set('recoveryEnable', !value);
                    self.setButtonsState();
                },

                onApply: function() {
                    SWCElements.modalWindow.hide();
                }
            });
        }

        this.setButtonsState();
    },

    /**
     * Save page changes, when user presses "Save" button:
     *
     * @description:
     *
     * While saving page data, it must save password recovery status and a new password.
     *
     * @note:
     *
     * Password must be saved even if recovery saving failed. That's why there is used <deferred.always()>
     *
     * @returns {$.Deferred().then()}
     */
    save: function() {
        var self = this,
            deferred = $.Deferred();

        // Note: saving recovery have a greater priority than password
        swc.models.System.checkSessionState(function () {
            $.when(swc.models.PasswordRecovery.sync('update'))
                .always(self.onRecoveryStatusSave(deferred));
        });

        return deferred.promise();
    },

    /**
     * Save new password, applied by the user:
     *
     * @description:
     *
     * After the password recovery has saved, password changes must be saved too.
     *
     * @note:
     *
     * Password will not be saved, if all 3 fields are empty.
     *
     * @param $deferred {$.Deferred().then()}
     */
    onRecoveryStatusSave: function($deferred) {
        var password = this.$('input[name="current-password"]').val(),
            newPassword = this.$('input[name="new-password"]').val(),
            newPasswordConfirm = this.$('input[name="new-password-confirm"]').val();

        // Do not process with password save, if password fields were not filled in by the user:
        if (_.isEmpty(password) && _.isEmpty(newPassword) && _.isEmpty(newPasswordConfirm)) {
            return $deferred.resolve();
        }

        // Save new password on the server:
        $.when(swc.models.UserManagement.changePassword(newPassword))
            .done(function() {
                $deferred.resolve();
            })
            .fail(function() {
                $deferred.reject();
            });
    }
});
;swc.constructors.LoginView = swc.base.PageView.extend({

    className: 'login',

    pageTemplateID: 'login',

    models: ['PasswordRecovery', 'UserManagement'],

    events: {
        'click a[name="restore-button"]': 'startRecoveryProcess',

        'keyup input': 'updateFormState',
        // Update form state even if 'backspace' button holding
        'keydown input': 'updateFormState',
        'input input': 'updateFormState',
        'propertychange input': 'updateFormState',
        'paste input': 'updateFormState', //for IE
        'change input': 'updateFormState',


        // Submit login form with enter button
        'keydown input[name="login-password"]': 'processLogin',
        'click a[name="login-button"]:not(.disabled)': 'processLogin',

        'swc-checkbox:change .display-password': 'displayPassword',
        'keyup input[name*=login-password]': 'copyPassword',
        'input input[name*=login-password]': 'copyPassword',
        'propertychange input[name*=login-password]': 'copyPassword',
        'paste input[name*=login-password]': 'copyPassword', //for IE
        'change input[name*=login-password]': 'copyPassword'
    },

    preRender: function () {
        // Login View has special layout
        if (swc.views.Application.contentArea && swc.views.Application.contentArea.size()) {
            swc.views.Application.contentArea.remove();
            swc.views.Application.prepareLayout('login-layout');
        }
    },

    setTemplateData: function() {
        this.templateData = {
            localeStrings: swc.models.Locale.getLocaleStrings(),
            localeString: getTranslationStringsjQuery,
            formatDate: swc.models.Locale.formatDate,
            recoveryEnable: swc.models.PasswordRecovery.get('recoveryEnable')
        };
    },

    renderComplete: function () {
        var currentPage = Backbone.history.fragment,
            isRemoteLogin = currentPage === 'remote-login' || !_.isNull(localStorage.getItem('remoteLogin'));

        // Check if current login for remote admin:
        if (isRemoteLogin) {
            this.$('input[name="login-name"]').val('superadmin');
            // Add supper admin class to body to handle some features with CSS styles:
            $('body').toggleClass('superAdmin', isRemoteLogin);
        } else {
            this.$('input[name="login-name"]').val(swc.models.UserManagement.userName);
        }

        // Remove local storage items:
        localStorage.removeItem('remoteLogin');
        localStorage.removeItem('userSuperAdmin');

        // Focus to password input
        $('input[name="login-password"]').val('').focus();
        $('input[name="login-password-copy"]').val('');

        // Update form and login button state
        this.updateFormState();

        // Fix for IE8 - it does not support placeholder attribute on input element
        $('input, textarea').placeholder();

        // remove application env variables
        this.clearLogoutState();
        
        if (swc.models.PasswordRecovery.isRecoveryRunning()) {
            swc.router.navigate("recovery/start");
        }
    },

    /**
     * Change login form (login button) state, according to inputs value
     *
     * @param e {String}
     *
     * @return void
     */
    updateFormState: function(e){
        var target = e ? $(e.target) : null,
            loginButton = this.$('a[name="login-button"]');

        if (target) {
            // Hiding validation if form is edited:
            if (target.val() !== target.data('old-val')) {
                $('.info-messages .message').hide();
                target.removeClass("validation-error");
            }

            target.data('old-val', target.val());
        }

        loginButton.toggleClass('disabled', this.isValidationError());
    },

    /**
     * Display password input as text type
     */
    displayPassword: function() {
        var inputPasswordVisible = this.$('input[name="login-password"]'),
            inputPasswordHidden = this.$('input[name="login-password-copy"]');

        inputPasswordHidden.val(inputPasswordVisible.val()).show();
        inputPasswordVisible.hide();

        inputPasswordVisible.attr('name', 'login-password-copy');
        inputPasswordHidden.attr('name', 'login-password');
    },

    copyPassword: function() {
        var element = this.$('input[name="login-password"]'),
            visibleField,
            hiddenField;


        /**
         * We copy values from currently visible element into currently hidden element
         */
        if (element.attr('name') === 'login-password') {
            visibleField = this.$('input[name=login-password]');
            hiddenField = this.$('input[name=login-password-copy]');
        } else {
            visibleField = this.$('input[name=login-password-copy]');
            hiddenField = this.$('input[name=login-password]');
        }

        hiddenField.val(visibleField.val());
    },

    /**
     * Start login process
     *
     * @param e {String}
     *
     */
    processLogin: function(e) {
        var inputPasswordField = this.$('input[name="login-password"]'),
            inputLoginField = this.$('input[name="login-name"]'),
            self = this;

        if (e.type !== "keydown") {
            e.preventDefault();
        }

        if (e.which === 13 || e.type !== 'keydown') {
            if (!this.isValidationError()) {
                $.when(swc.models.Login.processLogin(inputLoginField.val(), inputPasswordField.val()))
                    .done(function(response) {
                        if (response.status) {
                            swc.views.Application.prepareLayout('application');

                            // always to overview?
                            // swc.router.navigate(swc.router.determineNextPage());
                            swc.router.navigate('overview', {trigger:true, replace: true});
                        } else {
                            // Below code which helps simulate brute-force protection ability before NP blackbuild 06.00.01 
                            // response.response.errors = [];
                            // response.response.errors.push({'description':'', 'waittime':15});
                            if(_.isUndefined(response.response.errors)) {
                                self.displayWarningMessage('login');
                            } else {
                                var lastError = response.response.errors[0];
                                if(!_.isUndefined(lastError.waittime)) {
                                    self.displayWarningMessage('brute-force', lastError.waittime);
                                }
                            }
                        }
                    })
                    .fail(function() {
                        self.displayWarningMessage('login-device');
                    });
            } else {
                this.displayWarningMessage('both-fields-required');
            }
        }
    },

    /**
     * Validate login form:
     *
     * @return {Boolean}
     *
     */
    isValidationError: function() {
        var error = false,
            checkbox = this.$('.swc-checkbox.display-password input'),
            inputPasswordOriginal = this.$('input[name="login-password"]'),
            inputPasswordCopy = this.$('input[name="login-password-copy"]'),
            inputLoginField = this.$('input[name="login-name"]');

        // Copy password to original input if checkbox "Show Password" is active
        if (checkbox.prop('checked')) {
            inputPasswordOriginal.val(inputPasswordCopy.val());
        }

        if (!inputLoginField.val().length) {
            error = true;
        }

        if (!inputPasswordOriginal.val().length) {
            error = true;
        }

        return error;
    },

    /**
     * Display warning message to user:
     */
    displayWarningMessage: function(message, waittime) {
        var dialog = $('.info-messages').find('.' + message);
        $('.info-messages').children().css('display', 'none');

        dialog.show();

        if (message === "brute-force") {
            var warning_message_wait = dialog.find('span:eq(1)');
            warning_message_wait.text(waittime);
            $("input[name='login-password']").addClass("disabled");
            $("input[name='login-password']").prop('disabled', true);
            $("a[name='login-button']").addClass("disabled");
            $("a[name='login-button']").prop('disabled', true);
            _.delay(function () {
                $("input[name='login-password']").removeClass("disabled");
                $("input[name='login-password']").prop('disabled', false);
                $("a[name='login-button']").removeClass("disabled");
                $("a[name='login-button']").prop('disabled', false);
                dialog.hide();
            }, waittime * 1000);
        }

        if (message === "login") {
            $("input[name='login-password']").addClass("validation-error");
        }
    },

    /**
     * Clear application state after logout
     *
     * @description:
     *
     * Remove application env variables(action-logout, session-logout,
     * reset-logout) from the localStorage
     */
    clearLogoutState: function() {
        if (_.isNull(localStorage.getItem('reset-logout'))) {
            if (!_.isNull(localStorage.getItem('action-logout'))) {
                this.displayWarningMessage('logout');
                localStorage.removeItem('action-logout');
                localStorage.removeItem('session-logout');
            }

            if (!_.isNull(localStorage.getItem('session-logout'))) {
                this.displayWarningMessage('session-expired');
                localStorage.removeItem('action-logout');
                localStorage.removeItem('session-logout');
            }
        } else {
            // Clean-up flag that logout done via reset
            localStorage.removeItem('reset-logout');
            /*
             Usually we are logged out by call to LoginModel.processLogout()
             even if it is reset/upgrade/etc. process;
             thus clean-up the flag been set in order to not show "Successfully logged out" when <F5> button pressed
             */
            localStorage.removeItem('action-logout');
            localStorage.removeItem('session-logout');
        }
    },

    startRecoveryProcess: function() {
        // Go to page with hint about Password Recovery process
        swc.router.navigate("recovery/start");
    }
});
;// This is just to support correct routing implementation
swc.constructors.RemoteloginView = _.extend(swc.constructors.LoginView, {});;swc.constructors.RecoverySetpasswordView = swc.constructors.SetPasswordView.extend({

    className: 'set-new-password',

    models: ['PasswordRecovery', 'UserManagement'],

    pageTemplateID: 'recovery:set-password',

    validation: {
        'new-password': 'PasswordRecovery:password',
        'new-password-confirm': 'PasswordRecovery:passwordConfirm'
    },

    initialize: function () {
        swc.base.PageView.prototype.initialize.apply(this, arguments);
    },
    
    setButtonsState: function() {
        var container = this.$('.buttons-container-message'),
            buttonSave = container.find('.button.save-changes'),
            newPasswordValue = this.$('input[name=new-password]').val(),
            newPasswordConfirmValue = this.$('input[name=new-password-confirm]').val(),
            isValid = (swc.Utils.validatePassword(newPasswordValue) && (newPasswordValue === newPasswordConfirmValue)),
            globalEnableChanged = this.isGlobaEnableChanged();

        if(isValid || globalEnableChanged) {
            buttonSave.removeClass('disabled');
        } else {
            buttonSave.addClass('disabled');
        }
    },

    hasChanged: function() {
        return false;
    },

    /**
     * Executes when we change the device password
     */
    save: function () {
        var self = this,
            newPasswordValue = this.$('input[name=new-password]').val();

        this.$('.save-success, .save-error').hide();

        this.showPageLoading("Applying changes...");

        swc.models.PasswordRecovery.setNewPassword(newPasswordValue)
            .done(function (result) {
                // When no response, that means that everything went fine, aka "Linux-style-error-handling" :-)
                if (result) {
                    self.$('.info-messages .internal-error').show();
                } else {
                    // NP replies immediately, but new password is not applied yet - wait for a while
                    setTimeout(function () {
                        self.signInWithNewPassword(newPasswordValue);
                    }, 1000);
                }
            })
            .fail(function() {
                // TODO: Show actual error message to the user, add translation for the message returned by NP side
                self.$('.info-messages .error').hide();
                self.$('.info-messages .feature-not-available').show();

            })
            .always(function () {
                self.stopPageLoading();
                swc.models.PasswordRecovery.forgetChannelId();
            });
    },

    proceedToApplication: function () {
        swc.views.Application.prepareLayout('application');
        swc.models.PasswordRecovery.forgetChannelId();
        swc.router.navigate(swc.router.determineNextPage(), { skipUnsavedChanges: true });
    },

    signInWithNewPassword: function (newPasswordValue) {
        var self = this;

        swc.models.Login.processLogin(swc.models.UserManagement.userName, newPasswordValue)
            .done(function () {
                // We only able to set password recovery after successfully signed it
                swc.models.PasswordRecovery.sync("update")
                    .done(function () {
                        // Re-read status of password-recovery, otherwise will miss it after update
                        swc.models.PasswordRecovery.fetch()
                            .done(function () {
                                self.proceedToApplication();
                            });
                    });
            });
    }
});
;swc.constructors.RecoveryStartView = swc.base.PageView.extend({
    className: 'start-recovery',

    pageTemplateID: 'recovery:start',

    models: ['PasswordRecovery'],

    events: {
        'click a[name="back"]:not(.disabled)': 'stopRecovery'
    },

    preRender: function () {
        var deferred = new $.Deferred(),
            self = this;

		if(swc.models.Login.checkIfLoggedIn()) {
			window.location.href = '/#overview';
			return deferred.reject();
		}

        /**
         * Start recovery process - after executing the confirmation code will appear on LCD display
         * @returns {*}swc.views.Application
         */
        swc.models.EventManager = new swc.constructors.EventManager({
            events: [{"handler": "PasswordRecovery"}],
            eventsVersionToUse: 1
        });

        //this.showPageLoading("Starting Password Recovery Process...");

        /**
         * Don't open new channel if just page has been refreshed or locale has been changed
         */
        if (sessionStorage.getItem("eventManager:channelId") && swc.models.PasswordRecovery.isRecoveryRunning()) {
            self._startEventManagerListener(sessionStorage.getItem("eventManager:channelId"), deferred);
        } else {
            // First, have to open channel to listen to password-recovery
            $.when(swc.models.EventManager.openChannel())
                .done(function() {
                    var channelId = swc.models.EventManager.get("channelid");

                    self._startEventManagerListener(channelId, deferred);

                    // Store channel ID in the local storage to avoid re-opening channel in case if page reloaded in browser
                    sessionStorage.setItem("eventManager:channelId", channelId);
                });
        }

        return deferred.promise();
    },

    setTemplateData: function() {
        this.templateData = {
            localeStrings: swc.models.Locale.getLocaleStrings(),
            localeString: getTranslationStringsjQuery,
            formatDate: swc.models.Locale.formatDate,
            deviceType: swc.Utils.DeviceType
        };
    },

    /**
     * Callback being called after Events channel has been opened.
     * Also this method resolves deferred from the outer scope.
     *
     * This method only creates instance of EventManager listener and handles event happened on Screen.
     * Needed if user pressed F5 in their browser - we can just use previous channel id value from session storage.
     *
     * @param {Number} channelId - ID of opened channel
     * @param {Deferred} deferred - Deferred object started in another place
     *
     * @protected Only for internal usage
     *
     * @return {void}
     */
    _startEventManagerListener: function (channelId, deferred) {
        var self= this;

        // Create instance of EM listener
        swc.models.EventManagerListener = new swc.constructors.EventManagerListener({
            events: [{"handler": "PasswordRecovery"}],
            eventsVersionToUse: 1
        });
        swc.models.EventManagerListener.setAjaxParameters(JSON.stringify({
            "channelid": channelId,
            "events": [{"handler": "PasswordRecovery"}]
        }));

        // Subscribe to listen if smth.changed
        swc.models.EventManagerListener.on("change", function () {
            var ScreenEvent = swc.models.EventManagerListener.pop();

            if (ScreenEvent && ScreenEvent.get('attributes')) {
                // User pressed "BACK" on device, we do the same -
                if (ScreenEvent.get('attributes').response === "Denied") {
                    // stop background event listener
                    clearInterval(self.eventsListenerInterval);
                    self.eventsListenerInterval = null;
    
                    swc.models.EventManagerListener.off("PasswordRecovery");
                
                    swc.models.PasswordRecovery.forgetChannelId();
                    swc.router.navigate("login");
                } else if (ScreenEvent.get('attributes').response === "Allowed") {
                    // stop background event listener
                    clearInterval(self.eventsListenerInterval);
                    self.eventsListenerInterval = null;
    
                    swc.models.EventManagerListener.off("PasswordRecovery");
                
                    // don't remove channel Id here - user may press Back button in browser from Set-Password page
                    swc.router.navigate("recovery/set-password");
                } else {
                    swc.models.EventManagerListener.listenChannel();
                }
            }
        });

        self._initRecoveryProcess();

        deferred.resolve();
    },

    /**
     * This method actually initiates Set-New-Password flow on the device.
     * We should not re-start process if we have already running  one
     *
     * @protected Only for internal usage
     *
     * @return {void}
     */
    _initRecoveryProcess: function () {
        var self = this;

        if (!swc.models.PasswordRecovery.isRecoveryRunning()) {
            swc.models.PasswordRecovery.startProcess()
                .done(function() {
                    // Although listenChannel is a deferred, we don't need to resolve it
                    swc.models.EventManagerListener.listenChannel();

                    // Check current recovery status
                    swc.models.PasswordRecovery.sync("read")
                        .done(function(){
                            swc.views.Application.stopPageLoading();
                            self._startScreenEventListener();
                        });
                });
        } else {
            self._startScreenEventListener();
        }
    },

    /**
     * Start polling for Screen events.
     */
    _startScreenEventListener: function () {
        var self = this;

        if (!self.eventsListenerInterval) {
            self.eventsListenerInterval = setInterval(function () {
                // although listenChannel is a deferred, we don't need to resolve it
                swc.models.EventManagerListener.listenChannel();
                $.when(swc.models.PasswordRecovery.sync("read"))
                    .done(function () {
                        if (!swc.models.PasswordRecovery.isRecoveryRunning()) {
                            // simulate click on back button
                            self.$('a[name="back"]:not(.disabled)').click();
                        }
                    })
                    .fail(function() {
                        // TODO: do nothing or what?
                    });
            }, 15000);
        }
    },

    /**
     * Handler for "Back" button
     * @callback
     */
    stopRecovery: function () {
        var self = this;

        $.when(swc.models.PasswordRecovery.stopProcess())
            .done(function () {
                // We have to check current state of Password Recovery.
                // Should be "Enable", not "Processing" when "Back" is pressed.
                $.when(swc.models.PasswordRecovery.sync("read"))
                    .done(function () {
                        // stop listener
                        if (self.eventsListenerInterval) {
                            clearInterval(self.eventsListenerInterval);
                            self.eventsListenerInterval = null;
                        }
                        swc.models.PasswordRecovery.forgetChannelId();
                        swc.router.navigate("login");
                    });
            });
    }
});
;
swc.constructors.SpeedtestView =  swc.base.PageView.extend(swc.base.SpeedcheckProtoView).extend({

	pageTemplateID: "speedtest",

	outsidePanel: true,

	models: [],

	preRender: function() {
		if (swc.views.Application.contentArea && swc.views.Application.contentArea.size()) {
            swc.views.Application.contentArea.remove();
            swc.views.Application.prepareLayout('login-layout');
        }

        this.tab = $.template("pageContent", swc.Templates.get("system:diagnostics:speedcheck").get('content'));
	},

	speedcheckRenderComplete: function() {
		var content = $('.tabs-content');

		content.html($.tmpl(this.tab, {
			localeStrings: swc.models.Locale.getLocaleStrings('system/diagnostics/speedcheck'),
            localeString: getTranslationStringsjQuery
		}));
	},
	checkPermissions: function() {}
});;swc.constructors.PinCode = swc.BaseModel.extend({
    
    url: {
        read: "/sysbus/NeMo/Intf/wwan:getPinType"
    },
    
    /** 
     * Get the required pin
     * When "pin" is returned, setPin must be called to enter the pin. If "puk" is returned
     *  the pin need to be reset with resetPin. If "none" is returned,
     *  the pin has already been entered or is not needed.
     *  @return string with required pin type, can be "pin", "puk" or "none"
     */
    apiToJSON: function(json) {
        var data = json.status;

        return {
            status: data
        };
    },

    /**
     * Enter the pin code
     * If the pin is correct, the parameter PINCode will be updated with this value.
     * @param pin pin code to enter
     * @error pcb_error_invalid_parameter
     */
    setPin: function(pin) {
        var deferred = new $.Deferred();

        swc.models.Rest.sendRequest({
            url: '/sysbus/NeMo/Intf/wwan:setPin',
            data: {
                'parameters': {
                    'pin': pin
                }
            },

            success: function(response) {
                if(response.errors && response.errors.length > 0) {
                    deferred.reject(response.errors);
                } else {
                    deferred.resolve();
                }
            },

            error: function() {
                deferred.reject();
            }
        });

        return deferred.promise();
    },

    /**
     * Eeset the pin code.
     * @param puk puk code ot enter
     * @param pin new value for pin code
     * @error pcb_error_invalid_parameter
     */
    resetPin: function(puk, pin) {
        var deferred = new $.Deferred();

        swc.models.Rest.sendRequest({
            url: '/sysbus/NeMo/Intf/wwan:resetPin',
            data: {
                'parameters': {
                    'puk': puk,
                    'newpin': pin
                }
            },

            success: function(response) {
                if(response.errors && response.errors.length > 0) {
                    deferred.reject(response.errors);
                } else {
                    deferred.resolve();
                }
            },

            error: function() {
                deferred.reject();
            }
        });

        return deferred.promise();
    }
});
;swc.constructors.StickyPageModel = Backbone.Model.extend({

    sync: function() {
        return new $.Deferred().resolve();
    },

    getConnectivityStatus: function() {
        var deferred = new $.Deferred();

        swc.models.Rest.sendRequest({
            url: '/sysbus/DeviceManager/Connectivity:getStatus',
            data: { parameters: {} },

            success: function(response) {
                deferred.resolve(response);
            },

            error: function() {
                deferred.reject();
            }
        });

        return deferred.promise();
    }

});
;swc.constructors.StickyPageView = swc.base.PageView.extend({

    models: [
        'StickyPageModel', 'PinCode'
    ],

    events: {
        'swc-dropdown:change .locale-selector': 'setLocale',
        'click .open-desired-website': 'checkConnection',
        'click .reboot-gateway': 'rebootGateway',
        'click .reboot-process': 'clickProcess',
        //'change input[name="pinCode"]': 'validatePinCode',
        'keyup input[name="pinCode"]': 'enablePinButton',
        'keyup input[subtype="puk"]': 'enablePukButton',
        'change input[name="pukCode"]': 'validatePukCode',
        'change input[name="newPinCode"]': 'validateNewPinCode',
        'change input[name="confirmPinCode"]': 'validateConfirmPinCode',
        'click .confirm.pin:not(.done)': 'confirmPinCode',
        'click .confirm.puk:not(.done)': 'confirmPukCode',
        'click .done': 'redirectToMain'
    },

    /**
     * This mapping only needed to find out which page to show to user.
     * We have several steps.
     */
    templateForErrorMap: {
        'Error_02': 'no-connection',
        'Error_03': 'no-connection',
        'Error_04': 'no-connection-final',
        'Error_07': 'no-connection-final-support',
        'Error_11': 'parental-control',
        'Error_12': 'emergency-stick-connection'
    },

    defaultError: 'Error_02',

    initialize: function() {
        this.template = $.template('sticky', swc.Templates.get('sticky:application').get('content'));
        this.render();
        this.lastPin = '';
        
        if(location.search.indexOf('?errorcode=Error_02') > -1 || location.search.indexOf('?errorcode=Error_04') > -1) {
            var lastPage = localStorage.getItem('last-page');
            if(lastPage && lastPage !== (location.pathname + location.search)) {
                location.href = lastPage;
            }
        }
    },

    checkConnection: function(e){
        var self = this,
            $el = $(e.currentTarget),
            url = $el.attr('href');

        e.preventDefault();

        swc.models.StickyPageModel.getConnectivityStatus()
            .done(function(response){
                if (response.status && response.status.data && response.status.data.status === true){
                    location.href = url;
                    localStorage.removeItem('last-page');
                } else {
                    self.showRebootPage(url);
                }
            })
            .fail(function(){
                self.showRebootPage(url);
            });

        return false;
    },

    showRebootPage: function(url) {
        location.href = location.pathname + "?errorcode=Error_04&url=" + encodeURIComponent(url);
        localStorage.setItem('last-page', location.pathname + "?errorcode=Error_04&url=" + encodeURIComponent(url));
    },

    clickProcess: function(e){
        e.preventDefault();
        return false;
    },

    rebootGateway: function(e){
        this.$('.reboot-gateway').hide();

        // Start Device polling
        this.pollGateway();

        e.preventDefault();

        return false;
    },

    pollGateway: function(){
        var self = this,
            query = this.parseQuery(),
            url = '#';

        if (query) {
            url = decodeURIComponent(query.url);
        }

        swc.models.StickyPageModel.getConnectivityStatus()
            .done(function(response){
                if (response.status && response.status.data && response.status.data.status === true){
                    location.href = url;
                } else {
                    self.showFinalPage(url);
                }
            })
            .fail(function(){
                this.$('.reboot-process').show();
                setTimeout(function() {
                    self.pollGateway();
                }, 1000);
            });

        return false;
    },

    showFinalPage: function(url){
        location.href = location.pathname + "?errorcode=Error_07&url=" + encodeURIComponent(url);
        localStorage.setItem('last-page', location.pathname + "?errorcode=Error_07&url=" + encodeURIComponent(url));
    },

    setNotification: function() {
        var me = this,
            queryParams = this.parseQuery(),
            strings = swc.models.Locale.getLocaleStrings('sticky'),
            data = {
                localeStrings: strings,
                localeString: getTranslationStringsjQuery,
                formatDate: swc.models.Locale.formatDate,
                url: decodeURIComponent(queryParams.url || '/')
            },
            // Compile template for specific error code
            tmpl;
        
        function showTemplate() {
            data = me.updateData(queryParams.templateId, data);
            
            tmpl = $.template('error-dialog', swc.Templates.get('sticky:error:' +
                    queryParams.templateId).get('content'));
    
            me.$('.sticky-message-container').html($.tmpl(tmpl, data));
        }
            
        // special case
        switch(queryParams.templateId) {
            case 'emergency-stick-connection':
                var status = swc.models.PinCode.get('status');
                if(status === 'pin') {
                    queryParams.templateId = 'emergency-stick-connection-pin';
                    showTemplate();
                } else if(status === 'puk') {
                    queryParams.templateId = 'emergency-stick-connection-puk';
                    showTemplate();
                } else if(status === 'puk-blocked') {
                    queryParams.templateId = 'emergency-stick-connection-puk-locked';
                    showTemplate();
                } else {
                    me.redirectToMain();
                }
                break;
            default:
                showTemplate();
                break;
        }
    },
    
    updateData: function(templateId, data) {
        switch(templateId) {
            case 'emergency-stick-connection':
                data.pinCodeHint = 'e.g., 4568';
                break;
        }
        
        return data;
    },

    /**
     * @override for BaseView::displayPage() because we have different layout for sticky pages then regular application
     */
    displayPage: function() {
        var strings = swc.models.Locale.getLocaleStrings('sticky'),
            data = {
                localeStrings: strings,
                localeString: getTranslationStringsjQuery,
                staticPagesLinks: swc.models.Locale.getStaticPagesLinks(),
                formatDate: swc.models.Locale.formatDate
            };

        this.$el = $.tmpl(this.template, data);

        $('div#application').html(this.$el);
    },

    renderComplete: function() {
        this.$('.locale-selector')
            .data('options', swc.models.Locale.getLocaleOptions())
            .trigger('swc-dropdown:swc-change', swc.models.Locale.locale);

        this.setNotification();
        this.delegateEvents();
    },

    setLocale: function(e, value){
        var self = this;

        $.when(swc.models.Locale.setLocale(value, true)).done(function() {
            self.remove();
            self.render();
        });
    },

    /**
     * Parses query string and extract parameter <-> value pairs.
     * Also defines which template will be shown to user based on returned "errorcode" value.
     *
     * @private This is just a helper method
     *
     * @returns {{}}
     */
    parseQuery: function() {
        var query = location.search.replace('?', ''),
            res = {};

        $.each(query.split('&'), function(i, pair){
            var temp = pair.split('=');
            res[temp[0]] = temp[1];
        });

        if (!res.errorcode || !this.templateForErrorMap[res.errorcode]) {
            res.errorcode = this.defaultError;
        }
        res.templateId = this.templateForErrorMap[res.errorcode];

        return res;
    },
    
    validatePinCode: function() {
        var input = $('input[name="pinCode"]'),
            pinCode = input.val(),
            validationError = false,
            errorCode;

        if(pinCode.length < 4 || pinCode.length > 8) {
            validationError = true;
            errorCode = 'Invalid PIN Code length';
        }
        
        this.showErrorInfo(validationError, errorCode, 'validation-message', 'pinCode');

        return !validationError;
    },
    
    validatePukCode: function() {
        var pukCode = $('input[name="pukCode"]').val(),
            validationError = false,
            errorCode;

        if(pukCode.length !== 8) {
            validationError = true;
            errorCode = 'Invalid PUK Code length';
        }
        
        this.showErrorInfo(validationError, errorCode, 'validation-message-puk', 'pukCode');
        
        return !validationError;
    },
    
    validateNewPinCode: function() {
        var newPinCode = $('input[name="newPinCode"]').val(),
            validationError = false,
            errorCode;

        if((newPinCode.length < 4 || newPinCode.length > 8)) {
            validationError = true;
            errorCode = 'Invalid PIN Code length';
        }
        
        this.showErrorInfo(validationError, errorCode, 'validation-message-new-pin', 'newPinCode');

        return !validationError;
    },
    
    validateConfirmPinCode: function() {
        var newPinCode = $('input[name="newPinCode"]').val(),
            confirmPinCode = $('input[name="confirmPinCode"]').val(),
            validationError = false,
            errorCode;

        if((newPinCode.length < 4 || newPinCode.length > 8) || (confirmPinCode.length > 0 && (confirmPinCode.length < 4 || confirmPinCode.length > 8))) {
            validationError = true;
            errorCode = 'Invalid PIN Code length';
        } else if(newPinCode !== confirmPinCode) {
            validationError = true;
            errorCode = 'Mismatch PIN Code value';
        }
        
        this.showErrorInfo(validationError, errorCode, 'validation-message-confirm-pin', 'confirmPinCode');

        return !validationError;
    },
    
    enablePinButton: function() {
        var button = $('.button.confirm'),
            value = $('input[name="pinCode"]').val();
        
        if(value.length > 0) {
            if(this.lastPin !== value) {
                button.removeClass('disabled');
            } else {
                button.addClass('disabled');
            }
        } else {
            button.addClass('disabled');
        }
    },
    
    enablePukButton: function() {
        var button = $('.button.confirm'),
            pukInputs = $('input[subtype="puk"]'),
            enable = true;
            
        _.each(pukInputs, function(input){
            enable &= ($(input).val().length > 0);
        });
        
        if(enable) {
            button.removeClass('disabled');
        } else {
            button.addClass('disabled');
        }
    },
    
    showErrorInfo: function(validationError, errorCode, messageClass, inputName) {
        var validationMessage = $('.' + messageClass);
        
        if (validationError) {
            validationMessage.show();
            validationMessage.find('.error-message').hide();
            validationMessage.find('.error-message[data-error="' + errorCode + '"]').show();
        } else {
            validationMessage.hide();
            validationMessage.find('.error-message').hide();
        }

        $('.info-message').hide();
        $('input[name="' + inputName + '"]').toggleClass('validation-error', validationError);
    },
    
    confirmPinCode: function() {
        var me = this,
            input = $('input[name="pinCode"]'),
            pinCode = input.val();
        
        if(!$('.button.confirm').hasClass('disabled') && me.validatePinCode()) {
            $.when(swc.models.PinCode.setPin(pinCode))
                .done(function() {
                    me.showValidInfo('PIN code has been authorized successfully');
                }).fail(function() {
                    $.when(swc.models.PinCode.fetch()).always(function() {
                        if(swc.models.PinCode.get('status') === 'puk') {
                            me.setNotification();
                        } else {
                            me.showErrorInfo(true, 'Invalid PIN Code value', 'validation-message', 'pinCode');
                            me.lastPin = pinCode;
                            me.enablePinButton();
                        }
                    });
                });
        }
    },
    
    confirmPukCode: function() {
        var me = this,
            pukCode = $('input[name="pukCode"]').val(),
            pinCode = $('input[name="newPinCode"]').val();
        
        if(!$('.button.confirm').hasClass('disabled') && me.validatePukCode() && me.validateNewPinCode() && me.validateConfirmPinCode()) {
            $.when(swc.models.PinCode.resetPin(pukCode, pinCode))
                .done(function() {
                    me.showValidInfo('PIN code has been changed successfully');
                }).fail(function() {
                    me.showErrorInfo(true, 'Invalid PUK Code value', 'validation-message-puk', 'pukCode');
                });
        }
    },
    
    showValidInfo: function(infoCode) {
        var formSection = $('.form-section'),
            validationMessage = $('.validation-message'),
            infoMessage = $('.info-message'),
            button = $('.button.confirm');
        
        validationMessage.hide();
        validationMessage.find('.error-message').hide();
        formSection.hide();
        infoMessage.show();
        infoMessage.find('.info-message').hide();
        infoMessage.find('.info-message[data-info="' + infoCode + '"]').show();
        
        button.html(getTranslationStrings('OK'));
        button.addClass('done');
    },
    
    redirectToMain: function() {
        var query = this.parseQuery(),
            url = '#';

        if (query) {
            url = decodeURIComponent(query.url);
        }

        location.href = url;
    }
});
;swc.Utils.DefaultValidator = {
	username: function(username) {
        var validationStatus = true,
            validationMessages = [];

        if (!username.length) {
            validationStatus = false;
            validationMessages.push('username must not be empty');
        } else
        if (username.length < 3 || username.length > 32) {
            validationStatus = false;
            validationMessages.push('username must be from 3 to 32 symbols');
        } else
        if (!/^[a-z0-9-_\.]+$/.test(username)) {
            validationStatus = false;
            validationMessages.push('invalid characters');
        }

        return {
            status: validationStatus,
            messages: validationMessages
        };
    },

    password: function(username, password) {
        var validationStatus = true,
            validationMessages = [];

        if(username === password) {
            validationStatus = false;
            validationMessages.push('password must be different than username');
        } else
        if(!/[^a-zA-Z]/.test(password)) {
            validationStatus = false;
            validationMessages.push('must contain special character or digit');
        } else
        if (password.length < 8 || password.length > 16) {
            validationStatus = false;
            validationMessages.push('password must be from 8 to 16 symbols');
        } else
        if (!swc.Utils.validatePassword(password)) {
            validationStatus = false;
            validationMessages.push('invalid characters');
        }

        return {
            status: validationStatus,
            messages: validationMessages
        };
    }
};