describe('Telephony->Phonebook: formatted name "Petrov Ivan"', function() {
    var contact = new swc.constructors.PhonebookContact({
        firstName: 'Ivan',
        lastName: 'Petrov'
    });

    it('is equal Petrov Ivan', function() {
        expect(contact.getFormattedName()).to.equal('Petrov Ivan');
    });

    it('is not equal to petrov ivan', function() {
        expect(contact.getFormattedName()).not.to.equal('petrov ivan');
    });

    it('is not equal to Ivan Petrov', function() {
        expect(contact.getFormattedName()).not.to.equal('Ivan Petrov');
    });

    it('is not equal to ivan petrov', function() {
        expect(contact.getFormattedName()).not.to.equal('ivan petrov');
    });

    it('contact serialized name', function() {
        expect(contact.getSerializedName()).to.equal('N:Petrov;Ivan');
        expect(contact.getSerializedName()).not.to.equal('N:petrov;ivan');
        expect(contact.getSerializedName()).not.to.equal('Petrov Ivan');
    });
});

describe('Telephony->Phonebook: serialized name "Petrov Ivan"', function() {
    var contact = new swc.constructors.PhonebookContact({
        firstName: 'Ivan',
        lastName: 'Petrov'
    });

    it('is equal "N:Petrov;Ivan"', function() {
        expect(contact.getSerializedName()).to.equal('N:Petrov;Ivan');
    });

    it('is not equal to "N:petrov;ivan"', function() {
        expect(contact.getSerializedName()).not.to.equal('N:petrov;ivan');
    });

    it('is not equal to "Petrov Ivan"', function() {
        expect(contact.getSerializedName()).not.to.equal('Petrov Ivan');
    });
});
