describe("BaseModel", function() {
    var modelConstructor = swc.BaseModel.extend();
    var model = new modelConstructor({
        "stringValue": "some string value"
    });

    // Default behaviour:

    it("should get JSON formated model when call toJSON method" ,function() {
        var model = new modelConstructor({
            "stringValue": "some string value",
            "numericValue": 7,
            "arrayValue": [ 1, 2, 3 ]
        });

        expect(model.toJSON()).to.eql({
            "stringValue": "some string value",
            "numericValue": 7,
            "arrayValue": [ 1, 2, 3 ]
        });
    });


    // Check {'.parse()'} + {'.apiToJSON()'} methods

    it("should check if .parse() method will return valid json", function() {
        var parseModel = new modelConstructor();

        expect(parseModel.parse({ a: 2, b: 3 })).to.eql({ a: 2, b: 3 });
    });

    it("should check if .parse() method with empty .apiToJSON() method will return valid json", function() {
        var parseModel = new modelConstructor();

        parseModel.apiToJSON = function(json) {
            return json;
        };

        expect(parseModel.parse({ a: 2, b: 3 })).to.eql({ a: 2, b: 3 });
    });

    it("should check if .parse() method with not empty .apiToJSON() method will return valid json", function() {
        var parseModel = new modelConstructor();

        parseModel.apiToJSON = function(json) {
            return { c: json.a + json.b };
        };

        expect(parseModel.parse({ a: 2, b: 3 })).to.eql({ c: 5 });
    });

    it("should check if .parse() method will will set valid json to the {'this.originalAttributes'}", function() {
        var parseModel = new modelConstructor();

        parseModel.parse({ a: 2, b: 3 });

        expect(parseModel.originalAttributes).to.eql({ a: 2, b: 3 });
    });

    it("should check if .parse() method with empty .apiToJSON() will set valid json to the {'this.originalAttributes'}", function() {
        var parseModel = new modelConstructor();

        parseModel.apiToJSON = function(json) {
            return json;
        };

        parseModel.parse({ a: 2, b: 3 });

        expect(parseModel.originalAttributes).to.eql({ a: 2, b: 3 });
    });

    it("should check if .parse() method with not empty .apiToJSON() will set valid json to the {'this.originalAttributes'}", function() {
        var parseModel = new modelConstructor();

        parseModel.apiToJSON = function(json) {
            return { c: json.a + json.b };
        };

        parseModel.parse({ a: 2, b: 3 });

        expect(parseModel.originalAttributes).to.eql({ c: 5 })
    });


    // Check {'.changedAttributes()'} method (no changes case)

    it("should check if .changedAttributes() method will return {} (no changes)", function() {
        expect(model.changedAttributes()).to.eql({});
    });

    it("should check if .changedAttributes({string} : correct) method will return {} (no changes)", function() {
        expect(model.changedAttributes("stringValue")).to.eql({});
    });

    it("should check if .changedAttributes({string} : incorrect) method will return {} (no changes)", function() {
        expect(model.changedAttributes("notExistingKey")).to.eql({});
    });

    it("should check if .changedAttributes({array[1]} : correct) method will return {} (no changes)", function() {
        expect(model.changedAttributes([ "stringValue" ])).to.eql({});
    });

    it("should check if .changedAttributes({array[1]} : incorrect) method will return {} (no changes)", function() {
        expect(model.changedAttributes([ "notExistingKey" ])).to.eql({});
    });

    it("should check if .changedAttributes({array[2]} : correct + incorrect) method will return {} (no changes)", function() {
        expect(model.changedAttributes([ "stringValue", "notExistingKey" ])).to.eql({});
    });


    // Check {'.changedAttributes()'} method (changes done case)

    it("should check if .changedAttributes() method will return { stringValue: 'some other string' } (changes done)", function() {
        model.set("stringValue", 'some other string');

        expect(model.changedAttributes()).to.eql({ stringValue: 'some other string' });
    });

    it("should check if .changedAttributes({string} : correct) method will return { stringValue: 'some other string' } (changes done)", function() {
        model.set("stringValue", 'some other string');

        expect(model.changedAttributes("stringValue")).to.eql({ stringValue: 'some other string' });
    });

    it("should check if .changedAttributes({string} : incorrect) method will return {} (changes done)", function() {
        model.set("stringValue", 'some other string');

        expect(model.changedAttributes("notExistingKey")).to.eql({});
    });

    it("should check if .changedAttributes({array[1]} : correct) method will return { stringValue: 'some other string' } (changes done)", function() {
        model.set("stringValue", 'some other string');

        expect(model.changedAttributes([ "stringValue" ])).to.eql({ stringValue: 'some other string' });
    });

    it("should check if .changedAttributes({array[1]} : incorrect) method will return { stringValue: 'some other string' } (changes done)", function() {
        model.set("stringValue", 'some other string');

        expect(model.changedAttributes([ "notExistingKey" ])).to.eql({});
    });

    it("should check if .changedAttributes({array[2]} : correct + incorrect) method will return { stringValue: 'some other string' } (changes done)", function() {
        model.set("stringValue", 'some other string');

        expect(model.changedAttributes([ "stringValue", "notExistingKey" ])).to.eql({ stringValue: 'some other string' });
    });


    // Check {'.changedAttributes()'} method (changes reverted case)

    it("should check if .changedAttributes() method will return {} (changes reverted)", function() {
        model.set("stringValue", 'some other string');
        model.set("stringValue", 'some string value');

        expect(model.changedAttributes()).to.eql({});
    });

    it("should check if .changedAttributes({string} : correct) method will return {} (changes reverted)", function() {
        model.set("stringValue", 'some other string');
        model.set("stringValue", 'some string value');

        expect(model.changedAttributes("stringValue")).to.eql({});
    });

    it("should check if .changedAttributes({string} : incorrect) method will return {} (changes reverted)", function() {
        model.set("stringValue", 'some other string');
        model.set("stringValue", 'some string value');

        expect(model.changedAttributes("notExistingKey")).to.eql({});
    });

    it("should check if .changedAttributes({array[1]} : correct) method will return {} (changes reverted)", function() {
        model.set("stringValue", 'some other string');
        model.set("stringValue", 'some string value');

        expect(model.changedAttributes([ "stringValue" ])).to.eql({});
    });

    it("should check if .changedAttributes({array[1]} : incorrect) method will return {} (changes reverted)", function() {
        model.set("stringValue", 'some other string');
        model.set("stringValue", 'some string value');

        expect(model.changedAttributes([ "notExistingKey" ])).to.eql({});
    });

    it("should check if .changedAttributes({array[2]} : correct + incorrect) method will return {} (changes reverted)", function() {
        model.set("stringValue", 'some other string');
        model.set("stringValue", 'some string value');

        expect(model.changedAttributes([ "stringValue", "notExistingKey" ])).to.eql({});
    });


    // Check {'.hasChanged()'} method (no changes case)

    it("should check if .hasChanged() method will return false (no changes)", function() {
        expect(model.hasChanged()).to.eql(false);
    });

    it("should check if .hasChanged({string} : correct) method will return false (no changes)", function() {
        expect(model.hasChanged("stringValue")).to.eql(false);
    });

    it("should check if .hasChanged({string} : incorrect) method will return false (no changes)", function() {
        expect(model.hasChanged("notExistingKey")).to.eql(false);
    });

    it("should check if .hasChanged({array[1]} : correct) method will return false (no changes)", function() {
        expect(model.hasChanged([ "stringValue" ])).to.eql(false);
    });

    it("should check if .hasChanged({array[1]} : incorrect) method will return false (no changes)", function() {
        expect(model.hasChanged([ "notExistingKey" ])).to.eql(false);
    });

    it("should check if .hasChanged({array[2]} : correct + incorrect) method will return false (no changes)", function() {
        expect(model.hasChanged([ "stringValue", "notExistingKey" ])).to.eql(false);
    });


    // Check {'.hasChanged()'} method (changes done case)

    it("should check if .hasChanged() method will return true (changes done)", function() {
        model.set("stringValue", 'some other string');

        expect(model.hasChanged()).to.eql(true);
    });

    it("should check if .hasChanged({string} : correct) method will return true (changes done)", function() {
        model.set("stringValue", 'some other string');

        expect(model.hasChanged("stringValue")).to.eql(true);
    });

    it("should check if .hasChanged({string} : incorrect) method will return false (changes done)", function() {
        model.set("stringValue", 'some other string');

        expect(model.hasChanged("notExistingKey")).to.eql(false);
    });

    it("should check if .hasChanged({array[1]} : correct) method will return true (changes done)", function() {
        model.set("stringValue", 'some other string');

        expect(model.hasChanged([ "stringValue" ])).to.eql(true);
    });

    it("should check if .hasChanged({array[1]} : incorrect) method will return false (changes done)", function() {
        model.set("stringValue", 'some other string');

        expect(model.hasChanged([ "notExistingKey" ])).to.eql(false);
    });

    it("should check if .hasChanged({array[2]} : correct + incorrect) method will return true (changes done)", function() {
        model.set("stringValue", 'some other string');

        expect(model.hasChanged([ "stringValue", "notExistingKey" ])).to.eql(true);
    });


    // Check {'.hasChanged()'} method (reverted changes case)

    it("should check if .hasChanged() method will return false (changed reverted)", function() {
        model.set("stringValue", 'some other string');
        model.set("stringValue", 'some string value');

        expect(model.hasChanged()).to.eql(false);
    });

    it("should check if .hasChanged({string} : correct) method will return false (changes reverted)", function() {
        model.set("stringValue", 'some other string');
        model.set("stringValue", 'some string value');

        expect(model.hasChanged("stringValue")).to.eql(false);
    });

    it("should check if .hasChanged({string} : incorrect) method will return false (changes reverted)", function() {
        model.set("stringValue", 'some other string');
        model.set("stringValue", 'some string value');

        expect(model.hasChanged("notExistingKey")).to.eql(false);
    });

    it("should check if .hasChanged({array[1]} : correct) method will return false (changes reverted)", function() {
        model.set("stringValue", 'some other string');
        model.set("stringValue", 'some string value');

        expect(model.hasChanged([ "stringValue" ])).to.eql(false);
    });

    it("should check if .hasChanged({array[1]} : incorrect) method will return false (changes reverted)", function() {
        model.set("stringValue", 'some other string');
        model.set("stringValue", 'some string value');

        expect(model.hasChanged([ "notExistingKey" ])).to.eql(false);
    });

    it("should check if .hasChanged({array[2]} : correct + incorrect) method will return false (changes reverted)", function() {
        model.set("stringValue", 'some other string');
        model.set("stringValue", 'some string value');

        expect(model.hasChanged([ "stringValue", "notExistingKey" ])).to.eql(false);
    });

});
