describe("BaseCollection", function() {
    var collectionConstructor = swc.BaseCollection.extend();

    // Check {'.toJSON()'} method

    it("should get JSON formated models when call toJSON method" ,function() {
        var collection = new collectionConstructor([
            { a: 2, b: 3 },
            { c: 4, d: 5 }
        ]);

        expect(collection.toJSON()).to.eql([
            { a: 2, b: 3 },
            { c: 4, d: 5 }
        ]);
    });

    it("should get not deleted JSON formated models when call toJSON method" ,function() {
        var collection = new collectionConstructor([
            { a: 2, b: 3 },
            { c: 4, d: 5 }
        ]);

        expect(collection.toJSON()).to.eql([
            { a: 2, b: 3 },
            { c: 4, d: 5 }
        ]);
    });

    it("should get all JSON formated models when call toJSON method with showDeleted options" ,function() {
        var collection = new collectionConstructor([
            { a: 2, b: 3 },
            { c: 4, d: 5 },
            { e: 4, f: 5, isDeletedByCollection: true },
            { m: 4, n: 5, isDeletedByCollection: true }
        ]);

        expect(collection.toJSON({ showDeleted: true })).to.eql([
            { a: 2, b: 3 },
            { c: 4, d: 5 },
            { e: 4, f: 5, isDeletedByCollection: true },
            { m: 4, n: 5, isDeletedByCollection: true }
        ]);
    });


    // Check {'.reset()'} method

    it("should reset collection when call .reset() method" ,function() {
        var collection = new collectionConstructor([
            { a: 2, b: 3 },
            { c: 4, d: 5 }
        ]);

        collection.reset();

        expect(collection.toJSON()).to.eql([]);
    });


    // Check {'.remove()'} method

    it("should remove (mark model as 'deleted') from collection" ,function() {
        var collection = new collectionConstructor([
            { a: 2, b: 3 },
            { c: 4, d: 5 }
        ]);
        var model = collection.models[1];

        collection.remove(model);

        expect(collection.models[1].get('isDeletedByCollection')).to.eql(true);
    });

    it("should remove model (permanent) from collection" ,function() {
        var collection = new collectionConstructor([
            { a: 2, b: 3 },
            { c: 4, d: 5 }
        ]);
        var model = collection.models[1];

        collection.remove(model, { permanent: true });

        expect(collection.models[1]).to.eql(undefined);
    });


    // Check {'.reset()'} method

    it("should reset collection when calling .reset() method" ,function() {
        var collection = new collectionConstructor([
            { a: 2, b: 3 },
            { c: 4, d: 5 }
        ]);

        collection.reset();

        expect(collection.models).to.eql([]);
    });


    // Check {'.toJSON()'} method

    it("should return [] when calling .toJSON() method (empty collection, no deleted models)", function() {
        var collection = new collectionConstructor();

        expect(collection.toJSON()).to.eql([]);
    });

    it("should return [] when calling .toJSON({ showDeleted: true }) method (empty collection, no deleted models)", function() {
        var collection = new collectionConstructor();

        expect(collection.toJSON({ showDeleted: true })).to.eql([]);
    });

    it("should return JSON formated collection when calling .toJSON() method (not empty collection, no deleted models)", function() {
        var collection = new collectionConstructor([
            { a: 2, b: 3 },
            { c: 4, d: 5 }
        ]);

        expect(collection.toJSON()).to.eql([
            { a: 2, b: 3 },
            { c: 4, d: 5 }
        ]);
    });

    it("should return JSON formated collection when calling .toJSON({ showDeleted: true }) method (not empty collection, no deleted models)", function() {
        var collection = new collectionConstructor([
            { a: 2, b: 3 },
            { c: 4, d: 5 }
        ]);

        expect(collection.toJSON({ showDeleted: true })).to.eql([
            { a: 2, b: 3 },
            { c: 4, d: 5 }
        ]);
    });

    it("should return JSON formated collection when calling .toJSON({ showDeleted: true }) without deleted models", function() {
        var collection = new collectionConstructor([
            { a: 2, b: 3 },
            { c: 4, d: 5 },
            { e: 4, f: 5, isDeletedByCollection: true }
        ]);

        expect(collection.toJSON()).to.eql([
            { a: 2, b: 3 },
            { c: 4, d: 5 }
        ]);
    });

    it("should return JSON formated collection when calling .toJSON({ showDeleted: true }) with deleted models", function() {
        var collection = new collectionConstructor([
            { a: 2, b: 3 },
            { c: 4, d: 5 },
            { e: 4, f: 5, isDeletedByCollection: true }
        ]);

        expect(collection.toJSON({ showDeleted: true })).to.eql([
            { a: 2, b: 3 },
            { c: 4, d: 5 },
            { e: 4, f: 5, isDeletedByCollection: true }
        ]);
    });


    // Check {'.hasChanged()'} method

    it("should return false when collection did not changed and .hasChanged() method was called" ,function() {
        var collection = new collectionConstructor([
            { a: 2, b: 3 },
            { c: 4, d: 5 }
        ]);

        expect(collection.hasChanged()).to.eql(false);
    });

    it("should return true when collection changed and .hasChanged() method was called" ,function() {
        var collection = new collectionConstructor([
            { a: 2, b: 3 },
            { c: 4, d: 5 }
        ]);

        collection.models[1].set('c', 12);

        expect(collection.hasChanged()).to.eql(true);
    });

    it("should return false when collection changed and reverted and .hasChanged() method was called" ,function() {
        var collection = new collectionConstructor([
            { a: 2, b: 3 },
            { c: 4, d: 5 }
        ]);

        collection.models[1].set('c', 12);
        collection.models[1].set('c', 4);

        expect(collection.hasChanged()).to.eql(false);
    });


    // Check {'.changedModels()'} method

    it("should return [] collection did not changed and .changedModels() method was called" ,function() {
        var collection = new collectionConstructor([
            { a: 2, b: 3 },
            { c: 4, d: 5 }
        ]);

        expect(collection.changedModels()).to.eql([]);
    });

    it("should return [] collection did not changed and .changedModels({ onlyEdited: true }) method was called" ,function() {
        var collection = new collectionConstructor([
            { a: 2, b: 3 },
            { c: 4, d: 5 }
        ]);

        expect(collection.changedModels({ onlyEdited: true })).to.eql([]);
    });

    it("should return [] collection did not changed and .changedModels({ onlyDeleted: true }) method was called" ,function() {
        var collection = new collectionConstructor([
            { a: 2, b: 3 },
            { c: 4, d: 5 }
        ]);

        expect(collection.changedModels({ onlyDeleted: true })).to.eql([]);
    });


    it("should return all changed when collection changed and .changedModels() method was called w/o options", function() {
        var collection = new collectionConstructor([
            { a: 2, b: 3 },
            { c: 4, d: 5 },
            { c: 4, d: 5 },
            { c: 4, d: 5 }
        ]);

        collection.models[0].set('a', 4);
        collection.models[1].set('c', 5);

        collection.remove(collection.models[2]);
        collection.remove(collection.models[3]);

        expect(collection.changedModels()).to.eql([
            collection.models[0],
            collection.models[1],
            collection.models[2],
            collection.models[3]
        ]);
    });

    it("should return only updated models when collection changed and .changedModels({ onlyEdited: true }) method was called" ,function() {
        var collection = new collectionConstructor([
            { a: 2, b: 3 },
            { c: 4, d: 5 },
            { c: 4, d: 5 },
            { c: 4, d: 5 }
        ]);

        collection.models[0].set('a', 4);
        collection.models[1].set('c', 5);

        collection.remove(collection.models[2]);
        collection.remove(collection.models[3]);
        
        expect(collection.changedModels({ onlyEdited: true })).to.eql([
            collection.models[0],
            collection.models[1]
        ]);
    });

    it("should return only deleted models when collection changed and .changedModels({ onlyDeleted: true }) method was called" ,function() {
        var collection = new collectionConstructor([
            { a: 2, b: 3 },
            { c: 4, d: 5 }
        ]);

        var collection = new collectionConstructor([
            { a: 2, b: 3 },
            { c: 4, d: 5 },
            { c: 4, d: 5 },
            { c: 4, d: 5 }
        ]);

        collection.models[0].set('a', 4);
        collection.models[1].set('c', 5);

        collection.remove(collection.models[2]);
        collection.remove(collection.models[3]);

        expect(collection.changedModels({ onlyDeleted: true })).to.eql([
            collection.models[2],
            collection.models[3]
        ]);
    });

});
