describe('Wireless', function() {

    describe('Validation', function() {
        var validation = new swc.constructors.Wireless().validation;

        describe('SSID', function() {
            it('can not be empty', function() {
                var data = [{parameterName: "ssid", parameterValue: ""}];
                expect(validation.ssid(data).status).not.to.be.true;
            });

            it('can contain lowercase chars', function() {
                var data = [{parameterName: "ssid", parameterValue: "testwlan"}];
                expect(validation.ssid(data).status).to.be.true;
            });

            it('can contain uppercase chars', function() {
                var data = [{parameterName: "ssid", parameterValue: "testWLAN"}];
                expect(validation.ssid(data).status).to.be.true;
            });

            it('can contain digits', function() {
                var data = [{parameterName: "ssid", parameterValue: "0123456789"}];
                expect(validation.ssid(data).status).to.be.true;
            });

            it('can contain spaces', function() {
                var data = [{parameterName: "ssid", parameterValue: "test with spaces"}];
                expect(validation.ssid(data).status).to.be.true;
            });

            it('can contain underscores', function() {
                var data = [{parameterName: "ssid", parameterValue: "test_with_underscores"}];
                expect(validation.ssid(data).status).to.be.true;
            });

            it('can contain hyphens', function() {
                var data = [{parameterName: "ssid", parameterValue: "test-with-hyphens"}];
                expect(validation.ssid(data).status).to.be.true;
            });

            it('should contain at least 3 symbols', function() {
                var data = [{parameterName: "ssid", parameterValue: "ab"}];
                expect(validation.ssid(data).status).not.to.be.true;
            });

            it('should contain at most 32 symbols', function() {
                var data = [{parameterName: "ssid", parameterValue: "01234567890123456789012345678901"}];
                expect(validation.ssid(data).status).to.be.true;
            });

            it('can not contain more than 32 symbols', function() {
                var data = [{parameterName: "ssid", parameterValue: "012345678901234567890123456789012"}];
                expect(validation.ssid(data).status).not.to.be.true;
            });

            it('can not contain only spaces', function() {
                var data = [{parameterName: "ssid", parameterValue: "        "}];
                expect(validation.ssid(data).status).not.to.be.true;
            });

            it('can contain spaces in the beginning', function() {
                var data = [{parameterName: "ssid", parameterValue: "    wlan    "}];
                expect(validation.ssid(data).status).to.be.true;
            });

            it('can not contain special characters like $', function() {
                var data = [{parameterName: "ssid", parameterValue: "wlan$"}];
                expect(validation.ssid(data).status).not.to.be.true;
            });

            it('can not contain special characters like ^', function() {
                var data = [{parameterName: "ssid", parameterValue: "^wlan"}];
                expect(validation.ssid(data).status).not.to.be.true;
            });

            it('can not contain umlauts like "ü ö ä Ä Ü Ö ß"', function() {
                var data = [{parameterName: "ssid", parameterValue: "ü ö ä Ä Ü Ö ß"}];
                expect(validation.ssid(data).status).not.to.be.true;
            });
        });

        describe('password', function() {
            swc.models.Login = new swc.constructors.LoginModel();

            it('can not be empty', function() {
                var data = [
                    {parameterName: "password", parameterValue: ""},
                    {parameterName: "encryption", parameterValue: ""}
                ];
                expect(validation.password(data).status).not.to.be.true;
            });
    
            it('can contain lowercase chars', function() {
                var data = [
                    {parameterName: "password", parameterValue: "testwlan"},
                    {parameterName: "encryption", parameterValue: ""}
                ];
                expect(validation.password(data).status).to.be.true;
            });
    
            it('can contain uppercase chars', function() {
                var data = [
                    {parameterName: "password", parameterValue: "testWLAN"},
                    {parameterName: "encryption", parameterValue: ""}
                ];
                expect(validation.password(data).status).to.be.true;
            });
    
            it('can contain digits', function() {
                var data = [
                    {parameterName: "password", parameterValue: "0123456789"},
                    {parameterName: "encryption", parameterValue: ""}
                ];
                expect(validation.password(data).status).to.be.true;
            });
    
            it('can contain spaces', function() {
                var data = [
                    {parameterName: "password", parameterValue: "test with spaces"},
                    {parameterName: "encryption", parameterValue: ""}
                ];
                expect(validation.password(data).status).to.be.true;
            });
    
            it('can contain underscores', function() {
                var data = [
                    {parameterName: "password", parameterValue: "test_with_underscores"},
                    {parameterName: "encryption", parameterValue: ""}
                ];
                expect(validation.password(data).status).to.be.true;
            });
    
            it('can contain hyphens', function() {
                var data = [
                    {parameterName: "password", parameterValue: "test-with-hyphens"},
                    {parameterName: "encryption", parameterValue: ""}
                ];
                expect(validation.password(data).status).to.be.true;
            });
    
            it('should contain at least 8 symbols', function() {
                var data = [
                    {parameterName: "password", parameterValue: "ab"},
                    {parameterName: "encryption", parameterValue: ""}
                ];
                expect(validation.password(data).status).not.to.be.true;
            });
    
            it('should contain at most 64 symbols', function() {
                var data = [
                    {parameterName: "password", parameterValue: "0123456789012345678901234567890123456789012345678901234567890123"},
                    {parameterName: "encryption", parameterValue: ""}
                ];
                expect(validation.password(data).status).to.be.true;
            });
    
            it('can not contain more than 64 symbols', function() {
                var data = [
                    {parameterName: "password", parameterValue: "01234567890123456789012345678901234567890123456789012345678901234"},
                    {parameterName: "encryption", parameterValue: ""}
                ];
                expect(validation.password(data).status).not.to.be.true;
            });
    
            it('can contain only spaces', function() {
                var data = [
                    {parameterName: "password", parameterValue: "        "},
                    {parameterName: "encryption", parameterValue: ""}
                ];
                expect(validation.password(data).status).to.be.true;
            });
    
            it('can contain spaces in the beginning', function() {
                var data = [
                    {parameterName: "password", parameterValue: "    wlan    "},
                    {parameterName: "encryption", parameterValue: ""}
                ];
                expect(validation.password(data).status).to.be.true;
            });
    
            it('can not contain special characters like $', function() {
                var data = [
                    {parameterName: "password", parameterValue: "wlan$"},
                    {parameterName: "encryption", parameterValue: ""}
                ];
                expect(validation.password(data).status).not.to.be.true;
            });
    
            it('can not contain special characters like ^', function() {
                var data = [
                    {parameterName: "password", parameterValue: "^wlan"},
                    {parameterName: "encryption", parameterValue: ""}
                ];
                expect(validation.password(data).status).not.to.be.true;
            });

            it('can not contain umlauts like "ü ö ä Ä Ü Ö ß"', function() {
                var data = [
                    {parameterName: "password", parameterValue: "ü ö ä Ä Ü Ö ß"},
                    {parameterName: "encryption", parameterValue: ""}
                ];
                expect(validation.password(data).status).not.to.be.true;
            });

            it('should be skipped if encryption is None', function() {
                var data = [
                    {parameterName: "password", parameterValue: "ü ö ä Ä Ü Ö ß"},
                    {parameterName: "encryption", parameterValue: "None"}
                ];
                expect(validation.password(data).status).to.be.true;
            });
        });
    });

});