describe('Telephony', function() {

    describe('Phonebook', function() {

        describe('Validation', function() {
            var phonebookValidation = (new swc.constructors.Phonebook()).validation;

            describe('allowable first name', function() {
                it('can be empty', function() {
                    var data = [{ "parameterName":"firstName", "parameterValue":"" }];
                    expect(phonebookValidation.firstName(data).status).to.be.ok;
                });

                it('can contain printable chars', function() {
                    var data = [{ "parameterName":"firstName", "parameterValue":"Ivan" }];
                    expect(phonebookValidation.firstName(data).status).to.be.ok;
                });

                it('can contain numbers', function() {
                    var data = [{ "parameterName":"firstName", "parameterValue":"Ivan_123" }];
                    expect(phonebookValidation.firstName(data).status).to.be.ok;
                });

                it('can contain splat "+"', function() {
                    var data = [{ "parameterName":"firstName", "parameterValue":"Ivan+123" }];
                    expect(phonebookValidation.firstName(data).status).to.be.ok;
                });

                it('can contain splat "*"', function() {
                    var data = [{ "parameterName":"firstName", "parameterValue":"Ivan *" }];
                    expect(phonebookValidation.firstName(data).status).to.be.ok;
                });

                it('can contain umlauts like "ü ö ä Ä Ü Ö ß"', function() {
                    var data = [{ "parameterName":"firstName", "parameterValue":"ü ö ä Ä Ü Ö ß" }];
                    expect(phonebookValidation.firstName(data).status).to.be.ok;
                });
            });

            describe('allowable last name', function() {
                it('last name can be empty', function() {
                    var data = [{ "parameterName":"lastName", "parameterValue":"" }];
                    expect(phonebookValidation.lastName(data).status).to.be.ok;
                });

                it('can contain printable chars', function() {
                    var data = [{ "parameterName":"lastName", "parameterValue":"Petrov" }];
                    expect(phonebookValidation.lastName(data).status).to.be.ok;
                });

                it('can contain numbers', function() {
                    var data = [{ "parameterName":"lastName", "parameterValue":"123_Petrov" }];
                    expect(phonebookValidation.lastName(data).status).to.be.ok;
                });

                it('can contain splat "+"', function() {
                    var data = [{ "parameterName":"lastName", "parameterValue":"123+Petrov" }];
                    expect(phonebookValidation.lastName(data).status).to.be.ok;
                });

                it('can contain splat "*"', function() {
                    var data = [{ "parameterName":"lastName", "parameterValue":"* Petrov" }];
                    expect(phonebookValidation.lastName(data).status).to.be.ok;
                });

                it('can contain umlauts like "ü ö ä Ä Ü Ö ß"', function() {
                    var data = [{ "parameterName":"lastName", "parameterValue":"ü ö ä Ä Ü Ö ß" }];
                    expect(phonebookValidation.lastName(data).status).to.be.ok;
                });
            });

            describe('allowable home phone number', function() {
                it('can be empty', function() {
                    var data = [{ "parameterName":"homeNumber", "parameterValue":"" }];
                    expect(phonebookValidation.homeNumber(data).status).to.be.ok;
                });

                it('can contain numbers', function() {
                    var data = [{ "parameterName":"homeNumber", "parameterValue":"080035007" }];
                    expect(phonebookValidation.homeNumber(data).status).to.be.ok;
                });

                it('can not contain chars', function() {
                    var data = [{ "parameterName":"homeNumber", "parameterValue":"080035007b" }];
                    expect(phonebookValidation.homeNumber(data).status).not.to.be.ok;
                });

                it('can not contain splat "+"', function() {
                    var data = [{ "parameterName":"homeNumber", "parameterValue":"+080035007" }];
                    expect(phonebookValidation.homeNumber(data).status).not.to.be.ok;
                });

                it('can contain splat "*"', function() {
                    var data = [{ "parameterName":"homeNumber", "parameterValue":"*080035007" }];
                    expect(phonebookValidation.homeNumber(data).status).to.be.ok;
                });

                it('can contain splat "#"', function() {
                    var data = [{ "parameterName":"homeNumber", "parameterValue":"#080035007" }];
                    expect(phonebookValidation.homeNumber(data).status).to.be.ok;
                });

                it('can not contain umlauts like "ü ö ä Ä Ü Ö ß"', function() {
                    var data = [{ "parameterName":"homeNumber", "parameterValue":"ü ö ä Ä Ü Ö ß" }];
                    expect(phonebookValidation.homeNumber(data).status).not.to.be.ok;
                });
            });
            
            describe('allowable cell phone number', function() {
                it('can be empty', function() {
                    var data = [{ "parameterName":"cellNumber", "parameterValue":"" }];
                    expect(phonebookValidation.cellNumber(data).status).to.be.ok;
                });

                it('can contain numbers', function() {
                    var data = [{ "parameterName":"cellNumber", "parameterValue":"080035007" }];
                    expect(phonebookValidation.cellNumber(data).status).to.be.ok;
                });

                it('can not contain chars', function() {
                    var data = [{ "parameterName":"cellNumber", "parameterValue":"080035007b" }];
                    expect(phonebookValidation.cellNumber(data).status).not.to.be.ok;
                });

                it('can not contain splat "+"', function() {
                    var data = [{ "parameterName":"cellNumber", "parameterValue":"+080035007" }];
                    expect(phonebookValidation.cellNumber(data).status).not.to.be.ok;
                });

                it('can contain splat "*"', function() {
                    var data = [{ "parameterName":"cellNumber", "parameterValue":"*080035007" }];
                    expect(phonebookValidation.cellNumber(data).status).to.be.ok;
                });

                it('can contain splat "#"', function() {
                    var data = [{ "parameterName":"cellNumber", "parameterValue":"#080035007" }];
                    expect(phonebookValidation.cellNumber(data).status).to.be.ok;
                });

                it('can not contain umlauts like "ü ö ä Ä Ü Ö ß"', function() {
                    var data = [{ "parameterName":"cellNumber", "parameterValue":"ü ö ä Ä Ü Ö ß" }];
                    expect(phonebookValidation.cellNumber(data).status).not.to.be.ok;
                });
            });
            
            describe('allowable work phone number', function() {
                it('can be empty', function() {
                    var data = [{ "parameterName":"workNumber", "parameterValue":"" }];
                    expect(phonebookValidation.workNumber(data).status).to.be.ok;
                });

                it('can contain numbers', function() {
                    var data = [{ "parameterName":"workNumber", "parameterValue":"080035007" }];
                    expect(phonebookValidation.workNumber(data).status).to.be.ok;
                });

                it('can not contain chars', function() {
                    var data = [{ "parameterName":"workNumber", "parameterValue":"080035007b" }];
                    expect(phonebookValidation.workNumber(data).status).not.to.be.ok;
                });

                it('can not contain splat "+"', function() {
                    var data = [{ "parameterName":"workNumber", "parameterValue":"+080035007" }];
                    expect(phonebookValidation.workNumber(data).status).not.to.be.ok;
                });

                it('can contain splat "*"', function() {
                    var data = [{ "parameterName":"workNumber", "parameterValue":"*080035007" }];
                    expect(phonebookValidation.workNumber(data).status).to.be.ok;
                });

                it('can contain splat "#"', function() {
                    var data = [{ "parameterName":"workNumber", "parameterValue":"#080035007" }];
                    expect(phonebookValidation.workNumber(data).status).to.be.ok;
                });

                it('can not contain umlauts like "ü ö ä Ä Ü Ö ß"', function() {
                    var data = [{ "parameterName":"workNumber", "parameterValue":"ü ö ä Ä Ü Ö ß" }];
                    expect(phonebookValidation.workNumber(data).status).not.to.be.ok;
                });
            });

        });

    });

});


