describe("Network Devices Collection", function() {


    it("should return device when calling getDeviceByIP(IPv4)", function() {
        var collection = new swc.constructors.NetworkDevices([
                new Backbone.Model({ address: { 'IPv4' : '1', 'IPv6': ['5', '6', '7'] }}),
                new Backbone.Model({ address: { 'IPv4' : '2', 'IPv6': ['8', '9', '10'] }}),
                new Backbone.Model({ address: { 'IPv4' : '3', 'IPv6': ['11', '12', '13'] }}),
                new Backbone.Model({ address: { 'IPv4' : '4', 'IPv6': ['14', '15', '16'] }})
            ]);

        expect(collection.getDeviceByIP('3')).to.eql(collection.models[2]);
    });

    it("should return device when calling getDeviceByIP(IPv6)", function() {
        var collection = new swc.constructors.NetworkDevices([
            new Backbone.Model({ address: { 'IPv4' : '1', 'IPv6': ['5', '6', '7'] }}),
            new Backbone.Model({ address: { 'IPv4' : '2', 'IPv6': ['8', '9', '10'] }}),
            new Backbone.Model({ address: { 'IPv4' : '3', 'IPv6': ['11', '12', '13'] }}),
            new Backbone.Model({ address: { 'IPv4' : '4', 'IPv6': ['14', '15', '16'] }})
        ]);

        expect(collection.getDeviceByIP('14')).to.eql(collection.models[3]);
    });
});
