describe("Central Storage", function() {

    it("USB devices can apply the sync state", function() {
        var centralStorage = new swc.constructors.CentralStorage();

        expect(centralStorage.getSyncState('IN_PROGRESS')).to.equal('progress');
        expect(centralStorage.getSyncState('UPLOAD_IN_PROGRESS')).to.equal('progress');
        expect(centralStorage.getSyncState('DELETE_IN_PROGRESS')).to.equal('progress');
        expect(centralStorage.getSyncState('COMPLETE')).to.equal('complete');
        expect(centralStorage.getSyncState('ERROR')).to.equal('error');
        expect(centralStorage.getSyncState()).to.equal('not_sync');
    });

    it("supported and unsupported USB devices can have icon name", function() {
        var centralStorage = new swc.constructors.CentralStorage();

        expect(centralStorage.getIcon('usb-disk', true)).to.equal('usb-disk');
        expect(centralStorage.getIcon('usb-disk', false)).to.equal('usb-disk-undefined');
        expect(centralStorage.getIcon('sd-card', true)).to.equal('sd-card');
        expect(centralStorage.getIcon('sd-card', false)).to.equal('sd-card-undefined');
    });

});
