describe("Password", function(){

    it("should not be less than 8 characters", function(){
        expect(validatePassword("1234")).not.to.be.ok;
    });
    it("should not be more than 16 characters", function(){
        expect(validatePassword("123445678-.-_abcdefghy")).not.to.be.ok;
    });
    it("have to have at least 1 digit", function(){
        expect(validatePassword("abcdefghy")).not.to.be.ok;
    });
    it("is valid when has at least 1 special symbol from: [.-_]", function(){
        expect(validatePassword("abcdefghy.")).to.be.ok;
    });
    it("is valid when has at least 1 digit", function(){
        expect(validatePassword("abcdefghy9")).to.be.ok;
    });
    it("should not have umlauts", function(){
        expect(validatePassword("abcdefg9_ü")).not.to.be.ok;
    });
});

describe("Utils::getDaySeconds()", function () {
    it("should return Monday (0) and 3000 seconds", function(){
        expect(getDaySeconds(3000)).to.eql({seconds: 3000, hops: 0}); 
    });
    it("should return end of Monday (0, 86400)", function(){
        expect(getDaySeconds(86400)).to.eql({seconds: 86400, hops: 0});
    });
    it("should return 3000 seconds of Thursday (4, 3000)", function(){
        expect(getDaySeconds(86400 * 4 + 3000)).to.eql({seconds: 3000, hops: 4});
    });
    it("should return 86400 seconds for end of Sunday", function(){
        expect(getDaySeconds(604800)).to.eql({seconds: 86400, hops: 6});
    });
});
