String.prototype.capitalize = function() {
    return this.charAt(0).toUpperCase() + this.slice(1);
};

String.prototype.deCapitalize = function() {
    return this.charAt(0).toLowerCase() + this.slice(1);
};

String.prototype.replaceAll = function(search, replace){
    return this.split(search).join(replace);
};

/**
 * FIX for IE browser
 * @link http://tosbourn.com/2013/08/javascript/a-fix-for-window-location-origin-in-internet-explorer/
 */
if (!window.location.origin) {
    window.location.origin = window.location.protocol + "//" + window.location.hostname +
        (window.location.port ? ':' + window.location.port: '');
}

/**
 * Returns array with defined length - useful for 'for' loops in jquery-tmpl
 * example:
 *
 * {{each returnArray(5)}}
 * {{/each}}
 *
 * @param length
 * @returns {Array}
 */
function returnArray(length){
    if (length <= 0) {
        return [];
    }
    return new Array(length);
}

/**
 * Calculates day number (assuming 0 is Monday) and seconds from start of a day 
 * using seconds since start of a week.
 * Result would be an object of view: {seconds: 3000, hops: 2},
 * where hops = day of week (0 - Monday, 1 - Tuesday...)
 * @example: 
 *   <pre>604800(end of sunday) -> 86400(end of a day)</pre>
 *   
 * @param seconds in a week
 * 
 * @returns Object 
 */
function getDaySeconds(seconds_since_monday){
    var secondsInDay = 86400;
    return {
        seconds: seconds_since_monday % secondsInDay || secondsInDay,
        hops: Math.ceil(seconds_since_monday / secondsInDay) - 1
    };
}


function getTranslationStrings(id, isLoadingWindow) {
    var localeStrings;

    if (isLoadingWindow) {
        localeStrings = swc.models.Locale.getLocaleStrings('application');
    } else {
        localeStrings = swc.models.Locale.getLocaleStrings();
    }

    if (localeStrings && localeStrings[id]) {
        return localeStrings[id];
    } else {
        return id;
    }
}

/**
 * Method for translation strings in html template.
 *
 * @description
 *
 *  {{html localeString("Some string to be translated")}} = Some string to be translated
 *  {{html localeString("Some %placeholder% to be translated", { 'placeholder': 'value' } )}} = Some value to be translated
 *
 * @param id {String}
 * @param params {Object | Map}
 *
 * @returns {String}
 */
function getTranslationStringsjQuery(id, params) {
    var string = id;

    if (this.data.localeStrings && this.data.localeStrings[id]) {
        string = this.data.localeStrings[id];
    }

    if (params && getObjectLength(params)) {
        $.each(params, function(key, value) {
            string = string.replaceAll('%' + key + '%', value);
        });
    }

    return string;
}

/**
 * Get parameter Name / Value based on element type and value:
 * @param element {Object}
 */
function getParameter(element) {
    var parameterName = '',
        parameterValue = '';

    if (element.hasClass('swc-input')) {
        parameterName = element.attr('name');
        parameterValue = element.val();
    }

    else if (element.hasClass('swc-checkbox')) {
        parameterName = element.data('name');
        parameterValue = element.data('value');
    }

    else if (element.hasClass('swc-extended')) {
        parameterName = element.data('name');
        parameterValue = element.data('value');
    }

    else if (element.hasClass('swc-dropdown')) {
        parameterName = element.data('name');
        parameterValue = element.data('value');
    }

    else if (element.hasClass('swc-radio-buttons')) {
        parameterName = element.data('name');
        parameterValue = element.data('value');
    }

    return {
        'parameterName': parameterName,
        'parameterValue': parameterValue,
        'parameterClasses': $(element).attr('class') ? $(element).attr('class').split(/\s+/) : [],
        'parameterData': $(element).data()
    };
}

function getObjectLength(map) {
    var length = 0;

    if (map) {
        $.each(map, function(key, value) {
            length++;
        });
    }

    return length;
}

/**
 * Get application locale either stored in localStorage or retrieved from user's web-browser
 * 
 * @param supportedLocales list of locales currently supported by application
 * 
 * @return {String}
 */
function getApplicationLocale(supportedLocales) {
    var locale,
        browserLocale = navigator.language ? navigator.language.split('-')[0] : navigator.userLanguage.split('-')[0];
    
    var storedLocal = localStorage.getItem("locale");
    if (storedLocal && storedLocal !== "undefined") {
        locale = storedLocal;
    } else {
        if (_.findWhere(supportedLocales, {key: browserLocale.toLowerCase()})) {
            locale = browserLocale.toLowerCase();
        }
    }
    
    return locale;
}

/**
 * Password validator
 * @param password
 * @return boolean
 */
function validatePassword(password){
    var testRegEx = /^(?=.*?[a-zA-Z])(?=.*?[-._\d])[-.\w]{8,16}$/;
    
    return testRegEx.test(password);
}

function getBuildInfo() {
    var info = swc.settings.application.get('build');

    $.each(info, function(key, value) {
        console.log(key + ' - ' + value);
    });
}

function getCharacterByKey(isShiftKey, characterCode) {
    var keysToExclude = [
            8, 9, 13, 16, 17, 18, 20, 27, 37, 39, 46, 91,  92
        ],
        keysCodesMap = {
            32: " ", 48: ")", 49: "!", 50:  "@", 51:  "#", 52:  "$",
            53:  "%", 54:  "^", 55:  "&", 56:  "*", 57:  "(", 59:  ":",
            96: "0", 97: "1", 98: "2", 99: "3", 100: "4", 101: "5", 102: "6",
            103: "7", 104: "8", 105: "9", 107:  "+", 109:  "_", 188:  "<",
            190:  ">", 191:  "?", 192:  "~", 219:  "{", 220:  "|", 221:  "}",
            222:  "\""
        },
        character = "";
    if ($.inArray(characterCode, keysToExclude) !== -1) {
        return character;
    }

    if (typeof isShiftKey !== "boolean" || typeof characterCode !== "number") {
        return character;
    }

    if (isShiftKey) {
        if (characterCode >= 65 && characterCode <= 90) {
            character = String.fromCharCode(characterCode);
        } else {
            character = keysCodesMap[characterCode];
        }
    } else {
        if (characterCode >= 65 && characterCode <= 90) {
            character = String.fromCharCode(characterCode).toLowerCase();
        }
        else if (characterCode >= 96 && characterCode <= 105) {
            character = keysCodesMap[characterCode];
        } else {
            character = String.fromCharCode(characterCode);
        }
    }

    return character;
}

/**
 * Get device ID stored in cookies.
 * 
 * @returns {string}
 */
function getDeviceID() {
    var cookiesArray = document.cookie.split(';'),
        id;

    /**
     * NOTE:
     * Server side sends session cookie in weird format.
     * Actually, session-cookie-name consists of deviceId + sessid suffix separated with / (slash)
     * Thus, we loop through all cookies and check if cookie name has "/sessid" in it,
     * if so, we use such cookie to retrieve device Id and save it under separate cookie
     */
    _.each(cookiesArray, function(cookie) {
        var cookieName = cookie.split('=')[0];
        if (cookieName.split('/')[1] === 'sessid') {
            id = $.trim(cookieName.split('/')[0]);
        }
    });
    
    // haven't found device Id in returned cookies?
    // Try use previously saved deviceId.
    // This could be a situation after Reset when we got to the login page) but already know device's Id.
    if (!id) {
        id = $.cookie('swc/deviceID');
    }

    return id;
}

/**
 * Few SAH callbacks use prototype.js-related event dispatcher on document object. This function will convert it to jquery-related
 * @param event
 * @param options
 */
document.fire = function(event, options){
    $(document).trigger(event, options);
};

/**
 * mobile device detector
 */
function detectMobileBrowser(){
    return (/Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent));
}

