// Dependencies modules:
var express         = require("express");
var http            = require('http');
var httpProxy       = require('http-proxy');
var exec            = require('child_process').exec;
var fs              = require('fs');
var path            = require('path');
var sys             = require('sys');
var request         = require('request');

var conf            = require('./configuration'),
    fixtureGatherer = require('./fixtureGatherer');


// Init express application
var app             = express();


// Proxy settings for application
var proxy           = new httpProxy.RoutingProxy();
var proxySettings   = conf.proxySettings;


// Create build from Grunt file
function buildDevelopment(req, res) {
    exec("grunt build-dev", function(error, stdout, stderr) {
        if (error) {
            console.error(stdout);
            res.send("Build failed. Check console output");
        } else {
            console.log(stdout);
            res.sendfile('./build' + req.path);
        }
    });
}


// Configure express application:
app.configure(function() {
    app.enable('trust proxy');

    if (conf.saveFixtures) {
        app.use(fixtureGatherer.save);
    }
});


// Routes handler:
app.all('*',  function(req, res) {
    var staticPaths = [ "/backup", "/restore", "/upgrade" ];

    if (!req.xhr && staticPaths.indexOf(req.path) == -1) {
        if (req.is('text/html') || req.path == "/") {
            buildDevelopment(req, res);                  // Only for *.html files (index.html etc.)
        } else {
            res.sendfile('./build' + req.path);          // Only for static files (*.png, *.css, etc.)
        }
    } else {
        var fileFormats = ["json", "html", "js", "css"]; // Supported file extentions for XHR requests

        if (fileFormats.indexOf(req.path.split('.').pop()) != -1) {
            res.sendfile('./build' + req.path);
        } else {
            var realEnd = res.end;
            var start = +new Date();

            // Handler for after proxy send request
            res.end = function () {
                realEnd.apply(res);
            }

            proxy.proxyRequest(req, res, {
                host: proxySettings.ip,
                port: proxySettings.port
            });
        }
    }
});


// Starting server
http.createServer(app).listen(conf.appPort, function() {
    console.log("\nNode.js express server is running on http://localhost:"+conf.appPort+"/\n");
});
