swc.constructors.StickyPageView = swc.base.PageView.extend({

    models: [
        'StickyPageModel'
    ],

    events: {
        'swc-dropdown:change .locale-selector': 'setLocale',
        'click .open-desired-website': 'checkConnection',
        'click .reboot-gateway': 'rebootGateway',
        'click .reboot-process': 'clickProcess'
    },

    /**
     * This mapping only needed to find out which page to show to user.
     * We have several steps.
     */
    templateForErrorMap: {
        'Error_02': 'no-connection',
        'Error_03': 'no-connection',
        'Error_04': 'no-connection-final',
        'Error_07': 'no-connection-final-support',
        'Error_11': 'parental-control'
    },

    defaultError: 'Error_02',

    initialize: function() {
        this.template = $.template('sticky', swc.Templates.get('sticky:application').get('content'));
        this.render();
    },

    checkConnection: function(e){
        var self = this,
            $el = $(e.currentTarget),
            url = $el.attr('href');

        e.preventDefault();
        
        swc.models.StickyPageModel.getConnectivityStatus()
            .done(function(response){
                if (response.status && response.status.data && response.status.data.status === true){
                    location.href = url;
                } else {
                    self.showRebootPage(url);
                }
            })
            .fail(function(){
                self.showRebootPage(url);
            });
        
        return false;
    },

    showRebootPage: function(url){
        location.href = location.pathname + "?errorcode=Error_04&url=" + encodeURIComponent(url);
    },

    clickProcess: function(e){
        e.preventDefault();
        return false;
    },

    rebootGateway: function(e){
        this.$('.reboot-process').show();
        this.$('.reboot-gateway').hide();
        
        // Start Device polling
        this.pollGateway();
        
        e.preventDefault();
        
        return false;
    },

    pollGateway: function(){
        var self = this,
            query = this.parseQuery(),
            url = '#';
        
        if (query) {
            url = decodeURIComponent(query.url);
        }
        
        swc.models.StickyPageModel.getConnectivityStatus()
            .done(function(response){
                if (response.status && response.status.data && response.status.data.status === true){
                    location.href = url;
                } else {
                    self.showFinalPage(url);
                }
            })
            .fail(function(){
                setTimeout(function() {
                    self.pollGateway();
                }, 1000);
            });
        
        return false;
    },

    showFinalPage: function(url){
        location.href = location.pathname + "?errorcode=Error_07&url=" + encodeURIComponent(url);
    },

    setNotification: function() {
        var queryParams = this.parseQuery(),
            strings = swc.models.Locale.getLocaleStrings('sticky'),
            data = {
                localeStrings: strings,
                localeString: getTranslationStringsjQuery,
                formatDate: swc.models.Locale.formatDate,
                url: decodeURIComponent(queryParams.url || '/')
            },
            // Compile template for specific error code
            tmpl = $.template('error-dialog', swc.Templates.get('sticky:error:' +
                queryParams.templateId).get('content'));

        this.$('.sticky-message-container').html($.tmpl(tmpl, data));
    },

    /**
     * @override for BaseView::displayPage() because we have different layout for sticky pages then regular application 
     */
    displayPage: function() {
        var strings = swc.models.Locale.getLocaleStrings('sticky'),
            data = {
                localeStrings: strings,
                localeString: getTranslationStringsjQuery,
                staticPagesLinks: swc.models.Locale.getStaticPagesLinks(),
                formatDate: swc.models.Locale.formatDate
            };

        this.$el = $.tmpl(this.template, data);

        $('div#application').html(this.$el);
    },

    renderComplete: function() {
        this.$('.locale-selector')
            .data('options', swc.models.Locale.getLocaleOptions())
            .trigger('swc-dropdown:swc-change', swc.models.Locale.locale);

        this.setNotification();
        this.delegateEvents();
    },

    setLocale: function(e, value){
        var self = this;

        $.when(swc.models.Locale.setLocale(value)).done(function() {
            self.remove();
            self.render();
        });
    },

    /**
     * Parses query string and extract parameter <-> value pairs.
     * Also defines which template will be shown to user based on returned "errorcode" value.
     * 
     * @private This is just a helper method
     * 
     * @returns {{}}
     */
    parseQuery: function() {
        var query = location.search.replace('?', ''),
            res = {};

        $.each(query.split('&'), function(i, pair){
            var temp = pair.split('=');
            res[temp[0]] = temp[1];
        });

        if (!res.errorcode || !this.templateForErrorMap[res.errorcode]) {
            res.errorcode = this.defaultError;
        }
        res.templateId = this.templateForErrorMap[res.errorcode];

        return res;
    }

});
