/**
 * Constructor `{BaseCompositeModel}` extends Backbone.Model object literal argument to
 * extend is the prototype for the BaseCompositeModel constructor
 *
 * @type {Object}
 */

swc.BaseCompositeModel = Backbone.Model.extend({

    models: {},

    /**
     * Mapper converts field name into value (get mode)
     * or into the list of models and their fields to set (set mode) 
     * map: {
     *      'fieldName': 'modelName.fieldName',
     *      'complexField': function (data, options) {
     *              if (data) { //setter
     *                  return {
     *                      model: { field: value, ... }, ...
     *                  }
     *              }
     *              else { //getter
     *                  ...
     *                  return value;
     *              }
     *          }
     *      ...
     * }
     *
     * or:
     *
     * map: function (data, isReverse) { ... } // still TODO
     */
    map: {},

    modelsPool: {},

    /**
     * Define initialize method:
     *
     * @param attributes {Object}
     * @param options {Object}
     */
    initialize: function (attributes, options) {
        var self = this;
        this.modelsPool = {};

        $.each(this.models, function(key, value) {
            var attr = {}; // TODO - compose from attributes and mapper
            self.modelsPool[key] = new /*TODO*/ swc.constructors[key](attr, options);
        });
    },

    get: function (name) {
        if (!this.map[name]) {
            return null;
        }

        if (_.isFunction(this.map[name])) {
            return this.map[name]();
        }
        else {
            var parts = this.map[name].split('.'),
                modelName = parts[0],
                modelField = parts[1];
            return this.modelPool[modelName].get(modelField);
        }
    },

    set: function (name, value, options) {
        var self = this,
            data;
        if (_.isObject(name)) {
            data = name;
        }
        else {
            (data = {})[name] = value;
        }

        // Run validation.
        if (!this._validate(data, options)) {
            return false;
        }

        var newData = {};
        $.each(data, function (key, val) {
            if (_.isFunction(this.map[key])) {
                _.extend(newData, this.map[key](val, options));
            }
            else {
                var parts = this.map[name].split('.'),
                    modelName = parts[0],
                    modelField = parts[1];
                if (!newData[modelName]) {
                    newData[modelName] = {};
                }
                newData[modelName][modelField] = val;
            }
        });
        $.each(newData, function (modelName, vals) {
            self.modelPool[modelName].set(vals, options);
        });
        return this;
    },

    /**
     * 
     * TODO: add mapper
     */
    syncAll: function (method, options) {
        var self = this,
            deferred = new $.Deferred(),
            promises = [];

        if (_.keys(this.models).length === 0) {
            return deferred.resolve();
        }

        $.each(this.models, function(key, value) {
            promises.push(self.syncSubModel(method, key, options));
        });

        $.when.apply(null, promises)
            .done(function() {
                return deferred.resolve();
            })
            .fail(function() {
                return deferred.reject();
            });

        return deferred.promise();
    },

    syncSubModel: function (method, modelName, options) {
        var deferred, originalPromise;

        originalPromise = this.modelsPool[modelName].sync(method, options);

        if (this.models[modelName].required === true) {
            return originalPromise;
        }

        // If the model is not required then we resolve the deffered object always
        deferred = new $.Deferred();

        originalPromise.always(function () {
            deferred.resolve();
        });

        return deferred.promise();
    },

    sync: function(method, options) {
        var self = this,
            deferred = new $.Deferred();

        if (!method) {
            method = 'read';
        }

        options = _.extend({}, options);

        // Check if current page has any models:
        if (_.keys(this.models).length === 0) {
            return deferred.resolve();
        } else {
            var methodName = 'syncAs' + method.charAt(0).toUpperCase() + method.slice(1);

            if (_.isFunction(this[methodName])) {
                deferred = new $.Deferred();
                $.when(this[methodName](options))
                    .done(function() {
                        deferred.resolve();
                    })
                    .fail(function() {
                        deferred.reject();
                    });
            }
            else {
                return this.syncAll('read', options);
            }

            return deferred.promise();
        }
    },

    /**
     * Default save method.
     * Can be overriden for custom behavior.
     *
     */
    syncAsSave: function (options) {
        return this.syncAll(undefined, options);
    },

    /**
     * Validation of model parameters on '{set}' method
     *
     * @param attributes {Object}
     * @param options {Object}
     */
    _validate: function(attributes, options) {
        // TODO
        if (!this.validate()) {
            return false;
        }

        for(var i in this.modelsPool) {
            var attrs = {}; // TODO form attributes and mapper

            if (!this.modelsPool[i]._validate(_.extend({}, attrs), _.extend({}, options))) {
                return false;
            }
        }

        return true;
    },

    validate: function(attributes, options) {
        // overrideable
        return true;
    },

    /**
     * Reset model to it previous values (IF some error happened)
     */
    resetToPreviousState: function() {
        $.each(this.modelsPool, function(key, model) {
            model.resetToPreviousState();
        });
    }
});
