/**
 * SWC REST LAYER
 *
 */
swc.constructors.Rest = Backbone.Model.extend({

    /**
     * List of rules for formatting query strings
     * @type {Object}
     */
    rules: {
        stringType: function(json) {
            return JSON.stringify(json);
        },
        jsonType: function(json) {
            return json;
        }
    },

    /**
     * Initialise REST model
     */
    initialize: function() {},

    /**
     * Send REST request based on incoming options
     * @param options {Object}
     * @return {Object}
     */
    sendRequest: function(options) {
        var contentType = options.contentType ? options.contentType : 'application/x-sah-ws-4-call+json',
            requestType = options.method ? options.method : 'POST',
            // undefined -> true
            // true -> true
            // false -> false
            processData = options.processData === false ? options.processData : true,
            requestHeaders = options.headers ? options.headers : {
                'X-Context': $.cookie(getDeviceID() + '/context'),
                'Authorization': 'X-Sah ' + $.cookie(getDeviceID() + '/context')
            },
            requestData = options.data ? options.data : {},
            formatRule = options.formatRule ? options.formatRule : "stringType",
            timeout = options.timeout ? options.timeout : 29000,
            self = this;

        // Check if request is in background:
        if (!_.isUndefined(options.fromListener) && options.fromListener === true) {
            requestHeaders = $.extend(requestHeaders, {
                'X-Sah-Request-Type': 'idle',
                'idle': true
            });
        }

        if ((requestType.toLowerCase() === 'post' && !options.data)) {
            return {
                'status': 'error',
                'message': 'Wrong POST data provided'
            };
        }

        if (processData && this.rules[formatRule]) {
            requestData = this.rules[formatRule].call(this, options.data);
        } else {
            requestData = options.data;
        }

        if (!processData && !options.contentType) {
            contentType = false;
        }

        $.ajax({
            type: requestType,
            url: options.url,
            contentType: contentType,
            processData: processData,
            headers: requestHeaders,
            data: requestData,
            timeout: timeout,
            cache: false,

            beforeSend: function() {},

            complete: function() {},

            success: function(response) {
                var isPermissionDenied = false;
                if(response.errors && response.errors.length > 0){
                    _.each(response.errors, function(error){
                        if (error["description"] === "Permission denied") {
                            isPermissionDenied = true;
                        }
                    });
                }

                if (!response || isPermissionDenied) {
                    swc.models.Login.processLogout({ action: 'session-logout' });
                }

                if (options.success && $.isFunction(options.success)) {
                    options.success(response);
                }

                self.trigger("success:" + options.component + '-' + options.action);
            },

            error: function(xhr, ajaxOptions, thrownError) {
                if (options.error && $.isFunction(options.error)) {
                    options.error(xhr, ajaxOptions, thrownError);
                }

                if (xhr.responseText && xhr.responseText.indexOf("Permission denied") !== -1) {
                    swc.models.Login.processLogout({ action: 'session-logout' });
                }
            },

            statusCode: {
                403: function() {
                    if (options.statusCode && options.statusCode['403'] && $.isFunction(options.statusCode['403'])) {
                        options.statusCode['403']();
                    }
                },

                404: function() {
                    if (options.statusCode && options.statusCode['404'] && $.isFunction(options.statusCode['404'])) {
                        options.statusCode['404']();
                    }
                },

                500: function() {
                    if (options.statusCode && options.statusCode['500'] && $.isFunction(options.statusCode['500'])) {
                        options.statusCode['500']();
                    }
                },

                502: function() {
                    if (options.statusCode && options.statusCode['502'] && $.isFunction(options.statusCode['502'])) {
                        options.statusCode['502']();
                    }
                }
            }
        });
    }

});
