swc.constructors.Template = Backbone.Model;
swc.constructors.SimpleModel = Backbone.Model;

/**
 * Base backbone model for extending in application
 *
 * @type {*}
 *
 */
swc.base.Model = Backbone.Model.extend({

    /**
     * Rest interface component:
     *
     * @param {component} String
     *
     */
    component: '',

    /**
     * Rest interface action:
     *
     * @param {component} String
     *
     */
    action: '',

    /**
     * Rest interface component to save data
     *
     * @param {componentSave} String
     */
    componentSave: '',

    /**
     * Rest interface action to save data
     *
     * @param {actionSave} String
     */
    actionSave: '',

    /**
     * JSON data witch will be sent via AJAX when model.sync() will be proceed
     */
    json: {},

    /**
     * JSON data witch will be sent via AJAX when model.save() will be proceed
     */
    saveJSON: {},

    /**
     * Request method
     */
    method: 'POST',

    /**
     * Request method for save action
     */
    methodSave: 'POST',

    /**
     * Model sync method which can be redefined while extending if necessary
     */
    sync: function(method, model, options) {
        var deferred = new $.Deferred(),
            headers,
            self = this;

        if (this.headers) {
            headers = this.headers;
        } else {
            headers = {
                'X-Context': $.cookie(getDeviceID() + '/context'),
                'Authorization': 'X-Sah ' + $.cookie(getDeviceID() + '/context')
            };
        }

        swc.models.Rest.sendRequest({
            component: self.component,
            action: self.action,
            data: self.json,

            method: self.method,
            contentType: 'application/x-sah-ws-4-call+json',

            headers: headers,

            success: function(response) {
                if (response.status) {
                    if (typeof response.status === "string") {
                        self.set("data", $.parseJSON(response.status));
                    } else {
                        self.set("data", response.status);
                    }
                } else {
                    if (typeof response === "string") {
                        self.set("data", $.parseJSON(response));
                    } else {
                        self.set("data", response);
                    }
                }

                return deferred.resolve();
            },

            error: function() {
                return deferred.resolve();
            }
        });

        return deferred.promise();
    },

    /**
     *
     */
    save: function() {
        var deferred = new $.Deferred(),
            self = this;

        swc.models.Rest.sendRequest({
            component: self.componentSave,
            action: self.actionSave,
            data: self.saveJSON,
            method: self.methodSave,

            success: function(response) {
                return deferred.resolve();
            },

            error: function() {
                return deferred.resolve();
            }
        });

        return deferred.promise();
    },

    /**
     * Method for updating current model on the server
     */
    pageSave: function() {}
});

/**
 *
 * Backbone model for Templates
 *
 * @type {*}
 *
 */
swc.constructors.Templates = Backbone.Collection.extend({

    initialize: function() {},

    /**
     * Load application template files
     *
     * @param callback
     *
     */
    loadTemplates: function(callback) {
        var self = this,
            deferred = new $.Deferred();

        $.get('/application/tpl.min.html').success(function(response) {
            $.each($(response), function(templateKey, template) {
                if(template.nodeName.toLowerCase() === 'script') {
                    var localTemplate = new swc.constructors.Template();

                    localTemplate.set('content', template);
                    localTemplate.set('id', $(template).attr('id'));

                    self.add(localTemplate);
                }
            });

            if ($.isFunction(callback)) {
                callback();
            }
        });

        return deferred.promise();
    },

    /**
     * Load separate template file
     * @param url {String}
     * @returns {*}
     */
    loadTemplate: function(url) {

    }

});
