var swc = {
    "base": {},
    "views": {},
    "models": {},
    "constructors": {},
    "settings": {
        "application": {},
        "rest": {}
    }
};

swc.Utils = {

    /**
     * Format IPv6 address to short form:
     *
     * @description
     *
     *  one or more leading zeroes from any groups of hexadecimal digits MUST be removed;
     *  consecutive sections of zeroes MUST be replaced with a double colon ( :: ).
     *
     * @param address {String}
     *
     * @returns {String}
     */
    formatIPv6Address: function (address) {
        return address ? address.replace(/\b0+/g, "").replace(/:{2,}/g, "::") : '';
    },

    /**
     * @function: getBytesWithUnit()
     * @purpose: Converts bytes to the most simplified unit.
     * @param: (number) bytes, the amount of bytes
     * @returns: (string)
     */
    getBytesWithUnit: function (bytes) {
        if( isNaN( bytes ) ){ return; }
        var units = [ ' bytes', ' KB', ' MB', ' GB', ' TB', ' PB', ' EB', ' ZB', ' YB' ];
        var amountOf2s = Math.floor( Math.log( +bytes )/Math.log(2) );
        if( amountOf2s < 1 ){
            amountOf2s = 0;
        }
        var i = Math.floor( amountOf2s / 10 );
        bytes = +bytes / Math.pow( 2, 10*i );

        // Rounds to 3 decimals places.
        if( bytes.toString().length > bytes.toFixed(2).toString().length ){
            bytes = bytes.toFixed(2);
        }

        return bytes + units[i];
    },

    getIEVersion: function () {
        // Returns the version of Internet Explorer or 0
        // (indicating the use of another browser).
    
        var rv = 0; // Return value assumes failure.
        if (navigator.appName === 'Microsoft Internet Explorer')
        {
            var ua = navigator.userAgent;
            var re  =  /MSIE (\d+(?:\.\d+)?)/;
            if (re.exec(ua) !== null){
                rv = parseFloat( RegExp.$1 );
            }
        }
    
        return rv;
    },


    /**
     * Check if childArr contains all values from parentArr
     * @param parentArr array
     * @param childArr array
     */
    containsArray: function (parentArr, childArr) {
        var contains = true;
        _.each(parentArr, function(value){
            if(!_.contains(childArr, value)){
                contains = false;
            }
        });
    
        return contains;
    },

    /**
     * Convert values Value => Element Key map to values
     *
     * @param map {Object}
     * @param data {Object} page elements
     *
     * @returns {*}
     */
    getDataToValidate: function(map, data) {
        var values = {};

        _.each(data, function(elementMap, key) {
            _.each(map, function(value, id) {
                if (!_.isUndefined(value.elementName)) {
                    if (elementMap.parameterName === value.elementName) {
                        if (!_.isUndefined(value.elementClass)) {
                            if (_.indexOf(elementMap.parameterClasses, value.elementClass) !== -1) {
                                values[id] = elementMap.parameterValue;
                            }
                        } else {
                            values[id] = elementMap.parameterValue;
                        }
                    }
                }
            });
        });

        return values;
    },

    /**
     * is used because doublequotes break NP response format in some calls (PF, IPv6).
     */
    generateId: function () {
        return _.uniqueId((new Date().getTime()) + "_");
    }
};

// We have to disable cache completely
$.ajaxSetup({
    cache: false
});

$(document).ready(function() {

    $.getJSON("/static/settings/application.json", {}, function(response){
            swc.settings.application = new Backbone.Model();
            swc.settings.application.set(response);
        
            // This setting should be the same as currently used domain,
            // that is why fixing it here to not dig through all application where we do redirect,
            // i.e. Reboot / Restore Config / Upgrade, etc
            swc.settings.application.set("url", window.location.origin);

            // Clone application dispatcher from Backbone events:
            swc.constructors.dispatcher = _.clone(Backbone.Events);
    
            // Init main application model
            swc.models.Application = new swc.constructors.ApplicationModel();

            // Execute IE fixes
            if (swc.Utils.getIEVersion() === 8) {
                $.get('/application/ie8.css', function(data) {
                    var css = data,
                        head = document.getElementsByTagName('head')[0],
                        style = document.createElement('style');

                    style.type = 'text/css';

                    if (style.styleSheet) {
                        style.styleSheet.cssText = css;
                    } else {
                        style.appendChild(document.createTextNode(css));
                    }

                    head.appendChild(style);
                });

                $.get('/application/ie8.fix.js');
            }

            if (swc.Utils.getIEVersion() >= 1 && swc.Utils.getIEVersion() <= 7) {
                alert('Your Internet Explorer browser is too old. Please, upgrade it to 8th version or newer.');
            }
        });
});
