swc.constructors.WpsPairingMixin = {

    startWpsPairing: function() {
        var wirelessDevicesCount = swc.models.NetworkDevices.where({ interfaceType: 'wireless', status: true }).length,
            self = this;

        self.showPageLoading('Starting WPS Pairing...');

        // Request WPS pairing from NP:
        $.when(swc.models.Wireless.startWPSPairing())
            .done(function() {
                self.stopPageLoading();
                self.wpsPairingModal(wirelessDevicesCount);
            })
            .fail(function() {
                self.wpsPairingError();
            });
    },

    wpsPairingModal: function(wirelessDevicesCount) {
        var self = this,
            timeEnd = false;

        SWCElements.modalWindow.show({
            className: 'wps-pairing',
            templateID: 'wifi:wps:modal:pairing',
            templateData: {
                localeStrings: swc.models.Locale.getLocaleStrings(self.pageTemplateID),
                localeString: getTranslationStringsjQuery
            },

            onShow: function() {
                var element = $('.modalWindow'),
                    isSuccess = false,
                    pairingTime = 120000,
                    wpsRuler;

                // Insert progress ruller to the template:
                element.find('.ruler-block').html(
                    $.tmpl(swc.Templates.get('ruler').get('content'), {
                        'className': 'reset-ruler'
                    })
                );

                wpsRuler = element.find('.reset-ruler');

                function checkNewDevice() {
                    if (!timeEnd) {
                        $.when(swc.models.NetworkDevices.sync(true))
                            .done(function() {
                                var updatedWirelessDevicesCount = swc.models.NetworkDevices.where({ interfaceType: 'wireless', status: true }).length;

                                if (updatedWirelessDevicesCount > wirelessDevicesCount) {
                                    isSuccess = true;
                                    wpsRuler.trigger('swc-ruler:finish', true);
                                } else {
                                    setTimeout(checkNewDevice, 2000);
                                }
                            });
                    }
                }

                wpsRuler.on('swc-ruler:finish', function(status) {
                    timeEnd = true;

                    SWCElements.modalWindow.hide();

                    if (isSuccess) {
                        self.wpsPairingComplete();
                    } else {
                        self.wpsPairingError();
                    }
                });

                setTimeout(function() {
                    wpsRuler.trigger('swc-ruler:start', { time: pairingTime });
                    checkNewDevice();
                }, 10);
            },
            onCancel: function(){
                $.when(swc.models.Wireless.stopWPSPairing()).done(function() {
                    timeEnd = true;
                });
            }
        });
    },

    wpsPairingComplete: function() {
        var self = this;

        SWCElements.modalWindow.show({
            className: 'wps-pairing',
            templateID: 'wifi:wps:modal:complete',
            templateData: {
                localeStrings: swc.models.Locale.getLocaleStrings(self.pageTemplateID),
                localeString: getTranslationStringsjQuery
            },

            onApply: function() {
                SWCElements.modalWindow.hide();
                swc.router.navigate('network/devices', { trigger: true });
            }
        });
    },

    wpsPairingError: function() {
        var self = this;

        SWCElements.modalWindow.show({
            className: 'wps-pairing',
            templateID: 'wifi:wps:modal:failed',
            templateData: {
                localeStrings: swc.models.Locale.getLocaleStrings(self.pageTemplateID),
                localeString: getTranslationStringsjQuery
            },

            onApply: function() {
                SWCElements.modalWindow.hide();
                self.startWpsPairing();
            }
        });
    }
};
