swc.constructors.WifiSettingsView = swc.base.PageView.extend({

    className: 'wifi-settings',

    events: {
        'swc-switcher:change .enable-wifi-global': 'setWiFiGlobalState',
        'swc-dropdown:change .swc-dropdown.wifi-mode': 'updateWiFiGlobalMode'
    },

    models: [
        'Schedulers',
        'NetworkDevices'
    ],

    setTemplateData: function() {
        this.templateData = {
            wifiState: swc.models.Wireless.getParameter("status", "status"),
            wifiConfigurationMode: swc.models.Wireless.getParameter("configurationMode", "status"),
            wifiSchedulerState: swc.models.Schedulers.get('wifi').get('enable')
        };
    },

    renderComplete: function() {
        this.setWiFiGlobalMode();
    },

    setWiFiGlobalState: function(e, value) {
        // Show saving page state:
        this.showPageLoading("Updating WiFi state");

        // Send requests to update wifi status on the device:
        $.when(
                swc.models.Wireless.setGlobalStatus(value)
            ).done(function() {
                $.when(swc.models.Wireless.sync()).done(function() {
                    swc.router.navigate(Backbone.history.fragment);
                });
            });
    },

    setWiFiGlobalMode: function() {
        var dropDown = this.$el.find(".swc-dropdown.wifi-mode"),
            isEquals = swc.models.Wireless.isAccessPointsEquals('2.4GHz', '5GHz', ['name', 'password', 'encryption', 'visibility', 'status']),
            data = {
                configurationMode: swc.models.Wireless.getParameter("configurationMode", "status"),
                options: swc.models.Wireless.formatModeOptions()
            };

        // TR-069 Upgrade Regression fix (when mode is combined but APs not equals
        if (data.configurationMode && !isEquals) {
            this.resetWiFiGlobalMode('separate');
        } else {
            dropDown.data('options', data["options"]);
            dropDown.data('default-value', data["configurationMode"] ? 'combined' : 'separate');
            dropDown.trigger('swc-dropdown:swc-change', data["configurationMode"] ? 'combined' : 'separate');
        }
    },

    updateWiFiGlobalMode: function(e, value) {
        var parameter = getParameter($(e.target)),
            dropDown = this.$el.find(".swc-dropdown.wifi-mode"),
            isEquals = swc.models.Wireless.isAccessPointsEquals('2.4GHz', '5GHz', ['name', 'password', 'encryption']),
            encryption = swc.models.Wireless.getParameter("encryption", '5GHz'),
            self = this,
            data = {
                ssid: swc.models.Wireless.getParameter("name", '5GHz'),
                password: swc.models.Wireless.getParameter("password", '5GHz'),
                encryption: ""
            };

        // Pass encryption as localised string
        switch (encryption) {
        case 'None':
            data.encryption = getTranslationStrings("No encryption");
            break;
        case 'WPA2-Personal':
            data.encryption = getTranslationStrings("WPA2");
            break;
        case 'WPA-WPA2-Personal':
            data.encryption = getTranslationStrings("WPA/WPA2");
            break;
        }

        // Check if current switch selected to combined mode:
        if (parameter.parameterValue === "combined") {
            if (!isEquals) {
                SWCElements.modalWindow.show({
                    templateID: 'wifi:settings:modal-windows:set-combined-mode',
                    templateData: data,
                    className: 'wifi-global-change-mode',
                    onCancel: function() {
                        dropDown.trigger('swc-dropdown:swc-change', 'separate');
                    },
                    onApply: function() {
                        self.resetWiFiGlobalMode('combined');
                    }
                });
            } else {
                self.resetWiFiGlobalMode('combined');
            }
        } else {
            self.resetWiFiGlobalMode('separate');
        }
    },

    resetWiFiGlobalMode: function(mode) {
        var pages = Backbone.history.fragment.split('/'),
            toDo = [
                swc.models.Wireless.setGlobalConfigurationMode(mode === "combined")
            ];

        // Close current modal window:
        SWCElements.modalWindow.hide();

        // Show page loading message
        this.showPageLoading("Switching Wi-Fi to " + mode + " mode");

        // Switch to selected mode:
        if (mode === "combined") {
            toDo.push(swc.models.Wireless.switchToCombinedMode('2.4GHz'));
        }

        // Save changes to Configuration Mode
        $.when.apply(null, toDo).done(function() {
            swc.router.navigate(pages[0] + "/" + pages[1] + "/" + 'type-24', {skipUnsavedChanges: true});
        });
    }
});
