swc.constructors.WifiSettingsType24View = swc.base.TabView.extend({

    className: 'type-24',

    accessPointInterface: '2.4GHz',

    validation: {
        'ssid': 'Wireless:ssid',
        'password': 'Wireless:password'
    },

    events: {
        'keyup input.password-original': 'updatePasswordsChange',
        'keyup input.password-copy': 'updatePasswordsChange',

        'swc-checkbox:change .swc-checkbox.WiFiEnable': 'showStatusChangeWarning',
        'swc-checkbox:change .swc-checkbox.show-password': 'setPasswordState',

        'swc-dropdown:change .swc-dropdown.channel-selection': 'onChanelChange',
        'swc-dropdown:change .swc-dropdown.encryption-selection': 'setEncryptionState',

        'click .wps-pairing:not(.disabled)': 'startWpsPairing'
    },

    setTemplateData: function() {
        this.templateData = {
            wifiState: swc.models.Wireless.getParameter("status", "status"),
            wifiConfigurationMode: swc.models.Wireless.getParameter("configurationMode", "status"),
            status: swc.models.Wireless.getParameter("status", this.accessPointInterface),
            ssid: swc.models.Wireless.getParameter("name", this.accessPointInterface),
            password: swc.models.Wireless.getParameter("password", this.accessPointInterface),
            visibility: swc.models.Wireless.getParameter("visibility", this.accessPointInterface) ? "visible" : "hidden",
            encryption: swc.models.Wireless.getParameter("encryption", this.accessPointInterface),
            encryptionOptions: swc.models.Wireless.formatEncryptionOptions(this.accessPointInterface),
            channel: swc.models.Wireless.getParameter('channel', this.accessPointInterface),
            channelAutoEnable: swc.models.Wireless.getParameter('channelAutoEnable', this.accessPointInterface),
            channelOptions: swc.models.Wireless.formatChannelsOptions(this.accessPointInterface),
            operating: swc.models.Wireless.getParameter('operating', this.accessPointInterface),
            operatingOptions: swc.models.Wireless.formatOperatingOptions(this.accessPointInterface)
        };

        // For 5 GHz 36,40,44,48 will report 42, so 40 will be set
        if (this.templateData.channel === 42) {
            this.templateData.channel = 40;
        }

        // For 5 GHz 52,56,60,64 will report 58, so 52 will be set
        if (this.templateData.channel === 58) {
            this.templateData.channel = 52;
        }

        // For 5 GHz 100,104,108,112 will report 106, so 100 will be set
        if (this.templateData.channel === 106) {
            this.templateData.channel = 100;
        }
    },

    renderComplete: function() {
        var self = this,
            encryptionDropdown = this.$el.find('.swc-dropdown.encryption-selection'),
            passwordOrigBox = this.$el.find('input.password-original'),
            passwordCopyBox = this.$el.find('input.password-copy');

        this.setEncryptionData();
        this.setChannelData();
        this.setOperatingMode();
        this.setShowPasswordState();

        // Listener on Encryption dropdown change (Validate visible password box)
        encryptionDropdown.on('validation-success', function() {
            if (passwordOrigBox.css('display') !== 'none') {
                self.pageValidation(passwordOrigBox, false);
            } else {
                self.pageValidation(passwordCopyBox, false);
            }
        });
    },

    setShowPasswordState: function() {
        var encryption = this.templateData["encryption"],
            $passwordOrigBox = this.$('input.password-original'),
            $passwordCopyBox = this.$('input.password-copy'),
            $showPasswordCheckbox = this.$('.swc-checkbox.show-password');

        if (encryption === 'None') {
           $showPasswordCheckbox
               .addClass('disabled')
               .trigger('swc-checkbox:swc-change', false);
        }
    },

    /**
     * Handler for channel changes
     *
     * @description:
     *
     *  When user changes channel, and one of watched values has selected -> user must be shown a confirmation dialog:
     *
     *  if user presses "apply" value has to be applied to the dropdown
     *  if user presses "cancel" value has to be reverted to previous one
     *
     * @param e
     * @param value
     */
    onChanelChange: function(e, value) {
        var self = this,
            dropdown = $(e.target),
            previousValue = dropdown.data("previous-value"),
            watchedValues = [ 116, 120, 124, 128 ];

        if (_.indexOf(watchedValues, value) !== -1) {
            SWCElements.modalWindow.show({
                templateID: 'wifi:settings:modal-windows:on-change-chanel',
                templateData: {},
                className: 'wifi-on-change-chanel',

                onCancel: function() {
                    dropdown.trigger('swc-dropdown:swc-change', previousValue);
                    self.setButtonsState();
                },

                onApply: function() {
                    SWCElements.modalWindow.hide();
                    self.setButtonsState();
                }
            });
        }
    },

    setEncryptionData: function() {
        var encryptionDropdown = this.$el.find('.swc-dropdown.encryption-selection');

        // Set dropdown data:
        encryptionDropdown.data('options', this.templateData["encryptionOptions"]);
        encryptionDropdown.trigger('swc-dropdown:swc-change', this.templateData["encryption"]);
        encryptionDropdown.data("default-value", this.templateData["encryption"]);

        // Update password boxes state:
        this.setEncryptionState(null, this.templateData["encryption"]);
    },

    setChannelData: function() {
        var dropDownChannel = this.$el.find('.swc-dropdown.channel-selection');

        // Update dropdown data
        dropDownChannel.data('options', this.templateData["channelOptions"]);

        if (this.templateData["channelAutoEnable"]) {
            dropDownChannel.data("default-value", "auto");
            dropDownChannel.trigger('swc-dropdown:swc-change', "auto");
        } else {
            dropDownChannel.data("default-value", this.templateData["channel"]);
            dropDownChannel.trigger('swc-dropdown:swc-change', this.templateData["channel"]);
        }
    },

    setOperatingMode: function() {
        var dropDownOperation = this.$el.find('.swc-dropdown.operating-mode-selection');

        // Update dropdown data
        dropDownOperation.data('options', this.templateData["operatingOptions"]);
        dropDownOperation.data("default-value", this.templateData["operating"]);
        dropDownOperation.trigger('swc-dropdown:swc-change', this.templateData["operating"]);
    },

    setPasswordState: function(e, value) {
        var passwordOrigBox = $('input.password-original'),
            passwordCopyBox = $('input.password-copy');

        if (value) {
            passwordOrigBox.hide();
            passwordCopyBox.show();
        } else {
            passwordCopyBox.hide();
            passwordOrigBox.show();
        }
    },

    setEncryptionState: function(e, value) {
        var passwordOrigBox = $('input.password-original'),
            passwordCopyBox = $('input.password-copy'),
            $showPasswordCheckbox = this.$('.swc-checkbox.show-password');

        if (value === "None") {
            passwordOrigBox.addClass("disabled").attr("disabled", "disabled").removeClass("validatable");
            passwordCopyBox.addClass("disabled").attr("disabled", "disabled").removeClass("validatable");
        } else {
            $showPasswordCheckbox.removeClass('disabled');
            passwordOrigBox.removeClass("disabled").removeAttr("disabled", "disabled").addClass("validatable");
            passwordCopyBox.removeClass("disabled").removeAttr("disabled", "disabled").addClass("validatable");
        }
    },

    showStatusChangeWarning: function() {
        var self = this,
            checkBox = this.$el.find('.swc-checkbox.WiFiEnable'),
            parameter = getParameter(checkBox);

        if (!parameter.parameterValue) {
            SWCElements.modalWindow.show({
                templateID: 'wifi:settings:modal-windows:turn-' + self.accessPointInterface + '-off',
                templateData: {},
                className: 'wifi-ap-change-state-warning',
                onCancel: function() {
                    checkBox.trigger('swc-checkbox:swc-change', true);
                    self.setButtonsState();
                },

                onApply: function() {
                    SWCElements.modalWindow.hide();
                    self.setButtonsState();
                }
            });
        }
    },

    updatePasswordsChange: function(e) {
        var parameters = getParameter($(e.target)),
            passwordOrigBox = $('input.password-original'),
            passwordCopyBox = $('input.password-copy');

        if ($.inArray('password-original', parameters.parameterClasses) !== -1) {
            passwordCopyBox.val(passwordOrigBox.val());
        } else {
            passwordOrigBox.val(passwordCopyBox.val());
        }
    },

    startWpsPairing: function() {
        // lazy mixin:
        _.extend(this, swc.constructors.WpsPairingMixin);
        this.startWpsPairing();
    },

    save: function() {
        var self = this,
            deferred = new $.Deferred(),
            pageData = [],
            actionsToDo = [];

        // Get elements name => value map
        $.each(this.getElements(), function(key, element) {
            pageData.push(getParameter($(element)));
        });

        // Define what settings has to be saved:
        if (swc.models.Wireless.getParameter("configurationMode", "status")) {
            actionsToDo = [
                swc.models.Wireless.saveSettingsCombined('2.4GHz', pageData),
                swc.models.Wireless.saveSettingsCombined('5GHz', pageData)
            ];
        } else {
            actionsToDo = [
                swc.models.Wireless.saveSettings(self.accessPointInterface, pageData),
                swc.models.Wireless.setVAPStatus(self.accessPointInterface, pageData)
            ];
        }

        // Process save request:
        $.when.apply(null, actionsToDo).done(function() {
            $.when(swc.models.Wireless.sync()).done(function() {
                return deferred.resolve();
            }).fail(function() {
                    return deferred.reject();
                });
        }).fail(function() {
                return deferred.reject();
            });

        return deferred.promise();
    }
});