swc.constructors.WifiSchedulerView = swc.base.PageView.extend({

    className: 'wifi-scheduler',

    models: ['Schedulers', 'Wireless'],


    events: {
        'swc-checkbox:change .enable-scheduler':'enableScheduler',
        'click .apply-wifi-schedule:not(.disabled)': 'applyScheduler',
        'click .cancel-wifi-schedule:not(.disabled)': 'cancelScheduler'
    },

    setTemplateData: function(){
        this.templateData = {
            schedulerState: swc.models.Schedulers.get('wifi').get('enable')
        };
    },

    enableScheduler: function(e, value){
        var schedulerState = value;

        swc.models.Schedulers.get('wifi').set('enable', schedulerState);

        this.renderComplete();
    },

    applyComplete: function(resp){
        var self = this;
        this.render();
        self.changedScheduler = false;
        setTimeout(function(){
            if(resp.status){
                self.$el.find('.buttons-container-message .save-success').show();
            } else {
                self.$el.find('.buttons-container-message .save-error').show();
            }
        }, 500);
    },

    emptyModal: function(){
        var self = this;

        SWCElements.modalWindow.show({
            templateID: 'power:wifi:modal',
            templateData: {
                localeStrings: swc.models.Locale.getLocaleStrings('power'),
                localeString: getTranslationStringsjQuery,
                formatDate: swc.models.Locale.formatDate
            },
            className: 'storage-schedule',
            onCancel: function() {
                self.changedScheduler = false;
                self.render();
            },
            onApply: function() {
                SWCElements.modalWindow.hide();
                self.showPageLoading('Saving page data..');

                $.when(
                        swc.models.Schedulers.addSchedule('wifi'),
                        swc.models.Wireless.setGlobalStatus(false)
                    ).done(function(resp1, resp2){
                        self.applyComplete(resp1);
                    });
            }
        });
    },

    applyScheduler: function(e){
        var self = this;
        if(swc.models.Schedulers.emptySchedulers[0] === 'wifi'){
            self.emptyModal();
        } else {
            $.when(swc.models.Schedulers.addSchedule('wifi')).done(function(resp){
                self.applyComplete(resp);
            });
        }
    },

    cancelScheduler: function(){
        this.changedScheduler = false;
        this.render();
    },

    changeButtonsState: function(){
        var element = $(this.el);
        if(this.pageCheckDefaultValues() && !this.changedScheduler){
            element.find('.buttons-container-message .button').addClass('disabled');
        } else {
            element.find('.buttons-container-message .button').removeClass('disabled');
        }
    },

    renderComplete: function(){
        var self = this;
        var element = $(this.el);

        this.changeButtonsState();

        swc.constructors.dispatcher.off('scheduler:change');
        swc.constructors.dispatcher.on('scheduler:change', function(e){
            self.changedScheduler = true;
            self.changeButtonsState();
        });

        var schedulerModel = swc.models.Schedulers.get('wifi');

        self.schedulerDiapazon = new swc.constructors.SchedulerLiner({
            isDisabled: !schedulerModel.get('enable'),
            scaleWidth: 432,
            diapazones: schedulerModel.get('pixelSchedule'),
            model: schedulerModel,
            schedulerType: 'wifi'
        });

        $(self.el).find('.scheduler-container').html(self.schedulerDiapazon.el);

        self.delegateEvents();
    }
});