swc.constructors.WifiGuestView = swc.base.PageView.extend({

    className: 'wifi-guest',

    models: [
        "Wireless"
    ],

    validation: {
        'ssid': 'Wireless:ssid',
        'password': 'Wireless:password'
    },

    events: {
        'swc-switcher:change .set-wifi-status': 'setWiFiState',

        'keyup input.password-original': 'updatePasswordsChange',
        'keyup input.password-copy': 'updatePasswordsChange',

        'swc-checkbox:change .swc-checkbox.show-password': 'setPasswordState',

        'swc-dropdown:change .swc-dropdown.encryption-selection': 'setEncryptionState'
    },

    setTemplateData: function() {
        var time = new Date(swc.models.Wireless.getParameter("time", "systemTime")).getTime(),
            timeout = swc.models.Wireless.getParameter("timeout", "guestTimer"),
            date = {
                hours: new Date(time + timeout * 1000).getHours(),
                minutes: new Date(time + timeout * 1000).getMinutes()
            };

        // Set template data:
        this.templateData = {
            "state": swc.models.Wireless.getParameter("status", "guestStatus"),
            "ssid": swc.models.Wireless.getParameter("name", "Guest-2.4GHz"),
            "password": swc.models.Wireless.getParameter("password", "Guest-2.4GHz"),
            "encryption": swc.models.Wireless.getParameter("encryption", "Guest-2.4GHz"),
            "encryptionOptions": swc.models.Wireless.formatEncryptionOptions("Guest-2.4GHz"),
            "deactivationOptions": swc.models.Wireless.formatDeactivationOptions(),
            "deactivationTimeout": timeout,
            "deactivationSelected": 0,
            "deactivationTime": ''
        };

        // Check hours value for consistensy
        if (date.hours < 10) {
            date.hours = "0" + date.hours;
        }

        // Check minutes value for consistensy
        if (date.minutes < 10) {
            date.minutes = "0" + date.minutes;
        }

        // Update deactivation time value:
        this.templateData["deactivationTime"] = date.hours + ':' + date.minutes;
    },

    renderComplete: function() {
        var self = this,
            encryptionDropdown = this.$el.find('.swc-dropdown.encryption-selection'),
            passwordOrigBox = $('input.password-original'),
            passwordCopyBox = $('input.password-copy');

        // Listener on Encryption dropdown change
        encryptionDropdown.on('validation-success', function() {

            // Validate visible password box:
            if (passwordOrigBox.css('display') !== 'none') {
                self.pageValidation(passwordOrigBox, false);
            } else {
                self.pageValidation(passwordCopyBox, false);
            }
        });

        // Set encryption data when page is loaded:
        this.setEncryptioData();

        // Set deactivation data when page is loaded:
        this.setDeactivationData();

        this.setShowPasswordState();
    },

    setShowPasswordState: function() {
        var encryption = this.templateData["encryption"],
            $passwordOrigBox = this.$('input.password-original'),
            $passwordCopyBox = this.$('input.password-copy'),
            $showPasswordCheckbox = this.$('.swc-checkbox.show-password');

        if (encryption === 'None') {
           $showPasswordCheckbox
               .addClass('disabled')
               .trigger('swc-checkbox:swc-change', false);
        } else {
            this.setPasswordState(null, true);
        }
    },

    setEncryptioData: function() {
        var encryptionDropdown = this.$el.find('.swc-dropdown.encryption-selection');

        // Set dropdown data:
        encryptionDropdown.data('options', this.templateData["encryptionOptions"]);
        encryptionDropdown.trigger('swc-dropdown:swc-change', this.templateData["encryption"]);
        encryptionDropdown.data("default-value", this.templateData["encryption"]);

        // Update password boxes state:
        this.setEncryptionState(null, this.templateData["encryption"]);
    },

    setDeactivationData: function() {
        var dropDownDeactivation = this.$el.find('.swc-dropdown.deactivation-selection');

        // Calculate nearest value:
        if (this.templateData["deactivationTimeout"] > 0 && this.templateData["deactivationTimeout"] <= 21600) {
            this.templateData["deactivationSelected"] = 21600; // 6h
        }
        else if (this.templateData["deactivationTimeout"] > 21600 && this.templateData["deactivationTimeout"] <= 43200) {
            this.templateData["deactivationSelected"] = 43200; // 12h
        }
        else if (this.templateData["deactivationTimeout"] > 43200 && this.templateData["deactivationTimeout"] <= 86400) {
            this.templateData["deactivationSelected"] = 86400; // 24h
        }
        else {
            this.templateData["deactivationSelected"] = 0; // No auto disable
        }

        // Set dropdown data:
        dropDownDeactivation.data('options', this.templateData["deactivationOptions"]);
        dropDownDeactivation.data("default-value", this.templateData["deactivationSelected"]);
        dropDownDeactivation.trigger('swc-dropdown:swc-change', this.templateData["deactivationSelected"]);
    },

    setWiFiState: function(e, value) {
        var self = this,
            toDo = [];

        // Show page saving message
        this.showPageLoading("Updating Guest WiFi state");

        // Set activation timer on wifi activation:
        if (value) {
            toDo = [
                swc.models.Wireless.setGuestStatus(true),
                swc.models.Wireless.setGuestActivationTimer(6)
            ];
        } else {
            toDo.push(
                swc.models.Wireless.setGuestStatus(false)
            );
        }

        // Wait till all changes are completed
        $.when.apply(null, toDo).done(function() {
            $.when(swc.models.Wireless.sync()).done(function() {
                self.render();
            });
        });
    },

    setPasswordState: function(e, value) {
        var passwordOrigBox = $('input.password-original'),
            passwordCopyBox = $('input.password-copy');

        if (value) {
            passwordOrigBox.hide();
            passwordCopyBox.show();
        } else {
            passwordCopyBox.hide();
            passwordOrigBox.show();
        }
    },

    setEncryptionState: function(e, value) {
        var passwordOrigBox = $('input.password-original'),
            passwordCopyBox = $('input.password-copy'),
            $showPasswordCheckbox = this.$('.swc-checkbox.show-password');

        if (value === "None") {
            passwordOrigBox.addClass("disabled").attr("disabled", "disabled").removeClass("validatable");
            passwordCopyBox.addClass("disabled").attr("disabled", "disabled").removeClass("validatable");
        } else {
            $showPasswordCheckbox.removeClass('disabled');
            passwordOrigBox.removeClass("disabled").removeAttr("disabled", "disabled").addClass("validatable");
            passwordCopyBox.removeClass("disabled").removeAttr("disabled", "disabled").addClass("validatable");
        }
    },

    updatePasswordsChange: function(e) {
        var parameters = getParameter($(e.target)),
            passwordOrigBox = $('input.password-original'),
            passwordCopyBox = $('input.password-copy');

        if ($.inArray('password-original', parameters.parameterClasses) !== -1) {
            passwordCopyBox.val(passwordOrigBox.val());
        } else {
            passwordOrigBox.val(passwordCopyBox.val());
        }
    },

    save: function() {
        var deferred = new $.Deferred(),
            timerDropdown = this.$el.find('.swc-dropdown.deactivation-selection'),
            timerDropdownValue = getParameter(timerDropdown),
            toDo = [],
            pageData = [];

        // Get elements name => value map
        $.each(this.getElements(), function(key, element) {
            pageData.push(getParameter($(element)));
        });

        // Check if timer has changed:
        if (parseInt(timerDropdown.data('value'), 10) !== parseInt(timerDropdown.data('default-value'), 10)) {
            toDo.push(
                swc.models.Wireless.setGuestActivationTimer((timerDropdownValue.parameterValue / 60) / 60)
            );
        }

        // Push saving state:
        toDo.push(swc.models.Wireless.saveSettingsGuest('2.4GHz', pageData));
        // toDo.push(swc.models.Wireless.saveSettingsGuest('5GHz', pageData)); // Removed due to SAH problems

        $.when.apply(null, toDo).done(function() {
            return deferred.resolve();
        }).fail(function() {
                return deferred.reject();
            });

        return deferred.promise();
    }
});