swc.constructors.DectPairingModalView = swc.base.PageView.extend({
    className: 'modal dect-pairing',

    tagName: 'div',

    hidden: false,

    events: {
        'click .close-modal': 'closeModal',
        'click .try-pairing': 'tryPairing',
        'hide': 'hideModal'
    },

    closeModal: function(){
        var self = this;
        $.when(swc.models.Telephony.stopPairing())
            .always(function(response) {
                swc.models.Login.off('beforeLogout', self.closeModal, self);
                self.hideModal();
                $(self.el).modal('hide');
            });
    },

    tryPairing: function(){
        this.render();
    },

    hideModal: function(){
        this.hidden = true;
    },

    initialize: function(){
        var self = this;
        this.pairingTemplate = swc.Templates.get('telephony:device:pair:modal:pairing');
        this.failTemplate = swc.Templates.get('telephony:device:pair:modal:failed');
        this.successTemplate = swc.Templates.get('telephony:device:pair:modal:complete');
        this.rulerTemplate = swc.Templates.get('ruler');
        this.render();
    },

    render: function(){
        var self = this, element = $(this.el);
        element.html($.tmpl(self.pairingTemplate.get('content'), {
            localeStrings: swc.models.Locale.getLocaleStrings("telephony"),
            localeString: getTranslationStringsjQuery,
            formatDate: swc.models.Locale.formatDate
        }));

        this.$el.modal({keyboard: false, backdrop: 'static'});

        var countDectPhones = function(){
                return swc.models.Telephony.get('phones').length-2;
            },
            dectPhonesCount = countDectPhones();

        element.find('.ruler-block').html($.tmpl(self.rulerTemplate.get('content'), {
            'className': 'pairing-ruler'
        }));

        swc.models.Login.on('beforeLogout', this.closeModal, this);

        $.when(swc.models.Telephony.startPairing()).done(function(response){

            var timeEnded = false,
                pairingTime = 120000,

                throwSuccess = function(){
                    element.html(
                        $.tmpl(self.successTemplate.get('content'), {
                            localeStrings: swc.models.Locale.getLocaleStrings("telephony"),
                            localeString: getTranslationStringsjQuery,
                            formatDate: swc.models.Locale.formatDate
                        })
                    );
                },

                throwError = function(){
                    element.html(
                        $.tmpl(self.failTemplate.get('content'), {
                            localeStrings: swc.models.Locale.getLocaleStrings("telephony"),
                            localeString: getTranslationStringsjQuery,
                            formatDate: swc.models.Locale.formatDate
                        })
                    );
                },

                checkPaired = function(){
                    $.when(swc.models.Telephony.getPhones()).done(function(){
                        if(countDectPhones() > dectPhonesCount){
                            throwSuccess();
                        } else {
                            if(!timeEnded && !self.hidden){
                                setTimeout(function(){
                                    checkPaired();
                                }, 1000);
                            } else {
                                throwError();
                            }
                        }
                    });
                };

            element.find('.ruler-container').trigger('swc-ruler:start', {time: pairingTime});

            setTimeout(function(){
                timeEnded = true;
            }, pairingTime);

            checkPaired();
        });
    }
});
