swc.constructors.NoGroupsModal = Backbone.View.extend({
    className: 'modal',

    tagName: 'div',

    initialize: function(){
        this.pageTemplateID = "telephony";
        this.render();
    },

    render: function(){
        var self = this;

        SWCElements.modalWindow.show({
            templateID: 'telephony:modal-windows:no-groups',
            templateData: {
                localeStrings: swc.models.Locale.getLocaleStrings(self.pageTemplateID),
                localeString: getTranslationStringsjQuery,
                formatDate: swc.models.Locale.formatDate
            },
            className: 'cloud-unchecked',
            
            onApply: function() {
                SWCElements.modalWindow.hide();
            }
        });

    }
});
