swc.constructors.TelephonyPhonebookView = swc.base.PageView.extend({

    className: 'phonebook',

    models: ['Phonebook'],

    /**
     * Due to overriding render method in the child view TelephonyPhonebookList
     * success message should be shown explicitly.
     *
     * This variable is used in the child view TelephonyPhonebookList
     * to determine if the success message should be shown after save.
     * This variable is declared here because the child view always has
     * new instance after rendering of this(parent) view
     *
     * @type {Boolean}
     */
    showSuccessMessage: false,

    renderComplete: function(){
        var view,
            element = $(this.el);

        swc.views.TelephonyPhonebookList = new swc.constructors.TelephonyPhonebookList();
        view = swc.views.TelephonyPhonebookList;

        element.find('.phonebook').html(view.el);
        view.render();
        view.delegateEvents();
    },

    /**
     * TODO: remove this custom solution when load/unload of views will be realized
     */
    beforeRouteChangeHook: function() {
        if (swc.views['telephonyPhonebookEditView']) {
            swc.views['telephonyPhonebookEditView'].resetContactModel();
        }
    }

});