swc.constructors.TelephonyPhonebookList = swc.base.PageView.extend({

    className: 'view-contacts',

    events : {
        'keyup .search-input': 'searchContacts',
        'click .new-contact': 'redirectToAddContact',

        'click .clear-contacts:not(.disabled)': 'clearAllModal',
        'click .do-delete': 'deleteContact',

        'expandable:edit .expandable-list': 'listEditMode'
    },

    searchKeyword: "",

    searchProcess: false,

    // A flag showing if there are some contacts prepared for deletion
    deletedContacts: false,

    initialize: function() {
        swc.base.PageView.prototype.initialize.call(this, arguments);
        this.template = $.template("pageContent", swc.Templates.get('telephony:phonebook:phonebook').get('content'));
    },

    /**
     * Event handler: is fired on start edit
     *
     * @param e
     * @param value
     */
    listEditMode: function(e, value) {
        sessionStorage.setItem(swc.models.Phonebook.requestParamNameID, value);
        swc.router.navigate('telephony/phonebook/edit');
    },

    redirectToAddContact: function() {
        sessionStorage.removeItem(swc.models.Phonebook.requestParamNameID);
        swc.router.navigate('telephony/phonebook/edit');
    },

    /**
     * Get actual collection of contacts.
     * The following contacts are thrown away from collection:
     *    - which are marked as deleted
     *    - which are not matched to the search keyword(both name and number are checked)
     *
     * @returns {Array}
     */
    filterContactsBySearch: function() {
        var self = this,
            collection = [];

        collection = swc.models.Phonebook.filter(function(model) {
            var response = false,
                numbers = model.get('telephoneNumbers');

            // make object for editable number fields
            model.set('numberFields', {
                'HOME': _.where(numbers, {'type': 'HOME'})[0] ? _.where(numbers, {'type': 'HOME'})[0].name : '',
                'CELL': _.where(numbers, {'type': 'CELL'})[0] ? _.where(numbers, {'type': 'CELL'})[0].name : '',
                'WORK': _.where(numbers, {'type': 'WORK'})[0] ? _.where(numbers, {'type': 'WORK'})[0].name : ''
            });

            if (model.get('deleted')) {
                self.deletedContacts = true;
                response = false;
            } else if (self.searchKeyword) {
                var searchKeywordLC = self.searchKeyword.toLowerCase();
                if (model.get('formattedName').toLowerCase().indexOf(searchKeywordLC) !== -1) {
                    response = true;
                }

                _.each(model.get('telephoneNumbers'), function(number) {
                    if (number.name.indexOf(searchKeywordLC) !== -1) {
                        response = true;
                    }
                });
            } else {
                response = true;
            }

            return response;
        });

        return collection;
    },

    /**
     * Event handler: is fired during user input in the search field
     *
     * @param e
     */
    searchContacts: function(e) {
        this.searchKeyword = $(e.target).val();
        this.searchProcess = true;
        this.render();
        this.searchProcess = false;
    },

    /**
     * Save all contacts.
     * The following flags influences on the actual action during saving
     *    modified { Boolean }
     *    deleted { Boolean }
     */
    save: function() {
        var self = this;

        $.when(swc.models.Phonebook.deleteAllContacts())
            .done(function() {
                swc.views.telephonyPhonebookView.showSuccessMessage = true;
                swc.views.telephonyPhonebookView.render();
            });
    },

    /**
     * Event handler: render page in the default state
     */
    onCancel: function() {
        swc.views.telephonyPhonebookView.render();
    },

    /**
     * Event handler: delete picked contact from model
     * Actually contact is not deleted but marked as deleted
     *
     * @param e {Object}
     */
    deleteContact: function(e) {
        var itemId = $(e.target).closest('.expandable-list-item').attr('data-key');
        swc.models.Phonebook.get(itemId).set({'deleted': true});
        this.deletedContacts = true;
        this.setButtonsState();
        this.render();
    },

    /**
     * Delete all contacts
     * Is used as a handler of the event clearAllModal
     */
    deleteAllContacts: function() {
        swc.models.Phonebook.each(function(model) {
            model.set({'deleted': true});
        });
        this.saveChanges();
        this.setElementsState();
    },

    /**
     * Event handler: show modal window with prompt to delete all contacts from phone book
     */
    clearAllModal: function() {
        var self = this,
            templateData = {
                localeStrings: swc.models.Locale.getLocaleStrings(self.pageTemplateID),
                localeString: getTranslationStringsjQuery,
                formatDate: swc.models.Locale.formatDate
            };

        SWCElements.modalWindow.show({
            templateID: 'telephony:modal-windows:phonebook:clear-all',
            templateData: templateData,
            className: 'phonebook-clearall',
            onApply: function() {
                self.deleteAllContacts();
                SWCElements.modalWindow.hide();
            }
        });
    },

    checkModification: function() {
        return (!this.pageCheckDefaultValues() || this.deletedContacts);
    },

    /**
     * Enable save/cancel buttons
     */
    activateButtons: function(){
        this.$('.save-changes').removeClass('disabled');
        this.$('.cancel-changes').removeClass('disabled');
    },

    /**
     * Disable save/cancel buttons
     */
    deactivateButtons: function(){
        this.$('.save-changes').addClass('disabled');
        this.$('.cancel-changes').addClass('disabled');
    },

    /**
     * Enable search input
     */
    activateSearchElement: function(){
        this.$('.search-form div').removeClass('disabled');
        this.$('.search-form input').removeAttr('disabled');
    },

    /**
     * Disable search input
     */
    deactivateSearchElement: function() {
        this.$('.search-form div').addClass('disabled');
        this.$('.search-form input').attr('disabled', 'disabled');
    },

    /**
     * Set state(enable/disable) of buttons and search input
     */
    setElementsState: function() {
        // if there are some modification(edit, delete of some amount of contacts)
        // or phone book list is empty
        // then search input should be disabled
        if (this.checkModification() || !swc.models.Phonebook.length) {
            this.deactivateSearchElement();
        } else {
            this.activateSearchElement();
        }

        // if there are some modification(edit, delete of some amount of contacts)
        // then buttons save/cancel should be disabled
        if (this.checkModification()) {
            this.activateButtons();
        } else {
            this.deactivateButtons();
        }
    },

    setTemplateData: function() {
        var self = this;

        this.templateData = {
            phoneTypes: {
                'HOME': 'Home',
                'CELL': 'Mobile',
                'WORK': 'Office'
            },
            searchProcess: self.searchProcess,
            isModified: self.checkModification(),
            contacts: self.filterContactsBySearch()
        };
    },

    render: function() {
        var self = this;

        // Set template data:
        this.setTemplateData();

        $(this.el).html(
            $.tmpl(this.template, {
                localeStrings: swc.models.Locale.getLocaleStrings("telephony"),
                localeString: getTranslationStringsjQuery,
                formatDate: swc.models.Locale.formatDate,
                data: self.templateData
            })
        );

        this.renderComplete();
    },

    renderComplete: function() {
        var searchInput;

        this.$('.search-input').val(this.searchKeyword);

        if (this.searchProcess) {
            searchInput = this.$('.search-input')[0];
            $(searchInput).focus();
            // put cursor at the end of the search input
            if (searchInput.setSelectionRange) {
                // ... then use it
                // (Doesn't work in IE)
                // Double the length because Opera is inconsistent about whether a carriage return is one character or two. Sigh.
                var len = $(searchInput).val().length * 2;
                searchInput.setSelectionRange(len, len);
            }
        }

        this.setElementsState();

        // due to overriding render method the
        // success message should be shown explicitly
        if (swc.views.telephonyPhonebookView.showSuccessMessage) {
            this.$('.buttons-container-message .save-success').show();
            swc.views.telephonyPhonebookView.showSuccessMessage = false;
        }
    }

});
